/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordingListener
implements GraphListener {
    public List<Object> history = new ArrayList<Object>();

    public void notifyAddTriple(Graph g, Triple t) {
        this.record("add", g, t);
    }

    public void notifyAddArray(Graph g, Triple[] triples) {
        this.record("add[]", g, triples);
    }

    public void notifyAddList(Graph g, List<Triple> triples) {
        this.record("addList", g, triples);
    }

    public void notifyAddIterator(Graph g, Iterator<Triple> it) {
        this.record("addIterator", g, GraphTestBase.iteratorToList(it));
    }

    public void notifyAddGraph(Graph g, Graph added) {
        this.record("addGraph", g, added);
    }

    public void notifyDeleteTriple(Graph g, Triple t) {
        this.record("delete", g, t);
    }

    public void notifyDeleteArray(Graph g, Triple[] triples) {
        this.record("delete[]", g, triples);
    }

    public void notifyDeleteList(Graph g, List<Triple> triples) {
        this.record("deleteList", g, triples);
    }

    public void notifyDeleteIterator(Graph g, Iterator<Triple> it) {
        this.record("deleteIterator", g, GraphTestBase.iteratorToList(it));
    }

    public void notifyDeleteGraph(Graph g, Graph removed) {
        this.record("deleteGraph", g, removed);
    }

    public void notifyEvent(Graph source, Object event) {
        this.record("someEvent", source, event);
    }

    protected void record(String tag, Object x, Object y) {
        this.history.add(tag);
        this.history.add(x);
        this.history.add(y);
    }

    protected void record(String tag, Object info) {
        this.history.add(tag);
        this.history.add(info);
    }

    public void clear() {
        this.history.clear();
    }

    public boolean has(List<Object> things) {
        return ((Object)this.history).equals(things);
    }

    public boolean hasStart(List<Object> L) {
        return L.size() <= this.history.size() && ((Object)L).equals(this.history.subList(0, L.size()));
    }

    public boolean hasEnd(List<Object> L) {
        return L.size() <= this.history.size() && ((Object)L).equals(this.history.subList(this.history.size() - L.size(), this.history.size()));
    }

    public boolean has(Object[] things) {
        return this.has(Arrays.asList(things));
    }

    public void assertHas(List<Object> things) {
        if (!this.has(things)) {
            Assert.fail((String)("expected " + things + " but got " + this.history));
        }
    }

    public void assertHas(Object[] things) {
        this.assertHas(Arrays.asList(things));
    }

    public void assertHasStart(Object[] start) {
        List<Object> L = Arrays.asList(start);
        if (!this.hasStart(L)) {
            Assert.fail((String)("expected " + L + " at the beginning of " + this.history));
        }
    }

    public void assertHasEnd(Object[] end) {
        List<Object> L = Arrays.asList(end);
        if (!this.hasEnd(L)) {
            Assert.fail((String)("expected " + L + " at the end of " + this.history));
        }
    }
}

