/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Dyadic;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestSuite;

public class TestExpressionConstraints
extends QueryTestBase {
    protected static final Expression eTRUE = Expression.TRUE;
    protected static final Expression eFALSE = Expression.FALSE;

    public TestExpressionConstraints(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestExpressionConstraints.class);
    }

    public void testConstraintFALSE() {
        Graph g = TestExpressionConstraints.graphWith("x R y; a P b");
        Query q = new Query().addMatch(X, ANY, ANY).addConstraint(eFALSE);
        TestExpressionConstraints.assertFalse((boolean)q.executeBindings(g, this.justX).hasNext());
    }

    public void testConstraintTRUE() {
        Graph g = TestExpressionConstraints.graphWith("x R y; a P b");
        Query q = new Query().addMatch(X, ANY, ANY).addConstraint(eTRUE);
        TestExpressionConstraints.assertTrue((boolean)q.executeBindings(g, this.justX).hasNext());
    }

    public void testConstraintNE1() {
        Graph g = TestExpressionConstraints.graphWith("x R y; a P a");
        Query q = new Query().addMatch(X, ANY, Y).addConstraint(this.notEqual(X, Y));
        Set expected = CollectionFactory.createHashedSet();
        expected.add(TestExpressionConstraints.node("x"));
        TestExpressionConstraints.assertEquals((Object)expected, TestExpressionConstraints.iteratorToSet(q.executeBindings(g, this.justX).mapWith(getFirst)));
    }

    public void testConstraintNE2() {
        Graph g = TestExpressionConstraints.graphWith("x R y; a P a");
        Query q = new Query().addMatch(X, ANY, Y).addConstraint(this.notEqual(X, Y));
        Set expected = CollectionFactory.createHashedSet();
        expected.add(TestExpressionConstraints.node("x"));
        TestExpressionConstraints.assertEquals((Object)expected, TestExpressionConstraints.iteratorToSet(q.executeBindings(g, this.justX).mapWith(getFirst)));
    }

    public void testConstraintNE3() {
        Graph g = TestExpressionConstraints.graphWith("x R a; y P b; z Q c");
        Query q = new Query().addMatch(X, ANY, ANY).addConstraint(this.notEqual(X, TestExpressionConstraints.node("y")));
        Set expected = CollectionFactory.createHashedSet();
        expected.add(TestExpressionConstraints.node("x"));
        expected.add(TestExpressionConstraints.node("z"));
        TestExpressionConstraints.assertEquals((Object)expected, TestExpressionConstraints.iteratorToSet(q.executeBindings(g, this.justX).mapWith(getFirst)));
    }

    public void testConstraintNE4() {
        Graph g = TestExpressionConstraints.graphWith("x R a; y P b; z Q c");
        Query q = new Query().addMatch(X, ANY, ANY).addConstraint(this.notEqual(X, TestExpressionConstraints.node("y"))).addConstraint(this.notEqual(X, TestExpressionConstraints.node("x")));
        Set expected = CollectionFactory.createHashedSet();
        expected.add(TestExpressionConstraints.node("z"));
        TestExpressionConstraints.assertEquals((Object)expected, TestExpressionConstraints.iteratorToSet(q.executeBindings(g, this.justX).mapWith(getFirst)));
    }

    public void testVI() {
        VI varValues = new VI().set("X", 1).set("Y", 2).set("Z", 3);
        TestExpressionConstraints.assertEquals((int)1, (int)varValues.indexOf("X"));
        TestExpressionConstraints.assertEquals((int)2, (int)varValues.indexOf("Y"));
        TestExpressionConstraints.assertEquals((int)3, (int)varValues.indexOf("Z"));
    }

    public void testNE() {
        Expression e = this.areEqual(X, Y);
        VI vi = new VI().set("X", 1).set("Y", 2);
        IV iv = new IV().set(1, "something").set(2, "else");
        TestExpressionConstraints.assertEquals((boolean)false, (boolean)e.prepare((VariableIndexes)vi).evalBool((IndexValues)iv));
    }

    public void testVVTrue() {
        TestExpressionConstraints.assertEquals((boolean)true, (boolean)Expression.TRUE.prepare(this.noVariables).evalBool(noIVs));
    }

    public void testVVFalse() {
        TestExpressionConstraints.assertEquals((boolean)false, (boolean)Expression.FALSE.prepare(this.noVariables).evalBool(noIVs));
    }

    public void testVVMatches() {
        VI vi = new VI().set("X", 0).set("Y", 1);
        IV iv = new IV().set(0, "hello").set(1, "ell");
        TestExpressionConstraints.assertEquals((boolean)true, (boolean)this.matches(X, Y).prepare((VariableIndexes)vi).evalBool((IndexValues)iv));
    }

    public void testPrepareNE() {
        Expression e = this.notEqual(X, Y);
        Mapping map = new Mapping(new Node[0]);
    }

    public void testURIs() {
        TestExpressionConstraints.assertEquals((String)"http://jena.hpl.hp.com/constraints/NE", (String)this.notEqual(X, Y).getFun());
        TestExpressionConstraints.assertEquals((String)"http://jena.hpl.hp.com/constraints/EQ", (String)this.areEqual(X, Y).getFun());
        TestExpressionConstraints.assertEquals((String)"http://jena.hpl.hp.com/constraints/MATCHES", (String)this.matches(X, Y).getFun());
    }

    public void testNotConstant() {
        TestExpressionConstraints.assertFalse((boolean)this.notEqual(X, Y).isConstant());
    }

    public void testDetectAnd() {
        Expression e1 = this.notEqual(X, Y);
        Expression e2 = this.notEqual(X, Z);
        Query q = new Query().addConstraint(Dyadic.and((Expression)e1, (Expression)e2));
        Set eBoth = CollectionFactory.createHashedSet();
        eBoth.add(e1);
        eBoth.add(e2);
        Set s = TestExpressionConstraints.iteratorToSet(q.getConstraints().iterator());
        TestExpressionConstraints.assertEquals((Object)eBoth, s);
    }

    public void testUnknownExpression() {
        Expression.Base eOpaque = new Expression.Base(){

            public Valuator prepare(VariableIndexes vi) {
                return null;
            }
        };
        TestExpressionConstraints.assertFalse((boolean)Expression.Util.containsAllVariablesOf(new HashSet(), (Expression)eOpaque));
    }

    public static class IV
    implements IndexValues {
        private Map<Integer, Node> values = CollectionFactory.createHashedMap();

        public IV set(int i, String x) {
            this.values.put(new Integer(i), Node.createLiteral((String)x));
            return this;
        }

        public Object get(int i) {
            return this.values.get(new Integer(i));
        }
    }

    public static class VI
    implements VariableIndexes {
        private Map<String, Integer> values = CollectionFactory.createHashedMap();

        public VI set(String x, int i) {
            this.values.put(x, new Integer(i));
            return this;
        }

        public int indexOf(String name) {
            return this.values.get(name);
        }
    }
}

