/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.WrappedGraph;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Dyadic;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.PatternLiteral;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.graph.query.SimpleTripleSorter;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.query.TripleSorter;
import com.hp.hpl.jena.graph.query.test.QueryTest;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.QueryStageException;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestQuery
extends QueryTestBase {
    protected Query Q;
    protected Node O = AbstractTestQuery.node("?O");
    protected Graph empty;
    protected Graph single;
    protected final Node[] none = new Node[0];
    private static final String[][] tests = new String[][]{{"", "pigs might fly", "", ""}, {"", "", "pigs might fly", ""}, {"", "a pings b; b pings c", "a pings _x; _x pings c", "a pings b; b pings c"}, {"", "a pings b; b pings c; a pings x; x pings c", "a pings _x; _x pings c", "a pings b; b pings c; a pings x; x pings c"}};

    public AbstractTestQuery(String name) {
        super(name);
    }

    public abstract Graph getGraph();

    public static TestSuite suite() {
        return new TestSuite(QueryTest.class);
    }

    public Graph getGraphWith(String facts) {
        return AbstractTestQuery.graphAdd(this.getGraph(), facts);
    }

    public void setUp() {
        this.Q = new Query();
        this.empty = this.getGraphWith("");
        this.single = this.getGraphWith("spindizzies drive cities");
    }

    private void testTreeQuery(String title, String content, String pattern, String correct) {
        Graph gc = this.getGraphWith(content);
        Graph gp = this.getGraphWith(pattern);
        Graph answer = gc.queryHandler().prepareTree(gp).executeTree();
        if (title.equals("")) {
            title = "checking {" + content + "} against {" + pattern + "} should give {" + correct + "}" + " not " + answer;
        }
        AbstractTestQuery.assertIsomorphic(title, this.getGraphWith(correct), answer);
    }

    private void testTreeQuery(String content, String pattern, String answer) {
        this.testTreeQuery("checking", content, pattern, answer);
    }

    public void testManyThings() {
        for (int i = 0; i < tests.length; ++i) {
            this.testTreeQuery(tests[i][0], tests[i][1], tests[i][2], tests[i][3]);
        }
    }

    public void testAtomicTreeQuery() {
        this.testTreeQuery("pigs might fly; birds will joke; cats must watch", "birds will joke", "birds will joke");
    }

    public void testCompositeTreeQuery() {
        this.testTreeQuery("pigs might fly; birds will joke; cats must watch", "birds will joke; pigs might fly", "pigs might fly; birds will joke");
    }

    public void testChainedTreeQuery() {
        this.testTreeQuery("a pings b; b pings c; c pings d", "a pings b; b pings c", "a pings b; b pings c");
    }

    public void testEmptyIterator() {
        Graph empty = this.getGraph();
        Query q = new Query().addMatch(X, Y, Z);
        BindingQueryPlan bqp = empty.queryHandler().prepareBindings(q, this.justX);
        AbstractTestQuery.assertEquals(new HashSet(), (Object)bqp.executeBindings().toSet());
    }

    public void testSingleBindings() {
        Graph single = this.getGraphWith("rice grows quickly");
        Node V1 = AbstractTestQuery.node("?v1");
        Node V3 = AbstractTestQuery.node("?v3");
        Query q = new Query().addMatch(V1, AbstractTestQuery.node("grows"), V3);
        BindingQueryPlan qp = single.queryHandler().prepareBindings(q, new Node[]{V1, V3});
        AbstractTestQuery.assertEquals(AbstractTestQuery.nodeListSet("rice quickly"), (Object)qp.executeBindings().toSet());
    }

    public void testMultipleBindings() {
        Graph several = this.getGraphWith("rice grows quickly; time isan illusion");
        Node V1 = AbstractTestQuery.node("?v1");
        Node V2 = AbstractTestQuery.node("?v2");
        Node V3 = AbstractTestQuery.node("?v3");
        Query q = new Query().addMatch(V1, V2, V3);
        BindingQueryPlan qp = several.queryHandler().prepareBindings(q, new Node[]{V1, V2, V3});
        Set<List<Node>> wanted = AbstractTestQuery.nodeListSet("time isan illusion; rice grows quickly");
        AbstractTestQuery.assertEquals(wanted, (Object)qp.executeBindings().toSet());
    }

    protected static Set<List<Node>> nodeListSet(String s) {
        HashSet<List<Node>> result = new HashSet<List<Node>>();
        StringTokenizer st = new StringTokenizer(s, ";");
        while (st.hasMoreTokens()) {
            result.add(AbstractTestQuery.nodeList(st.nextToken()));
        }
        return result;
    }

    public void testMultiplePatterns() {
        Graph bookish = this.getGraphWith("ben wrote Clayface; Starfish ingenre SF; Clayface ingenre Geology; bill wrote Starfish");
        Query q = new Query();
        Node A = AbstractTestQuery.node("?A");
        q.addMatch(X, AbstractTestQuery.node("wrote"), A).addMatch(A, AbstractTestQuery.node("ingenre"), AbstractTestQuery.node("SF"));
        BindingQueryPlan qp = bookish.queryHandler().prepareBindings(q, this.justX);
        Set<List<Node>> justBill = AbstractTestQuery.nodeListSet("bill Starfish");
        AbstractTestQuery.assertEquals(justBill, (Object)qp.executeBindings().toSet());
    }

    protected ExtendedIterator<Domain> eb(Graph g, Query q, Node[] nodes) {
        return g.queryHandler().prepareBindings(q, nodes).executeBindings();
    }

    protected List<Domain> ebList(Graph g, Query q, Node[] nodes) {
        return this.eb(g, q, nodes).toList();
    }

    protected Set<Domain> ebSet(Graph g, Query q, Node[] nodes) {
        return this.eb(g, q, nodes).toSet();
    }

    public void testNodeVariablesA() {
        Graph mine = this.getGraphWith("storms hit England");
        Node spoo = AbstractTestQuery.node("?spoo");
        this.Q.addMatch(spoo, AbstractTestQuery.node("hit"), AbstractTestQuery.node("England"));
        ExtendedIterator<Domain> it = this.eb(mine, this.Q, new Node[]{spoo});
        AbstractTestQuery.assertTrue((String)"tnv: it has a solution", (boolean)it.hasNext());
        AbstractTestQuery.assertEquals((String)"", (Object)AbstractTestQuery.node("storms"), (Object)((Domain)it.next()).get(0));
        AbstractTestQuery.assertFalse((String)"tnv: just the one solution", (boolean)it.hasNext());
    }

    public void testNodeVariablesB() {
        Graph mine = this.getGraphWith("storms hit England");
        Node spoo = AbstractTestQuery.node("?spoo");
        Node flarn = AbstractTestQuery.node("?flarn");
        this.Q.addMatch(spoo, AbstractTestQuery.node("hit"), flarn);
        ExtendedIterator<Domain> it = this.eb(mine, this.Q, new Node[]{flarn, spoo});
        AbstractTestQuery.assertTrue((String)"tnv: it has a solution", (boolean)it.hasNext());
        Domain answer = (Domain)it.next();
        AbstractTestQuery.assertEquals((String)"tnvB", (Object)AbstractTestQuery.node("storms"), (Object)answer.get(1));
        AbstractTestQuery.assertEquals((String)"tnvB", (Object)AbstractTestQuery.node("England"), (Object)answer.get(0));
        AbstractTestQuery.assertFalse((String)"tnv: just the one solution", (boolean)it.hasNext());
    }

    public void testBindingQuery() {
        Graph empty = this.getGraphWith("");
        Graph base = this.getGraphWith("pigs might fly; cats chase mice; dogs chase cars; cats might purr");
        Query any = new Query().addMatch(Query.ANY, Query.ANY, Query.ANY);
        AbstractTestQuery.assertFalse((String)"empty graph, no bindings", (boolean)this.eb(empty, any, this.none).hasNext());
        AbstractTestQuery.assertTrue((String)"full graph, > 0 bindings", (boolean)this.eb(base, new Query(), this.none).hasNext());
    }

    public void testEmpty() {
        List<Domain> bindings = this.ebList(this.empty, this.Q, this.none);
        AbstractTestQuery.assertEquals((String)"testEmpty: select [] from {} => 1 empty binding [size]", (int)bindings.size(), (int)1);
        Domain d = bindings.get(0);
        AbstractTestQuery.assertEquals((String)"testEmpty: select [] from {} => 1 empty binding [width]", (int)d.size(), (int)0);
    }

    public void testOneMatch() {
        this.Q.addMatch(X, Query.ANY, Query.ANY);
        List<Domain> bindings = this.ebList(this.single, this.Q, this.justX);
        AbstractTestQuery.assertEquals((String)"select X from {spindizzies drive cities} => 1 binding [size]", (int)bindings.size(), (int)1);
        Domain d = bindings.get(0);
        AbstractTestQuery.assertEquals((String)"select X from {spindizzies drive cities} => 1 binding [width]", (int)d.size(), (int)1);
        AbstractTestQuery.assertTrue((String)"select X from {spindizzies drive cities} => 1 binding [value]", (boolean)d.get(0).equals((Object)AbstractTestQuery.node("spindizzies")));
    }

    public void testMismatch() {
        this.Q.addMatch(X, X, X);
        List<Domain> bindings = this.ebList(this.single, this.Q, this.justX);
        AbstractTestQuery.assertEquals((String)"bindings mismatch (X X X)", (int)bindings.size(), (int)0);
    }

    public void testXXXMatch1() {
        this.Q.addMatch(X, X, X);
        Graph xxx = this.getGraphWith("ring ring ring");
        List<Domain> bindings = this.ebList(xxx, this.Q, this.justX);
        AbstractTestQuery.assertEquals((String)"bindings match (X X X)", (int)bindings.size(), (int)1);
    }

    public void testXXXMatch3() {
        this.Q.addMatch(X, X, X);
        Graph xxx = this.getGraphWith("ring ring ring; ding ding ding; ping ping ping");
        List<Domain> bindings = this.ebList(xxx, this.Q, this.justX);
        AbstractTestQuery.assertEquals((String)"bindings match (X X X)", (int)bindings.size(), (int)3);
        Set found = CollectionFactory.createHashedSet();
        for (int i = 0; i < bindings.size(); ++i) {
            Domain d = bindings.get(i);
            AbstractTestQuery.assertEquals((String)"one bound variable", (int)d.size(), (int)1);
            found.add(d.get(0));
        }
        Set<Node> wanted = this.nodeSet("ring ding ping");
        AbstractTestQuery.assertEquals((String)"testMatch getting {ring ding ping}", (Object)found, wanted);
    }

    public void testTwoPatterns() {
        Node reads = AbstractTestQuery.node("reads");
        Node inGenre = AbstractTestQuery.node("inGenre");
        Graph g = this.getGraphWith("chris reads blish; blish inGenre SF");
        this.Q.addMatch(X, reads, Y);
        this.Q.addMatch(Y, inGenre, Z);
        List<Domain> bindings = this.ebList(g, this.Q, new Node[]{X, Z});
        AbstractTestQuery.assertEquals((String)"testTwoPatterns: one binding", (int)1, (int)bindings.size());
        Domain d = bindings.get(0);
        AbstractTestQuery.assertTrue((String)"testTwoPatterns: width 2", (d.size() >= 2 ? 1 : 0) != 0);
        AbstractTestQuery.assertEquals((String)"testTwoPatterns: X = chris", (Object)d.get(0), (Object)AbstractTestQuery.node("chris"));
        AbstractTestQuery.assertEquals((String)"testTwoPatterns: Y = SF", (Object)d.get(1), (Object)AbstractTestQuery.node("SF"));
    }

    public void testGraphQuery() {
        Graph pattern = this.getGraphWith("?X reads ?Y; ?Y inGenre ?Z");
        Graph target = this.getGraphWith("chris reads blish; blish inGenre SF");
        Query q = new Query(pattern);
        List<Domain> bindings = this.ebList(target, q, new Node[]{AbstractTestQuery.node("?X"), AbstractTestQuery.node("?Z")});
        AbstractTestQuery.assertEquals((String)"testTwoPatterns: one binding", (int)1, (int)bindings.size());
        Domain d = bindings.get(0);
        AbstractTestQuery.assertTrue((String)"testTwoPatterns: width 2", (d.size() >= 2 ? 1 : 0) != 0);
        AbstractTestQuery.assertEquals((String)"testTwoPatterns: X = chris", (Object)d.get(0), (Object)AbstractTestQuery.node("chris"));
        AbstractTestQuery.assertEquals((String)"testTwoPatterns: Y = SF", (Object)d.get(1), (Object)AbstractTestQuery.node("SF"));
    }

    public void testGraphConstraints(String title, Expression constraint, String wanted) {
        Query Q = new Query().addMatch(Query.ANY, Query.ANY, this.O).addConstraint(constraint);
        Graph G = this.getGraphWith("pigs fly south; dogs fly badly; plans fly flat");
        Set results = this.eb(G, Q, new Node[]{this.O}).mapWith(getFirst).toSet();
        AbstractTestQuery.assertEquals((String)"tgs", this.nodeSet(wanted), (Object)results);
    }

    public void testGraphConstraints() {
        Node badly = AbstractTestQuery.node("badly");
        Node flat = AbstractTestQuery.node("flat");
        this.testGraphConstraints("tgs A", Expression.TRUE, "south flat badly");
        this.testGraphConstraints("tgs B", this.notEqual(this.O, badly), "south flat");
        this.testGraphConstraints("tgs C", Dyadic.and((Expression)this.notEqual(this.O, badly), (Expression)this.notEqual(this.O, flat)), "south");
    }

    private void helpConstraint(String title, Expression constraints, int n) {
        Query q = new Query();
        Graph g = this.getGraphWith("blish wrote CIF; blish wrote VOR; hambly wrote Darwath; feynman mechanicked quanta");
        q.addMatch(X, AbstractTestQuery.node("wrote"), Query.ANY);
        q.addConstraint(constraints);
        List<Domain> bindings = this.ebList(g, q, this.justX);
        AbstractTestQuery.assertEquals((String)("testConstraint " + title + ": number of bindings"), (int)n, (int)bindings.size());
    }

    public void testConstraint() {
        this.helpConstraint("none", Expression.TRUE, 3);
        this.helpConstraint("X /= blish", this.notEqual(X, AbstractTestQuery.node("blish")), 1);
        this.helpConstraint("X /= blish & X /= hambly", Dyadic.and((Expression)this.notEqual(X, AbstractTestQuery.node("blish")), (Expression)this.notEqual(X, AbstractTestQuery.node("hambly"))), 0);
    }

    private void helpConstraintThree(String title, Expression c, int n) {
        Query q = new Query();
        Graph g = this.getGraphWith("brust wrote jhereg; hedgehog hacked code; angel age 230; brust wrote 230");
        q.addConstraint(c);
        q.addMatch(X, Y, Z);
        List<Domain> bindings = this.ebList(g, q, new Node[]{X, Z});
        AbstractTestQuery.assertEquals((String)("testConstraint " + title + ": number of bindings"), (int)n, (int)bindings.size());
    }

    public void testConstraintThree() {
        this.helpConstraintThree("testConstraintThree 1:", this.areEqual(X, AbstractTestQuery.node("brust")), 2);
        this.helpConstraintThree("testConstraintThree 2:", this.areEqual(Y, AbstractTestQuery.node("hacked")), 1);
        this.helpConstraintThree("testConstraintThree 3:", this.areEqual(Z, AbstractTestQuery.node("230")), 2);
    }

    public void testConstraintFour() {
        Query q = new Query();
        Graph g = this.getGraphWith("bill pinged ben; ben pinged weed; weed pinged weed; bill ignored bill");
        q.addMatch(X, AbstractTestQuery.node("pinged"), Y);
        q.addConstraint(this.notEqual(X, Y));
        Set bindings = this.eb(g, q, this.justX).mapWith(getFirst).toSet();
        AbstractTestQuery.assertEquals(this.arrayToSet(new Node[]{AbstractTestQuery.node("bill"), AbstractTestQuery.node("ben")}), (Object)bindings);
    }

    public void testMatchConstraint() {
        Set expected = CollectionFactory.createHashedSet();
        expected.add(AbstractTestQuery.node("beta"));
        Query q = new Query().addMatch(X, AbstractTestQuery.node("ppp"), Y).addConstraint(this.matches(Y, AbstractTestQuery.node("'ell'")));
        Graph g = this.getGraphWith("alpha ppp beta; beta ppp 'hello'; gamma ppp 'goodbye'");
        Set bindings = this.eb(g, q, this.justX).mapWith(getFirst).toSet();
        AbstractTestQuery.assertEquals((Object)expected, (Object)bindings);
    }

    public void testExtractConstraint() {
    }

    public void testStringResults() {
        Graph g = this.getGraphWith("ding dong dilly");
        Query q = new Query().addMatch(X, Y, Query.ANY);
        List<Domain> bindings = this.ebList(g, q, new Node[]{X, Y});
        AbstractTestQuery.assertEquals((String)"one result back by name", (int)bindings.size(), (int)1);
        AbstractTestQuery.assertEquals((String)"x = ding", (Object)bindings.get(0).get(0), (Object)AbstractTestQuery.node("ding"));
    }

    public void testMissingVariable() {
        Graph g = this.getGraphWith("x y z");
        List<Domain> bindings = this.ebList(g, this.Q, new Node[]{X, Y});
        Domain L = bindings.get(0);
        AbstractTestQuery.assertEquals((String)"undefined variables get null", null, (Object)L.get(0));
    }

    public void testDisconnected() {
        Graph g = this.getGraphWith("x pred1 foo; y pred2 bar");
        Query q = new Query(this.getGraphWith("?X ?? foo; ?Y ?? bar"));
        List<Domain> bindings = this.ebList(g, q, AbstractTestQuery.nodeArray("?X ?Y"));
        AbstractTestQuery.assertEquals((int)1, (int)bindings.size());
        AbstractTestQuery.assertEquals((Object)AbstractTestQuery.node("x"), (Object)bindings.get(0).get(0));
        AbstractTestQuery.assertEquals((Object)AbstractTestQuery.node("y"), (Object)bindings.get(0).get(1));
    }

    public void testQueryTripleOrder() {
        Triple t1 = Triple.create((String)"A B C");
        Triple t2 = Triple.create((String)"D E F");
        List<Triple> desired = Arrays.asList(t1, t2);
        List<Triple> obtained = this.getTriplesFromQuery(desired);
        AbstractTestQuery.assertEquals(desired, obtained);
    }

    private List<Triple> getTriplesFromQuery(List<Triple> desired) {
        Query q = new Query();
        final Triple[][] tripleses = new Triple[1][];
        GraphBase g = new GraphBase(){

            public ExtendedIterator<Triple> graphBaseFind(TripleMatch tm) {
                return NullIterator.instance();
            }

            public QueryHandler queryHandler() {
                return new SimpleQueryHandler((Graph)this){

                    public Stage patternStage(Mapping map, ExpressionSet constraints, Triple[] t) {
                        if (t.length > 1) {
                            tripleses[0] = t;
                        }
                        return super.patternStage(map, constraints, t);
                    }
                };
            }
        };
        for (int i = 0; i < desired.size(); ++i) {
            q.addMatch(desired.get(i));
        }
        this.eb((Graph)g, q, this.none);
        return Arrays.asList(tripleses[0]);
    }

    public void testVariableCount() {
        this.assertCount(0, "");
        this.assertCount(0, "x R y");
        this.assertCount(1, "?x R y");
        this.assertCount(1, "?x R y", "?x");
        this.assertCount(2, "?x R y", "?z");
        this.assertCount(1, "?x R ?x");
        this.assertCount(2, "?x R ?y");
        this.assertCount(3, "?x R ?y", "?z");
        this.assertCount(3, "?x ?R ?y");
        this.assertCount(6, "?x ?R ?y; ?a ?S ?c");
        this.assertCount(6, "?x ?R ?y; ?a ?S ?c", "?x");
        this.assertCount(6, "?x ?R ?y; ?a ?S ?c", "?x ?c");
        this.assertCount(6, "?x ?R ?y; ?a ?S ?c", "?x ?y ?c");
        this.assertCount(7, "?x ?R ?y; ?a ?S ?c", "?dog");
        this.assertCount(8, "?x ?R ?y; ?a ?S ?c", "?dog ?cat ?x");
        this.assertCount(18, "?a ?b ?c; ?d ?e ?f; ?g ?h ?i; ?j ?k ?l; ?m ?n ?o; ?p ?q ?r");
    }

    public void assertCount(int expected, String query) {
        this.assertCount(expected, query, "");
    }

    public void assertCount(int expected, String query, String vars) {
        Graph g = this.getGraphWith("");
        Query q = new Query();
        Triple[] triples = AbstractTestQuery.tripleArray(query);
        for (int i = 0; i < triples.length; ++i) {
            q.addMatch(triples[i]);
        }
        q.executeBindings(g, AbstractTestQuery.nodeArray(vars));
        AbstractTestQuery.assertEquals((int)expected, (int)q.getVariableCount());
    }

    public void testQueryConstraintUnbound() {
        Query q = new Query().addConstraint(this.notEqual(X, Z)).addMatch(X, Query.ANY, X);
        Graph g = this.getGraphWith("x R x; x R y");
        try {
            ExtendedIterator<Domain> it = this.eb(g, q, this.justX);
            AbstractTestQuery.fail((String)"should spot unbound variable");
        }
        catch (Query.UnboundVariableException b) {
            AbstractTestQuery.pass();
        }
    }

    public void testCloseQuery() {
        int i;
        Graph g = this.getGraphWith("x R y; a P b; i L j; d X f; h S g; no more heroes");
        for (int n = 0; n < 1000; ++n) {
            AbstractTestQuery.graphAdd(g, "ping pong X" + n);
        }
        Query q = new Query().addMatch(Query.S, Query.P, Query.O);
        ArrayList stages = new ArrayList();
        ExtendedIterator<Domain> it = this.eb(g, q, AbstractTestQuery.nodeArray("?P"));
        it.next();
        for (i = 0; i < stages.size(); ++i) {
            AbstractTestQuery.assertFalse((boolean)((Stage)stages.get(i)).isClosed());
        }
        it.close();
        for (i = 0; i < stages.size(); ++i) {
            AbstractTestQuery.assertTrue((boolean)((Stage)stages.get(i)).isClosed());
        }
    }

    public void testRewriteStartswithExpression() {
        Query q = new Query();
        Expression L = this.constant("x");
        Expression R = this.createSimplePattern("^begins");
        Expression provided = this.dyadic(L, "Q_StringMatch", R);
        Expression desired = this.dyadic(L, "J_startsWith", this.constant("begins"));
        q.addConstraint(provided);
        Expression e2 = (Expression)q.getConstraints().iterator().next();
        AbstractTestQuery.assertEquals((Object)desired, (Object)e2);
    }

    public void testRewriteStartswithInsensitiveExpression() {
        Query q = new Query();
        Expression L = this.constant("x");
        Expression R = this.createModifiedPattern("^begins", "i");
        Expression provided = this.dyadic(L, "Q_StringMatch", R);
        Expression desired = this.dyadic(L, "J_startsWithInsensitive", this.constant("begins"));
        q.addConstraint(provided);
        Expression e2 = (Expression)q.getConstraints().iterator().next();
        AbstractTestQuery.assertEquals((Object)desired, (Object)e2);
    }

    public void testRewriteEndswithExpression() {
        Query q = new Query();
        Expression L = this.constant("x");
        Expression R = this.createSimplePattern("ends$");
        Expression provided = this.dyadic(L, "Q_StringMatch", R);
        Expression desired = this.dyadic(L, "J_endsWith", this.constant("ends"));
        q.addConstraint(provided);
        Expression e2 = (Expression)q.getConstraints().iterator().next();
        AbstractTestQuery.assertEquals((Object)desired, (Object)e2);
    }

    public void testRewriteEndswithInsensitiveExpression() {
        Query q = new Query();
        Expression L = this.constant("x");
        Expression R = this.createModifiedPattern("ends$", "i");
        Expression provided = this.dyadic(L, "Q_StringMatch", R);
        Expression desired = this.dyadic(L, "J_endsWithInsensitive", this.constant("ends"));
        q.addConstraint(provided);
        Expression e2 = (Expression)q.getConstraints().iterator().next();
        AbstractTestQuery.assertEquals((Object)desired, (Object)e2);
    }

    public void testRewriteContainsExpression() {
        Query q = new Query();
        Expression L = this.constant("x");
        Expression R = this.createSimplePattern("contains");
        Expression provided = this.dyadic(L, "Q_StringMatch", R);
        Expression desired = this.dyadic(L, "J_contains", this.constant("contains"));
        q.addConstraint(provided);
        Expression e2 = (Expression)q.getConstraints().iterator().next();
        AbstractTestQuery.assertEquals((Object)desired, (Object)e2);
    }

    public void testRewritePreservesCharacterCases() {
        Query q = new Query();
        Expression L = this.constant("x");
        Expression R = this.createModifiedPattern("coNtaIns", "i");
        Expression provided = this.dyadic(L, "Q_StringMatch", R);
        Expression desired = this.dyadic(L, "J_containsInsensitive", this.constant("coNtaIns"));
        q.addConstraint(provided);
        Expression e2 = (Expression)q.getConstraints().iterator().next();
        AbstractTestQuery.assertEquals((Object)desired, (Object)e2);
    }

    public void testQueryExceptionCleanlyExits() {
        Query q = new Query().addMatch(Triple.ANY);
        GraphBase g = new GraphBase(){

            protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
                throw new BangException();
            }
        };
        ExtendedIterator<Domain> it = this.eb((Graph)g, q, new Node[0]);
        try {
            it.next();
            AbstractTestQuery.fail((String)"should fail because graph explodes");
        }
        catch (QueryStageException e) {
            AbstractTestQuery.assertTrue((boolean)(e.getCause() instanceof BangException));
        }
        catch (Exception e) {
            AbstractTestQuery.fail((String)"should throw QueryStageException");
        }
    }

    public Expression createSimplePattern(String p) {
        return new PL(p);
    }

    public Expression createModifiedPattern(String content, String modifiers) {
        return new PL(content, modifiers);
    }

    private Expression constant(Object it) {
        return new Expression.Fixed(it);
    }

    private Expression dyadic(Expression l, String op, Expression r) {
        String f = "urn:x-jena:expr:" + op;
        return new Dyadic(l, f, r){

            public boolean evalBool(Object l, Object r) {
                return false;
            }
        };
    }

    public void testTripleSorting() {
        Graph g = this.dataGraph();
        Map<List<Node>, Integer> answer = this.getAnswer(g, TripleSorter.dontSort);
        AbstractTestQuery.assertEquals((int)1, (int)answer.size());
        AbstractTestQuery.assertEquals((Object)new Integer(1), (Object)answer.get(Arrays.asList(AbstractTestQuery.nodeArray("a d"))));
        AbstractTestQuery.assertEquals(answer, this.getAnswer(g, TripleSorter.dontSort));
        AbstractTestQuery.assertEquals(answer, this.getAnswer(g, this.fiddle(0, 2, 1)));
        AbstractTestQuery.assertEquals(answer, this.getAnswer(g, this.fiddle(1, 0, 2)));
        AbstractTestQuery.assertEquals(answer, this.getAnswer(g, this.fiddle(1, 2, 0)));
        AbstractTestQuery.assertEquals(answer, this.getAnswer(g, this.fiddle(2, 1, 0)));
        AbstractTestQuery.assertEquals(answer, this.getAnswer(g, this.fiddle(2, 0, 1)));
    }

    protected TripleSorter fiddle(final int a, final int b, final int c) {
        return new TripleSorter(){

            public Triple[] sort(Triple[] triples) {
                return new Triple[]{triples[a], triples[b], triples[c]};
            }
        };
    }

    protected Graph dataGraph() {
        Graph result = this.getGraph();
        AbstractTestQuery.graphAdd(result, "a SPOO d; a X b; b Y c");
        return result;
    }

    protected Map<List<Node>, Integer> getAnswer(Graph g, TripleSorter sorter) {
        Map result = CollectionFactory.createHashedMap();
        Query q = new Query();
        q.addMatch(AbstractTestQuery.triple("?a ?? ?d ")).addMatch(AbstractTestQuery.triple("?a X ?b")).addMatch(AbstractTestQuery.triple("?b Y ?c"));
        q.addConstraint(this.notEqual(AbstractTestQuery.node("?d"), AbstractTestQuery.node("?b")));
        Node[] answers = AbstractTestQuery.nodeArray("?a ?d");
        q.setTripleSorter(sorter);
        ExtendedIterator<Domain> it = this.eb(g, q, answers);
        while (it.hasNext()) {
            this.addAnswer(result, (Domain)it.next(), answers.length);
        }
        return result;
    }

    protected void addAnswer(Map<List<Node>, Integer> result, Domain bindings, int limit) {
        List key = bindings.subList(0, limit);
        Integer already = result.get(key);
        if (already == null) {
            already = new Integer(0);
        }
        result.put(key, new Integer(already + 1));
    }

    public void testQueryOptimisation() {
        int dontCount = this.queryCount(TripleSorter.dontSort);
        int optimCount = this.queryCount((TripleSorter)new SimpleTripleSorter());
        if (optimCount > dontCount) {
            AbstractTestQuery.fail((String)("optimisation " + optimCount + " yet plain " + dontCount));
        }
    }

    public void testFixedTypedLiterals() {
        Graph g = this.getGraphWith("a P 'value'xsd:string; b P 'value'xsd:nosuch");
        if (g.getCapabilities().handlesLiteralTyping()) {
            Query q = new Query().addMatch(Query.S, Query.P, AbstractTestQuery.node("'value'"));
            ExtendedIterator it = q.executeBindings(g, new Node[]{Query.S, Query.P});
            AbstractTestQuery.assertEquals(this.nodeSet("a"), (Object)it.mapWith(this.select(0)).toSet());
        }
    }

    public void testBoundTypedLiterals() {
        Graph g = this.getGraphWith("a P 'value'xsd:string; b V 'value'");
        if (g.getCapabilities().handlesLiteralTyping()) {
            Query q = new Query().addMatch(AbstractTestQuery.node("b"), AbstractTestQuery.node("V"), Query.X).addMatch(Query.S, AbstractTestQuery.node("P"), Query.X);
            ExtendedIterator it = q.executeBindings(g, new Node[]{Query.S, Query.P});
            AbstractTestQuery.assertEquals(this.nodeSet("a"), (Object)it.mapWith(this.select(0)).toSet());
        }
    }

    int queryCount(TripleSorter sort) {
        CountingGraph g = this.bigCountingGraph();
        for (int a = 0; a < 10; ++a) {
            for (int b = 0; b < 10; ++b) {
                for (int X = 0; X < 3; ++X) {
                    AbstractTestQuery.graphAdd((Graph)g, "a" + a + " X" + (X == 0 ? "" : X + "") + " b" + b);
                }
            }
        }
        AbstractTestQuery.graphAdd((Graph)g, "a SPOO d; a X b; b Y c");
        this.getAnswer((Graph)g, sort);
        return g.getCount();
    }

    CountingGraph bigCountingGraph() {
        Graph bigGraph = this.getGraph();
        return new CountingGraph(bigGraph);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CountingGraph
    extends WrappedGraph {
        int counter;
        private QueryHandler qh = new SimpleQueryHandler((Graph)this);

        public QueryHandler queryHandler() {
            return this.qh;
        }

        CountingGraph(Graph base) {
            super(base);
        }

        public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
            return this.find((TripleMatch)Triple.createMatch((Node)s, (Node)p, (Node)o));
        }

        public ExtendedIterator<Triple> find(TripleMatch tm) {
            return this.count((ExtendedIterator<Triple>)this.base.find(tm));
        }

        ExtendedIterator<Triple> count(ExtendedIterator<Triple> it) {
            return new WrappedIterator<Triple>(it){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Triple next() {
                    try {
                        Triple triple = (Triple)super.next();
                        return triple;
                    }
                    finally {
                        ++CountingGraph.this.counter;
                    }
                }
            };
        }

        int getCount() {
            return this.counter;
        }

        public String toString() {
            return this.base.toString();
        }
    }

    protected static class PL
    extends Expression.Fixed
    implements PatternLiteral {
        protected String modifiers = "";

        public PL(String content) {
            super((Object)content);
        }

        public PL(String content, String modifiers) {
            super((Object)content);
            this.modifiers = modifiers;
        }

        public String getPatternString() {
            return (String)this.value;
        }

        public String getPatternModifiers() {
            return this.modifiers;
        }

        public String getPatternLanguage() {
            return "http://jena.hpl.hp.com/2003/07/query/RDQL";
        }
    }

    protected static class BangException
    extends JenaException {
        public BangException() {
            super("bang!");
        }
    }
}

