/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.test.AbstractTestQuery1;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.shared.ReificationStyle;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestSuite;

public class TestQuery1
extends AbstractTestQuery1 {
    private IDBConnection theConnection;
    private int count = 0;
    private List<GraphRDB> graphs;

    public TestQuery1(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestQuery1.class);
    }

    public void setUp() throws Exception {
        this.theConnection = TestConnection.makeTestConnection();
        this.graphs = new ArrayList<GraphRDB>();
        super.setUp();
    }

    public void tearDown() throws Exception {
        this.removeGraphs();
        this.theConnection.close();
        super.tearDown();
    }

    private void removeGraphs() {
        for (int i = 0; i < this.graphs.size(); ++i) {
            this.graphs.get(i).remove();
        }
    }

    public Graph getGraph() {
        return this.getGraph(ReificationStyle.Minimal);
    }

    public Graph getGraph(ReificationStyle style) {
        String name = "jena-test-rdb-TestQuery1-" + this.count++;
        if (this.theConnection.containsModel(name)) {
            this.makeGraph(name, false, style).remove();
        }
        GraphRDB result = this.makeGraph(name, true, style);
        this.graphs.add(result);
        return result;
    }

    protected GraphRDB makeGraph(String name, boolean fresh, ReificationStyle style) {
        return new GraphRDB(this.theConnection, name, this.theConnection.getDefaultModelProperties().getGraph(), GraphRDB.styleRDB((ReificationStyle)style), fresh);
    }
}

