/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.test.AbstractTestPrefixMapping;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestSuite;

public class TestPrefixMapping
extends AbstractTestPrefixMapping {
    private List<Model> models = null;
    private IDBConnection theConnection = null;
    private static int count = 0;

    public TestPrefixMapping(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestPrefixMapping.class);
    }

    public void setUp() {
        this.theConnection = TestConnection.makeAndCleanTestConnection();
        this.models = new ArrayList<Model>();
    }

    public void tearDown() {
        for (Model m : this.models) {
            m.close();
        }
        try {
            this.theConnection.close();
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    private String getModelName() {
        return "test" + count++;
    }

    private Model getModel() {
        ModelRDB model = ModelRDB.createModel((IDBConnection)this.theConnection, (String)this.getModelName());
        this.models.add((Model)model);
        return model;
    }

    public PrefixMapping getMapping() {
        Model model = this.getModel();
        return model.getGraph().getPrefixMapping();
    }

    public void testPrefixesPersist() {
        String name = "prefix-testing-model-persist";
        ModelRDB m = ModelRDB.createModel((IDBConnection)this.theConnection, (String)name);
        m.setNsPrefix("hello", "eh:/someURI#");
        m.setNsPrefix("bingo", "eh:/otherURI#");
        m.setNsPrefix("yendi", "eh:/otherURI#");
        m.close();
        ModelRDB m1 = ModelRDB.open((IDBConnection)this.theConnection, (String)name);
        TestPrefixMapping.assertEquals((String)"eh:/someURI#", (String)m1.getNsPrefixURI("hello"));
        TestPrefixMapping.assertEquals((String)"eh:/otherURI#", (String)m1.getNsPrefixURI("yendi"));
        TestPrefixMapping.assertEquals((String)"eh:/otherURI#", (String)m1.getNsPrefixURI("bingo"));
        m1.close();
    }

    public void testPrefixesRemoved() {
        String name = "prefix-testing-model-remove";
        ModelRDB m = ModelRDB.createModel((IDBConnection)this.theConnection, (String)name);
        m.setNsPrefix("hello", "eh:/someURI#");
        m.setNsPrefix("there", "eg:/otherURI#");
        m.removeNsPrefix("hello");
        TestPrefixMapping.assertEquals(null, (String)m.getNsPrefixURI("hello"));
        m.close();
        ModelRDB m1 = ModelRDB.open((IDBConnection)this.theConnection, (String)name);
        TestPrefixMapping.assertEquals(null, (String)m1.getNsPrefixURI("hello"));
        TestPrefixMapping.assertEquals((String)"eg:/otherURI#", (String)m1.getNsPrefixURI("there"));
        m1.close();
    }
}

