/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.BadObjectException;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.RuleSet;
import com.hp.hpl.jena.assembler.assemblers.RuleSetAssembler;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRuleSetAssembler
extends AssemblerTestBase {
    public TestRuleSetAssembler(String name) {
        super(name);
    }

    @Override
    protected Class<? extends Assembler> getAssemblerClass() {
        return RuleSetAssembler.class;
    }

    public void testRuleSetVocabulary() {
        this.assertSubclassOf(JA.RuleSet, JA.HasRules);
        this.assertDomain(JA.HasRules, JA.rule);
        this.assertDomain(JA.HasRules, JA.rulesFrom);
        this.assertDomain(JA.HasRules, JA.rules);
        this.assertRange(JA.RuleSet, JA.rules);
    }

    public void testRuleSetAssemblerType() {
        this.testDemandsMinimalType((Assembler)new RuleSetAssembler(), JA.RuleSet);
    }

    public void testEmptyRuleSet() {
        RuleSetAssembler a = new RuleSetAssembler();
        Resource root = this.resourceInModel("x rdf:type ja:RuleSet");
        TestRuleSetAssembler.assertEquals((Object)RuleSet.empty, (Object)a.open(root));
    }

    public void testSingleRuleString() {
        RuleSetAssembler a = new RuleSetAssembler();
        String ruleString = "[(?a P ?b) -> (?a Q ?b)]";
        Resource root = this.resourceInModel("x rdf:type ja:RuleSet; x ja:rule '" + ruleString.replaceAll(" ", "\\\\s") + "'");
        RuleSet rules = (RuleSet)a.open(root);
        HashSet expected = new HashSet(Rule.parseRules((String)ruleString));
        TestRuleSetAssembler.assertEquals(expected, new HashSet(rules.getRules()));
    }

    public void testMultipleRuleStrings() {
        RuleSetAssembler a = new RuleSetAssembler();
        String ruleStringA = "[(?a P ?b) -> (?a Q ?b)]";
        String ruleStringB = "[(?a R ?b) -> (?a S ?b)]";
        Resource root = this.resourceInModel("x rdf:type ja:RuleSet; x ja:rule '" + ruleStringA.replaceAll(" ", "\\\\s") + "'" + "; x ja:rule '" + ruleStringB.replaceAll(" ", "\\\\s") + "'");
        RuleSet rules = (RuleSet)a.open(root);
        HashSet expected = new HashSet(Rule.parseRules((String)ruleStringA));
        expected.addAll(Rule.parseRules((String)ruleStringB));
        TestRuleSetAssembler.assertEquals(expected, new HashSet(rules.getRules()));
    }

    public void testRulesFrom() {
        RuleSetAssembler a = new RuleSetAssembler();
        String rulesA = TestRuleSetAssembler.file("example.rules");
        Resource root = this.resourceInModel("x rdf:type ja:RuleSet; x ja:rulesFrom " + rulesA);
        HashSet expected = new HashSet(Rule.rulesFromURL((String)rulesA));
        RuleSet rules = (RuleSet)a.open(root);
        TestRuleSetAssembler.assertEquals(expected, new HashSet(rules.getRules()));
    }

    public void testSubRules() {
        RuleSetAssembler a = new RuleSetAssembler();
        String ruleStringA = "[(?a P ?b) -> (?a Q ?b)]";
        Resource root = this.resourceInModel("x rdf:type ja:RuleSet; x ja:rules y; y rdf:type ja:RuleSet; y ja:rule '" + ruleStringA.replaceAll(" ", "\\\\s") + "'");
        HashSet expected = new HashSet(Rule.parseRules((String)ruleStringA));
        RuleSet rules = (RuleSet)a.open(root);
        TestRuleSetAssembler.assertEquals(expected, new HashSet(rules.getRules()));
    }

    public void testTrapsBadRulesObject() {
        this.testTrapsBadRuleObject("ja:rules", "'y'");
        this.testTrapsBadRuleObject("ja:rulesFrom", "17");
        this.testTrapsBadRuleObject("ja:rule", "aResource");
        this.testTrapsBadRuleObject("ja:rule", "17");
        this.testTrapsBadRuleObject("ja:rule", "'something'xsd:else");
    }

    private void testTrapsBadRuleObject(String property, String value) {
        RuleSetAssembler a = new RuleSetAssembler();
        Resource root = this.resourceInModel("x rdf:type ja:RuleSet; x <property> <value>".replaceAll("<property>", property).replaceAll("<value>", value));
        try {
            a.open(root);
            TestRuleSetAssembler.fail((String)("should trap bad rules object " + value + " for property " + property));
        }
        catch (BadObjectException e) {
            Model m = e.getRoot().getModel();
            TestRuleSetAssembler.assertEquals((Object)TestRuleSetAssembler.resource("x"), (Object)e.getRoot());
            TestRuleSetAssembler.assertEquals((Object)TestRuleSetAssembler.rdfNode(m, value), (Object)e.getObject());
        }
    }

    protected static String file(String name) {
        return "file:testing/modelspecs/" + name;
    }
}

