/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.RuleSet;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.shared.BrokenException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRuleSet
extends AssemblerTestBase {
    public TestRuleSet(String name) {
        super(name);
    }

    @Override
    protected Class<? extends Assembler> getAssemblerClass() {
        throw new BrokenException("TestAssemblers does not need this method");
    }

    public void testEmpty() {
        TestRuleSet.assertEquals((Object)Collections.EMPTY_LIST, (Object)RuleSet.empty.getRules());
        TestRuleSet.assertEquals((Object)RuleSet.empty, (Object)RuleSet.create(Collections.emptyList()));
    }

    public void testEmptyRuleSet() {
        RuleSet s = RuleSet.create(Collections.emptyList());
        TestRuleSet.assertEquals((Object)Collections.EMPTY_LIST, (Object)s.getRules());
        TestRuleSet.assertNotSame((Object)Collections.EMPTY_LIST, (Object)s.getRules());
    }

    public void testSingleRuleSet() {
        Rule rule = Rule.parseRule((String)"[(?a P b) -> (?a rdf:type T)]");
        List<Rule> list = TestRuleSet.listOfOne(rule);
        RuleSet s = RuleSet.create(list);
        TestRuleSet.assertEquals(list, (Object)s.getRules());
        TestRuleSet.assertNotSame(list, (Object)s.getRules());
    }

    public void testMultipleRuleSet() {
        Rule A = Rule.parseRule((String)"[(?a P b) -> (?a rdf:type T)]");
        Rule B = Rule.parseRule((String)"[(?a Q b) -> (?a rdf:type U)]");
        List<Rule> rules = Arrays.asList(A, B);
        RuleSet s = RuleSet.create(rules);
        TestRuleSet.assertEquals(rules, (Object)s.getRules());
        TestRuleSet.assertNotSame(rules, (Object)s.getRules());
    }

    public void testFactoryForString() {
        String ruleString = "[(?a P b) -> (?a rdf:type T)]";
        RuleSet s = RuleSet.create((String)ruleString);
        TestRuleSet.assertEquals((Object)Rule.parseRules((String)ruleString), (Object)s.getRules());
    }

    public void testHashAndEquality() {
        String A = "[(?x breaks ?y) -> (?y brokenBy ?x)]";
        String B = "[(?a Q b) -> (?a rdf:type U)]";
        RuleSet rsA = RuleSet.create((String)A);
        RuleSet rsA2 = RuleSet.create((String)A);
        RuleSet rsB = RuleSet.create((String)B);
        TestRuleSet.assertEquals((Object)rsA.getRules(), (Object)rsA2.getRules());
        TestRuleSet.assertEquals((Object)rsA, (Object)rsA2);
        TestRuleSet.assertDiffer(rsA, rsB);
        TestRuleSet.assertEquals((int)rsA.hashCode(), (int)rsA2.hashCode());
        TestRuleSet.assertFalse((rsA.hashCode() == rsB.hashCode() ? 1 : 0) != 0);
    }
}

