/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.assemblers.PrefixMappingAssembler;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPrefixMappingAssembler
extends AssemblerTestBase {
    public TestPrefixMappingAssembler(String name) {
        super(name);
    }

    @Override
    protected Class<? extends Assembler> getAssemblerClass() {
        return PrefixMappingAssembler.class;
    }

    public void testPrefixMappingAssemblerType() {
        this.testDemandsMinimalType((Assembler)new PrefixMappingAssembler(), JA.PrefixMapping);
    }

    public void testConstructEmptyPrefixMapping() {
        PrefixMappingAssembler a = new PrefixMappingAssembler();
        Resource root = this.resourceInModel("pm rdf:type ja:PrefixMapping");
        Object pm = a.open(root);
        TestPrefixMappingAssembler.assertInstanceOf(PrefixMapping.class, pm);
    }

    public void testSimplePrefixMapping() {
        PrefixMapping wanted = PrefixMapping.Factory.create().setNsPrefix("pre", "some:prefix/");
        PrefixMappingAssembler a = new PrefixMappingAssembler();
        Resource root = this.resourceInModel("pm rdf:type ja:PrefixMapping; pm ja:prefix 'pre'; pm ja:namespace 'some:prefix/'");
        PrefixMapping pm = (PrefixMapping)a.open(root);
        this.assertSamePrefixMapping(wanted, pm);
    }

    public void testIncludesSingleMapping() {
        PrefixMapping wanted = PrefixMapping.Factory.create().setNsPrefix("pre", "some:prefix/");
        PrefixMappingAssembler a = new PrefixMappingAssembler();
        Resource root = this.resourceInModel("root rdf:type ja:PrefixMapping; root ja:includes pm; pm rdf:type ja:PrefixMapping; pm ja:prefix 'pre'; pm ja:namespace 'some:prefix/'");
        PrefixMapping pm = (PrefixMapping)a.open(root);
        this.assertSamePrefixMapping(wanted, pm);
    }

    public void testIncludesMultipleMappings() {
        PrefixMapping wanted = PrefixMapping.Factory.create().setNsPrefix("p1", "some:prefix/").setNsPrefix("p2", "other:prefix/").setNsPrefix("p3", "simple:prefix#");
        PrefixMappingAssembler a = new PrefixMappingAssembler();
        Resource root = this.resourceInModel("root rdf:type ja:PrefixMapping; root ja:includes pm1; pm1 rdf:type ja:PrefixMapping; pm1 ja:prefix 'p1'; pm1 ja:namespace 'some:prefix/'; root ja:includes pm2; pm2 rdf:type ja:PrefixMapping; pm2 ja:prefix 'p2'; pm2 ja:namespace 'other:prefix/'; root ja:prefix 'p3'; root ja:namespace 'simple:prefix#'");
        PrefixMapping pm = (PrefixMapping)a.open(root);
        this.assertSamePrefixMapping(wanted, pm);
    }
}

