/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version {
    private List<Class<?>> classes = new ArrayList();
    private static String[] fields = new String[]{"VERSION", "BUILD_DATE"};

    public void addClass(Class<?> c) {
        this.classes.add(c);
    }

    public void print() {
        for (Class<?> c : this.classes) {
            String x = Utils.classShortName(c);
            Version.fields(x, c);
        }
    }

    private static void fields(String prefix, Class<?> cls) {
        for (int i = 0; i < fields.length; ++i) {
            Version.printField(IndentedWriter.stdout, prefix, fields[i], cls);
        }
    }

    private static String field(String fieldName, Class<?> cls) {
        try {
            Field f = cls.getDeclaredField(fieldName);
            return f.get(null).toString();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchFieldException ex) {
            ex.printStackTrace();
        }
        return "<error>";
    }

    private static void printField(IndentedWriter out, String prefix, String fieldName, Class<?> cls) {
        out.print(prefix);
        out.print(": ");
        out.pad(12);
        out.print(fieldName);
        out.print(": ");
        out.print(Version.field(fieldName, cls));
        out.println();
        out.flush();
    }
}

