/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.reorder;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderProc;
import com.hp.hpl.jena.sparql.util.ALog;

public class ReorderProcIndexes
implements ReorderProc {
    private int[] indexes;

    public ReorderProcIndexes(int[] indexes) {
        this.indexes = indexes;
    }

    public BasicPattern reorder(BasicPattern bgp) {
        if (this.indexes.length != bgp.size()) {
            String str2 = String.format("Expected size = %d : actual basic pattern size = %d", this.indexes.length, bgp.size());
            ALog.fatal(this, str2);
            throw new ARQException(str2);
        }
        BasicPattern bgp2 = new BasicPattern();
        for (int j = 0; j < this.indexes.length; ++j) {
            int idx = this.indexes[j];
            Triple t = bgp.get(idx);
            bgp2.add(t);
        }
        return bgp2;
    }

    public String toString() {
        String x = "";
        String sep = "";
        for (int idx : this.indexes) {
            x = x + sep + idx;
            sep = ", ";
        }
        return x;
    }
}

