/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.binding;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingBase;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import java.util.Iterator;

public class BindingUtils {
    public static Triple substituteIntoTriple(Triple t, Binding binding) {
        Node subject = BindingUtils.substituteNode(t.getSubject(), binding);
        Node predicate = BindingUtils.substituteNode(t.getPredicate(), binding);
        Node object = BindingUtils.substituteNode(t.getObject(), binding);
        if (subject == t.getSubject() && predicate == t.getPredicate() && object == t.getObject()) {
            return t;
        }
        return new Triple(subject, predicate, object);
    }

    public static Node substituteNode(Node n, Binding binding) {
        return Var.lookup(binding, n);
    }

    public static Binding asBinding(QuerySolution qSolution) {
        BindingMap binding = new BindingMap(null);
        BindingUtils.addToBinding(binding, qSolution);
        return binding;
    }

    public static void addToBinding(Binding binding, QuerySolution qSolution) {
        if (qSolution == null) {
            return;
        }
        Iterator<String> iter = qSolution.varNames();
        while (iter.hasNext()) {
            String n = iter.next();
            RDFNode x = qSolution.get(n);
            binding.add(Var.alloc(n), x.asNode());
        }
    }

    public static boolean equals(Binding b1, Binding b2) {
        return BindingBase.equals(b1, b2);
    }
}

