/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.StrUtils;
import com.hp.hpl.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Explain {
    public static final Logger logExec = LoggerFactory.getLogger((String)"com.hp.hpl.jena.tdb.exec");
    public static boolean explaining = false;
    public static final Symbol symLogExec = ARQConstants.allocSymbol("logExec");

    public static void explain(Op op, Context context) {
        if (Explain.explaining(context)) {
            Explain._explain("Execute", op.toString());
        }
    }

    public static void explain(BasicPattern bgp, Context context) {
        if (Explain.explaining(context)) {
            Explain._explain("Execute", bgp.toString());
        }
    }

    private static void _explain(String reason, String explanation) {
        explanation = StrUtils.chop(explanation);
        while (explanation.endsWith("\n") || explanation.endsWith("\r")) {
            explanation = StrUtils.chop(explanation);
        }
        explanation = reason + "\n" + explanation;
        Explain._explain(explanation);
    }

    private static void _explain(String explanation) {
        logExec.info(explanation);
    }

    public static void explain(Context context, String message) {
        if (Explain.explaining(context)) {
            Explain._explain(message);
        }
    }

    public static boolean explaining(Context context) {
        return context.isTrue(symLogExec) && logExec.isInfoEnabled();
    }
}

