/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op0;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpQuadPattern
extends Op0 {
    Node graphNode;
    BasicPattern triples;
    List<Quad> quads = null;

    public static boolean isQuadPattern(Op op) {
        return op instanceof OpQuadPattern;
    }

    public OpQuadPattern(Node quadNode, BasicPattern triples) {
        this.graphNode = quadNode;
        this.triples = triples;
    }

    public List<Quad> getQuads() {
        if (this.quads == null) {
            this.quads = new ArrayList<Quad>();
            for (Triple t : this.triples) {
                this.quads.add(new Quad(this.graphNode, t));
            }
        }
        return this.quads;
    }

    public Node getGraphNode() {
        return this.graphNode;
    }

    public BasicPattern getBasicPattern() {
        return this.triples;
    }

    public boolean isEmpty() {
        return this.triples.size() == 0;
    }

    public boolean isDefaultGraph() {
        return Quad.isQuadDefaultGraphNode(this.graphNode);
    }

    @Override
    public String getName() {
        return "quadpattern";
    }

    @Override
    public Op apply(Transform transform) {
        return transform.transform(this);
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op copy() {
        return new OpQuadPattern(this.graphNode, this.triples);
    }

    @Override
    public int hashCode() {
        return this.graphNode.hashCode() ^ this.triples.hashCode();
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpQuadPattern)) {
            return false;
        }
        OpQuadPattern opQuad = (OpQuadPattern)other;
        if (!this.graphNode.equals((Object)opQuad.graphNode)) {
            return false;
        }
        return this.triples.equiv(opQuad.triples, labelMap);
    }
}

