/*
 * Decompiled with CFR 0.152.
 */
package proc.thema;

import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.LocalSemanticDatabase;
import data.structures.classification.Corpus;
import data.structures.classification.LemmePondere;
import data.structures.classification.NuagePondere;
import data.structures.classification.Operation;
import data.structures.classification.Taxonomie;
import data.structures.corpus.CorpusGraph;
import data.structures.corpus.CorpusGraphLemmaItem;
import data.structures.tagging.GraphLemmaItem;
import data.structures.tagging.LemmaItem;
import data.structures.thema.ThemaGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import proc.text.Horloge;

public class Experience
implements Runnable {
    public static final int VECTEUR_PRODUIT_SCALAIRE = 1;
    public static final int VECTEUR_DISTANCE_EUCLIDIENNE = 2;
    public static final int VECTEUR_DISTANCE_DE_MANHATTAN = 3;
    private Database base;
    private String titre;
    private String desc;
    private CorpusGraph corpus;
    private ThemaGraph themas;
    private int[] themaTrouvees;
    private String statut;
    private boolean enrichThemaBase = false;
    private boolean enrichThemaSpe = false;
    private boolean enrichThemaGen = false;
    private boolean enrichThemaCat = false;
    private boolean enrichThemaSem = false;
    private boolean enrichArticleBase = false;
    private boolean enrichArticleGen = false;
    private boolean enrichArticleCat = false;
    private boolean enrichArticleSem = false;
    private boolean normalisationTaille = false;
    private Map<Operation, Double> poidsOrigines = new HashMap<Operation, Double>();
    private Map<String, Double> poidsCategories = new HashMap<String, Double>();
    private double poidsCategoriesNonSpecifie = 1.0;
    private int algoCalcul = 1;
    Corpus cor = new Corpus();
    Taxonomie tax = new Taxonomie();
    private boolean demarree = false;
    private boolean termine = true;
    private long depart;
    private long fin;

    public void setBase(Database base) {
        this.base = base;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getTitre() {
        return this.titre;
    }

    public void setTitre(String titre) {
        this.titre = titre;
    }

    public boolean isEnrichThemaBase() {
        return this.enrichThemaBase;
    }

    public void setEnrichThemaBase(boolean enrichThemaBase) {
        this.enrichThemaBase = enrichThemaBase;
    }

    public boolean isEnrichThemaSpe() {
        return this.enrichThemaSpe;
    }

    public boolean isEnrichArticleCat() {
        return this.enrichArticleCat;
    }

    public void setEnrichArticleCat(boolean enrichArticleCat) {
        this.enrichArticleCat = enrichArticleCat;
    }

    public boolean isEnrichThemaCat() {
        return this.enrichThemaCat;
    }

    public void setEnrichThemaCat(boolean enrichThemaCat) {
        this.enrichThemaCat = enrichThemaCat;
    }

    public void setEnrichThemaSpe(boolean enrichThemaSpe) {
        this.enrichThemaSpe = enrichThemaSpe;
    }

    public boolean isEnrichThemaGen() {
        return this.enrichThemaGen;
    }

    public void setEnrichThemaGen(boolean enrichThemaGen) {
        this.enrichThemaGen = enrichThemaGen;
    }

    public boolean isEnrichArticleBase() {
        return this.enrichArticleBase;
    }

    public void setEnrichArticleBase(boolean enrichArticleBase) {
        this.enrichArticleBase = enrichArticleBase;
    }

    public boolean isEnrichArticleGen() {
        return this.enrichArticleGen;
    }

    public void setEnrichArticleGen(boolean enrichArticleGen) {
        this.enrichArticleGen = enrichArticleGen;
    }

    public void setPoidsOrigine(Operation origine, double poids) {
        this.poidsOrigines.put(origine, new Double(poids));
    }

    public void annulePoidsCategories() {
        this.poidsCategoriesNonSpecifie = 0.0;
    }

    public void setPoidsCategorie(String categorie, double poids) {
        this.poidsCategories.put(categorie, new Double(poids));
    }

    public void setCorpus(CorpusGraph corpus) {
        this.corpus = corpus;
        this.themaTrouvees = new int[corpus.getItems().length];
    }

    public void setThemas(ThemaGraph themas) {
        this.themas = themas;
    }

    public boolean isEnrichArticleSem() {
        return this.enrichArticleSem;
    }

    public void setEnrichArticleSem(boolean enrichArticleSem) {
        this.enrichArticleSem = enrichArticleSem;
    }

    public boolean isEnrichThemaSem() {
        return this.enrichThemaSem;
    }

    public void setEnrichThemaSem(boolean enrichThemaSem) {
        this.enrichThemaSem = enrichThemaSem;
    }

    public boolean isNormalisationTaille() {
        return this.normalisationTaille;
    }

    public void setNormalisationTaille(boolean normalisationTaille) {
        this.normalisationTaille = normalisationTaille;
    }

    public int getAlgoCalcul() {
        return this.algoCalcul;
    }

    public void setAlgoCalcul(int algoCalcul) {
        this.algoCalcul = algoCalcul;
    }

    public int getNbLemmesCoteArticle() {
        if (this.corpus == null) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.cor.getArticles().length; ++i) {
            nb += this.cor.getArticles()[i].getAllLemmes().length;
        }
        return nb;
    }

    public int getNbLemmesCoteThematique() {
        if (this.themas == null) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.tax.getThematiques().length; ++i) {
            nb += this.tax.getThematiques()[i].getAllLemmes().length;
        }
        return nb;
    }

    private void creeNuageCorpus() throws NoBaseException {
        LemmePondere lp;
        String categorie;
        Vector orig;
        int quotite;
        String nom;
        int a;
        LemmaItem[] enrichissement;
        Set<LemmaItem> enrichissement0;
        LocalSemanticDatabase lsdb;
        LemmePondere lemme;
        int j;
        Vector<LemmePondere> newLemmes;
        int i;
        System.out.println(Horloge.getHMS() + "  Articles");
        CorpusGraphLemmaItem[] lCor = this.corpus.getItems();
        for (i = 0; i < lCor.length; ++i) {
            this.statut = "Enrichissement article de base (" + (i + 1) + "/" + lCor.length + ");";
            this.cor.addArticle(lCor[i]);
        }
        if (this.isEnrichArticleSem()) {
            for (i = 0; i < this.cor.getArticles().length; ++i) {
                this.statut = "Enrichissement article par champ s\u00e9mantique (" + (i + 1) + "/" + this.cor.getArticles().length + ")";
                System.out.println(Horloge.getHMS() + "   Article " + (i + 1) + "/" + this.cor.getArticles().length + " : " + this.cor.getArticles()[i].getId());
                newLemmes = new Vector<LemmePondere>();
                for (j = 0; j < this.cor.getArticles()[i].getAllLemmes().length; ++j) {
                    lemme = this.cor.getArticles()[i].getAllLemmes()[j];
                    System.out.println(Horloge.getHMS() + "    Lemme " + (j + 1) + "/" + this.cor.getArticles()[i].getAllLemmes().length + " : " + lemme.getLemme());
                    if (this.base == null) continue;
                    lsdb = new LocalSemanticDatabase(this.base);
                    enrichissement0 = lsdb.getChampSemantique(lemme.toLemmaItem());
                    enrichissement = new LemmaItem[enrichissement0.size()];
                    enrichissement0.toArray(enrichissement);
                    for (a = 0; a < enrichissement.length; ++a) {
                        nom = enrichissement[a].getLemmaName();
                        quotite = lemme.getNbOccurences();
                        orig = (Vector)lemme.getOrigine().clone();
                        orig.addElement(Operation.CHAMP_SEMANTIQUE);
                        categorie = enrichissement[a].getLemmaLex();
                        lp = new LemmePondere(nom, orig, categorie, quotite);
                        newLemmes.add(lp);
                    }
                }
                for (j = 0; j < newLemmes.size(); ++j) {
                    this.cor.getArticles()[i].addLemme((LemmePondere)newLemmes.elementAt(j));
                }
            }
        }
        if (this.isEnrichArticleCat()) {
            for (i = 0; i < this.cor.getArticles().length; ++i) {
                this.statut = "Enrichissement article par cat\u00e9gorisation (" + (i + 1) + "/" + this.cor.getArticles().length + ")";
                System.out.println(Horloge.getHMS() + "   Article " + (i + 1) + "/" + this.cor.getArticles().length + " : " + this.cor.getArticles()[i].getId());
                newLemmes = new Vector();
                for (j = 0; j < this.cor.getArticles()[i].getAllLemmes().length; ++j) {
                    lemme = this.cor.getArticles()[i].getAllLemmes()[j];
                    System.out.println(Horloge.getHMS() + "    Lemme " + (j + 1) + "/" + this.cor.getArticles()[i].getAllLemmes().length + " : " + lemme.getLemme());
                    if (this.base == null) continue;
                    lsdb = new LocalSemanticDatabase(this.base);
                    enrichissement0 = lsdb.getGeneralisationWiki(lemme.toLemmaItem());
                    enrichissement = new LemmaItem[enrichissement0.size()];
                    enrichissement0.toArray(enrichissement);
                    for (a = 0; a < enrichissement.length; ++a) {
                        nom = enrichissement[a].getLemmaName();
                        quotite = lemme.getNbOccurences();
                        orig = (Vector)lemme.getOrigine().clone();
                        orig.addElement(Operation.CATEGORISATION);
                        categorie = enrichissement[a].getLemmaLex();
                        lp = new LemmePondere(nom, orig, categorie, quotite);
                        newLemmes.add(lp);
                    }
                }
                for (j = 0; j < newLemmes.size(); ++j) {
                    this.cor.getArticles()[i].addLemme((LemmePondere)newLemmes.elementAt(j));
                }
            }
        }
        if (this.isEnrichArticleGen()) {
            for (i = 0; i < this.cor.getArticles().length; ++i) {
                this.statut = "Enrichissement article par g\u00e9n\u00e9ralisation (" + (i + 1) + "/" + this.cor.getArticles().length + ")";
                System.out.println(Horloge.getHMS() + "   Article " + (i + 1) + "/" + this.cor.getArticles().length + " : " + this.cor.getArticles()[i].getId());
                newLemmes = new Vector();
                for (j = 0; j < this.cor.getArticles()[i].getAllLemmes().length; ++j) {
                    lemme = this.cor.getArticles()[i].getAllLemmes()[j];
                    System.out.println(Horloge.getHMS() + "    Lemme " + (j + 1) + "/" + this.cor.getArticles()[i].getAllLemmes().length + " : " + lemme.getLemme());
                    if (this.base == null) continue;
                    lsdb = new LocalSemanticDatabase(this.base);
                    enrichissement0 = lsdb.getGeneralisationOnto(lemme.toLemmaItem());
                    enrichissement = new LemmaItem[enrichissement0.size()];
                    enrichissement0.toArray(enrichissement);
                    for (a = 0; a < enrichissement.length; ++a) {
                        nom = enrichissement[a].getLemmaName();
                        quotite = lemme.getNbOccurences();
                        orig = (Vector)lemme.getOrigine().clone();
                        orig.addElement(Operation.GENERALISATION);
                        categorie = enrichissement[a].getLemmaLex();
                        lp = new LemmePondere(nom, orig, categorie, quotite);
                        newLemmes.add(lp);
                    }
                }
                for (j = 0; j < newLemmes.size(); ++j) {
                    this.cor.getArticles()[i].addLemme((LemmePondere)newLemmes.elementAt(j));
                }
            }
        }
    }

    private void creeNuageTaxonomie() throws NoBaseException {
        LemmePondere lp;
        String categorie;
        Vector orig;
        int quotite;
        String nom;
        int a;
        LemmaItem[] enrichissement;
        Set<LemmaItem> enrichissement0;
        LocalSemanticDatabase lsdb;
        LemmePondere lemme;
        int j;
        Vector<LemmePondere> newLemmes;
        int i;
        System.out.println(Horloge.getHMS() + "  Th\u00e9matiques");
        GraphLemmaItem[] lThe = this.themas.getItems(0);
        for (i = 0; i < lThe.length; ++i) {
            this.statut = "Enrichissement th\u00e9matique de base (" + (i + 1) + "/" + lThe.length + ");";
            this.tax.addThematique(lThe[i]);
        }
        if (this.isEnrichThemaSpe()) {
            lThe = this.themas.getItems(3);
            for (i = 0; i < lThe.length; ++i) {
                this.statut = "Enrichissement th\u00e9matique par sp\u00e9cialisation (" + (i + 1) + "/" + lThe.length + ");";
                this.tax.addInThematique(lThe[i]);
            }
        }
        if (this.isEnrichThemaSem()) {
            for (i = 0; i < this.tax.getThematiques().length; ++i) {
                this.statut = "Enrichissement th\u00e9matique par champ s\u00e9mantique (" + (i + 1) + "/" + this.tax.getThematiques().length + ")";
                System.out.println(Horloge.getHMS() + "   Th\u00e9matique " + (i + 1) + "/" + this.tax.getThematiques().length + " : " + this.tax.getThematiques()[i].getId());
                newLemmes = new Vector<LemmePondere>();
                for (j = 0; j < this.tax.getThematiques()[i].getAllLemmes().length; ++j) {
                    lemme = this.tax.getThematiques()[i].getAllLemmes()[j];
                    System.out.println(Horloge.getHMS() + "    Lemme " + (j + 1) + "/" + this.tax.getThematiques()[i].getAllLemmes().length + " : " + lemme.getLemme());
                    if (this.base == null) continue;
                    lsdb = new LocalSemanticDatabase(this.base);
                    enrichissement0 = lsdb.getChampSemantique(lemme.toLemmaItem());
                    enrichissement = new LemmaItem[enrichissement0.size()];
                    enrichissement0.toArray(enrichissement);
                    for (a = 0; a < enrichissement.length; ++a) {
                        nom = enrichissement[a].getLemmaName();
                        quotite = lemme.getNbOccurences();
                        orig = (Vector)lemme.getOrigine().clone();
                        orig.addElement(Operation.CHAMP_SEMANTIQUE);
                        categorie = enrichissement[a].getLemmaLex();
                        lp = new LemmePondere(nom, orig, categorie, quotite);
                        newLemmes.add(lp);
                    }
                }
                for (j = 0; j < newLemmes.size(); ++j) {
                    this.tax.getThematiques()[i].addLemme((LemmePondere)newLemmes.elementAt(j));
                }
            }
        }
        if (this.isEnrichThemaCat()) {
            for (i = 0; i < this.tax.getThematiques().length; ++i) {
                this.statut = "Enrichissement th\u00e9matique par cat\u00e9gorisation (" + (i + 1) + "/" + this.tax.getThematiques().length + ")";
                System.out.println(Horloge.getHMS() + "   Th\u00e9matique " + (i + 1) + "/" + this.tax.getThematiques().length + " : " + this.tax.getThematiques()[i].getId());
                newLemmes = new Vector();
                for (j = 0; j < this.tax.getThematiques()[i].getAllLemmes().length; ++j) {
                    lemme = this.tax.getThematiques()[i].getAllLemmes()[j];
                    System.out.println(Horloge.getHMS() + "    Lemme " + (j + 1) + "/" + this.tax.getThematiques()[i].getAllLemmes().length + " : " + lemme.getLemme());
                    if (this.base == null) continue;
                    lsdb = new LocalSemanticDatabase(this.base);
                    enrichissement0 = lsdb.getGeneralisationWiki(lemme.toLemmaItem());
                    enrichissement = new LemmaItem[enrichissement0.size()];
                    enrichissement0.toArray(enrichissement);
                    for (a = 0; a < enrichissement.length; ++a) {
                        nom = enrichissement[a].getLemmaName();
                        quotite = lemme.getNbOccurences();
                        orig = (Vector)lemme.getOrigine().clone();
                        orig.addElement(Operation.CATEGORISATION);
                        categorie = enrichissement[a].getLemmaLex();
                        lp = new LemmePondere(nom, orig, categorie, quotite);
                        newLemmes.add(lp);
                    }
                }
                for (j = 0; j < newLemmes.size(); ++j) {
                    this.tax.getThematiques()[i].addLemme((LemmePondere)newLemmes.elementAt(j));
                }
            }
        }
        if (this.isEnrichThemaGen()) {
            for (i = 0; i < this.tax.getThematiques().length; ++i) {
                this.statut = "Enrichissement th\u00e9matique par g\u00e9n\u00e9ralisation (" + (i + 1) + "/" + this.tax.getThematiques().length + ")";
                System.out.println(Horloge.getHMS() + "   Th\u00e9matique " + (i + 1) + "/" + this.tax.getThematiques().length + " : " + this.tax.getThematiques()[i].getId());
                newLemmes = new Vector();
                for (j = 0; j < this.tax.getThematiques()[i].getAllLemmes().length; ++j) {
                    lemme = this.tax.getThematiques()[i].getAllLemmes()[j];
                    System.out.println(Horloge.getHMS() + "    Lemme " + (j + 1) + "/" + this.tax.getThematiques()[i].getAllLemmes().length + " : " + lemme.getLemme());
                    if (this.base == null) continue;
                    lsdb = new LocalSemanticDatabase(this.base);
                    enrichissement0 = lsdb.getGeneralisationOnto(lemme.toLemmaItem());
                    enrichissement = new LemmaItem[enrichissement0.size()];
                    enrichissement0.toArray(enrichissement);
                    for (a = 0; a < enrichissement.length; ++a) {
                        nom = enrichissement[a].getLemmaName();
                        quotite = lemme.getNbOccurences();
                        orig = (Vector)lemme.getOrigine().clone();
                        orig.addElement(Operation.GENERALISATION);
                        categorie = enrichissement[a].getLemmaLex();
                        lp = new LemmePondere(nom, orig, categorie, quotite);
                        newLemmes.add(lp);
                    }
                }
                for (j = 0; j < newLemmes.size(); ++j) {
                    this.tax.getThematiques()[i].addLemme((LemmePondere)newLemmes.elementAt(j));
                }
            }
        }
    }

    private void creeNuages() throws NoBaseException {
        int i;
        Vector<Object> v;
        System.out.println(Horloge.getHMS() + " Constitution des nuages.");
        if (this.cor != null) {
            this.creeNuageCorpus();
        }
        if (this.tax != null) {
            this.creeNuageTaxonomie();
        }
        this.statut = "Pond\u00e9ration en cours";
        System.out.println(Horloge.getHMS() + " Pond\u00e9ration");
        if (!this.poidsOrigines.isEmpty()) {
            v = new Vector<Operation>(this.poidsOrigines.keySet());
            for (i = 0; i < v.size(); ++i) {
                this.cor.pondereOrigine(v.elementAt(i), this.poidsOrigines.get(v.elementAt(i)));
                this.tax.pondereOrigine((Operation)v.elementAt(i), this.poidsOrigines.get(v.elementAt(i)));
            }
        }
        this.cor.pondereAllCategories(this.poidsCategoriesNonSpecifie);
        this.tax.pondereAllCategories(this.poidsCategoriesNonSpecifie);
        if (!this.poidsCategories.isEmpty()) {
            v = new Vector<String>(this.poidsCategories.keySet());
            for (i = 0; i < v.size(); ++i) {
                this.cor.pondereCategorie((String)v.elementAt(i), this.poidsCategories.get(v.elementAt(i)));
                this.tax.pondereCategorie((String)v.elementAt(i), this.poidsCategories.get(v.elementAt(i)));
            }
        }
        if (this.normalisationTaille) {
            this.tax.normaliseParTaille();
        }
    }

    private String[] creeVecteur(NuagePondere[] nuage) {
        HashSet<String> listeLemmes = new HashSet<String>();
        for (int i = 0; i < nuage.length; ++i) {
            for (int j = 0; j < nuage[i].getAllLemmes().length; ++j) {
                LemmePondere aAjouter = nuage[i].getAllLemmes()[j];
                if (!(aAjouter.getPoidsCategorie() > 0.0)) continue;
                listeLemmes.add(aAjouter.getLemme() + ":" + aAjouter.getCategorie());
            }
        }
        String[] vecteur = new String[listeLemmes.size()];
        listeLemmes.toArray(vecteur);
        return vecteur;
    }

    public void run() {
        int a;
        int index;
        String lemme;
        int j;
        LemmePondere[] lemmes;
        int i;
        this.demarree = true;
        System.out.println(Horloge.getHMS() + this.titre + " : exp\u00e9rience lanc\u00e9e.");
        if (!this.termine) {
            System.out.println(Horloge.getHMS() + " Erreur : Pr\u00e9c\u00e9dente exp\u00e9rience en cours.");
            return;
        }
        this.termine = false;
        this.depart = System.currentTimeMillis();
        if (this.corpus == null || this.themas == null) {
            this.termine = true;
            this.fin = System.currentTimeMillis();
            System.out.println(Horloge.getHMS() + " Erreur : Pas de th\u00e9matique ou pas d'article.");
            return;
        }
        if (!this.isEnrichThemaBase() || !this.isEnrichArticleBase()) {
            this.termine = true;
            this.fin = System.currentTimeMillis();
            System.out.println(Horloge.getHMS() + " Erreur : Pas d'enrichissement de base.");
            return;
        }
        for (int i2 = 0; i2 < this.themaTrouvees.length; ++i2) {
            this.themaTrouvees[i2] = -1;
        }
        try {
            this.creeNuages();
        }
        catch (NoBaseException nbe) {
            // empty catch block
        }
        this.statut = "Confrontation en cours";
        NuagePondere[] articles = this.cor.getArticles();
        NuagePondere[] thematiques = this.tax.getThematiques();
        String[] vecteur = this.creeVecteur(thematiques);
        double[][] matriceThematiques = new double[thematiques.length][vecteur.length];
        double[][] matriceArticles = new double[articles.length][vecteur.length];
        System.out.println(Horloge.getHMS() + " Confrontation : " + articles.length + " articles, " + thematiques.length + " th\u00e9matiques.");
        for (i = 0; i < thematiques.length; ++i) {
            this.statut = "Vectorisation en cours (th\u00e9matique " + (i + 1) + "/" + articles.length + ")";
            lemmes = thematiques[i].getAllLemmes();
            for (j = 0; j < lemmes.length; ++j) {
                if (!(lemmes[j].getPoidsCategorie() > 0.0)) continue;
                lemme = lemmes[j].getLemme() + ":" + lemmes[j].getCategorie();
                index = 0;
                for (a = 0; a < vecteur.length; ++a) {
                    if (!vecteur[a].equals(lemme)) continue;
                    index = a;
                    break;
                }
                matriceThematiques[i][index] = lemmes[j].getPoidsOrigine() * lemmes[j].getPoidsCategorie() * (double)lemmes[j].getNbOccurences();
            }
        }
        for (i = 0; i < articles.length; ++i) {
            this.statut = "Vectorisation en cours (article " + (i + 1) + "/" + articles.length + ")";
            lemmes = articles[i].getAllLemmes();
            for (j = 0; j < lemmes.length; ++j) {
                if (!(lemmes[j].getPoidsCategorie() > 0.0)) continue;
                lemme = lemmes[j].getLemme() + ":" + lemmes[j].getCategorie();
                index = 0;
                for (a = 0; a < vecteur.length; ++a) {
                    if (!vecteur[a].equals(lemme)) continue;
                    index = a;
                    break;
                }
                matriceArticles[i][index] = lemmes[j].getPoidsOrigine() * lemmes[j].getPoidsCategorie() * (double)lemmes[j].getNbOccurences();
            }
        }
        for (i = 0; i < articles.length; ++i) {
            int j2;
            this.statut = "Confrontation en cours (article " + (i + 1) + "/" + articles.length + ")";
            double[] scores = new double[thematiques.length];
            for (int j3 = 0; j3 < thematiques.length; ++j3) {
                int a2;
                scores[j3] = 0.0;
                if (this.algoCalcul == 1) {
                    for (a2 = 0; a2 < vecteur.length; ++a2) {
                        int n = j3;
                        scores[n] = scores[n] + matriceArticles[i][a2] * matriceThematiques[j3][a2];
                    }
                    continue;
                }
                if (this.algoCalcul == 2) {
                    for (a2 = 0; a2 < vecteur.length; ++a2) {
                        int n = j3;
                        scores[n] = scores[n] - (matriceArticles[i][a2] - matriceThematiques[j3][a2]) * (matriceArticles[i][a2] - matriceThematiques[j3][a2]);
                    }
                    scores[j3] = -1.0 * Math.sqrt(-1.0 * scores[j3]);
                    continue;
                }
                if (this.algoCalcul != 3) continue;
                for (a2 = 0; a2 < vecteur.length; ++a2) {
                    int n = j3;
                    scores[n] = scores[n] - Math.abs(matriceArticles[i][a2] - matriceThematiques[j3][a2]);
                }
            }
            double max = 0.0;
            for (j2 = 0; j2 < thematiques.length; ++j2) {
                if (!(scores[j2] > max)) continue;
                max = scores[j2];
            }
            if (max > 0.0) {
                for (j2 = 0; j2 < thematiques.length; ++j2) {
                    if (scores[j2] != max) continue;
                    this.themaTrouvees[i] = thematiques[j2].getId();
                }
            } else {
                this.themaTrouvees[i] = 0;
            }
            boolean v = this.themaTrouvees[i] == this.corpus.getItems()[i].getIdThematique();
            System.out.println(Horloge.getHMS() + "  " + (v ? "O" : "X") + " Article " + (i + 1) + " | Th\u00e9matique trouv\u00e9e : " + this.themaTrouvees[i] + " (th\u00e9oriquement " + this.corpus.getItems()[i].getIdThematique() + ")");
        }
        System.out.println(Horloge.getHMS() + " Exp\u00e9rience termin\u00e9e : pertinence " + (int)(100.0 * this.getPertinence()) + "%.");
        this.termine = true;
        this.fin = System.currentTimeMillis();
    }

    public int getSecondesExecution() {
        if (this.termine) {
            return (int)((this.fin - this.depart) / 1000L);
        }
        return (int)((System.currentTimeMillis() - this.depart) / 1000L);
    }

    public String getStatut() {
        if (!this.demarree) {
            return "Lancer l'exp\u00e9rience";
        }
        if (this.termine) {
            return "Exp\u00e9rience termin\u00e9e";
        }
        return this.statut;
    }

    public boolean isTermine() {
        return this.termine;
    }

    public double getPertinence() {
        if (this.corpus == null) {
            return 0.0;
        }
        int corrects = 0;
        int verifiables = 0;
        CorpusGraphLemmaItem[] lCorpus = this.corpus.getItems();
        for (int i = 0; i < this.themaTrouvees.length; ++i) {
            if (this.themaTrouvees[i] == -1 || lCorpus[i].getIdThematique() == 0) continue;
            ++verifiables;
            if (this.themaTrouvees[i] != lCorpus[i].getIdThematique()) continue;
            ++corrects;
        }
        if (verifiables > 0) {
            return 1.0 * (double)corrects / (double)verifiables;
        }
        return 0.0;
    }

    public boolean isPertinent(int index) {
        if (this.themaTrouvees == null) {
            return false;
        }
        if (index < 0 || index >= this.themaTrouvees.length) {
            return false;
        }
        CorpusGraphLemmaItem[] lCorpus = this.corpus.getItems();
        boolean res = false;
        if (this.themaTrouvees[index] != -1 && lCorpus[index].getIdThematique() != 0 && this.themaTrouvees[index] == lCorpus[index].getIdThematique()) {
            res = true;
        }
        return res;
    }
}

