/*
 * Decompiled with CFR 0.152.
 */
package proc.rss;

import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import data.structures.rss.BaseRSSItem;
import data.structures.rss.RSSFeed;
import data.structures.rss.RSSFeedInfoExtended;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import proc.rss.ComparateurBaseRSSItem;
import proc.rss.RSSParsingException;
import proc.text.Codecs;
import proc.text.Out;
import proc.text.XMLCleaner;

public class RSSParser {
    private static Map<String, Integer> mois = new HashMap<String, Integer>();

    public static BaseRSSItem[] lectureFlux(RSSFeedInfoExtended flux) throws RSSParsingException {
        if (flux.URL.equals("")) {
            throw new RSSParsingException("pas de flux");
        }
        URL url = null;
        try {
            url = new URL(flux.URL);
        }
        catch (MalformedURLException mue) {
            throw new RSSParsingException("erreur dans l'URL " + flux.URL + " : " + mue.getMessage());
        }
        String xml = "";
        try {
            String s;
            BufferedReader data = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((s = data.readLine()) != null) {
                xml = xml + s;
            }
            if (xml.trim().length() == 0) {
                throw new RSSParsingException("rien dans le flux " + flux.URL);
            }
            data.close();
        }
        catch (IOException ioe) {
            return RSSParser.lectureRome(flux);
        }
        xml = Codecs.desEscapeHTMLText(xml);
        Pattern item = Pattern.compile("<item[^s].*?/item>");
        Matcher m = item.matcher(xml);
        Vector<String> items = new Vector<String>();
        while (m.find()) {
            items.addElement(m.group());
        }
        String[] articles = new String[items.size()];
        items.toArray(articles);
        if (articles.length == 0) {
            item = Pattern.compile("<entry.*?/entry>");
            m = item.matcher(xml);
            items = new Vector();
            while (m.find()) {
                items.addElement(m.group());
            }
            articles = new String[items.size()];
            items.toArray(articles);
        }
        if (articles.length == 0) {
            throw new RSSParsingException("flux vide");
        }
        String[] titres = new String[articles.length];
        for (int i = 0; i < articles.length; ++i) {
            item = Pattern.compile("<title.*?/title>");
            m = item.matcher(articles[i]);
            String candidat = "";
            if (m.find()) {
                candidat = m.group();
            }
            candidat = candidat.replaceAll("<!\\[CDATA\\[", "");
            candidat = candidat.replaceAll("\\]\\]>", "");
            titres[i] = Codecs.deHTMLize(candidat);
        }
        String titre = "";
        for (int i = 0; i < titres.length; ++i) {
            titre = titre + titres[i].trim();
        }
        if (titre.length() == 0) {
            throw new RSSParsingException("titres vides");
        }
        String[] descriptions = new String[articles.length];
        for (int i = 0; i < articles.length; ++i) {
            item = Pattern.compile("<summary.*?/summary>");
            m = item.matcher(articles[i]);
            String candidat = "";
            if (m.find()) {
                candidat = m.group();
            }
            if (candidat.equals("") && (m = (item = Pattern.compile("<description.*?/description>")).matcher(articles[i])).find()) {
                candidat = m.group();
            }
            if (candidat.equals("") && (m = (item = Pattern.compile("<content.*?/content>")).matcher(articles[i])).find()) {
                candidat = m.group();
            }
            if (candidat.equals("") && (m = (item = Pattern.compile("<atom:summary.*?/atom:summary>")).matcher(articles[i])).find()) {
                candidat = m.group();
            }
            candidat = candidat.replaceAll("<!\\[CDATA\\[", "");
            candidat = candidat.replaceAll("\\]\\]>", "");
            descriptions[i] = Codecs.deHTMLize(candidat);
        }
        String desc = "";
        for (int i = 0; i < descriptions.length; ++i) {
            desc = desc + descriptions[i].trim();
        }
        if (desc.length() == 0) {
            // empty if block
        }
        String[] liens = new String[articles.length];
        for (int i = 0; i < articles.length; ++i) {
            item = Pattern.compile("<link.*?</link>");
            m = item.matcher(articles[i]);
            String candidat = "";
            if (m.find()) {
                candidat = m.group();
            }
            if (candidat.equals("")) {
                item = Pattern.compile("<link.*?alternate.*?/>");
                m = item.matcher(articles[i]);
                if (m.find()) {
                    candidat = m.group();
                }
                candidat = candidat.replaceAll("href=\\\"", "href=>");
                candidat = candidat.replaceAll("\\\"", "<");
                candidat = candidat.replaceAll("href=\\'", "href=>");
                candidat = candidat.replaceAll("\\'", "<");
            }
            if (candidat.equals("") && (m = (item = Pattern.compile("<alink.*?/alink>")).matcher(articles[i])).find()) {
                candidat = m.group();
            }
            candidat = candidat.replaceAll("<!\\[CDATA\\[", "");
            candidat = candidat.replaceAll("\\]\\]>", "");
            liens[i] = Codecs.deHTMLize(candidat);
        }
        String lien = "";
        for (int i = 0; i < liens.length; ++i) {
            lien = lien + liens[i];
        }
        if (lien.length() == 0) {
            // empty if block
        }
        String[] dates = new String[articles.length];
        for (int i = 0; i < articles.length; ++i) {
            item = Pattern.compile("<published.*?/published>");
            m = item.matcher(articles[i]);
            String candidat = "";
            if (m.find()) {
                candidat = m.group();
            }
            if (candidat.equals("") && (m = (item = Pattern.compile("<issued.*?/issued>")).matcher(articles[i])).find()) {
                candidat = m.group();
            }
            if (candidat.equals("") && (m = (item = Pattern.compile("<pubDate.*?/pubDate>")).matcher(articles[i])).find()) {
                candidat = m.group();
            }
            if (candidat.equals("") && (m = (item = Pattern.compile("<dc:date.*?/dc:date>")).matcher(articles[i])).find()) {
                candidat = m.group();
            }
            if (candidat.equals("") && (m = (item = Pattern.compile("<updated.*?/updated>")).matcher(articles[i])).find()) {
                candidat = m.group();
            }
            candidat = candidat.replaceAll("<!\\[CDATA\\[", "");
            candidat = candidat.replaceAll("\\]\\]>", "");
            dates[i] = Codecs.deHTMLize(candidat).trim();
        }
        String date = "";
        for (int i = 0; i < dates.length; ++i) {
            date = date + dates[i];
        }
        if (date.length() == 0) {
            throw new RSSParsingException("dates non renseign\u00e9es");
        }
        Date[] dates2 = new Date[dates.length];
        boolean remarqueDate = false;
        for (int i = 0; i < dates.length; ++i) {
            String[] h;
            TimeZone t;
            String[] h2;
            String[] s;
            String[] h3;
            String[] s2;
            TimeZone t2;
            GregorianCalendar d = new GregorianCalendar();
            d.setTimeInMillis(0L);
            boolean formatFound = false;
            if (!formatFound && (m = (item = Pattern.compile("[MTWFS]..,\\s\\d{1,2}\\s[jfmasondJFMASOND].*?\\s\\d{4}\\s\\d{2}:\\d{2}:\\d{2}\\sEST")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    t2 = TimeZone.getTimeZone("UTC");
                    t2.setRawOffset(-18000000);
                    d.setTimeZone(t2);
                    s2 = dates[i].split("\\s");
                    d.set(5, Integer.parseInt(s2[1]));
                    d.set(2, mois.get(s2[2]));
                    d.set(1, Integer.parseInt(s2[3]));
                    h3 = s2[4].split(":");
                    d.set(11, Integer.parseInt(h3[0]));
                    d.set(12, Integer.parseInt(h3[1]));
                    d.set(13, Integer.parseInt(h3[2]));
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("[MTWFS]..,\\s\\d{1,2}\\s[jfmasondJFMASOND].*?\\s\\d{4}\\s\\d{2}:\\d{2}:\\d{2}\\sEDT")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    t2 = TimeZone.getTimeZone("UTC");
                    t2.setRawOffset(-14400000);
                    d.setTimeZone(t2);
                    s2 = dates[i].split("\\s");
                    d.set(5, Integer.parseInt(s2[1]));
                    d.set(2, mois.get(s2[2]));
                    d.set(1, Integer.parseInt(s2[3]));
                    h3 = s2[4].split(":");
                    d.set(11, Integer.parseInt(h3[0]));
                    d.set(12, Integer.parseInt(h3[1]));
                    d.set(13, Integer.parseInt(h3[2]));
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("[MTWFS]..,\\s\\d{1,2}\\s[jfmasondJFMASOND].*?\\s\\d{4}\\s\\d{2}:\\d{2}:\\d{2}\\sPDT")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    t2 = TimeZone.getTimeZone("UTC");
                    t2.setRawOffset(-25200000);
                    d.setTimeZone(t2);
                    s2 = dates[i].split("\\s");
                    d.set(5, Integer.parseInt(s2[1]));
                    d.set(2, mois.get(s2[2]));
                    d.set(1, Integer.parseInt(s2[3]));
                    h3 = s2[4].split(":");
                    d.set(11, Integer.parseInt(h3[0]));
                    d.set(12, Integer.parseInt(h3[1]));
                    d.set(13, Integer.parseInt(h3[2]));
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("[MTWFS]..,\\s\\d{1,2}\\s[jfmasondJFMASOND].*?\\s\\d{4}\\s\\d{2}:\\d{2}:\\d{2}\\sPST")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    t2 = TimeZone.getTimeZone("UTC");
                    t2.setRawOffset(-28800000);
                    d.setTimeZone(t2);
                    s2 = dates[i].split("\\s");
                    d.set(5, Integer.parseInt(s2[1]));
                    d.set(2, mois.get(s2[2]));
                    d.set(1, Integer.parseInt(s2[3]));
                    h3 = s2[4].split(":");
                    d.set(11, Integer.parseInt(h3[0]));
                    d.set(12, Integer.parseInt(h3[1]));
                    d.set(13, Integer.parseInt(h3[2]));
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("[MTWFS]..,\\s\\d{1,2}\\s[jfmasondJFMASOND].*?\\s\\d{4}\\s\\d{2}:\\d{2}\\sGMT")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    t2 = TimeZone.getTimeZone("GMT");
                    d.setTimeZone(t2);
                    s2 = dates[i].split("\\s");
                    d.set(5, Integer.parseInt(s2[1]));
                    d.set(2, mois.get(s2[2]));
                    d.set(1, Integer.parseInt(s2[3]));
                    h3 = s2[4].split(":");
                    d.set(11, Integer.parseInt(h3[0]));
                    d.set(12, Integer.parseInt(h3[1]));
                    d.set(13, 0);
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("[MTWFS]..,\\s\\d{1,2}\\s[jfmasondJFMASOND].*?\\s\\d{4}\\s\\d{2}:\\d{2}:\\d{2}\\sGMT")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    t2 = TimeZone.getTimeZone("GMT");
                    d.setTimeZone(t2);
                    s2 = dates[i].split("\\s");
                    d.set(5, Integer.parseInt(s2[1]));
                    d.set(2, mois.get(s2[2]));
                    d.set(1, Integer.parseInt(s2[3]));
                    h3 = s2[4].split(":");
                    d.set(11, Integer.parseInt(h3[0]));
                    d.set(12, Integer.parseInt(h3[1]));
                    d.set(13, Integer.parseInt(h3[2]));
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("[MTWFS]..,\\s\\d{1,2}\\s[jfmasondJFMASOND].*?\\s\\d{4}\\s\\d{2}:\\d{2}:\\d{2}\\sCEST")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    t2 = TimeZone.getTimeZone("UTC");
                    t2.setRawOffset(0x6DDD00);
                    d.setTimeZone(t2);
                    s2 = dates[i].split("\\s");
                    d.set(5, Integer.parseInt(s2[1]));
                    d.set(2, mois.get(s2[2]));
                    d.set(1, Integer.parseInt(s2[3]));
                    h3 = s2[4].split(":");
                    d.set(11, Integer.parseInt(h3[0]));
                    d.set(12, Integer.parseInt(h3[1]));
                    d.set(13, Integer.parseInt(h3[2]));
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("[MTWFS]..,\\s\\d{1,2}\\s[jfmasondJFMASOND].*?\\s\\d{4}\\s\\d{2}:\\d{2}:\\d{2}\\sCET")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    t2 = TimeZone.getTimeZone("UTC");
                    t2.setRawOffset(3600000);
                    d.setTimeZone(t2);
                    s2 = dates[i].split("\\s");
                    d.set(5, Integer.parseInt(s2[1]));
                    d.set(2, mois.get(s2[2]));
                    d.set(1, Integer.parseInt(s2[3]));
                    h3 = s2[4].split(":");
                    d.set(11, Integer.parseInt(h3[0]));
                    d.set(12, Integer.parseInt(h3[1]));
                    d.set(13, Integer.parseInt(h3[2]));
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("[MTWFS]..,\\s\\d{1,2}\\s[jfmasondJFMASOND].*?\\s\\d{4}\\s\\d{2}:\\d{2}:\\d{2}\\s[ap]m")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    s = dates[i].split("\\s");
                    d.set(5, Integer.parseInt(s[1]));
                    d.set(2, mois.get(s[2]));
                    d.set(1, Integer.parseInt(s[3]));
                    h2 = s[4].split(":");
                    d.set(10, Integer.parseInt(h2[0]));
                    d.set(12, Integer.parseInt(h2[1]));
                    d.set(13, Integer.parseInt(h2[2]));
                    d.set(14, 0);
                    if (s[5].equalsIgnoreCase("AM")) {
                        d.set(9, 0);
                    } else {
                        d.set(9, 1);
                    }
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("[MTWFS]..,\\s\\d{1,2}\\s[jfmasondJFMASOND].*?\\s\\d{4}\\s\\d{2}:\\d{2}:\\d{2}\\s{1,}[\\+\\-]0\\d00")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    s = dates[i].split("\\s{1,2}");
                    t = TimeZone.getTimeZone("UTC");
                    int x = 0;
                    x = s[5].startsWith("+") ? Integer.parseInt(s[5].substring(2, 3)) : -Integer.parseInt(s[5].substring(2, 3));
                    t.setRawOffset(x * 3600000);
                    d.setTimeZone(t);
                    d.set(5, Integer.parseInt(s[1]));
                    d.set(2, mois.get(s[2]));
                    d.set(1, Integer.parseInt(s[3]));
                    h = s[4].split(":");
                    d.set(11, Integer.parseInt(h[0]));
                    d.set(12, Integer.parseInt(h[1]));
                    d.set(13, Integer.parseInt(h[2]));
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("[MTWFS]..,\\s\\d{1,2}\\s[jfmasondJFMASOND].*?\\s\\d{4}\\s\\d{2}:\\d{2}:\\d{2}\\s[\\+\\-]0\\d:00")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    s = dates[i].split("\\s{1,2}");
                    t = TimeZone.getTimeZone("UTC");
                    int x = 0;
                    x = s[5].startsWith("+") ? Integer.parseInt(s[5].substring(2, 3)) : -Integer.parseInt(s[5].substring(2, 3));
                    t.setRawOffset(x * 3600000);
                    d.setTimeZone(t);
                    d.set(5, Integer.parseInt(s[1]));
                    d.set(2, mois.get(s[2]));
                    d.set(1, Integer.parseInt(s[3]));
                    h = s[4].split(":");
                    d.set(11, Integer.parseInt(h[0]));
                    d.set(12, Integer.parseInt(h[1]));
                    d.set(13, Integer.parseInt(h[2]));
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("\\d{1,2}\\s[jfmasondJFMASOND].*?\\s\\d{4}\\s\\d{2}:\\d{2}:\\d{2}\\s{1,}[\\+\\-]0\\d00")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    s = dates[i].split("\\s{1,2}");
                    t = TimeZone.getTimeZone("UTC");
                    int x = 0;
                    x = s[4].startsWith("+") ? Integer.parseInt(s[4].substring(2, 3)) : -Integer.parseInt(s[4].substring(2, 3));
                    t.setRawOffset(x * 3600000);
                    d.setTimeZone(t);
                    d.set(5, Integer.parseInt(s[0]));
                    d.set(2, mois.get(s[1]));
                    d.set(1, Integer.parseInt(s[2]));
                    h = s[3].split(":");
                    d.set(11, Integer.parseInt(h[0]));
                    d.set(12, Integer.parseInt(h[1]));
                    d.set(13, Integer.parseInt(h[2]));
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("[lmjvsd].*?\\s\\d{1,2}\\s[jfmasondJFMASOND].*?\\s\\d{4},\\s\\d{1,2}h\\d{2}")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    s = dates[i].split("\\s{1,2}");
                    d.set(5, Integer.parseInt(s[1]));
                    d.set(2, mois.get(s[2]));
                    d.set(1, Integer.parseInt(s[3].replaceAll(",", "")));
                    h2 = s[4].split("h");
                    d.set(11, Integer.parseInt(h2[0]));
                    d.set(12, Integer.parseInt(h2[1]));
                    d.set(13, 0);
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}[\\+\\-]0\\d:00")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    t2 = TimeZone.getTimeZone("UTC");
                    int x = 0;
                    x = dates[i].charAt(19) == '+' ? Integer.parseInt(dates[i].substring(21, 22)) : -Integer.parseInt(dates[i].substring(21, 22));
                    t2.setRawOffset(x * 3600000);
                    d.setTimeZone(t2);
                    String[] s3 = dates[i].split("[\\-:T+]");
                    d.set(5, Integer.parseInt(s3[2]));
                    d.set(2, Integer.parseInt(s3[1]) - 1);
                    d.set(1, Integer.parseInt(s3[0]));
                    d.set(11, Integer.parseInt(s3[3]));
                    d.set(12, Integer.parseInt(s3[4]));
                    d.set(13, Integer.parseInt(s3[5]));
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}[\\+\\-]0\\d:00")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    t2 = TimeZone.getTimeZone("UTC");
                    int x = 0;
                    x = dates[i].charAt(17) == '+' ? Integer.parseInt(dates[i].substring(18, 19)) : -Integer.parseInt(dates[i].substring(18, 19));
                    t2.setRawOffset(x * 3600000);
                    d.setTimeZone(t2);
                    String[] s4 = dates[i].split("[\\-:T+]");
                    d.set(5, Integer.parseInt(s4[2]));
                    d.set(2, Integer.parseInt(s4[1]) - 1);
                    d.set(1, Integer.parseInt(s4[0]));
                    d.set(11, Integer.parseInt(s4[3]));
                    d.set(12, Integer.parseInt(s4[4]));
                    d.set(13, 0);
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    t2 = TimeZone.getTimeZone("GMT");
                    d.setTimeZone(t2);
                    String[] s5 = dates[i].split("[\\-:TZ]");
                    d.set(5, Integer.parseInt(s5[2]));
                    d.set(2, Integer.parseInt(s5[1]) - 1);
                    d.set(1, Integer.parseInt(s5[0]));
                    d.set(11, Integer.parseInt(s5[3]));
                    d.set(12, Integer.parseInt(s5[4]));
                    d.set(13, Integer.parseInt(s5[5]));
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+\\-]0\\d:00")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    t2 = TimeZone.getTimeZone("UTC");
                    int x = 0;
                    x = dates[i].charAt(24) == '+' ? Integer.parseInt(dates[i].substring(25, 26)) : -Integer.parseInt(dates[i].substring(25, 26));
                    t2.setRawOffset(x * 3600000);
                    d.setTimeZone(t2);
                    String[] s6 = dates[i].split("[\\-:T\\.]");
                    d.set(5, Integer.parseInt(s6[2]));
                    d.set(2, Integer.parseInt(s6[1]) - 1);
                    d.set(1, Integer.parseInt(s6[0]));
                    d.set(11, Integer.parseInt(s6[3]));
                    d.set(12, Integer.parseInt(s6[4]));
                    d.set(13, Integer.parseInt(s6[5]));
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    s = dates[i].split("[\\-:T]");
                    d.set(5, Integer.parseInt(s[2]));
                    d.set(2, Integer.parseInt(s[1]) - 1);
                    d.set(1, Integer.parseInt(s[0]));
                    d.set(11, Integer.parseInt(s[3]));
                    d.set(12, Integer.parseInt(s[4]));
                    d.set(13, Integer.parseInt(s[5]));
                    d.set(14, 0);
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("\\d{10}")).matcher(dates[i])).find()) {
                formatFound = true;
                try {
                    d.setTimeInMillis(Integer.parseInt(dates[i]));
                }
                catch (Exception e) {
                    d = null;
                }
            }
            if (!formatFound && (m = (item = Pattern.compile("\\d{4}-\\d{2}-\\d{2}")).matcher(dates[i])).find()) {
                formatFound = true;
                d = null;
            }
            if (!formatFound && (m = (item = Pattern.compile("[MTWFS]..,\\s\\d{1,2}\\s[jfmasondJFMASOND].*?\\s\\d{4}\\s[\\+\\-]0\\d:00")).matcher(dates[i])).find()) {
                formatFound = true;
                d = null;
            }
            if (!formatFound && dates[i].equals("")) {
                formatFound = true;
                d = null;
            }
            if (!formatFound) {
                d = null;
                throw new RSSParsingException("format de date inconnu : " + dates[i]);
            }
            if (d != null) {
                dates2[i] = new Date(d.getTimeInMillis());
                continue;
            }
            dates2[i] = null;
            if (!remarqueDate) {
                Out.printErreur("Flux " + flux.name + " - date insuffisante : '" + dates[i] + "'");
            }
            remarqueDate = true;
        }
        Vector<BaseRSSItem> res0 = new Vector<BaseRSSItem>();
        for (int i = 0; i < articles.length; ++i) {
            String titre0 = titres[i].trim();
            String desc0 = descriptions[i].trim();
            String lien0 = liens[i].trim();
            Date date0 = dates2[i];
            if (date0 == null || titre0.equals("")) continue;
            BaseRSSItem item0 = new BaseRSSItem();
            item0.setTitle(titre0);
            item0.setDescription(desc0);
            item0.setLink(lien0);
            item0.setPubDate(date0);
            item0.setIdFluxRSS(Integer.parseInt(flux.ID));
            res0.addElement(item0);
        }
        BaseRSSItem[] res = new BaseRSSItem[res0.size()];
        res0.toArray(res);
        Arrays.sort(res, new ComparateurBaseRSSItem());
        return res;
    }

    public static BaseRSSItem[] lectureRome(RSSFeedInfoExtended flux) throws RSSParsingException {
        BaseRSSItem[] res;
        RSSFeed rf = new RSSFeed();
        if (rf.InitRSS(flux.URL) == RSSFeed.RSS_OK) {
            SyndEntryImpl[] entryList = rf.GetEntries();
            if (entryList != null) {
                res = new BaseRSSItem[entryList.length];
                for (int i = 0; i < entryList.length; ++i) {
                    res[i] = new BaseRSSItem();
                    res[i].setIdFluxRSS(Integer.parseInt(flux.ID));
                    res[i].setTitle(Codecs.deHTMLize(entryList[i].getTitle()));
                    String desc = "";
                    if (entryList[i].getDescription() != null) {
                        desc = entryList[i].getDescription().getValue();
                    } else if (entryList[i].getContents().size() > 0) {
                        desc = ((SyndContentImpl)entryList[i].getContents().get(0)).getValue();
                    }
                    res[i].setDescription(Codecs.deHTMLize(desc));
                    String url = entryList[i].getLink();
                    if (url == null) {
                        url = "";
                    }
                    res[i].setLink(url);
                    Date d = entryList[i].getPublishedDate();
                    if (d == null || d.getTime() == 0L) {
                        throw new RSSParsingException("dates non renseign\u00e9es");
                    }
                    res[i].setPubDate(d);
                }
            } else {
                res = new BaseRSSItem[]{};
            }
        } else {
            throw new RSSParsingException("flux illisible");
        }
        Arrays.sort(res, new ComparateurBaseRSSItem());
        return res;
    }

    public static BaseRSSItem[] lectureNews(String flux) throws RSSParsingException {
        BaseRSSItem[] res;
        RSSFeed rf = new RSSFeed();
        if (rf.InitRSS(flux) == RSSFeed.RSS_OK) {
            SyndEntryImpl[] entryList = rf.GetEntries();
            if (entryList != null) {
                res = new BaseRSSItem[entryList.length];
                for (int i = 0; i < entryList.length; ++i) {
                    res[i] = new BaseRSSItem();
                    res[i].setIdFluxRSS(0);
                    res[i].setTitle(Codecs.deHTMLize(entryList[i].getTitle()));
                    String desc = "";
                    if (entryList[i].getDescription() != null) {
                        desc = entryList[i].getDescription().getValue();
                    } else if (entryList[i].getContents().size() > 0) {
                        desc = ((SyndContentImpl)entryList[i].getContents().get(0)).getValue();
                    }
                    res[i].setDescription(Codecs.desEscapeHTMLText(desc));
                    String url = entryList[i].getLink();
                    if (url == null) {
                        url = "";
                    }
                    res[i].setLink(url);
                    Date d = entryList[i].getPublishedDate();
                    if (d == null || d.getTime() == 0L) {
                        throw new RSSParsingException("dates non renseign\u00e9es");
                    }
                    res[i].setPubDate(d);
                }
            } else {
                res = new BaseRSSItem[]{};
            }
        } else {
            throw new RSSParsingException("flux illisible");
        }
        Arrays.sort(res, new ComparateurBaseRSSItem());
        return res;
    }

    public static BaseRSSItem[] trouveArticlesSujet(String codeSujet) throws RSSParsingException {
        BaseRSSItem[] res;
        RSSFeed rf = new RSSFeed();
        String flux = "http://news.google.fr/news?cf=all&ned=fr&hl=fr&topic=h&num=1000&ncl=" + codeSujet + "&cf=all&output=rss";
        if (rf.InitRSS(flux) == RSSFeed.RSS_OK) {
            SyndEntryImpl[] entryList = rf.GetEntries();
            if (entryList != null) {
                res = new BaseRSSItem[entryList.length];
                for (int i = 0; i < entryList.length; ++i) {
                    res[i] = new BaseRSSItem();
                    res[i].setIdFluxRSS(0);
                    res[i].setTitle(Codecs.deHTMLize(entryList[i].getTitle()));
                    String desc = "";
                    if (entryList[i].getDescription() != null) {
                        desc = entryList[i].getDescription().getValue();
                    } else if (entryList[i].getContents().size() > 0) {
                        desc = ((SyndContentImpl)entryList[i].getContents().get(0)).getValue();
                    }
                    desc = Codecs.deHTMLize(XMLCleaner.xmlToText(desc));
                    res[i].setDescription(Codecs.desEscapeHTMLText(desc));
                    String url = "";
                    try {
                        url = entryList[i].getUri().split("=")[1];
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        // empty catch block
                    }
                    if (url == null) {
                        url = "";
                    }
                    res[i].setLink(url);
                }
            } else {
                res = new BaseRSSItem[]{};
            }
        } else {
            throw new RSSParsingException("flux illisible");
        }
        return res;
    }

    static {
        mois.put("Jan", new Integer(0));
        mois.put("Janvier", new Integer(0));
        mois.put("January", new Integer(0));
        mois.put("jan", new Integer(0));
        mois.put("janvier", new Integer(0));
        mois.put("january", new Integer(0));
        mois.put("Fev", new Integer(1));
        mois.put("F\u00e9v", new Integer(1));
        mois.put("Feb", new Integer(1));
        mois.put("Fevrier", new Integer(1));
        mois.put("F\u00e9vrier", new Integer(1));
        mois.put("February", new Integer(1));
        mois.put("fev", new Integer(1));
        mois.put("f\u00e9v", new Integer(1));
        mois.put("feb", new Integer(1));
        mois.put("fevrier", new Integer(1));
        mois.put("f\u00e9vrier", new Integer(1));
        mois.put("february", new Integer(1));
        mois.put("Mar", new Integer(2));
        mois.put("Mars", new Integer(2));
        mois.put("March", new Integer(2));
        mois.put("mar", new Integer(2));
        mois.put("Mmars", new Integer(2));
        mois.put("march", new Integer(2));
        mois.put("Avr", new Integer(3));
        mois.put("Apr", new Integer(3));
        mois.put("Avril", new Integer(3));
        mois.put("April", new Integer(3));
        mois.put("avr", new Integer(3));
        mois.put("apr", new Integer(3));
        mois.put("avril", new Integer(3));
        mois.put("april", new Integer(3));
        mois.put("Mai", new Integer(4));
        mois.put("May", new Integer(4));
        mois.put("mai", new Integer(4));
        mois.put("may", new Integer(4));
        mois.put("Jun", new Integer(5));
        mois.put("Juin", new Integer(5));
        mois.put("June", new Integer(5));
        mois.put("jun", new Integer(5));
        mois.put("juin", new Integer(5));
        mois.put("june", new Integer(5));
        mois.put("Jul", new Integer(6));
        mois.put("Juillet", new Integer(6));
        mois.put("July", new Integer(6));
        mois.put("jul", new Integer(6));
        mois.put("juillet", new Integer(6));
        mois.put("july", new Integer(6));
        mois.put("Aou", new Integer(7));
        mois.put("Ao\u00fb", new Integer(7));
        mois.put("Aug", new Integer(7));
        mois.put("Aout", new Integer(7));
        mois.put("Ao\u00fbt", new Integer(7));
        mois.put("August", new Integer(7));
        mois.put("aou", new Integer(7));
        mois.put("ao\u00fb", new Integer(7));
        mois.put("aug", new Integer(7));
        mois.put("aout", new Integer(7));
        mois.put("ao\u00fbt", new Integer(7));
        mois.put("august", new Integer(7));
        mois.put("Sep", new Integer(8));
        mois.put("Septembre", new Integer(8));
        mois.put("September", new Integer(8));
        mois.put("sep", new Integer(8));
        mois.put("septembre", new Integer(8));
        mois.put("september", new Integer(8));
        mois.put("Sept", new Integer(8));
        mois.put("sept", new Integer(8));
        mois.put("Oct", new Integer(9));
        mois.put("Octobre", new Integer(9));
        mois.put("October", new Integer(9));
        mois.put("oct", new Integer(9));
        mois.put("octobre", new Integer(9));
        mois.put("october", new Integer(9));
        mois.put("Nov", new Integer(10));
        mois.put("Novembre", new Integer(10));
        mois.put("November", new Integer(10));
        mois.put("nov", new Integer(10));
        mois.put("novembre", new Integer(10));
        mois.put("november", new Integer(10));
        mois.put("Dec", new Integer(11));
        mois.put("D\u00e9c", new Integer(11));
        mois.put("Decembre", new Integer(11));
        mois.put("D\u00e9cembre", new Integer(11));
        mois.put("D\u00e9cember", new Integer(11));
        mois.put("dec", new Integer(11));
        mois.put("d\u00e9c", new Integer(11));
        mois.put("decembre", new Integer(11));
        mois.put("d\u00e9cembre", new Integer(11));
        mois.put("d\u00e9cember", new Integer(11));
    }
}

