/*
 * Decompiled with CFR 0.152.
 */
package proc.rss;

import data.base.Config;
import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.RSSFeedDatabase;
import data.structures.rss.BaseRSSItem;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import proc.rss.Entree;
import proc.rss.NoDateException;
import proc.rss.RSSParser;
import proc.rss.RSSParsingException;
import proc.text.Codecs;
import proc.text.Out;

public class NewsSaver {
    private Database baseIPRI;
    private int totalItemCount = 0;
    private Thread traitement;
    private String readErrorMessage = "";
    private String googleNewsURL = "http://news.google.com/news?pz=1&cf=all&ned=fr&topic=h&num=50&output=rss";
    private Set<Entree> entrees = new HashSet<Entree>();
    private final Object lock = new Object();

    public NewsSaver(Database base) {
        this.baseIPRI = base;
        this.traitement = new Thread(){
            private boolean enCours = false;

            public void run() {
                try {
                    RSSFeedDatabase rS = new RSSFeedDatabase(NewsSaver.this.baseIPRI);
                    try {
                        while (true) {
                            if (NewsSaver.this.entrees.size() > 0) {
                                Date lastDate;
                                Entree e = NewsSaver.this.pioche();
                                this.enCours = true;
                                BaseRSSItem entry = e.getEntree();
                                if (NewsSaver.this.isToInsert(entry, lastDate = rS.getNewsLastEntryDate())) {
                                    String title = entry.getTitle();
                                    String desc = entry.getDescription();
                                    BaseRSSItem[] urls = NewsSaver.this.parseNews(desc);
                                    Date pubDate = entry.getPubDate();
                                    if (urls.length == 0) {
                                        Out.printErreur("Pas d'url pour le sujet " + Codecs.desEscapeHTML(Codecs.escapeHTML(entry.getTitle())));
                                    } else {
                                        Out.printInfo("Stockage du sujet : " + Codecs.desEscapeHTML(Codecs.escapeHTML(entry.getTitle())) + " (" + urls.length + " URL, dat\u00e9 du " + pubDate + ")...");
                                        rS.insereSujet(title, urls, pubDate);
                                    }
                                }
                                this.enCours = false;
                                continue;
                            }
                            this.enCours = false;
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException ie) {}
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                catch (NoBaseException noBaseException) {
                    // empty catch block
                }
            }

            public String toString() {
                return "" + this.enCours;
            }
        };
    }

    public void start() {
        this.traitement.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entree pioche() {
        Object object = this.lock;
        synchronized (object) {
            Iterator<Entree> i = this.entrees.iterator();
            Entree e = i.next();
            while (i.hasNext()) {
                Entree ee = i.next();
                if (!ee.getDate().before(e.getDate())) continue;
                e = ee;
            }
            this.entrees.remove(e);
            return e;
        }
    }

    public int readNews() throws NoBaseException {
        RSSFeedDatabase rS = new RSSFeedDatabase(this.baseIPRI);
        int newItemCount = 0;
        try {
            BaseRSSItem[] entryList = RSSParser.lectureNews(this.googleNewsURL);
            Vector<BaseRSSItem> entries = new Vector<BaseRSSItem>();
            Date lastDate = rS.getNewsLastEntryDate();
            for (int i = 0; i < entryList.length; ++i) {
                if (this.isToInsert(entryList[i], lastDate)) {
                    entries.addElement(entryList[i]);
                    ++newItemCount;
                    ++this.totalItemCount;
                }
                BaseRSSItem[] liste = new BaseRSSItem[entries.size()];
                entries.toArray(liste);
                this.insert(liste);
            }
        }
        catch (RSSParsingException e) {
            newItemCount = -1;
            this.readErrorMessage = e.getMessage();
        }
        return newItemCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(BaseRSSItem[] entries) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < entries.length; ++i) {
                this.entrees.add(new Entree(entries[i]));
            }
        }
        this.traitement.interrupt();
    }

    boolean isToInsert(BaseRSSItem entry, Date lastDate) {
        boolean b = false;
        try {
            b = this.isToInsert(entry.getPubDate(), lastDate);
        }
        catch (NoDateException nde) {
            // empty catch block
        }
        return b;
    }

    boolean isToInsert(Date entryPubDate, Date lastDate) throws NoDateException {
        Date limite = new Date(Config.getDateDepartCorpus());
        boolean result = false;
        if (entryPubDate != null) {
            if (entryPubDate.getTime() - lastDate.getTime() >= 1000L && entryPubDate.getTime() - limite.getTime() >= 1000L && entryPubDate.getTime() < System.currentTimeMillis()) {
                result = true;
            }
        } else {
            throw new NoDateException();
        }
        return result;
    }

    public String getReadErrorMessage() {
        return this.readErrorMessage;
    }

    public BaseRSSItem[] parseNews(String texte) {
        Vector<BaseRSSItem> urls = new Vector<BaseRSSItem>();
        Pattern formeURL2 = Pattern.compile("\\\"http://news\\.google\\.com/news/story.*?\\\"");
        Matcher m2 = formeURL2.matcher(texte);
        while (m2.find()) {
            String urlGoogle = m2.group().replaceAll("\"", "");
            String codeSujet = urlGoogle.replaceAll(".*?ncl=", "");
            try {
                BaseRSSItem[] articles = RSSParser.trouveArticlesSujet(codeSujet);
                for (int i = 0; i < articles.length; ++i) {
                    if (articles[i].getLink().equals("")) continue;
                    urls.addElement(articles[i]);
                }
            }
            catch (RSSParsingException rpe) {
                this.readErrorMessage = "impossible de r\u00e9cup\u00e9rer le flux \u00e9tendu";
            }
        }
        BaseRSSItem[] res = new BaseRSSItem[urls.size()];
        urls.toArray(res);
        return res;
    }
}

