/*
 * Decompiled with CFR 0.152.
 */
package ihm.iprinewsanalyzer;

import ihm.iprinewsanalyzer.Charte;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import proc.cluster.Experience;
import proc.cluster.Experiences;

public class TableExperiences2
extends JPanel
implements Scrollable {
    private JPanel[] pExperiences;
    private JLabel[] lDesc;
    private JLabel[] lDuree;
    private JScrollPane[] spResultats;
    private JTree[] tResultats;
    private JSlider[] sResultats;
    private JButton[] bRun;
    private JButton bRunAll;
    private Timer[] timerExperiences;
    private Experience[] listeExperiences = Experiences.getExperiences();

    public TableExperiences2() {
        int nbXP = Experiences.getExperiences().length;
        this.setLayout(new GridLayout(nbXP + 1, 1, 5, 0));
        this.pExperiences = new JPanel[nbXP];
        this.lDesc = new JLabel[nbXP];
        this.lDuree = new JLabel[nbXP];
        this.spResultats = new JScrollPane[nbXP];
        this.tResultats = new JTree[nbXP];
        this.sResultats = new JSlider[nbXP];
        this.bRun = new JButton[nbXP];
        this.timerExperiences = new Timer[nbXP];
        this.bRunAll = new JButton("Lancer toutes les exp\u00e9riences l'une apr\u00e8s l'autre");
        JPanel pRunAll = new JPanel(new FlowLayout());
        pRunAll.add(this.bRunAll);
        this.add(pRunAll);
        this.bRunAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TableExperiences2.this.lanceExperiences();
            }
        });
        for (int i = 0; i < nbXP; ++i) {
            this.pExperiences[i] = new JPanel();
            this.pExperiences[i].setBorder(BorderFactory.createTitledBorder(Experiences.getExperiences()[i].getTitre()));
            this.pExperiences[i].setLayout(new BorderLayout());
            JPanel pX = new JPanel(new BorderLayout());
            this.lDesc[i] = new JLabel(Experiences.getExperiences()[i].getDesc());
            pX.add((Component)this.lDesc[i], "Center");
            JPanel pData = new JPanel(new BorderLayout());
            final int j = i + 1;
            this.bRun[i] = new JButton("Lancer cette exp\u00e9rience");
            this.bRun[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    TableExperiences2.this.lanceExperience(j);
                }
            });
            JPanel pRun = new JPanel();
            pRun.add(this.bRun[i]);
            pData.add((Component)pRun, "North");
            JPanel pData2 = new JPanel(new GridLayout(1, 2));
            pData2.add(new JLabel("Dur\u00e9e de l'exp\u00e9rience : ", 4));
            this.lDuree[i] = new JLabel("00:00:00", 2);
            pData2.add(this.lDuree[i]);
            pData.add((Component)pData2, "South");
            pX.add((Component)pData, "South");
            this.pExperiences[i].add((Component)pX, "North");
            this.tResultats[i] = new JTree();
            DefaultMutableTreeNode racine = new DefaultMutableTreeNode("Clusters obtenus");
            this.tResultats[i].setModel(new DefaultTreeModel(racine));
            this.spResultats[i] = new JScrollPane(this.tResultats[i]);
            this.sResultats[i] = new JSlider(0, 1, 1, 1);
            this.sResultats[i].setMajorTickSpacing(1);
            this.sResultats[i].setMinorTickSpacing(1);
            this.sResultats[i].setPaintTicks(true);
            this.sResultats[i].setPaintLabels(false);
            this.sResultats[i].setValueIsAdjusting(true);
            this.sResultats[i].addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    TableExperiences2.this.montreResultat(j);
                }
            });
            JPanel pX2 = new JPanel(new BorderLayout());
            pX2.add((Component)this.spResultats[i], "Center");
            pX2.add((Component)this.sResultats[i], "South");
            this.pExperiences[i].add((Component)pX2, "Center");
            this.add(this.pExperiences[i]);
            this.timerExperiences[i] = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    TableExperiences2.this.majExperience(j);
                }
            });
        }
        Charte.formateAndFormateChildren(this);
    }

    public void completeExperiences() {
        int nbXP = Experiences.getExperiences().length;
        for (int i = 0; i < nbXP; ++i) {
            this.pExperiences[i].setBorder(BorderFactory.createTitledBorder(Experiences.getExperiences()[i].getTitre()));
            this.lDesc[i].setText(this.listeExperiences[i].getDesc());
        }
    }

    private void lanceExperience(int numero) {
        final int j = numero - 1;
        new Thread(){

            public void run() {
                for (int i = j; i < j + 1; ++i) {
                    TableExperiences2.this.bRun[i].setText("Exp\u00e9rience en cours");
                    new Thread(TableExperiences2.this.listeExperiences[i]).start();
                    TableExperiences2.this.timerExperiences[i].start();
                    do {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!TableExperiences2.this.listeExperiences[i].isTermine());
                    TableExperiences2.this.timerExperiences[i].stop();
                    System.out.println(TableExperiences2.this.listeExperiences[i].getResultat().getTitre());
                    System.out.println(TableExperiences2.this.listeExperiences[i].getResultat().getTotalClusters());
                    TableExperiences2.this.sResultats[i].setMaximum(TableExperiences2.this.listeExperiences[i].getResultat().getTotalClusters());
                    TableExperiences2.this.sResultats[i].setMajorTickSpacing(TableExperiences2.this.sResultats[i].getMaximum() / 10);
                    TableExperiences2.this.sResultats[i].setValue(1);
                    TableExperiences2.this.montreResultat(i + 1);
                    TableExperiences2.this.bRun[i].setText("Lancer cette exp\u00e9rience");
                }
            }
        }.start();
    }

    private void lanceExperiences() {
        new Thread(){

            public void run() {
                int nbXP = Experiences.getExperiences().length;
                for (int i = 0; i < nbXP; ++i) {
                    TableExperiences2.this.bRun[i].setText("Exp\u00e9rience en cours");
                    new Thread(TableExperiences2.this.listeExperiences[i]).start();
                    TableExperiences2.this.timerExperiences[i].start();
                    do {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!TableExperiences2.this.listeExperiences[i].isTermine());
                    TableExperiences2.this.timerExperiences[i].stop();
                    System.out.println(TableExperiences2.this.listeExperiences[i].getResultat().getTitre());
                    TableExperiences2.this.sResultats[i].setMaximum(TableExperiences2.this.listeExperiences[i].getResultat().getTotalClusters());
                    TableExperiences2.this.sResultats[i].setMajorTickSpacing(TableExperiences2.this.sResultats[i].getMaximum() / 10);
                    TableExperiences2.this.sResultats[i].setValue(1);
                    TableExperiences2.this.montreResultat(i + 1);
                    TableExperiences2.this.bRun[i].setText("Lancer cette exp\u00e9rience");
                }
            }
        }.start();
    }

    private void montreResultat(int numero) {
        int i;
        int nbClustersAMontrer = this.sResultats[numero - 1].getValue();
        Map<String, String[]> liste = this.listeExperiences[numero - 1].getResultat().aplanis(nbClustersAMontrer);
        DefaultMutableTreeNode racine = new DefaultMutableTreeNode("Clusters obtenus");
        Vector<String> c = new Vector<String>(liste.keySet());
        for (i = 0; i < c.size(); ++i) {
            String[] s = liste.get(c.elementAt(i));
            DefaultMutableTreeNode fils = new DefaultMutableTreeNode(c.elementAt(i));
            for (int j = 0; j < s.length; ++j) {
                fils.add(new DefaultMutableTreeNode(s[j]));
            }
            racine.add(fils);
        }
        this.tResultats[numero - 1].setModel(new DefaultTreeModel(racine));
        for (i = 0; i < this.tResultats[numero - 1].getRowCount(); ++i) {
            this.tResultats[numero - 1].expandRow(i);
        }
    }

    private void majExperience(int numero) {
        String s;
        String mn;
        int elapsed = this.listeExperiences[numero - 1].getSecondesExecution();
        String hr = "" + elapsed / 3600;
        if (hr.length() < 2) {
            hr = "0" + hr;
        }
        if ((mn = "" + elapsed % 3600 / 60).length() < 2) {
            mn = "0" + mn;
        }
        if ((s = "" + elapsed % 60).length() < 2) {
            s = "0" + s;
        }
        this.lDuree[numero - 1].setText(hr + ":" + mn + ":" + s);
        this.bRun[numero - 1].setText(this.listeExperiences[numero - 1].getStatut());
        if (this.listeExperiences[numero - 1].isTermine()) {
            this.timerExperiences[numero - 1].stop();
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
        return 600;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return 60;
    }
}

