/*
 * Decompiled with CFR 0.152.
 */
package ihm.iprinewsanalyzer;

import ihm.iprinewsanalyzer.Charte;
import ihm.iprinewsanalyzer.TableCorpus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.Timer;
import proc.thema.Experience;
import proc.thema.Experiences;

public class TableExperiences
extends JPanel
implements Scrollable {
    private JPanel[] pExperiences;
    private JLabel[] lDesc;
    private JLabel[] lNbArticle;
    private JLabel[] lNbThema;
    private JLabel[] lDuree;
    private JLabel[] lPertinence;
    private JButton[] bRun;
    private JButton bRunAll;
    private Timer[] timerExperiences;
    private TableCorpus aActualiser;
    private Experience[] listeExperiences = Experiences.getExperiences();

    public TableExperiences(TableCorpus aActualiser) {
        this.aActualiser = aActualiser;
        int nbXP = Experiences.getExperiences().length;
        this.setLayout(new GridLayout(nbXP + 1, 1, 5, 0));
        this.pExperiences = new JPanel[nbXP];
        this.lDesc = new JLabel[nbXP];
        this.lNbArticle = new JLabel[nbXP];
        this.lNbThema = new JLabel[nbXP];
        this.lDuree = new JLabel[nbXP];
        this.lPertinence = new JLabel[nbXP];
        this.bRun = new JButton[nbXP];
        this.timerExperiences = new Timer[nbXP];
        this.bRunAll = new JButton("Lancer toutes les exp\u00e9riences l'une apr\u00e8s l'autre");
        JPanel pRunAll = new JPanel(new FlowLayout());
        pRunAll.add(this.bRunAll);
        this.add(pRunAll);
        this.bRunAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TableExperiences.this.lanceExperiences();
            }
        });
        for (int i = 0; i < nbXP; ++i) {
            this.pExperiences[i] = new JPanel();
            this.pExperiences[i].setBorder(BorderFactory.createTitledBorder(Experiences.getExperiences()[i].getTitre()));
            this.pExperiences[i].setLayout(new BorderLayout());
            this.lDesc[i] = new JLabel(Experiences.getExperiences()[i].getDesc());
            this.pExperiences[i].add((Component)this.lDesc[i], "Center");
            JPanel pData = new JPanel(new BorderLayout());
            final int j = i + 1;
            this.bRun[i] = new JButton("Lancer cette exp\u00e9rience");
            this.bRun[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    TableExperiences.this.lanceExperience(j);
                }
            });
            JPanel pRun = new JPanel();
            pRun.add(this.bRun[i]);
            pData.add((Component)pRun, "North");
            JPanel pData2 = new JPanel(new GridLayout(2, 4));
            pData2.add(new JLabel("Lemmes c\u00f4t\u00e9 articles : ", 4));
            this.lNbArticle[i] = new JLabel("0", 2);
            pData2.add(this.lNbArticle[i]);
            pData2.add(new JLabel("Dur\u00e9e de l'exp\u00e9rience : ", 4));
            this.lDuree[i] = new JLabel("00:00:00", 2);
            pData2.add(this.lDuree[i]);
            pData2.add(new JLabel("Lemmes c\u00f4t\u00e9 th\u00e9matiques : ", 4));
            this.lNbThema[i] = new JLabel("0", 2);
            pData2.add(this.lNbThema[i]);
            pData2.add(new JLabel("Pertinence : ", 4));
            this.lPertinence[i] = new JLabel("0%", 2);
            pData2.add(this.lPertinence[i]);
            pData.add((Component)pData2, "South");
            this.pExperiences[i].add((Component)pData, "South");
            this.add(this.pExperiences[i]);
            this.timerExperiences[i] = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    TableExperiences.this.majExperience(j);
                }
            });
        }
        Charte.formateAndFormateChildren(this);
    }

    public void completeExperiences() {
        int nbXP = Experiences.getExperiences().length;
        for (int i = 0; i < nbXP; ++i) {
            this.pExperiences[i].setBorder(BorderFactory.createTitledBorder(Experiences.getExperiences()[i].getTitre()));
            this.lDesc[i].setText(this.listeExperiences[i].getDesc());
            this.lNbArticle[i].setText("" + this.listeExperiences[i].getNbLemmesCoteArticle());
            this.lNbThema[i].setText("" + this.listeExperiences[i].getNbLemmesCoteThematique());
        }
    }

    private void lanceExperience(int numero) {
        this.bRun[numero - 1].setText("Exp\u00e9rience en cours");
        new Thread(this.listeExperiences[numero - 1]).start();
        this.timerExperiences[numero - 1].start();
    }

    private void lanceExperiences() {
        new Thread(){

            public void run() {
                int nbXP = Experiences.getExperiences().length;
                for (int i = 0; i < nbXP; ++i) {
                    TableExperiences.this.bRun[i].setText("Exp\u00e9rience en cours");
                    new Thread(TableExperiences.this.listeExperiences[i]).start();
                    TableExperiences.this.timerExperiences[i].start();
                    do {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!TableExperiences.this.listeExperiences[i].isTermine());
                    TableExperiences.this.timerExperiences[i].stop();
                    TableExperiences.this.bRun[i].setText("Lancer cette exp\u00e9rience");
                    TableExperiences.this.aActualiser.actualise();
                }
            }
        }.start();
    }

    private void majExperience(int numero) {
        String s;
        String mn;
        int elapsed = this.listeExperiences[numero - 1].getSecondesExecution();
        String hr = "" + elapsed / 3600;
        if (hr.length() < 2) {
            hr = "0" + hr;
        }
        if ((mn = "" + elapsed % 3600 / 60).length() < 2) {
            mn = "0" + mn;
        }
        if ((s = "" + elapsed % 60).length() < 2) {
            s = "0" + s;
        }
        int pertinence = (int)Math.floor(this.listeExperiences[numero - 1].getPertinence() * 100.0);
        this.lNbArticle[numero - 1].setText("" + this.listeExperiences[numero - 1].getNbLemmesCoteArticle());
        this.lNbThema[numero - 1].setText("" + this.listeExperiences[numero - 1].getNbLemmesCoteThematique());
        this.lDuree[numero - 1].setText(hr + ":" + mn + ":" + s);
        this.lPertinence[numero - 1].setText(pertinence + "%");
        this.bRun[numero - 1].setText(this.listeExperiences[numero - 1].getStatut());
        if (this.listeExperiences[numero - 1].isTermine()) {
            this.timerExperiences[numero - 1].stop();
            this.aActualiser.actualise();
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
        return 600;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return 60;
    }
}

