/*
 * Decompiled with CFR 0.152.
 */
package ihm.iprinewsanalyzer;

import data.structures.thema.ThemaItem;
import ihm.iprinewsanalyzer.Charte;
import ihm.iprinewsanalyzer.FenetrePrincipale;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import proc.thema.Experiences;

public class TableCorpus
extends JPanel
implements Scrollable {
    private int[] id;
    private String[] titres;
    private String[] descriptions;
    private JLabel[] lTitres;
    private JLabel[][] pertinencesIndiv;
    private JLabel[] pertinences;
    private JComboBox[] manuel;
    private FenetrePrincipale parent;

    public TableCorpus(FenetrePrincipale parent, int taille, ThemaItem[] thematiquesPossibles) {
        this.parent = parent;
        this.id = new int[taille];
        this.titres = new String[taille];
        this.descriptions = new String[taille];
        this.lTitres = new JLabel[taille];
        this.manuel = new JComboBox[taille];
        this.pertinencesIndiv = new JLabel[taille][Experiences.getExperiences().length];
        this.setPreferredSize(new Dimension(550 + Experiences.getExperiences().length * 150, 20 + taille * 17));
        this.setLayout(null);
        for (int i = 0; i < taille; ++i) {
            this.lTitres[i] = new JLabel("");
            this.lTitres[i].setBorder(BorderFactory.createEtchedBorder());
            this.add(this.lTitres[i]);
            this.lTitres[i].setBounds(0, 20 + 17 * i, 400, 17);
            this.manuel[i] = new JComboBox<ThemaItem>(thematiquesPossibles);
            this.add(this.manuel[i]);
            this.manuel[i].setBounds(400, 20 + 17 * i, 150, 17);
            this.manuel[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                }
            });
            for (int j = 0; j < Experiences.getExperiences().length; ++j) {
                this.pertinencesIndiv[i][j] = new JLabel("?", 0);
                this.pertinencesIndiv[i][j].setBorder(BorderFactory.createEtchedBorder());
                this.add(this.pertinencesIndiv[i][j]);
                this.pertinencesIndiv[i][j].setBounds(550 + 34 * j, 20 + 17 * i, 34, 17);
            }
        }
        JLabel lTitre = new JLabel("Article", 0);
        lTitre.setBounds(0, 0, 400, 20);
        this.add(lTitre);
        JButton bSave = new JButton("Sauvegarder");
        bSave.setBounds(400, 0, 150, 20);
        this.add(bSave);
        bSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TableCorpus.this.sauvegardeManuel();
            }
        });
        this.pertinences = new JLabel[Experiences.getExperiences().length];
        for (int i = 0; i < Experiences.getExperiences().length; ++i) {
            this.pertinences[i] = new JLabel("100%", 0);
            this.pertinences[i].setBounds(550 + 34 * i, 0, 34, 20);
            this.add(this.pertinences[i]);
        }
        Charte.formateAndFormateChildren(this);
    }

    public void setArticleAt(int numArticle, int id, String title, String description, ThemaItem thematique) {
        this.id[numArticle] = id;
        this.titres[numArticle] = title;
        this.descriptions[numArticle] = description;
        this.manuel[numArticle].setSelectedItem(thematique);
        this.lTitres[numArticle].setText("<html>" + title.substring(0, Math.min(title.length(), 60)) + (title.length() > 60 ? "..." : ""));
        this.lTitres[numArticle].setToolTipText("<html><b><u>" + title + "</u></b><br/><i>" + this.formate(description));
    }

    private String formate(String s) {
        StringBuffer buffer = new StringBuffer(s);
        for (int i = 100; i < buffer.length(); i += 100) {
            int espace = buffer.indexOf(" ", i);
            if (espace == -1) continue;
            buffer = buffer.replace(espace, espace + 1, "<br/>");
        }
        return buffer.toString();
    }

    public int getIdAt(int numArticle) {
        return this.id[numArticle];
    }

    public String getTitreAt(int numArticle) {
        return this.titres[numArticle];
    }

    public String getDescriptionAt(int numArticle) {
        return this.descriptions[numArticle];
    }

    public int getIdThematiqueAt(int numArticle) {
        return ((ThemaItem)this.manuel[numArticle].getSelectedItem()).getConceptID();
    }

    public int getTaille() {
        return this.titres.length;
    }

    public void actualise() {
        int i;
        for (i = 0; i < this.pertinences.length; ++i) {
            this.pertinences[i].setText((int)(100.0 * Experiences.getExperiences()[i].getPertinence()) + "%");
        }
        for (i = 0; i < this.pertinencesIndiv.length; ++i) {
            for (int j = 0; j < Experiences.getExperiences().length; ++j) {
                this.pertinencesIndiv[i][j].setText(Experiences.getExperiences()[j].isPertinent(i) ? "O" : "-");
            }
        }
    }

    private void sauvegardeManuel() {
        this.parent.sauvegardeManuel();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
        return 600;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return 60;
    }
}

