/*
 * Decompiled with CFR 0.152.
 */
package data.structures.thema;

import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.ThesaurusDatabase;
import data.structures.tagging.GraphLemmaItem;
import data.structures.thema.ThemaItem;
import java.util.Vector;

public class ThemaGraph {
    public static final int BASE_UNIQUEMENT = 0;
    public static final int BASE_ENRICHIE = 1;
    public static final int TOUT = 2;
    public static final int ENRICH_UNIQUEMENT = 3;
    private GraphLemmaItem[] gitems0;
    private GraphLemmaItem[] gitems1;
    private GraphLemmaItem[] gitems2;
    private GraphLemmaItem[] gitems3;

    public ThemaGraph(Database db) {
        ThesaurusDatabase tDB = new ThesaurusDatabase(db);
        Vector<Object> items0 = new Vector();
        Vector items1 = new Vector();
        Vector<Object> items2 = new Vector();
        Vector items3 = new Vector();
        try {
            int i;
            items0 = new Vector<ThemaItem>(tDB.getTopClasses());
            items1 = (Vector)items0.clone();
            items2 = new Vector<ThemaItem>(tDB.getAllClasses());
            items3 = (Vector)items0.clone();
            this.gitems0 = new GraphLemmaItem[items0.size()];
            for (i = 0; i < this.gitems0.length; ++i) {
                this.gitems0[i] = new GraphLemmaItem();
                this.gitems0[i].setNodeID(((ThemaItem)items0.elementAt(i)).getConceptID());
                this.gitems0[i].setNodeName(((ThemaItem)items0.elementAt(i)).getConceptName());
                this.gitems0[i].setLemmas(tDB.getLemmas(((ThemaItem)items0.elementAt(i)).getConceptID()));
            }
            this.gitems1 = new GraphLemmaItem[items1.size()];
            for (i = 0; i < this.gitems1.length; ++i) {
                this.gitems1[i] = new GraphLemmaItem();
                this.gitems1[i].setNodeID(((ThemaItem)items1.elementAt(i)).getConceptID());
                this.gitems1[i].setNodeName(((ThemaItem)items1.elementAt(i)).getConceptName());
                this.gitems1[i].setLemmas(tDB.getExtendedLemmas(((ThemaItem)items1.elementAt(i)).getConceptID()));
            }
            this.gitems2 = new GraphLemmaItem[items2.size()];
            for (i = 0; i < this.gitems2.length; ++i) {
                this.gitems2[i] = new GraphLemmaItem();
                this.gitems2[i].setNodeID(((ThemaItem)items2.elementAt(i)).getConceptID());
                this.gitems2[i].setNodeName(((ThemaItem)items2.elementAt(i)).getConceptName());
                this.gitems2[i].setLemmas(tDB.getLemmas(((ThemaItem)items2.elementAt(i)).getConceptID()));
            }
            this.gitems3 = new GraphLemmaItem[items1.size()];
            for (i = 0; i < this.gitems3.length; ++i) {
                this.gitems3[i] = new GraphLemmaItem();
                this.gitems3[i].setNodeID(((ThemaItem)items3.elementAt(i)).getConceptID());
                this.gitems3[i].setNodeName(((ThemaItem)items3.elementAt(i)).getConceptName());
                this.gitems3[i].setLemmas(tDB.getOnlyExtendedLemmas(((ThemaItem)items3.elementAt(i)).getConceptID()));
            }
        }
        catch (NoBaseException nbe) {
            // empty catch block
        }
    }

    public GraphLemmaItem[] getItems(int couverture) {
        GraphLemmaItem[] items = null;
        switch (couverture) {
            case 0: {
                items = this.gitems0;
                break;
            }
            case 1: {
                items = this.gitems1;
                break;
            }
            case 3: {
                items = this.gitems3;
                break;
            }
            default: {
                items = this.gitems2;
            }
        }
        return items;
    }
}

