/*
 * Decompiled with CFR 0.152.
 */
package data.structures.tagging;

public class LemmaInfos {
    String source = new String();
    String lex = new String();
    String lemma = new String();

    public LemmaInfos(String ligne) {
        String[] elems = ligne.split("\t");
        if (elems.length == 3) {
            this.source = elems[0].toLowerCase();
            this.lex = elems[1];
            if (elems[2].contains("|")) {
                String[] ambiguities = elems[2].split("\\|");
                this.lemma = ambiguities[0].toLowerCase();
            } else {
                this.lemma = elems[2].matches("@card@") ? elems[0].toLowerCase() : elems[2].toLowerCase();
            }
        }
    }

    public String get_lemma() {
        return this.lemma;
    }

    public String get_lex() {
        return this.lex;
    }

    public String get_source() {
        return this.source;
    }

    public String toString() {
        String res = this.source + "\t" + this.lex + "\t" + this.lemma + "\n";
        return res;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LemmaInfos)) {
            return false;
        }
        LemmaInfos l = (LemmaInfos)o;
        return l.get_lemma().equals(this.get_lemma()) && l.get_lex().equals(this.get_lex());
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.lex != null ? this.lex.hashCode() : 0);
        hash = 29 * hash + (this.lemma != null ? this.lemma.hashCode() : 0);
        return hash;
    }
}

