/*
 * Decompiled with CFR 0.152.
 */
package data.structures.rss;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.List;

public class RSSFeed {
    private URLConnection url;
    private SyndFeedInput input = new SyndFeedInput();
    private SyndFeed feed;
    private String errorMessage;
    public static int RSS_OK = 1;
    public static int RSS_ERR = 0;

    public RSSFeed() {
        this.input.setXmlHealerOn(true);
        this.errorMessage = "Not Initialized";
    }

    public int InitRSS(String theURL) {
        if (!theURL.equals("")) {
            try {
                this.url = new URL(theURL).openConnection();
                this.url.setRequestProperty("User-Agent", "IPRI");
                XmlReader reader = new XmlReader(this.url);
                this.feed = this.input.build((Reader)reader);
                this.errorMessage = "";
                return RSS_OK;
            }
            catch (Exception ex) {
                this.errorMessage = ex.getMessage();
                return RSS_ERR;
            }
        }
        return RSS_ERR;
    }

    public int GetFeedItemCount() {
        if (this.errorMessage.equals("")) {
            return this.feed.getEntries().size();
        }
        return RSS_ERR;
    }

    public Date GetPubDate() {
        if (this.errorMessage.equals("")) {
            return this.feed.getPublishedDate();
        }
        return null;
    }

    public SyndEntryImpl[] GetEntries() {
        if (this.errorMessage.equals("")) {
            List entries = this.feed.getEntries();
            SyndEntryImpl[] result = new SyndEntryImpl[entries.size()];
            entries.toArray(result);
            return result;
        }
        return null;
    }

    public String GetRSSFeed() {
        if (this.errorMessage.equals("")) {
            return this.feed.toString();
        }
        return this.errorMessage;
    }

    public String getEncoding() {
        if (this.errorMessage.equals("")) {
            return this.feed.getEncoding();
        }
        return this.errorMessage;
    }

    public String GetErrorMsg() {
        return this.errorMessage;
    }
}

