/*
 * Decompiled with CFR 0.152.
 */
package data.structures.classification;

import data.structures.classification.LemmePondere;
import data.structures.classification.NuagePondere;
import data.structures.classification.Operation;
import data.structures.tagging.GraphLemmaItem;
import data.structures.tagging.LemmaItem;
import java.util.Vector;

public class Corpus {
    public Vector<NuagePondere> articles = new Vector();

    public void addArticle(NuagePondere article) {
        this.articles.add(article);
    }

    public void addArticle(GraphLemmaItem article) {
        NuagePondere nuage = new NuagePondere(article.getNodeID(), article.getNodeName());
        Vector<LemmaItem> v = new Vector<LemmaItem>(article.getLemmas());
        for (int i = 0; i < v.size(); ++i) {
            Vector<Operation> orig;
            LemmaItem l = v.elementAt(i);
            if (l.getCountTitle() > 0) {
                orig = new Vector<Operation>();
                orig.addElement(Operation.ACCES_TITRE);
                nuage.addLemme(new LemmePondere(l.getLemmaName(), orig, l.getLemmaLex(), l.getCountTitle()));
            }
            if (l.getCountDesc() <= 0) continue;
            orig = new Vector();
            orig.addElement(Operation.ACCES_DESC);
            nuage.addLemme(new LemmePondere(l.getLemmaName(), orig, l.getLemmaLex(), l.getCountDesc()));
        }
        this.articles.add(nuage);
    }

    public NuagePondere[] getArticles() {
        NuagePondere[] result = new NuagePondere[this.articles.size()];
        this.articles.toArray(result);
        return result;
    }

    public void pondereOrigine(Operation origine, double poids) {
        for (int i = 0; i < this.articles.size(); ++i) {
            this.articles.elementAt(i).pondereOrigine(origine, poids);
        }
    }

    public void pondereCategorie(String categorie, double poids) {
        for (int i = 0; i < this.articles.size(); ++i) {
            this.articles.elementAt(i).pondereCategorie(categorie, poids);
        }
    }

    public void pondereAllCategories(double poids) {
        for (int i = 0; i < this.articles.size(); ++i) {
            this.articles.elementAt(i).pondereAllCategories(poids);
        }
    }
}

