/*
 * Decompiled with CFR 0.152.
 */
package data.structures.classification;

import data.structures.classification.ClusterPart;
import data.structures.classification.LemmePondere;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cluster
implements ClusterPart {
    private ClusterPart[] sousClusters;
    private int randomTitreIndex;
    private double similarite = 0.0;
    private Vector<LemmePondere> lemmes = new Vector();

    public Cluster(ClusterPart[] sousClusters, double similarite) {
        this.sousClusters = sousClusters;
        this.similarite = similarite;
        for (int i = 0; i < sousClusters.length; ++i) {
            LemmePondere[] l = sousClusters[i].getAllLemmes();
            for (int j = 0; j < l.length; ++j) {
                this.lemmes.add(l[j]);
            }
        }
        this.fusionneLemmes();
        this.randomTitreIndex = (int)(Math.random() * (double)sousClusters.length);
    }

    @Override
    public ClusterPart[] getSousClusters() {
        return this.sousClusters;
    }

    @Override
    public int getTotalClusters() {
        int nb = 1;
        for (int i = 0; i < this.sousClusters.length; ++i) {
            nb += this.sousClusters[i].getTotalClusters();
        }
        return nb;
    }

    @Override
    public Map<String, String[]> aplanis(int nbClustersConserves) {
        Vector<ClusterPart> clusters = new Vector<ClusterPart>();
        clusters.addElement(this);
        while (clusters.size() < nbClustersConserves && clusters.size() < this.getTotalClusters()) {
            double moindreSimilarite = Double.MAX_VALUE;
            int index = -1;
            for (int i = 0; i < clusters.size(); ++i) {
                if (!(((ClusterPart)clusters.elementAt(i)).getSimilarite() < moindreSimilarite)) continue;
                moindreSimilarite = ((ClusterPart)clusters.elementAt(i)).getSimilarite();
                index = i;
            }
            ClusterPart choisi = (ClusterPart)clusters.get(index);
            clusters.removeElement(choisi);
            for (int i = 0; i < choisi.getSousClusters().length; ++i) {
                clusters.addElement(choisi.getSousClusters()[i]);
            }
        }
        HashMap<String, String[]> res = new HashMap<String, String[]>();
        for (int i = 0; i < clusters.size(); ++i) {
            res.put(((ClusterPart)clusters.elementAt(i)).getTitre(), ((ClusterPart)clusters.elementAt(i)).getFeuilles());
        }
        return res;
    }

    @Override
    public String[] getFeuilles() {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.sousClusters.length; ++i) {
            String[] s = this.sousClusters[i].getFeuilles();
            for (int j = 0; j < s.length; ++j) {
                v.addElement(s[j]);
            }
        }
        String[] res = new String[v.size()];
        v.toArray(res);
        return res;
    }

    @Override
    public String getTitre() {
        return this.sousClusters[this.randomTitreIndex].getTitre();
    }

    @Override
    public double getSimilarite() {
        return this.similarite;
    }

    @Override
    public LemmePondere[] getAllLemmes() {
        LemmePondere[] result = new LemmePondere[this.lemmes.size()];
        this.lemmes.toArray(result);
        return result;
    }

    private void fusionneLemmes() {
        for (int i = 0; i < this.lemmes.size(); ++i) {
            for (int j = i; j < this.lemmes.size(); ++j) {
                if (!this.lemmes.elementAt(i).getLemme().equals(this.lemmes.elementAt(j).getLemme()) || !this.lemmes.elementAt(i).getCategorie().equals(this.lemmes.elementAt(j).getCategorie()) || !this.lemmes.elementAt(i).getOrigine().equals(this.lemmes.elementAt(j).getOrigine())) continue;
                this.lemmes.elementAt(i).addNbOccurences(this.lemmes.elementAt(j).getNbOccurences());
                this.lemmes.removeElementAt(j);
                --j;
            }
        }
    }

    public String toString() {
        String s = "[" + this.getTitre() + " : \n";
        for (int i = 0; i < this.sousClusters.length; ++i) {
            s = s + this.sousClusters[i].toString() + "\n";
        }
        s = s + "]";
        return s;
    }
}

