/*
 * Decompiled with CFR 0.152.
 */
package data.structures.analyse;

import data.structures.analyse.SacArticles;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CorpusAnalyse {
    public static final String NOM_SUJET_COMMUN = "Pot commun";
    public static final String NOM_SUJET_DIVERS = "A trier";
    private Map<String, SacArticles> listeSujets = new HashMap<String, SacArticles>();

    public CorpusAnalyse() {
        this.listeSujets.put(NOM_SUJET_DIVERS, new SacArticles(NOM_SUJET_DIVERS));
    }

    public void addSujet(SacArticles sac) {
        SacArticles sac0 = this.listeSujets.get(sac.getTitre());
        if (sac0 != null) {
            sac.addAll(sac0);
            this.removeSujet(sac0);
        }
        this.listeSujets.put(sac.getTitre(), sac);
    }

    public void removeSujet(SacArticles sac) {
        this.listeSujets.remove(sac.getTitre());
    }

    public int getNbArticles() {
        int n = 0;
        for (SacArticles s : this.getSujets()) {
            n += s.getArticles().length;
        }
        return n;
    }

    public void fusionneSujets(SacArticles[] sacs) {
        for (int i = 1; i < sacs.length; ++i) {
            sacs[0].addAll(sacs[i]);
            this.removeSujet(sacs[i]);
        }
    }

    public SacArticles getSujet(String titre) {
        return this.listeSujets.get(titre);
    }

    public SacArticles[] getSujets() {
        SacArticles[] res = new SacArticles[this.listeSujets.values().size()];
        this.listeSujets.values().toArray(res);
        return res;
    }

    public CorpusAnalyse getBackup() {
        CorpusAnalyse backup = new CorpusAnalyse();
        SacArticles[] aCopier = this.getSujets();
        for (int i = 0; i < aCopier.length; ++i) {
            backup.addSujet(aCopier[i].clone());
        }
        return backup;
    }

    public String getSauvegarde() {
        String s = "<Corpus>\n";
        SacArticles[] aCopier = this.getSujets();
        for (int i = 0; i < aCopier.length; ++i) {
            s = s + "<Sujet>\n" + aCopier[i].getSauvegarde() + "</Sujet>\n";
        }
        s = s + "</Corpus>";
        return s;
    }

    public void sauvegarde(FileWriter out) throws IOException {
        out.write("<Corpus>\n");
        SacArticles[] aCopier = this.getSujets();
        for (int i = 0; i < aCopier.length; ++i) {
            out.write("<Sujet>\n");
            aCopier[i].sauvegarde(out);
            out.write("</Sujet>\n");
        }
        out.write("</Corpus>");
    }

    public static CorpusAnalyse charge(String sauvegarde) {
        CorpusAnalyse res = new CorpusAnalyse();
        String[] s = sauvegarde.split("<Sujet>");
        for (int i = 1; i < s.length; ++i) {
            String save = s[i].substring(0, s[i].indexOf("</Sujet>")).trim();
            res.addSujet(SacArticles.charge(save));
        }
        return res;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CorpusAnalyse)) {
            return false;
        }
        CorpusAnalyse c = (CorpusAnalyse)o;
        return c.getSauvegarde().equals(this.getSauvegarde());
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.listeSujets != null ? this.listeSujets.hashCode() : 0);
        return hash;
    }
}

