/*
 * Decompiled with CFR 0.152.
 */
package data.base.connectors;

import data.base.Database;
import data.base.NoBaseException;
import data.structures.tagging.LemmaInfos;
import data.structures.tagging.LemmaItem;
import data.structures.tagging.LemmaVector;
import data.structures.thema.ThemaItem;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import proc.tagging.TreeTagger;
import proc.text.Codecs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThesaurusDatabase {
    private Database theDB;
    private Map<Integer, ThemaItem> concepts = new HashMap<Integer, ThemaItem>();
    private Set<ThemaItem> topClasses;
    private Set<ThemaItem> topClasses2;
    private TreeTagger tt = new TreeTagger();
    private TreeTagger tte = new TreeTagger(1);

    public ThesaurusDatabase(Database db) {
        this.theDB = db;
    }

    public Set<ThemaItem> getAllClasses() throws NoBaseException {
        String query = String.format("SELECT * FROM tax_classes;", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        LinkedHashSet<ThemaItem> items = new LinkedHashSet<ThemaItem>();
        try {
            while (rs.next()) {
                ThemaItem ti = new ThemaItem();
                ti.setConceptID(rs.getInt("id"));
                ti.setConceptName(Codecs.desEscapeHTML(rs.getString("titreFR")));
                ti.setConceptDesc(Codecs.desEscapeHTML(rs.getString("descriptionFR")));
                ti.setThesaurusID(rs.getInt("taxonomie"));
                ti.setTitleLemmas(Codecs.desEscapeHTML(rs.getString("titreLemmaFR")));
                ti.setDescLemmas(Codecs.desEscapeHTML(rs.getString("descLemmaFR")));
                items.add(ti);
            }
        }
        catch (SQLException e) {
            System.out.println("error on get thema last key " + e.toString());
        }
        return items;
    }

    public Set<ThemaItem> getAllClasses(int taxonomie) throws NoBaseException {
        String query = String.format("SELECT * FROM tax_classes WHERE taxonomie=" + taxonomie + ";", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        LinkedHashSet<ThemaItem> items = new LinkedHashSet<ThemaItem>();
        try {
            while (rs.next()) {
                ThemaItem ti = new ThemaItem();
                ti.setConceptID(rs.getInt("id"));
                ti.setConceptName(Codecs.desEscapeHTML(rs.getString("titreFR")));
                ti.setConceptDesc(Codecs.desEscapeHTML(rs.getString("descriptionFR")));
                ti.setThesaurusID(rs.getInt("taxonomie"));
                ti.setTitleLemmas(Codecs.desEscapeHTML(rs.getString("titreLemmaFR")));
                ti.setDescLemmas(Codecs.desEscapeHTML(rs.getString("descLemmaFR")));
                items.add(ti);
            }
        }
        catch (SQLException e) {
            System.out.println("error on get thema last key " + e.toString());
        }
        return items;
    }

    public ThemaItem getClasse(int id) throws NoBaseException {
        ThemaItem item = this.concepts.get(new Integer(id));
        if (item == null) {
            String query = String.format("SELECT * FROM tax_classes WHERE id=" + id + ";", new Object[0]);
            ResultSet rs = this.theDB.executeSelection(query);
            item = new ThemaItem();
            try {
                while (rs.next()) {
                    ThemaItem ti = new ThemaItem();
                    ti.setConceptID(rs.getInt("id"));
                    ti.setConceptName(Codecs.desEscapeHTML(rs.getString("titreFR")));
                    ti.setConceptDesc(Codecs.desEscapeHTML(rs.getString("descriptionFR")));
                    ti.setThesaurusID(rs.getInt("taxonomie"));
                    ti.setTitleLemmas(Codecs.desEscapeHTML(rs.getString("titreLemmaFR")));
                    ti.setDescLemmas(Codecs.desEscapeHTML(rs.getString("descLemmaFR")));
                    item = ti;
                }
            }
            catch (SQLException e) {
                System.out.println("error on get thema last key " + e.toString());
            }
            this.concepts.put(new Integer(id), item);
        }
        return item;
    }

    public Set<LemmaItem> getLemmas(int classe) throws NoBaseException {
        String query = String.format("SELECT * FROM tax_lemmesfr WHERE classe=" + classe + ";", new Object[0]);
        HashSet<LemmaItem> lemmas = new HashSet<LemmaItem>();
        ResultSet lemmasRS = this.theDB.executeSelection(query);
        try {
            while (lemmasRS.next()) {
                LemmaItem li = new LemmaItem();
                li.setLemmaName(Codecs.desEscapeHTML(lemmasRS.getString("lemme")));
                li.setNodeID(lemmasRS.getInt("classe"));
                li.setCountTitle(lemmasRS.getInt("occuTitre"));
                li.setCountDesc(lemmasRS.getInt("occuDesc"));
                lemmas.add(li);
            }
        }
        catch (SQLException e) {
            System.out.println("error " + e.toString());
        }
        return lemmas;
    }

    public Set<LemmaItem> getExtendedLemmas(int classe) throws NoBaseException {
        HashSet<LemmaItem> lemmas = new HashSet<LemmaItem>();
        lemmas.addAll(this.getLemmas(classe));
        Vector<ThemaItem> v = new Vector<ThemaItem>(this.getSubclasses(classe));
        for (int i = 0; i < v.size(); ++i) {
            lemmas.addAll(this.getExtendedLemmas(v.elementAt(i).getConceptID()));
        }
        return lemmas;
    }

    public Set<LemmaItem> getOnlyExtendedLemmas(int classe) throws NoBaseException {
        HashSet<LemmaItem> lemmas = new HashSet<LemmaItem>();
        Vector<ThemaItem> v = new Vector<ThemaItem>(this.getSubclasses(classe));
        for (int i = 0; i < v.size(); ++i) {
            lemmas.addAll(this.getExtendedLemmas(v.elementAt(i).getConceptID()));
        }
        return lemmas;
    }

    public Set<ThemaItem> getSuperclasses(int classe) throws NoBaseException {
        String parentNodeQuery = String.format("SELECT t.id, t.titreFR, t.descriptionFR,t.taxonomie, t.titreLemmaFR, t.descLemmaFR FROM tax_hierarchie r, tax_classes t WHERE r.sousClasse = " + classe + " " + "AND t.id = r.surClasse;", new Object[0]);
        HashSet<ThemaItem> parentItems = new HashSet<ThemaItem>();
        ResultSet parentRS = this.theDB.executeSelection(parentNodeQuery);
        try {
            while (parentRS.next()) {
                ThemaItem ti = new ThemaItem();
                ti.setConceptID(parentRS.getInt("id"));
                ti.setConceptName(Codecs.desEscapeHTML(parentRS.getString("titreFR")));
                ti.setConceptDesc(Codecs.desEscapeHTML(parentRS.getString("descriptionFR")));
                ti.setThesaurusID(parentRS.getInt("taxonomie"));
                ti.setTitleLemmas(Codecs.desEscapeHTML(parentRS.getString("titreLemmaFR")));
                ti.setDescLemmas(Codecs.desEscapeHTML(parentRS.getString("descLemmaFR")));
                parentItems.add(ti);
            }
        }
        catch (SQLException e) {
            System.out.println("error on get thema last key " + e.toString());
        }
        return parentItems;
    }

    public Set<ThemaItem> getSubclasses(int classe) throws NoBaseException {
        String childNodeQuery = String.format("SELECT t.id, t.titreFR, t.descriptionFR,t.taxonomie, t.titreLemmaFR, t.descLemmaFR FROM tax_hierarchie r, tax_classes t WHERE r.surClasse = " + classe + " " + "AND t.id = r.sousClasse;", new Object[0]);
        HashSet<ThemaItem> childItems = new HashSet<ThemaItem>();
        ResultSet childRS = this.theDB.executeSelection(childNodeQuery);
        try {
            while (childRS.next()) {
                ThemaItem ti = new ThemaItem();
                ti.setConceptID(childRS.getInt("id"));
                ti.setConceptName(Codecs.desEscapeHTML(childRS.getString("titreFR")));
                ti.setConceptDesc(Codecs.desEscapeHTML(childRS.getString("descriptionFR")));
                ti.setThesaurusID(childRS.getInt("taxonomie"));
                ti.setTitleLemmas(Codecs.desEscapeHTML(childRS.getString("titreLemmaFR")));
                ti.setDescLemmas(Codecs.desEscapeHTML(childRS.getString("descLemmaFR")));
                childItems.add(ti);
            }
        }
        catch (SQLException e) {
            System.out.println("error on get thema last key " + e.toString());
        }
        return childItems;
    }

    public Set<ThemaItem> getTopClasses() throws NoBaseException {
        if (this.topClasses == null) {
            this.topClasses = new HashSet<ThemaItem>();
            Vector<ThemaItem> tout = new Vector<ThemaItem>(this.getAllClasses());
            for (int i = 0; i < tout.size(); ++i) {
                String parentNodeQuery = String.format("SELECT t.id FROM tax_hierarchie r, tax_classes t WHERE r.sousClasse = " + tout.elementAt(i).getConceptID() + " AND t.id = r.surClasse;", new Object[0]);
                ResultSet parentRS = this.theDB.executeSelection(parentNodeQuery);
                try {
                    if (parentRS.next()) continue;
                    this.topClasses.add(tout.elementAt(i));
                    continue;
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                }
            }
        }
        return this.topClasses;
    }

    public Set<ThemaItem> getTopClasses(int taxonomie) throws NoBaseException {
        if (this.topClasses2 == null) {
            this.topClasses2 = new HashSet<ThemaItem>();
            Vector<ThemaItem> tout = new Vector<ThemaItem>(this.getAllClasses(taxonomie));
            for (int i = 0; i < tout.size(); ++i) {
                String parentNodeQuery = String.format("SELECT t.id FROM tax_hierarchie r, tax_classes t WHERE r.sousClasse = " + tout.elementAt(i).getConceptID() + " AND t.id = r.surClasse;", new Object[0]);
                ResultSet parentRS = this.theDB.executeSelection(parentNodeQuery);
                try {
                    if (parentRS.next()) continue;
                    this.topClasses2.add(tout.elementAt(i));
                    continue;
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                }
            }
        }
        return this.topClasses2;
    }

    public String[] getNomsTopThematiques() throws NoBaseException {
        Vector<ThemaItem> result = new Vector<ThemaItem>(this.getTopClasses());
        String[] res = new String[result.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = result.elementAt(i).getConceptName();
        }
        return res;
    }

    public String[] getNomsTopThematiques(int taxonomie) throws NoBaseException {
        Vector<ThemaItem> result = new Vector<ThemaItem>(this.getTopClasses(taxonomie));
        String[] res = new String[result.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = result.elementAt(i).getConceptName();
        }
        return res;
    }

    public void resetTaxonomie(int id) throws NoBaseException {
        String removeRelations = "DELETE FROM tax_hierarchie WHERE surClasse IN (SELECT id FROM tax_classes WHERE taxonomie=" + id + ");";
        this.theDB.executeDeletion(removeRelations);
        String removeRelations2 = "DELETE FROM tax_hierarchie WHERE sousClasse IN (SELECT id FROM tax_classes WHERE taxonomie=" + id + ");";
        this.theDB.executeDeletion(removeRelations2);
        String removeLemmes = "DELETE FROM tax_lemmesFR WHERE classe IN (SELECT id FROM tax_classes WHERE taxonomie=" + id + ");";
        this.theDB.executeDeletion(removeLemmes);
        String removeLemmes2 = "DELETE FROM tax_lemmesEN WHERE classe IN (SELECT id FROM tax_classes WHERE taxonomie=" + id + ");";
        this.theDB.executeDeletion(removeLemmes2);
        String removeConcepts = "DELETE FROM tax_classes WHERE taxonomie=" + id + ";";
        this.theDB.executeDeletion(removeConcepts);
    }

    public void storeClasse(int taxonomie, int id, String nomEN, String descEN, String nomFR, String descFR, int parent) throws NoBaseException {
        LemmaVector lemmasNomFR = this.tt.processText(nomFR);
        LemmaVector lemmasDescFR = this.tt.processText(descFR);
        LemmaVector lemmasNomEN = this.tte.processText(nomEN);
        LemmaVector lemmasDescEN = this.tte.processText(descEN);
        if (parent <= 0) {
            String queryConcept = "INSERT INTO tax_classes(id, taxonomie, titreFR, descriptionFR, titreEN, descriptionEN, titreLemmaFR, descLemmaFR, titreLemmaEN, descLemmaEN) VALUES(" + id + ", " + taxonomie + ", '" + Codecs.escapeHTML(nomFR) + "', '" + Codecs.escapeHTML(descFR) + "', '" + Codecs.escapeHTML(nomEN) + "', '" + Codecs.escapeHTML(descEN) + "', '" + Codecs.escapeHTML(lemmasNomFR.toLemmas()) + "', '" + Codecs.escapeHTML(lemmasDescFR.toLemmas()) + "', '" + Codecs.escapeHTML(lemmasNomEN.toLemmas()) + "', '" + Codecs.escapeHTML(lemmasDescEN.toLemmas()) + "');";
            this.theDB.executeInsertOrUpdate(queryConcept);
            this.storeLemmesFR(id, lemmasNomFR, lemmasDescFR);
            this.storeLemmesEN(id, lemmasNomEN, lemmasDescEN);
        } else {
            String queryConcept = "INSERT INTO tax_classes(id, taxonomie, titreFR, descriptionFR, titreEN, descriptionEN, titreLemmaFR, descLemmaFR, titreLemmaEN, descLemmaEN) VALUES(" + id + ", " + taxonomie + ", '" + Codecs.escapeHTML(nomFR) + "', '" + Codecs.escapeHTML(descFR) + "', '" + Codecs.escapeHTML(nomEN) + "', '" + Codecs.escapeHTML(descEN) + "', '" + Codecs.escapeHTML(lemmasNomFR.toLemmas()) + "', '" + Codecs.escapeHTML(lemmasDescFR.toLemmas()) + "', '" + Codecs.escapeHTML(lemmasNomEN.toLemmas()) + "', '" + Codecs.escapeHTML(lemmasDescEN.toLemmas()) + "');";
            String queryRelation = "INSERT INTO tax_hierarchie(surClasse, sousClasse) VALUES(" + parent + ", " + id + ");";
            this.theDB.executeInsertOrUpdate(queryConcept);
            this.theDB.executeInsertOrUpdate(queryRelation);
            this.storeLemmesFR(id, lemmasNomFR, lemmasDescFR);
            this.storeLemmesEN(id, lemmasNomEN, lemmasDescEN);
        }
    }

    private void storeLemmesFR(int itemId, LemmaVector title, LemmaVector desc) throws NoBaseException {
        String lex;
        String lemma;
        int i;
        LinkedHashMap<LemmaInfos, Integer> lemmasCountTitle = title.toLemmasCount();
        LinkedHashMap<LemmaInfos, Integer> lemmasCountDesc = desc.toLemmasCount();
        Vector<LemmaInfos> liste = title.getLemmas();
        for (i = 0; i < liste.size(); ++i) {
            lemma = liste.elementAt(i).get_lemma();
            lex = liste.elementAt(i).get_lex();
            if (lemmasCountDesc.containsKey(liste.elementAt(i))) {
                try {
                    this.insertLemmaFR(itemId, lemma, (Integer)lemmasCountTitle.get(liste.elementAt(i)), (Integer)lemmasCountDesc.get(liste.elementAt(i)), lex);
                }
                catch (Exception ex) {
                    System.out.println(String.format("Lemme title+desc insert problem :" + ex.getMessage(), new Object[0]));
                }
                continue;
            }
            try {
                this.insertLemmaFR(itemId, lemma, (Integer)lemmasCountTitle.get(liste.elementAt(i)), 0, lex);
                continue;
            }
            catch (Exception ex) {
                System.out.println(String.format("Lemme title insert problem :" + ex.getMessage(), new Object[0]));
            }
        }
        liste = desc.getLemmas();
        for (i = 0; i < liste.size(); ++i) {
            lemma = liste.elementAt(i).get_lemma();
            lex = liste.elementAt(i).get_lex();
            if (lemmasCountTitle.containsKey(liste.elementAt(i))) continue;
            try {
                this.insertLemmaFR(itemId, lemma, 0, (Integer)lemmasCountDesc.get(liste.elementAt(i)), lex);
                continue;
            }
            catch (Exception ex) {
                System.out.println(String.format("Lemme desc insert problem :" + ex.getMessage(), new Object[0]));
            }
        }
    }

    private void storeLemmesEN(int itemId, LemmaVector title, LemmaVector desc) throws NoBaseException {
        String lex;
        String lemma;
        int i;
        LinkedHashMap<LemmaInfos, Integer> lemmasCountTitle = title.toLemmasCount();
        LinkedHashMap<LemmaInfos, Integer> lemmasCountDesc = desc.toLemmasCount();
        Vector<LemmaInfos> liste = title.getLemmas();
        for (i = 0; i < liste.size(); ++i) {
            lemma = liste.elementAt(i).get_lemma();
            lex = liste.elementAt(i).get_lex();
            if (lemmasCountDesc.containsKey(liste.elementAt(i))) {
                try {
                    this.insertLemmaEN(itemId, lemma, (Integer)lemmasCountTitle.get(liste.elementAt(i)), (Integer)lemmasCountDesc.get(liste.elementAt(i)), lex);
                }
                catch (Exception ex) {
                    System.out.println(String.format("Lemme title+desc insert problem :" + ex.getMessage(), new Object[0]));
                }
                continue;
            }
            try {
                this.insertLemmaEN(itemId, lemma, (Integer)lemmasCountTitle.get(liste.elementAt(i)), 0, lex);
                continue;
            }
            catch (Exception ex) {
                System.out.println(String.format("Lemme title insert problem :" + ex.getMessage(), new Object[0]));
            }
        }
        liste = desc.getLemmas();
        for (i = 0; i < liste.size(); ++i) {
            lemma = liste.elementAt(i).get_lemma();
            lex = liste.elementAt(i).get_lex();
            if (lemmasCountTitle.containsKey(liste.elementAt(i))) continue;
            try {
                this.insertLemmaEN(itemId, lemma, 0, (Integer)lemmasCountDesc.get(liste.elementAt(i)), lex);
                continue;
            }
            catch (Exception ex) {
                System.out.println(String.format("Lemme desc insert problem :" + ex.getMessage(), new Object[0]));
            }
        }
    }

    private void insertLemmaFR(int id, String lemma, int a, int b, String lex) throws NoBaseException {
        if (!this.unwantedLemma(lemma)) {
            String queryLemma = "INSERT INTO tax_lemmesfr(classe, lemme, occuTitre, occuDesc, nature) VALUES(" + id + ", '" + Codecs.escapeHTML(lemma) + "', " + a + ", " + b + ", '" + lex + "');";
            this.theDB.executeInsertOrUpdate(queryLemma);
        }
    }

    private void insertLemmaEN(int id, String lemma, int a, int b, String lex) throws NoBaseException {
        if (!this.unwantedLemma(lemma)) {
            String queryLemma = "INSERT INTO tax_lemmesen(classe, lemme, occuTitre, occuDesc, nature) VALUES(" + id + ", '" + Codecs.escapeHTML(lemma) + "', " + a + ", " + b + ", '" + lex + "');";
            this.theDB.executeInsertOrUpdate(queryLemma);
        }
    }

    private boolean unwantedLemma(String lemma) {
        return false;
    }
}

