/*
 * Decompiled with CFR 0.152.
 */
package data.base.connectors;

import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.CacheDatabase;
import data.base.connectors.OntologieDatabase;
import data.structures.tagging.LemmaItem;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import proc.text.Codecs;
import proc.text.Horloge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalSemanticDatabase {
    private Database myDB;
    private static Map<String, Set<LemmaItem>> goDejaTrouvees = new HashMap<String, Set<LemmaItem>>();
    private static Map<String, Set<LemmaItem>> gwDejaTrouvees = new HashMap<String, Set<LemmaItem>>();
    private static Map<String, Set<LemmaItem>> csDejaTrouves = new HashMap<String, Set<LemmaItem>>();
    private static Map<String, String> bcDejaCalcules = new HashMap<String, String>();

    public LocalSemanticDatabase(Database db) {
        this.myDB = db;
    }

    public Set<LemmaItem> getGeneralisationOnto(LemmaItem lemme) throws NoBaseException {
        System.out.println(Horloge.getHMS() + "     G\u00e9n\u00e9ralisation");
        Set<LemmaItem> res = goDejaTrouvees.get(lemme.getLemmaName());
        if (res == null) {
            res = new HashSet<LemmaItem>();
            System.out.println(Horloge.getHMS() + "     Recherche des concepts");
            String s = this.getBestConcept(lemme);
            res.addAll(this.getLemmesDeLaCategorieOnto(this.getCategorieOnto(s)));
            goDejaTrouvees.put(lemme.getLemmaName(), res);
            System.out.println(Horloge.getHMS() + "     G\u00e9n\u00e9ralisation : " + lemme.getLemmaName() + " - " + goDejaTrouvees.get(lemme.getLemmaName()));
        } else {
            System.out.println(Horloge.getHMS() + "     R\u00e9cup\u00e9ration des r\u00e9sultats pr\u00e9c\u00e9dents");
        }
        return res;
    }

    public Set<LemmaItem> getGeneralisationWiki(LemmaItem lemme) throws NoBaseException {
        System.out.println(Horloge.getHMS() + "     Cat\u00e9gorisation");
        Set<LemmaItem> res = gwDejaTrouvees.get(lemme.getLemmaName());
        if (res == null) {
            res = new HashSet<LemmaItem>();
            System.out.println(Horloge.getHMS() + "     Recherche des concepts");
            String s = this.getBestConcept(lemme);
            String[] s2 = this.getCategoriesWiki(s);
            for (int j = 0; j < s2.length; ++j) {
                res.addAll(this.getLemmesDeLaCategorieWiki(s2[j]));
            }
            gwDejaTrouvees.put(lemme.getLemmaName(), res);
            System.out.println(Horloge.getHMS() + "     G\u00e9n\u00e9ralisation : " + lemme.getLemmaName() + " - " + gwDejaTrouvees.get(lemme.getLemmaName()));
        } else {
            System.out.println(Horloge.getHMS() + "     R\u00e9cup\u00e9ration des r\u00e9sultats pr\u00e9c\u00e9dents");
        }
        return res;
    }

    public Set<LemmaItem> getChampSemantique(LemmaItem lemme) throws NoBaseException {
        System.out.println(Horloge.getHMS() + "      Champ s\u00e9mantique");
        Set<LemmaItem> res = csDejaTrouves.get(lemme.getLemmaName());
        if (res == null) {
            res = new HashSet<LemmaItem>();
            String s = this.getBestConcept(lemme);
            String query = "SELECT l.lemme, l.countTitle, l.countDesc, l.Lex FROM ipri_onto_concepts c, ipri_onto_con_lemmes l WHERE c.ConceptID=l.idConcept AND c.ResourceID=2 AND c.ConceptName='" + Codecs.escapeHTML(s) + "';";
            ResultSet rs = this.myDB.executeSelection(query);
            Vector<LemmaItem> res1 = new Vector<LemmaItem>();
            try {
                while (rs.next()) {
                    LemmaItem l = new LemmaItem();
                    l.setLemmaName(rs.getString(1).trim());
                    l.setCountTitle(rs.getInt(2));
                    l.setCountDesc(rs.getInt(3));
                    l.setLemmaLex(rs.getString(4).trim());
                    res1.add(l);
                }
            }
            catch (SQLException e) {
                System.err.println("Erreur de r\u00e9cup\u00e9ration des concepts contenant le lemme " + lemme + ".");
            }
            LemmaItem[] res2 = new LemmaItem[res1.size()];
            res1.toArray(res2);
            for (int j = 0; j < res2.length; ++j) {
                res.add(res2[j]);
            }
            System.out.println(Horloge.getHMS() + "      Champ s\u00e9mantique trouv\u00e9 : " + res.size() + " nouveaux lemmes " + res + ".");
            csDejaTrouves.put(lemme.getLemmaName(), res);
        } else {
            System.out.println(Horloge.getHMS() + "      R\u00e9cup\u00e9ration des r\u00e9sultats pr\u00e9c\u00e9dents");
        }
        return res;
    }

    private String[] getConcepts(LemmaItem lemme) throws NoBaseException {
        String query = String.format("SELECT c.ConceptName FROM ipri_onto_concepts c, ipri_onto_con_lemmes l WHERE c.ConceptID=l.idConcept AND c.ResourceID=2 AND l.lemme='" + Codecs.escapeHTML(lemme.getLemmaName()) + "' AND " + "l.countTitle>0;", new Object[0]);
        System.out.println(Horloge.getHMS() + "      Interrogation de la base");
        ResultSet rs = this.myDB.executeSelection(query);
        Vector<String> res = new Vector<String>();
        try {
            while (rs.next()) {
                res.add(rs.getString(1).trim());
            }
        }
        catch (SQLException e) {
            System.err.println("Erreur de r\u00e9cup\u00e9ration des concepts contenant le lemme " + lemme + ".");
        }
        String[] res2 = new String[res.size()];
        res.toArray(res2);
        System.out.println(Horloge.getHMS() + "      Interrogation de la base termin\u00e9e : " + res2.length + " concepts trouv\u00e9s.");
        return res2;
    }

    private String getBestConcept(LemmaItem lemme) throws NoBaseException {
        String res = bcDejaCalcules.get(lemme.getLemmaName());
        if (res == null) {
            String[] s = this.getConcepts(lemme);
            if (s.length == 0) {
                return "";
            }
            int dist = Integer.MAX_VALUE;
            int index = 0;
            for (int i = 0; i < s.length; ++i) {
                int d = this.distanceEdition(lemme.getLemmaName(), s[i]);
                if (d >= dist) continue;
                dist = d;
                index = i;
            }
            System.out.println(Horloge.getHMS() + "      Choix : " + s[index] + ".");
            res = s[index];
            bcDejaCalcules.put(lemme.getLemmaName(), res);
        }
        return res;
    }

    private int minimum(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public int distanceEdition(CharSequence str1, CharSequence str2) {
        int i;
        int[][] distance = new int[str1.length() + 1][str2.length() + 1];
        for (i = 0; i <= str1.length(); ++i) {
            distance[i][0] = i;
        }
        for (int j = 0; j <= str2.length(); ++j) {
            distance[0][j] = j;
        }
        for (i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                distance[i][j] = this.minimum(distance[i - 1][j] + 1, distance[i][j - 1] + 1, distance[i - 1][j - 1] + (str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1));
            }
        }
        return distance[str1.length()][str2.length()];
    }

    private Set<LemmaItem> getLemmesDuConcept(String concept) throws NoBaseException {
        String query = String.format("SELECT l.lemme, l.countTitle, l.countDesc, l.Lex FROM ipri_onto_concepts c, ipri_onto_con_lemmes l WHERE c.ConceptID=l.idConcept AND c.ResourceID=2 AND c.conceptName='" + Codecs.escapeHTML(concept) + "';", new Object[0]);
        ResultSet rs = this.myDB.executeSelection(query);
        HashSet<LemmaItem> res = new HashSet<LemmaItem>();
        try {
            while (rs.next()) {
                LemmaItem l = new LemmaItem();
                l.setLemmaName(rs.getString(1).trim());
                l.setCountTitle(rs.getInt(2));
                l.setCountDesc(rs.getInt(3));
                l.setLemmaLex(rs.getString(4).trim());
                res.add(l);
            }
        }
        catch (SQLException e) {
            System.err.println("Erreur de r\u00e9cup\u00e9ration des lemmes du concept " + concept + ".");
        }
        return res;
    }

    private String getCategorieOnto(int concept) throws NoBaseException {
        String query = "SELECT o.ressource FROM ipri_ontologie o, ipri_onto_con_cate_onto c WHERE c.idConcept=" + concept + " AND o.id=c.idCateOnto;";
        ResultSet rs = this.myDB.executeSelection(query);
        String res = "";
        try {
            if (rs.next()) {
                res = rs.getString(1).trim();
            }
        }
        catch (SQLException e) {
            System.err.println("Erreur de r\u00e9cup\u00e9ration de la cat\u00e9gorie ontologique du concept " + concept + ".");
        }
        return res;
    }

    private String getCategorieOnto(String concept) throws NoBaseException {
        String query = "SELECT c.CategorieName FROM ipri_onto_categories c WHERE c.ConceptName='" + Codecs.escapeHTML(concept) + "';";
        ResultSet rs = this.myDB.executeSelection(query);
        String res = "";
        try {
            if (rs.next()) {
                res = rs.getString(1).trim();
            }
        }
        catch (SQLException e) {
            System.err.println("Erreur de r\u00e9cup\u00e9ration de la cat\u00e9gorie ontologique du concept " + concept + ".");
        }
        return res;
    }

    private Set<LemmaItem> getLemmesDeLaCategorieOnto(String categorieOnto) throws NoBaseException {
        String query = String.format("SELECT l.lemme, l.countTitle, l.countDesc, l.Lex FROM ipri_onto_lemmes_en l, ipri_ontologie o WHERE o.id=l.idConcept AND o.ressource='" + categorieOnto + "';", new Object[0]);
        ResultSet rs = this.myDB.executeSelection(query);
        HashSet<LemmaItem> res = new HashSet<LemmaItem>();
        try {
            while (rs.next()) {
                LemmaItem l = new LemmaItem();
                l.setLemmaName(rs.getString(1).trim());
                l.setCountTitle(rs.getInt(2));
                l.setCountDesc(rs.getInt(3));
                l.setLemmaLex(rs.getString(4).trim());
                res.add(l);
            }
        }
        catch (SQLException e) {
            System.err.println("Erreur de r\u00e9cup\u00e9ration des lemmes de la cat\u00e9gorie " + categorieOnto + ".");
        }
        return res;
    }

    private String[] getCategoriesWiki(String concept) throws NoBaseException {
        String query = "SELECT c.CategorieName FROM ipri_onto_categories2 c WHERE c.ConceptName='" + Codecs.escapeHTML(concept) + "';";
        ResultSet rs = this.myDB.executeSelection(query);
        Vector<String> res = new Vector<String>();
        try {
            while (rs.next()) {
                res.add(rs.getString(1).trim());
            }
        }
        catch (SQLException e) {
            System.err.println("Erreur de r\u00e9cup\u00e9ration des cat\u00e9gories wiki du concept " + concept + ".");
        }
        String[] res2 = new String[res.size()];
        res.toArray(res2);
        return res2;
    }

    private Set<LemmaItem> getLemmesDeLaCategorieWiki(String categorieWiki) throws NoBaseException {
        String query = "SELECT l.lemme, l.countTitle, l.countDesc, l.Lex FROM ipri_onto_cate_labels c, ipri_onto_cate_lemmes_en l WHERE c.idCategorie=l.idCategorie AND c.idRessource=2 AND c.CategorieName='" + Codecs.escapeHTML(categorieWiki) + "';";
        ResultSet rs = this.myDB.executeSelection(query);
        HashSet<LemmaItem> res = new HashSet<LemmaItem>();
        try {
            while (rs.next()) {
                LemmaItem l = new LemmaItem();
                l.setLemmaName(rs.getString(1).trim());
                l.setCountTitle(rs.getInt(2));
                l.setCountDesc(rs.getInt(3));
                l.setLemmaLex(rs.getString(4).trim());
                res.add(l);
            }
        }
        catch (SQLException e) {
            System.err.println("Erreur de r\u00e9cup\u00e9ration des lemmes de la cat\u00e9gorie " + categorieWiki + ".");
        }
        return res;
    }

    public String[] getGeneralisation(String concept) throws NoBaseException {
        CacheDatabase cdb = new CacheDatabase(this.myDB);
        String[] s = cdb.getCategoriesOnto(concept);
        return s;
    }

    public String[] getSubGeneralisation(String concept) throws NoBaseException {
        CacheDatabase cdb = new CacheDatabase(this.myDB);
        String[] s = cdb.getCategoriesOnto(concept);
        return s;
    }

    public String[] getGeneralisationStricte(String concept, int niveaux) throws NoBaseException {
        int i;
        String[] premierResultat = this.getGeneralisation(concept);
        HashSet<String> aVerifier = new HashSet<String>();
        for (int i2 = 0; i2 < premierResultat.length; ++i2) {
            aVerifier.add(premierResultat[i2]);
        }
        if (aVerifier.size() >= 100) {
            aVerifier.clear();
        } else {
            Vector liste = new Vector(aVerifier);
            for (i = 0; i < liste.size(); ++i) {
                String[] gene;
                String s = (String)liste.elementAt(i);
                if (!aVerifier.contains(s) || (gene = this.getSubGeneralisation(s)).length <= 0) continue;
                boolean removed = false;
                for (int j = 0; j < gene.length; ++j) {
                    if (!aVerifier.contains(gene[j])) continue;
                    if (!removed) {
                        removed = true;
                    }
                    aVerifier.remove(gene[j]);
                }
            }
        }
        String[] resultat = new String[aVerifier.size()];
        aVerifier.toArray(resultat);
        for (i = 0; i < resultat.length; ++i) {
            resultat[i] = this.f(resultat[i]);
        }
        return resultat;
    }

    private String f(String url) {
        String[] s = url.split("\\/");
        return s[s.length - 1];
    }

    public String[] getHigherLevels() throws NoBaseException {
        ArrayList ontologiesIDs = new ArrayList();
        Vector<String> ontologies = new Vector<String>();
        OntologieDatabase odb = new OntologieDatabase(this.myDB);
        ontologiesIDs = odb.getHigherNodes();
        for (int i = 0; i < ontologiesIDs.size(); ++i) {
            int id = Integer.parseInt(ontologiesIDs.get(i).toString());
            ontologies.add(odb.getRessource(id));
        }
        String[] result = new String[ontologies.size()];
        ontologies.toArray(result);
        return result;
    }
}

