/*
 * Decompiled with CFR 0.152.
 */
package data.base.connectors;

import data.base.Database;
import data.base.NoBaseException;
import data.structures.corpus.CorpusItem;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import proc.text.Codecs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorpusDatabase {
    private Database theDB;

    public CorpusDatabase(Database db) {
        this.theDB = db;
    }

    public Vector<CorpusItem> loadCorpus() throws NoBaseException {
        Vector<CorpusItem> result = new Vector<CorpusItem>();
        try {
            ResultSet items = this.theDB.executeSelection("SELECT idRSSItem, name, description, idThema FROM ipri_corpus_etude;");
            while (items.next()) {
                int idRSSItem = items.getInt(1);
                String titleRSSItem = Codecs.desEscapeHTML(items.getString(2));
                String descRSSItem = Codecs.desEscapeHTML(items.getString(3));
                int conceptId = items.getInt(4);
                CorpusItem ci = new CorpusItem(idRSSItem, titleRSSItem, descRSSItem, conceptId);
                result.add(ci);
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        return result;
    }

    public void saveCorpus(Vector<CorpusItem> items) throws NoBaseException {
        this.theDB.executeInsertOrUpdate("DELETE FROM ipri_corpus_etude");
        for (int i = 0; i < items.size(); ++i) {
            String query = "INSERT INTO ipri_corpus_etude VALUES (NULL, " + items.elementAt(i).getIdItem() + ", '" + Codecs.escapeHTML(items.elementAt(i).getRSSItemTitle()) + "', '" + Codecs.escapeHTML(items.elementAt(i).getRSSItemDesc()) + "', " + items.elementAt(i).getThemaId() + ")  ";
            this.theDB.executeInsertOrUpdate(query);
        }
    }

    public Vector<CorpusItem> createClusteringCorpus(int taille) throws NoBaseException {
        Vector<CorpusItem> result = new Vector<CorpusItem>();
        try {
            ResultSet items = this.theDB.executeSelection("SELECT id, titre, description, datePubli FROM rss_articles ORDER BY datePubli DESC LIMIT " + taille + ";");
            while (items.next()) {
                int id = items.getInt(1);
                String titre = Codecs.desEscapeHTML(items.getString(2));
                String desc = Codecs.desEscapeHTML(items.getString(3));
                CorpusItem ci = new CorpusItem(id, titre, desc, 0);
                result.add(ci);
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        return result;
    }
}

