/*
 * Decompiled with CFR 0.152.
 */
package data.base;

import data.base.Config;
import data.base.NoBaseException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Database {
    public static int DB_ERR = 0;
    public static int DB_OK = 0;
    private String databaseConnectionString = "jdbc:mysql://" + Config.getBaseURL() + "/" + Config.getBaseName();
    private String dbUser = Config.getBaseLogin();
    private String dbPass = Config.getBasePassword();
    private Connection dB = null;
    private boolean connected = false;
    private Statement[] stmts = new Statement[10000];
    private int compteur;

    public int connect() {
        if (!this.connected) {
            try {
                Class.forName("com.mysql.jdbc.Driver");
                this.dB = DriverManager.getConnection(this.databaseConnectionString, this.dbUser, this.dbPass);
                for (int i = 0; i < this.stmts.length; ++i) {
                    this.stmts[i] = this.dB.createStatement();
                }
                this.connected = true;
            }
            catch (ClassNotFoundException e) {
                System.err.println("Unable to load MYSQL bridge, " + e);
                return DB_ERR;
            }
            catch (SQLException e) {
                System.err.println("Cannot connect to the database. " + e);
                System.err.println(this.databaseConnectionString);
                return DB_ERR;
            }
        }
        if (this.connected) {
            return DB_OK;
        }
        return DB_ERR;
    }

    public ResultSet executeSelection(String sql) throws NoBaseException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.connected) {
            throw new NoBaseException();
        }
        int id = (int)(Thread.currentThread().getId() % (long)this.stmts.length);
        ResultSet theResults = null;
        try {
            theResults = this.stmts[id].executeQuery(sql);
            theResults.beforeFirst();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.incrementeCompteur();
        return theResults;
    }

    public int executeInsertOrUpdate(String sql) throws NoBaseException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.connected) {
            throw new NoBaseException();
        }
        int id = (int)(Thread.currentThread().getId() % (long)this.stmts.length);
        int res = 0;
        try {
            Statement stmt = this.stmts[id];
            stmt.executeUpdate(sql, 1);
            res = stmt.getGeneratedKeys().getRow();
            ResultSet clefs = stmt.getGeneratedKeys();
            if (clefs.next()) {
                res = Integer.parseInt(clefs.getObject(1).toString());
            }
            clefs.close();
            stmt.close();
            this.stmts[id] = this.dB.createStatement();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.incrementeCompteur();
        return res;
    }

    public void executeDeletion(String sql) throws NoBaseException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.connected) {
            throw new NoBaseException();
        }
        int id = (int)(Thread.currentThread().getId() % (long)this.stmts.length);
        try {
            Statement stmt = this.stmts[id];
            stmt.executeUpdate(sql);
            stmt.close();
            this.stmts[id] = this.dB.createStatement();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.incrementeCompteur();
    }

    public int disconnect() {
        try {
            for (int i = 0; i < this.stmts.length; ++i) {
                this.stmts[i].close();
            }
            this.dB.close();
            this.connected = false;
            System.out.println("Disconnected");
            return DB_OK;
        }
        catch (Exception e) {
            System.err.println("Error Disconnecting");
            return DB_ERR;
        }
    }

    private void incrementeCompteur() {
        ++this.compteur;
        if (this.compteur % 1000 == 0) {
            System.out.println(this.compteur + " requ\u00eates effectu\u00e9es sur la base.");
        }
    }
}

