/*
 * Decompiled with CFR 0.152.
 */
package data.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.GregorianCalendar;

public class Config {
    private static String treeTagger = "C:\\TreeTagger\\";
    private static String baseName = "baseipri20110221b_em";
    private static String baseURL = "127.0.0.1";
    private static String login = "root";
    private static String pass = "";
    private static File ieCapt = new File("IECapt.exe");
    private static String captures = "cap";
    private static String classification = "svm";
    private static long dateDebut = 0L;

    public static String getBaseName() {
        return baseName;
    }

    public static String getBaseURL() {
        return baseURL;
    }

    public static String getBaseLogin() {
        return login;
    }

    public static String getBasePassword() {
        return pass;
    }

    public static String getTreeTaggerDirectory() {
        return treeTagger;
    }

    public static File getCaptureProgram() {
        return ieCapt;
    }

    public static String getCaptureDirectory() {
        return captures;
    }

    public static String getClassificationDirectory() {
        return classification;
    }

    public static long getDateDepartCorpus() {
        return dateDebut;
    }

    static {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, 2009);
        cal.set(2, 9);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        dateDebut = cal.getTimeInMillis();
        File f = new File("Parametres.ini");
        if (!f.exists()) {
            try {
                f.createNewFile();
                FileWriter w = new FileWriter(f);
                w.write("# Repertoire d'installation de TreeTagger\r\n");
                w.write("ttdir=C:\\TreeTagger\\\r\n");
                w.write("# URL de la base de donnees\r\n");
                w.write("baseURL=127.0.0.1\r\n");
                w.write("# Nom de la base de donnees\r\n");
                w.write("basename=baseipri\r\n");
                w.write("# Identifiant IPRI pour la base de donnees\r\n");
                w.write("login=root\r\n");
                w.write("# Mot de passe IPRI pour la base de donnees\r\n");
                w.write("pass=\r\n");
                w.write("# Emplacement de l'utilitaire IECapt.exe (pour les captures d'ecran)\r\n");
                w.write("IECapt=IECapt.exe\r\n");
                w.write("# R\u00e9pertoire ou stocker les captures d'ecran\r\n");
                w.write("capdir=cap\r\n");
                w.write("# R\u00e9pertoire de svm multiclass\r\n");
                w.write("svmdir=svm\r\n");
                w.write("# Date minimale a prendre en compte lors de la collecte (JOUR-MOIS-ANNEE HEURE:MINUTE:SECONDE)\r\n");
                w.write("dateDebut=01-01-2010 00:00:00\r\n");
                w.flush();
                w.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        try {
            BufferedReader r = new BufferedReader(new FileReader(f));
            while (r.ready()) {
                String s = r.readLine();
                String[] ss = s.split("=");
                if (ss[0].trim().equals("ttdir")) {
                    treeTagger = ss[1].trim();
                }
                if (ss[0].trim().equals("basename")) {
                    baseName = ss[1].trim();
                }
                if (ss[0].trim().equals("baseURL")) {
                    baseURL = ss[1].trim();
                }
                if (ss[0].trim().equals("login")) {
                    login = ss[1].trim();
                }
                if (ss[0].trim().equals("pass")) {
                    pass = ss[1].trim();
                }
                if (ss[0].trim().equals("IECapt")) {
                    ieCapt = new File(ss[1].trim());
                }
                if (ss[0].trim().equals("capdir")) {
                    captures = ss[1].trim();
                }
                if (ss[0].trim().equals("svmdir")) {
                    classification = ss[1].trim();
                }
                if (!ss[0].trim().equals("dateDebut")) continue;
                String[] date0 = ss[1].trim().split(" ");
                String[] date1 = date0[0].trim().split("-");
                String[] date2 = date0[1].trim().split(":");
                cal = new GregorianCalendar();
                cal.set(11, Integer.parseInt(date2[0].trim()));
                cal.set(12, Integer.parseInt(date2[1].trim()));
                cal.set(13, Integer.parseInt(date2[2].trim()));
                cal.set(5, Integer.parseInt(date1[0].trim()));
                cal.set(2, Integer.parseInt(date1[1].trim()) - 1);
                cal.set(1, Integer.parseInt(date1[2].trim()));
                dateDebut = cal.getTimeInMillis();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

