/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.proc.parsers;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author Sam
 */
public class CorrespondanceJERLXX {
    private final static CorrespondanceJERLXX instance = new CorrespondanceJERLXX();
    
    private Map<String, String> liste;
    
    private CorrespondanceJERLXX() {
        liste = new HashMap<>();
    }
    
    public void setCorrespondance(String codeJER, String codeLXX) {
        liste.put(codeJER, codeLXX);
    }
    
    public String getCorrespondance(String codeJER) {
        return liste.get(codeJER);
    }
    
    @Override
    public String toString() {
        String res = "";
        for(String cadp : liste.keySet()) {
            res += cadp + " -> " + liste.get(cadp) + "\n";
        }
        return res;
    }
    
    public static CorrespondanceJERLXX getInstance() {
        return instance;
    }
}
