/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.modele.listes;

import fr.cnrs.liris.drim.grt.ihm.GestionnaireErreurs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import fr.cnrs.liris.drim.grt.modele.Terme;
import fr.cnrs.liris.drim.grt.proc.parsers.Textes;

/**
 *
 * @author Sam
 */
public class LemmesRecurrents {
    private final static Set<Terme> liste = new HashSet<>();
    
    public static Terme[] getListe() {
        Terme[] liste0 = new Terme[getEnsemble().size()];
        getEnsemble().toArray(liste0);
        return liste0;
    }
    
    public static Set<Terme> getEnsemble() {
        if(liste.isEmpty()) {
            // chargement du fichier
            File fichier = new File("lemmesRecurrents.txt");
            if(fichier.exists()) {
                try {
                    BufferedReader lecteur = new BufferedReader(new InputStreamReader(new FileInputStream(fichier), "UTF-8"));
                    while(lecteur.ready()) {
                        String ligne = lecteur.readLine().trim();
                        if(!ligne.startsWith("#") && !ligne.isEmpty()) {
                            liste.add(Terme.cree(Textes.nettoieEncodageLettres(ligne)));
                        }
                    }
                } catch(IOException ex) {
                    GestionnaireErreurs.getInstance().affiche("Erreur d'application", 
                            "<html><p>Le fichier lemmesRecurrents.txt est présent mais illisible.</p>"
                            + "<p>Veuillez vérifier son contenu (il doit contenir une liste de lemmes récurrents, un par ligne).</p>"
                            + "<p>Pour information, l'erreur est</p>"
                            + "<p>"+ex.getClass()+" : "+ex.getMessage()+"</p></html>");
                }
            } else {
                // pas de fichier ? Pas grave, on en crée un vide
                try {
                    fichier.createNewFile();
                } catch (IOException ex) {
                    GestionnaireErreurs.getInstance().affiche("Erreur d'application", 
                            "<html><p>Nous n'avons pas trouvé le fichier lemmesRecurrents.txt qui contient la liste des lemmes récurrents.</p>"
                            + "<p>Nous avons essayé de le créer, sans succès.</p>"
                            + "<p>Nous vous recommandons de nous permettre d'écrire un tel fichier avant de continuer.</p>"
                            + "<p>Pour information, l'erreur est</p>"
                            + "<p>"+ex.getClass()+" : "+ex.getMessage()+"</p></html>");
                }
            }
        }
        return liste;
    }
    
    public static boolean contientTerme(Terme t) {
        return getEnsemble().contains(t.getLemmePrincipal());
    }
    
    public static boolean contientLemme(Terme t) {
        return getEnsemble().contains(t);
    }
    
    public static boolean contientUnDe(Terme[] liste) {
        boolean resultat = false;
        for(Terme t: liste) {
            if(contientTerme(t)) {
                resultat = true;
                break;
            }
        }
        return resultat;
    }
    
    public static boolean constitueLaTotaliteDe(Terme[] liste) {
        boolean resultat = true;
        for(Terme t: liste) {
            if(!contientTerme(t)) {
                resultat = false;
                break;
            }
        }
        return resultat;
    }
}
