/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.modele.listes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import fr.cnrs.liris.drim.grt.modele.Passage;
import fr.cnrs.liris.drim.grt.modele.Terme;
import fr.cnrs.liris.drim.grt.proc.Texte;

/**
 *
 * @author sgesche
 */
public class LemmesEntropiques {
    
    
    public static boolean contientTerme(Terme t) {
        return LemmesVides.contientTerme(t) || LemmesUsuels.contientTerme(t) || LemmesRecurrents.contientTerme(t);
    }
    
    public static boolean contientLemme(Terme t) {
        return LemmesVides.contientLemme(t) || LemmesUsuels.contientLemme(t) || LemmesRecurrents.contientLemme(t);
    }
    
    public static boolean contientUnDe(Terme[] liste) {
        return LemmesVides.contientUnDe(liste) || LemmesUsuels.contientUnDe(liste) || LemmesRecurrents.contientUnDe(liste);
    }
    
    public static boolean constitueLaTotaliteDe(Terme[] liste) {
        Set<Terme> aTester = new HashSet<>();
        ArrayList<Terme> aTester0 = new ArrayList<>(Arrays.asList(liste));
        for(Terme t: aTester0) {
            aTester.add(t.getLemmePrincipal());
        }
        aTester.removeAll(LemmesVides.getEnsemble());
        aTester.removeAll(LemmesUsuels.getEnsemble());
        aTester.removeAll(LemmesRecurrents.getEnsemble());
        return aTester.isEmpty();
    }
    
    public static boolean constitueLaTotaliteDe(Passage p) {
        return constitueLaTotaliteDe(new Texte(p).getContenu());
    }
}
