/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.modele.convertisseurs;

import org.apache.commons.lang.StringUtils;

/**
 *
 * @author sgesche
 */
public class ConvertisseurUnicodeVersMinuscules {
    public static String conversion(String s) {
        
        String s0 = s;
        
        s0 = StringUtils.replace(s0, ""+(char)7946, ""+(char)7938); //Ἂ
        s0 = StringUtils.replace(s0, ""+(char)7948, ""+(char)7940); //Ἄ
        s0 = StringUtils.replace(s0, ""+(char)7950, ""+(char)7942); //Ἆ
        s0 = StringUtils.replace(s0, ""+(char)7944, ""+(char)7936); //Ἀ
        s0 = StringUtils.replace(s0, ""+(char)7947, ""+(char)7939); //Ἃ
        s0 = StringUtils.replace(s0, ""+(char)7949, ""+(char)7941); //Ἅ
        s0 = StringUtils.replace(s0, ""+(char)7951, ""+(char)7943); //Ἇ
        s0 = StringUtils.replace(s0, ""+(char)7945, ""+(char)7937); //Ἁ
        s0 = StringUtils.replace(s0, ""+(char)913, ""+(char)945); //Α
        s0 = StringUtils.replace(s0, ""+(char)7962, ""+(char)7954); //Ἒ
        s0 = StringUtils.replace(s0, ""+(char)7963, ""+(char)7955); //Ἓ
        s0 = StringUtils.replace(s0, ""+(char)7964, ""+(char)7956); //Ἔ
        s0 = StringUtils.replace(s0, ""+(char)7965, ""+(char)7957); //Ἕ
        s0 = StringUtils.replace(s0, ""+(char)7960, ""+(char)7952); //Ἐ
        s0 = StringUtils.replace(s0, ""+(char)7961, ""+(char)7953); //Ἑ
        s0 = StringUtils.replace(s0, ""+(char)917, ""+(char)949); //Ε
        s0 = StringUtils.replace(s0, ""+(char)7978, ""+(char)7970); //Ἢ
        s0 = StringUtils.replace(s0, ""+(char)7979, ""+(char)7971); //Ἣ
        s0 = StringUtils.replace(s0, ""+(char)7980, ""+(char)7972); //Ἤ
        s0 = StringUtils.replace(s0, ""+(char)7981, ""+(char)7973); //Ἥ
        s0 = StringUtils.replace(s0, ""+(char)7982, ""+(char)7974); //Ἦ
        s0 = StringUtils.replace(s0, ""+(char)7983, ""+(char)7975); //Ἧ
        s0 = StringUtils.replace(s0, ""+(char)7976, ""+(char)7968); //Ἠ
        s0 = StringUtils.replace(s0, ""+(char)7977, ""+(char)7969); //Ἡ
        s0 = StringUtils.replace(s0, ""+(char)919, ""+(char)951); //Η
        s0 = StringUtils.replace(s0, ""+(char)7994, ""+(char)7986); //Ἲ
        s0 = StringUtils.replace(s0, ""+(char)7995, ""+(char)7987); //Ἳ
        s0 = StringUtils.replace(s0, ""+(char)7996, ""+(char)7988); //Ἴ
        s0 = StringUtils.replace(s0, ""+(char)7997, ""+(char)7989); //Ἵ
        s0 = StringUtils.replace(s0, ""+(char)7998, ""+(char)7990); //Ἶ
        s0 = StringUtils.replace(s0, ""+(char)7999, ""+(char)7991); //Ἷ
        s0 = StringUtils.replace(s0, ""+(char)7992, ""+(char)7984); //Ἰ
        s0 = StringUtils.replace(s0, ""+(char)7993, ""+(char)7985); //Ἱ
        s0 = StringUtils.replace(s0, ""+(char)921, ""+(char)953); //Ι
        s0 = StringUtils.replace(s0, ""+(char)8010, ""+(char)8002); //Ὂ
        s0 = StringUtils.replace(s0, ""+(char)8011, ""+(char)8003); //Ὃ
        s0 = StringUtils.replace(s0, ""+(char)8012, ""+(char)8004); //Ὄ
        s0 = StringUtils.replace(s0, ""+(char)8013, ""+(char)8005); //Ὅ
        s0 = StringUtils.replace(s0, ""+(char)8008, ""+(char)8000); //Ὀ
        s0 = StringUtils.replace(s0, ""+(char)8009, ""+(char)8001); //Ὁ
        s0 = StringUtils.replace(s0, ""+(char)927, ""+(char)959); //Ο
        s0 = StringUtils.replace(s0, ""+(char)8027, ""+(char)8019); //Ὓ
        s0 = StringUtils.replace(s0, ""+(char)8029, ""+(char)8021); //Ὕ
        s0 = StringUtils.replace(s0, ""+(char)8031, ""+(char)8023); //Ὗ
        s0 = StringUtils.replace(s0, ""+(char)8025, ""+(char)8017); //Ὑ
        s0 = StringUtils.replace(s0, ""+(char)933, ""+(char)965); //Υ
        s0 = StringUtils.replace(s0, ""+(char)8042, ""+(char)8034); //Ὢ
        s0 = StringUtils.replace(s0, ""+(char)8043, ""+(char)8035); //Ὣ
        s0 = StringUtils.replace(s0, ""+(char)8044, ""+(char)8036); //Ὤ
        s0 = StringUtils.replace(s0, ""+(char)8045, ""+(char)8037); //Ὥ
        s0 = StringUtils.replace(s0, ""+(char)8046, ""+(char)8038); //Ὦ
        s0 = StringUtils.replace(s0, ""+(char)8047, ""+(char)8039); //Ὧ
        s0 = StringUtils.replace(s0, ""+(char)8040, ""+(char)8032); //Ὠ
        s0 = StringUtils.replace(s0, ""+(char)8041, ""+(char)8033); //Ὡ
        s0 = StringUtils.replace(s0, ""+(char)937, ""+(char)969); //Ω
        s0 = StringUtils.replace(s0, ""+(char)8172, ""+(char)8165); //Ῥ
        s0 = StringUtils.replace(s0, ""+(char)929, ""+(char)961); //Ρ
        
        s0 = StringUtils.replace(s0, ""+(char)914, ""+(char)946); //Β
        s0 = StringUtils.replace(s0, ""+(char)915, ""+(char)947); //Γ
        s0 = StringUtils.replace(s0, ""+(char)916, ""+(char)948); //Δ
        s0 = StringUtils.replace(s0, ""+(char)918, ""+(char)950); //Ζ
        s0 = StringUtils.replace(s0, ""+(char)920, ""+(char)952); //Θ
        s0 = StringUtils.replace(s0, ""+(char)922, ""+(char)954); //Κ
        s0 = StringUtils.replace(s0, ""+(char)923, ""+(char)955); //Λ
        s0 = StringUtils.replace(s0, ""+(char)924, ""+(char)956); //Μ
        s0 = StringUtils.replace(s0, ""+(char)925, ""+(char)957); //Ν
        s0 = StringUtils.replace(s0, ""+(char)926, ""+(char)958); //Ξ
        s0 = StringUtils.replace(s0, ""+(char)928, ""+(char)960); //Π
        s0 = StringUtils.replace(s0, ""+(char)931, ""+(char)963); //Σ
        s0 = StringUtils.replace(s0, ""+(char)932, ""+(char)964); //Τ
        s0 = StringUtils.replace(s0, ""+(char)934, ""+(char)966); //Φ
        s0 = StringUtils.replace(s0, ""+(char)935, ""+(char)967); //Χ
        s0 = StringUtils.replace(s0, ""+(char)936, ""+(char)968); //Ψ
        
        return s0;
    }
}
