/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.ihm;

import fr.cnrs.liris.drim.grt.proc.base.Bases;
/**
 *
 * @author Sam
 */
public class FenetreDemarrageBasique extends javax.swing.JFrame {

    /**
     * Creates new form FenetreDemarrage
     */
    public FenetreDemarrageBasique() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        bRecherche = new javax.swing.JButton();
        bLemma = new javax.swing.JButton();
        bCodec = new javax.swing.JButton();
        bEvaluation = new javax.swing.JButton();
        bDev = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Greek Reuse Toolkit");

        jPanel1.setLayout(new java.awt.GridLayout(1, 1, 10, 10));

        jLabel1.setText("<html><p>Bonjour. Vous avez décidé de travailler avec Greek Quotation Toolkit, une boîte à outils pour le traitement du grec <i>Koinè</i> développée dans le cadre du projet ANR Biblindex.</p><p>Nous utiliserons, si besoin est, les informations lexicales données par des fichiers dans le répertoire du logiciel.</p><p>Dans quel domaine souhaitez-vous travailler aujourd'hui ?</p></html>");
        jLabel1.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel1.add(jLabel1);

        getContentPane().add(jPanel1, java.awt.BorderLayout.NORTH);

        jPanel2.setLayout(new java.awt.BorderLayout());

        jPanel3.setLayout(new javax.swing.BoxLayout(jPanel3, javax.swing.BoxLayout.PAGE_AXIS));

        bRecherche.setText("<html><ul><li>Je souhaite chercher des citations d'un texte dans un autre.</li></ul></html>");
        bRecherche.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        bRecherche.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bRechercheActionPerformed(evt);
            }
        });
        jPanel3.add(bRecherche);

        bLemma.setText("<html><ul><li>Je souhaite travailler avec le lemmatiseur, ou l'améliorer.</li></ul></html>");
        bLemma.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        bLemma.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bLemmaActionPerformed(evt);
            }
        });
        jPanel3.add(bLemma);

        bCodec.setText("<html><ul><li>Je souhaite visionner un texte, ou exporter un texte dans un nouveau format.</li></ul></html>");
        bCodec.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        bCodec.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bCodecActionPerformed(evt);
            }
        });
        jPanel3.add(bCodec);

        bEvaluation.setText("<html><ul><li>Je souhaite évaluer différentes méthodes de recherche de citations.</li></ul></html>");
        bEvaluation.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        bEvaluation.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bEvaluationActionPerformed(evt);
            }
        });
        jPanel3.add(bEvaluation);

        bDev.setText("<html><ul><li>Je souhaite travailler directement sur l'interface de développement (si si, je sais ce que je fais).</li></ul></html>");
        bDev.setHorizontalAlignment(javax.swing.SwingConstants.LEADING);
        bDev.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bDevActionPerformed(evt);
            }
        });
        jPanel3.add(bDev);

        jPanel2.add(jPanel3, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel2, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void bCodecActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bCodecActionPerformed
        // TODO add your handling code here:
        if(valideIds(false, false)) {
            new FenetreCodec().setVisible(true);
            setVisible(false);
        }
    }//GEN-LAST:event_bCodecActionPerformed

    private void bLemmaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bLemmaActionPerformed
        // TODO add your handling code here:
        if(valideIds(true, false)) {
            new FenetreLemmatiseur().setVisible(true);
            setVisible(false);
        }
    }//GEN-LAST:event_bLemmaActionPerformed

    private void bRechercheActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bRechercheActionPerformed
        // TODO add your handling code here:
        if(valideIds(true, true)) {
            new FenetreRecherche().setVisible(true);
            setVisible(false);
        }
    }//GEN-LAST:event_bRechercheActionPerformed

    private void bDevActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bDevActionPerformed
        // TODO add your handling code here:
        if(valideIds(true, true)) {
            new FenetreDeveloppement().setVisible(true);
            setVisible(false);
        }
    }//GEN-LAST:event_bDevActionPerformed

    private void bEvaluationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bEvaluationActionPerformed
        // TODO add your handling code here:
        if(valideIds(true, true)) {
            new FenetreEvaluation().setVisible(true);
            setVisible(false);
        }
    }//GEN-LAST:event_bEvaluationActionPerformed

    private boolean valideIds(boolean baseLexis, boolean baseBiblindex) {
        Bases.setSansBase();
        boolean resultat = true;
        return resultat;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bCodec;
    private javax.swing.JButton bDev;
    private javax.swing.JButton bEvaluation;
    private javax.swing.JButton bLemma;
    private javax.swing.JButton bRecherche;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    // End of variables declaration//GEN-END:variables
}
