/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.proc.recherche;

/**
 *
 * @author sgesche
 */
public interface Recherche {
    /**
     * Indique que les termes seront utilisés tels quels
     */
    public final static int TERMES_BRUTS = 0;
    /**
     * Indique que les termes seront normalisés (plus de flexion)
     */
    public final static int TERMES_NORMALISES = 1;
    /**
     * Indique que les termes seront lemmatisés
     */
    public final static int TERMES_LEMMATISES = 2;
    
    /**
     * Indique que l'ordre des termes sera pris en compte dans le calcul
     * de correspondance
     */
    public final static int L_ORDRE_DES_MOTS_COMPTE = 0;
    /**
     * Indique que l'ordre des termes ne sera pas pris en compte dans le calcul
     * de correspondance
     */
    public final static int L_ORDRE_DES_MOTS_NE_COMPTE_PAS = 1;
    
    /**
     * Indique que deux suites de termes seront mises en correspondance si leur 
     * distance est nulle
     */
    public final static int CORRESPONDANCE_STRICTE = 0;
    /**
     * Indique que deux suites de termes seront mises en correspondance si leur 
     * distance est inférieure à un seul entier
     */
    public final static int CORRESPONDANCE_SEUILLEE_EN_VALEUR = 1;
    /**
     * Indique que deux suites de termes seront mises en correspondance si leur 
     * distance est inférieure en pourcentage à un seuil
     */
    public final static int CORRESPONDANCE_SEUILLEE_EN_POURCENTAGE = 2;
    
    /**
     * Indique que les mots vides seront pris en compte dans l'analyse
     * (@see modele.listes.LemmesVides)
     */
    public final static int TEXTE_AVEC_MOTS_VIDES = 0;
    /**
     * Indique que les mots vides ne seront pas pris en compte dans l'analyse
     * (@see modele.listes.LemmesVides)
     */
    public final static int TEXTE_SANS_MOTS_VIDES = 1;
    /**
     * Indique que les mots vides ne seront pas pris en compte dans l'analyse
     * (@see modele.listes.LemmesStatistiquementVides)
     */
    public final static int TEXTE_SANS_MOTS_STATISTIQUEMENT_VIDES = 2;
    
    /**
     * Indique qu'un passage donné ne peut citer qu'une seule source
     */
    public final static int CITATIONS_VERS_UNE_SEULE_SOURCE = 0;
    /**
     * Indique qu'un passage donné peut citer plusieurs sources
     */
    public final static int CITATIONS_VERS_PLUSIEURS_SOURCES = 1;
    
    /**
     * Utilise une mesure de similarité binaire (deux termes sont égaux ou différents)
     * setSimilarite() : paramètre quelconque, qui ne sera pas utilisé
     */
    public final static int SIMILARITE_EXACTE = 0;
    /**
     * Utilise une mesure de similarité à partir des spectres de co-occurrence 
     * (deux termes sont plus ou moins proches suivant leurs co-occurrences 
     * respectives avec les termes les plus fréquents)
     * setSimilarite() : paramètre indiquant le nombre de 'termes les plus 
     * fréquents' considéré
     */
    public final static int SIMILARITE_PAR_CO_OCCURRENCES = 1;
    /**
     * Utilise une mesure de similarité établie par l'algorithme LSA.
     */
    public final static int SIMILARITE_LSA = 2;
    
    /**
     * Indique que les résultats qui s'appuient uniquement sur des expressions
     * vides ou récurrentes ne seront pas filtrés
     * (@see modele.listes.ExpressionsVides et @see modele.listes.ExpressionsRecurrentes)
     */
    public final static int FILTRAGE_AVEC_LEMMES_ET_EXPRESSIONS_VIDES = 0;
    
    /**
     * Indique que les résultats qui s'appuient uniquement sur des expressions
     * vides ou récurrentes seront filtrés
     * (@see modele.listes.ExpressionsVides et @see modele.listes.ExpressionsRecurrentes)
     */
    public final static int FILTRAGE_SANS_LEMMES_NI_EXPRESSIONS_VIDES = 1;
    
    /**
     * Indique que les résultats qui s'appuient uniquement sur des lemmes 
     * statistiquement vides seront filtrés
     */
    public final static int FILTRAGE_SANS_LEMMES_STATISTIQUEMENT_VIDES = 2;
    
    /**
     * Détermine le type de tratiement appliqué aux termes avant comparaison.
     * @param TERMES_QQCH une constante de l'interface commençant par TERMES
     */
    public void setTraitementTermes(int TERMES_QQCH);
    
    /**
     * Détermine l'importance de l'ordre des mots dans la mise en correspondance.
     * @param L_ORDRE_DES_MOTS_QQCH une constante de l'interface commençant par 
     * L_ORDRE_DES_MOTS
     */
    public void setImportanceOrdreMots(int L_ORDRE_DES_MOTS_QQCH);
    
    /**
     * Détermine le seuil en-deça duquel la mise en correspondance est faite.
     * @param CORRESPONDANCE_QQCH une constante de l'interface commençant par 
     * CORRESPONDANCE
     * @param seuil le seuil à considérer (si CORRESPONDANCE_QQCH = 
     * CORRESPONDANCE_STRICTE, le seuil ne sera pas utilisé)
     */
    public void setToleranceCorrespondance(int CORRESPONDANCE_QQCH, double seuil);
    
    /**
     * Détermine si les mots vides sont filtrés ou non.
     * @param TEXTE_QQCH une constante de l'interface en 
     * TEXTE_XXX_MOTS_VIDES
     */
    public void setFiltrageMotsVides(int TEXTE_QQCH);
    
    /**
     * Détermine si les expressions vides sont filtrées ou non.
     * @param FILTRAGE_QQCH une constante de l'interface en 
     * FILTRAGE_XXX_EXPRESSIONS_VIDES
     */
    public void setFiltrageExpressionsVides(int FILTRAGE_QQCH);
    
    /**
     * Détermine si un passage peut citer plusieurs passages source. Un passage 
     * source peut toujours être cité par plusieurs passages.
     * @param CITATIONS_QQCH une constante de l'interface commençant par 
     * CITATIONS
     */
    public void setMultiCitation(int CITATIONS_QQCH);
    
    /**
     * Détermine combien de mots au maximum il faut entre deux citations (dans les 
     * deux textes) pour que l'on fusionne ces deux citations.
     * @param nbMotsDifferents un entier positif
     */
    public void setSeuilFusion(int nbMotsDifferents);
    
    /**
     * Détermine la distance utilisée pour calculer si deux termes sont égaux ou pas
     * @param SIMILARITE_QQCH une constante de l'interface commençant par SIMILARITE
     * @param parametre un paramètre qui peut varier suivant la distance
     * @param seuilEgalite le seuil (entre 0 et 1) au-delà duquel deux termes sont considérés égaux
     */
    public void setSimilarite(int SIMILARITE_QQCH, int parametre, double seuilEgalite);
    
    /**
     * Détermine si les deux documents à tester sont les mêmes. Si c'est le cas, 
     * il faut éviter de retrouver une méga-citation du document dans lui-même.
     * @param identiques oui ou non
     */
    public void setSourceEtCiteurIdentiques(boolean identiques);
}
