/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.proc.parsers;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 *
 * @author Sam
 */
public class Temps {
    
    public static String getTexte(long ms) {
        long s = (ms/1000)%60;
        long mn = (ms/1000/60)%60;
        long h = (ms/1000/3600);
        if(ms<1000) {
            return ms + "ms";
        }
        return ((h>0?h+"h ":"") + (mn>0?(mn<10?"0":"")+mn+"mn ":"") + (s>0?(s<10?"0":"")+s+"s":"")).trim();
    }
    
    public static String getTexte(long ms, int nbCars) {
        long s = (ms/1000)%60;
        long mn = (ms/1000/60)%60;
        long h = (ms/1000/3600);
        String tps;
        if(ms<1000) {
            tps = ms + "ms";
        } else {
            tps = (h>0?h+"h ":"") + (mn>0?(mn<10?"0":"")+mn+"mn ":"") + (s>0?(s<10?"0":"")+s+"s":"");
        }
        tps = tps.trim();
        while(tps.length() < nbCars) {
            tps = " " + tps;
        }
        return tps;
    }
    
    public static String getDateCourante() {
        return new SimpleDateFormat("yyMMdd").format(new Date(System.currentTimeMillis()));
    }
    
    public static String getDateCouranteEnBonFrancais() {
        return new SimpleDateFormat("EEEE d MMM yyyy").format(new Date(System.currentTimeMillis()));
    }
}
