/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.modele.listes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import fr.cnrs.liris.drim.grt.modele.Lemme;
import fr.cnrs.liris.drim.grt.modele.Passage;
import fr.cnrs.liris.drim.grt.modele.Terme;
import fr.cnrs.liris.drim.grt.modele.exceptions.ListeStatistiqueNonInitialiseeException;
import fr.cnrs.liris.drim.grt.proc.Texte;

/**
 *
 * @author Sam
 */
public class LemmesStatistiquementVides {
    private static Set<Terme> liste = new HashSet<>();
    
    public final static boolean SEUIL_PAR_VALEUR = true;
    public final static boolean SEUIL_PAR_NOMBRE = false;
    
    public static void init() {
        Map<Terme, Integer> df = new HashMap<>();
        liste.clear();
        
        for(Terme t: Frequences.getInstance().getTermes()) {
            Lemme l = t.getLemmePrincipal();
            if(!df.containsKey(l)) {
                df.put(l, 0);
            }
            df.put(l, df.get(l) + Frequences.getInstance().getNbDocuments(t));
        }
        
        for(Terme t: df.keySet()) {
            if(1.0 * df.get(t) / Frequences.getInstance().getDocuments().length >= 1.00) {
                liste.add(t);
            }
        }
    }
    
    public Set<Terme> getEnsemble() throws ListeStatistiqueNonInitialiseeException {
        if(liste.isEmpty()) {
            throw new ListeStatistiqueNonInitialiseeException();
        }
        return liste;
    }
    
    public static boolean contientTerme(Terme t) throws ListeStatistiqueNonInitialiseeException {
        if(liste.isEmpty()) {
            throw new ListeStatistiqueNonInitialiseeException();
        }
        return liste.contains(t.getLemmePrincipal());
    }
    
    public static boolean contientLemme(Terme t) throws ListeStatistiqueNonInitialiseeException {
        if(liste.isEmpty()) {
            throw new ListeStatistiqueNonInitialiseeException();
        }
        return liste.contains(t);
    }
    
    public static boolean contientUnDe(Terme[] liste) throws ListeStatistiqueNonInitialiseeException {
        boolean resultat = false;
        for(Terme t: liste) {
            if(contientTerme(t)) {
                resultat = true;
                break;
            }
        }
        return resultat;
    }
    
    public static boolean constitueLaTotaliteDe(Terme[] texte) throws ListeStatistiqueNonInitialiseeException {
        Set<Terme> aTester = new HashSet(Arrays.asList(texte));
        aTester.removeAll(new HashSet(Arrays.asList(liste)));
        return aTester.isEmpty();
    }
    
    public static boolean constitueLaTotaliteDe(Passage p) throws ListeStatistiqueNonInitialiseeException {
        return constitueLaTotaliteDe(new Texte(p).getContenu());
    }
}
