/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.modele.convertisseurs;

import org.apache.commons.lang.StringUtils;

/**
 *
 * @author sgesche
 */
public class ConvertisseurUnicodeVersRienDuTout {
    public static String conversion(String s) {
        String s0 = s;
        
        // Majuscules
        s0 = StringUtils.replace(s0, ""+(char)7946, ""); //Ἂ
        s0 = StringUtils.replace(s0, ""+(char)7948, ""); //Ἄ
        s0 = StringUtils.replace(s0, ""+(char)7950, ""); //Ἆ
        s0 = StringUtils.replace(s0, ""+(char)7944, ""); //Ἀ
        s0 = StringUtils.replace(s0, ""+(char)7947, ""); //Ἃ
        s0 = StringUtils.replace(s0, ""+(char)7949, ""); //Ἅ
        s0 = StringUtils.replace(s0, ""+(char)7951, ""); //Ἇ
        s0 = StringUtils.replace(s0, ""+(char)7945, ""); //Ἁ
        s0 = StringUtils.replace(s0, ""+(char)913, ""); //Α
        s0 = StringUtils.replace(s0, ""+(char)7962, ""); //Ἒ
        s0 = StringUtils.replace(s0, ""+(char)7963, ""); //Ἓ
        s0 = StringUtils.replace(s0, ""+(char)7964, ""); //Ἔ
        s0 = StringUtils.replace(s0, ""+(char)7965, ""); //Ἕ
        s0 = StringUtils.replace(s0, ""+(char)7960, ""); //Ἐ
        s0 = StringUtils.replace(s0, ""+(char)7961, ""); //Ἑ
        s0 = StringUtils.replace(s0, ""+(char)917, ""); //Ε
        s0 = StringUtils.replace(s0, ""+(char)7978, ""); //Ἢ
        s0 = StringUtils.replace(s0, ""+(char)7979, ""); //Ἣ
        s0 = StringUtils.replace(s0, ""+(char)7980, ""); //Ἤ
        s0 = StringUtils.replace(s0, ""+(char)7981, ""); //Ἥ
        s0 = StringUtils.replace(s0, ""+(char)7982, ""); //Ἦ
        s0 = StringUtils.replace(s0, ""+(char)7983, ""); //Ἧ
        s0 = StringUtils.replace(s0, ""+(char)7976, ""); //Ἠ
        s0 = StringUtils.replace(s0, ""+(char)7977, ""); //Ἡ
        s0 = StringUtils.replace(s0, ""+(char)919, ""); //Η
        s0 = StringUtils.replace(s0, ""+(char)7994, ""); //Ἲ
        s0 = StringUtils.replace(s0, ""+(char)7995, ""); //Ἳ
        s0 = StringUtils.replace(s0, ""+(char)7996, ""); //Ἴ
        s0 = StringUtils.replace(s0, ""+(char)7997, ""); //Ἵ
        s0 = StringUtils.replace(s0, ""+(char)7998, ""); //Ἶ
        s0 = StringUtils.replace(s0, ""+(char)7999, ""); //Ἷ
        s0 = StringUtils.replace(s0, ""+(char)7992, ""); //Ἰ
        s0 = StringUtils.replace(s0, ""+(char)7993, ""); //Ἱ
        s0 = StringUtils.replace(s0, ""+(char)921, ""); //Ι
        s0 = StringUtils.replace(s0, ""+(char)8010, ""); //Ὂ
        s0 = StringUtils.replace(s0, ""+(char)8011, ""); //Ὃ
        s0 = StringUtils.replace(s0, ""+(char)8012, ""); //Ὄ
        s0 = StringUtils.replace(s0, ""+(char)8013, ""); //Ὅ
        s0 = StringUtils.replace(s0, ""+(char)8008, ""); //Ὀ
        s0 = StringUtils.replace(s0, ""+(char)8009, ""); //Ὁ
        s0 = StringUtils.replace(s0, ""+(char)927, ""); //Ο
        s0 = StringUtils.replace(s0, ""+(char)8027, ""); //Ὓ
        s0 = StringUtils.replace(s0, ""+(char)8029, ""); //Ὕ
        s0 = StringUtils.replace(s0, ""+(char)8031, ""); //Ὗ
        s0 = StringUtils.replace(s0, ""+(char)8025, ""); //Ὑ
        s0 = StringUtils.replace(s0, ""+(char)933, ""); //Υ
        s0 = StringUtils.replace(s0, ""+(char)8042, ""); //Ὢ
        s0 = StringUtils.replace(s0, ""+(char)8043, ""); //Ὣ
        s0 = StringUtils.replace(s0, ""+(char)8044, ""); //Ὤ
        s0 = StringUtils.replace(s0, ""+(char)8045, ""); //Ὥ
        s0 = StringUtils.replace(s0, ""+(char)8046, ""); //Ὦ
        s0 = StringUtils.replace(s0, ""+(char)8047, ""); //Ὧ
        s0 = StringUtils.replace(s0, ""+(char)8040, ""); //Ὠ
        s0 = StringUtils.replace(s0, ""+(char)8041, ""); //Ὡ
        s0 = StringUtils.replace(s0, ""+(char)937, ""); //Ω
        s0 = StringUtils.replace(s0, ""+(char)8172, ""); //‘P
        s0 = StringUtils.replace(s0, ""+(char)929, ""); //Ρ
        
        s0 = StringUtils.replace(s0, ""+(char)914, ""); //Β
        s0 = StringUtils.replace(s0, ""+(char)915, ""); //Γ
        s0 = StringUtils.replace(s0, ""+(char)916, ""); //Δ
        s0 = StringUtils.replace(s0, ""+(char)918, ""); //Ζ
        s0 = StringUtils.replace(s0, ""+(char)920, ""); //Θ
        s0 = StringUtils.replace(s0, ""+(char)922, ""); //Κ
        s0 = StringUtils.replace(s0, ""+(char)923, ""); //Λ
        s0 = StringUtils.replace(s0, ""+(char)924, ""); //Μ
        s0 = StringUtils.replace(s0, ""+(char)925, ""); //Ν
        s0 = StringUtils.replace(s0, ""+(char)926, ""); //Ξ
        s0 = StringUtils.replace(s0, ""+(char)928, ""); //Π
        s0 = StringUtils.replace(s0, ""+(char)931, ""); //Σ
        s0 = StringUtils.replace(s0, ""+(char)932, ""); //Τ
        s0 = StringUtils.replace(s0, ""+(char)934, ""); //Φ
        s0 = StringUtils.replace(s0, ""+(char)935, ""); //Χ
        s0 = StringUtils.replace(s0, ""+(char)936, ""); //Ψ
        
        // Minuscules
        s0 = StringUtils.replace(s0, ""+(char)8066, ""); //ᾂ
        s0 = StringUtils.replace(s0, ""+(char)7938, ""); //ἂ
        s0 = StringUtils.replace(s0, ""+(char)8067, ""); //ᾃ
        s0 = StringUtils.replace(s0, ""+(char)7939, ""); //ἃ
        s0 = StringUtils.replace(s0, ""+(char)8068, ""); //ᾄ
        s0 = StringUtils.replace(s0, ""+(char)7940, ""); //ἄ
        s0 = StringUtils.replace(s0, ""+(char)8069, ""); //ᾅ
        s0 = StringUtils.replace(s0, ""+(char)7941, ""); //ἅ
        s0 = StringUtils.replace(s0, ""+(char)8070, ""); //ᾆ
        s0 = StringUtils.replace(s0, ""+(char)7942, ""); //ἆ
        s0 = StringUtils.replace(s0, ""+(char)8071, ""); //ᾇ
        s0 = StringUtils.replace(s0, ""+(char)7943, ""); //ἇ
        s0 = StringUtils.replace(s0, ""+(char)8114, ""); //ᾲ
        s0 = StringUtils.replace(s0, ""+(char)8048, ""); //ὰ
        s0 = StringUtils.replace(s0, ""+(char)8116, ""); //ᾴ
        s0 = StringUtils.replace(s0, ""+(char)8049, ""); //ά
        s0 = StringUtils.replace(s0, ""+(char)8119, ""); //ᾷ
        s0 = StringUtils.replace(s0, ""+(char)8118, ""); //ᾶ
        s0 = StringUtils.replace(s0, ""+(char)8115, ""); //ᾳ
        s0 = StringUtils.replace(s0, ""+(char)8064, ""); //ᾀ
        s0 = StringUtils.replace(s0, ""+(char)7936, ""); //ἀ
        s0 = StringUtils.replace(s0, ""+(char)8065, ""); //ᾁ
        s0 = StringUtils.replace(s0, ""+(char)7937, ""); //ἁ
        s0 = StringUtils.replace(s0, ""+(char)945, ""); //α
        
        s0 = StringUtils.replace(s0, ""+(char)946, ""); //β
        s0 = StringUtils.replace(s0, ""+(char)947, ""); //γ
        s0 = StringUtils.replace(s0, ""+(char)948, ""); //δ
        
        s0 = StringUtils.replace(s0, ""+(char)7954, ""); //ἒ
        s0 = StringUtils.replace(s0, ""+(char)7955, ""); //ἓ
        s0 = StringUtils.replace(s0, ""+(char)8050, ""); //ὲ
        s0 = StringUtils.replace(s0, ""+(char)7956, ""); //ἔ
        s0 = StringUtils.replace(s0, ""+(char)7957, ""); //ἕ
        s0 = StringUtils.replace(s0, ""+(char)8051, ""); //έ
        s0 = StringUtils.replace(s0, ""+(char)7952, ""); //ἐ
        s0 = StringUtils.replace(s0, ""+(char)7953, ""); //ἑ
        s0 = StringUtils.replace(s0, ""+(char)949, ""); //ε
        
        s0 = StringUtils.replace(s0, ""+(char)950, ""); //ζ
        
        s0 = StringUtils.replace(s0, ""+(char)8082, ""); //ᾒ
        s0 = StringUtils.replace(s0, ""+(char)8083, ""); //ᾓ
        s0 = StringUtils.replace(s0, ""+(char)8084, ""); //ᾔ
        s0 = StringUtils.replace(s0, ""+(char)8085, ""); //ᾕ
        s0 = StringUtils.replace(s0, ""+(char)8086, ""); //ᾖ
        s0 = StringUtils.replace(s0, ""+(char)8087, ""); //ᾗ
        s0 = StringUtils.replace(s0, ""+(char)7970, ""); //ἢ
        s0 = StringUtils.replace(s0, ""+(char)7971, ""); //ἣ
        s0 = StringUtils.replace(s0, ""+(char)7972, ""); //ἤ
        s0 = StringUtils.replace(s0, ""+(char)7973, ""); //ἥ
        s0 = StringUtils.replace(s0, ""+(char)7974, ""); //ἦ
        s0 = StringUtils.replace(s0, ""+(char)7975, ""); //ἧ
        s0 = StringUtils.replace(s0, ""+(char)8080, ""); //ᾐ
        s0 = StringUtils.replace(s0, ""+(char)8081, ""); //ᾑ
        s0 = StringUtils.replace(s0, ""+(char)8130, ""); //ῂ
        s0 = StringUtils.replace(s0, ""+(char)8132, ""); //ῄ
        s0 = StringUtils.replace(s0, ""+(char)8135, ""); //ῇ
        s0 = StringUtils.replace(s0, ""+(char)8052, ""); //ὴ
        s0 = StringUtils.replace(s0, ""+(char)8053, ""); //ή
        s0 = StringUtils.replace(s0, ""+(char)8131, ""); //ῃ
        s0 = StringUtils.replace(s0, ""+(char)8134, ""); //ῆ
        s0 = StringUtils.replace(s0, ""+(char)7968, ""); //ἠ
        s0 = StringUtils.replace(s0, ""+(char)7969, ""); //ἡ
        s0 = StringUtils.replace(s0, ""+(char)951, ""); //η
        
        s0 = StringUtils.replace(s0, ""+(char)952, ""); //θ
        
        s0 = StringUtils.replace(s0, ""+(char)7986, ""); //ἲ
        s0 = StringUtils.replace(s0, ""+(char)7987, ""); //ἳ
        s0 = StringUtils.replace(s0, ""+(char)7988, ""); //ἴ
        s0 = StringUtils.replace(s0, ""+(char)7989, ""); //ἵ
        s0 = StringUtils.replace(s0, ""+(char)8146, ""); //ῒ
        s0 = StringUtils.replace(s0, ""+(char)8147, ""); //ΐ
        s0 = StringUtils.replace(s0, ""+(char)7990, ""); //ἶ
        s0 = StringUtils.replace(s0, ""+(char)7991, ""); //ἷ
        s0 = StringUtils.replace(s0, ""+(char)8054, ""); //ὶ
        s0 = StringUtils.replace(s0, ""+(char)8055, ""); //ί
        s0 = StringUtils.replace(s0, ""+(char)8150, ""); //ῖ
        s0 = StringUtils.replace(s0, ""+(char)7984, ""); //ἰ
        s0 = StringUtils.replace(s0, ""+(char)7985, ""); //ἱ
        s0 = StringUtils.replace(s0, ""+(char)970, ""); //ϊ
        s0 = StringUtils.replace(s0, ""+(char)953, ""); //ι
        
        s0 = StringUtils.replace(s0, ""+(char)954, ""); //κ
        s0 = StringUtils.replace(s0, ""+(char)955, ""); //λ
        s0 = StringUtils.replace(s0, ""+(char)956, ""); //μ
        s0 = StringUtils.replace(s0, ""+(char)957, ""); //ν
        s0 = StringUtils.replace(s0, ""+(char)958, ""); //ξ
        
        s0 = StringUtils.replace(s0, ""+(char)8004, ""); //ὄ
        s0 = StringUtils.replace(s0, ""+(char)8005, ""); //ὅ
        s0 = StringUtils.replace(s0, ""+(char)8002, ""); //ὂ
        s0 = StringUtils.replace(s0, ""+(char)8003, ""); //ὃ
        s0 = StringUtils.replace(s0, ""+(char)8056, ""); //ὸ
        s0 = StringUtils.replace(s0, ""+(char)8057, ""); //ό
        s0 = StringUtils.replace(s0, ""+(char)8000, ""); //ὀ
        s0 = StringUtils.replace(s0, ""+(char)8001, ""); //ὁ
        s0 = StringUtils.replace(s0, ""+(char)959, ""); //ο
        
        s0 = StringUtils.replace(s0, ""+(char)960, ""); //π
        
        s0 = StringUtils.replace(s0, ""+(char)8165, ""); //ῥ
        s0 = StringUtils.replace(s0, ""+(char)961, ""); //ρ
        
        s0 = StringUtils.replace(s0, ""+(char)962, ""); //ς
        s0 = StringUtils.replace(s0, ""+(char)963, ""); //σ
        s0 = StringUtils.replace(s0, ""+(char)964, ""); //τ
        
        s0 = StringUtils.replace(s0, ""+(char)8020, ""); //ὔ
        s0 = StringUtils.replace(s0, ""+(char)8021, ""); //ὕ
        s0 = StringUtils.replace(s0, ""+(char)8022, ""); //ὖ
        s0 = StringUtils.replace(s0, ""+(char)8023, ""); //ὗ
        s0 = StringUtils.replace(s0, ""+(char)8162, ""); //ῢ
        s0 = StringUtils.replace(s0, ""+(char)8163, ""); //ΰ
        s0 = StringUtils.replace(s0, ""+(char)8018, ""); //ὒ
        s0 = StringUtils.replace(s0, ""+(char)8019, ""); //ὓ
        s0 = StringUtils.replace(s0, ""+(char)8166, ""); //ῦ
        s0 = StringUtils.replace(s0, ""+(char)8058, ""); //ὺ
        s0 = StringUtils.replace(s0, ""+(char)8059, ""); //ύ
        s0 = StringUtils.replace(s0, ""+(char)8016, ""); //ὐ
        s0 = StringUtils.replace(s0, ""+(char)8017, ""); //ὑ
        s0 = StringUtils.replace(s0, ""+(char)971, ""); //ϋ
        s0 = StringUtils.replace(s0, ""+(char)965, ""); //υ
        
        s0 = StringUtils.replace(s0, ""+(char)966, ""); //φ
        s0 = StringUtils.replace(s0, ""+(char)967, ""); //χ
        s0 = StringUtils.replace(s0, ""+(char)968, ""); //ψ
        
        
        s0 = StringUtils.replace(s0, ""+(char)8098, ""); //ᾢ
        s0 = StringUtils.replace(s0, ""+(char)8099, ""); //ᾣ
        s0 = StringUtils.replace(s0, ""+(char)8100, ""); //ᾤ
        s0 = StringUtils.replace(s0, ""+(char)8101, ""); //ᾥ
        s0 = StringUtils.replace(s0, ""+(char)8102, ""); //ᾦ
        s0 = StringUtils.replace(s0, ""+(char)8103, ""); //ᾧ
        s0 = StringUtils.replace(s0, ""+(char)8178, ""); //ῲ
        s0 = StringUtils.replace(s0, ""+(char)8180, ""); //ῴ
        s0 = StringUtils.replace(s0, ""+(char)8096, ""); //ᾠ
        s0 = StringUtils.replace(s0, ""+(char)8097, ""); //ᾡ
        s0 = StringUtils.replace(s0, ""+(char)8034, ""); //ὢ
        s0 = StringUtils.replace(s0, ""+(char)8035, ""); //ὣ
        s0 = StringUtils.replace(s0, ""+(char)8036, ""); //ὤ
        s0 = StringUtils.replace(s0, ""+(char)8037, ""); //ὥ
        s0 = StringUtils.replace(s0, ""+(char)8038, ""); //ὦ
        s0 = StringUtils.replace(s0, ""+(char)8039, ""); //ὧ
        s0 = StringUtils.replace(s0, ""+(char)8183, ""); //ῷ
        s0 = StringUtils.replace(s0, ""+(char)8032, ""); //ὠ
        s0 = StringUtils.replace(s0, ""+(char)8033, ""); //ὡ
        s0 = StringUtils.replace(s0, ""+(char)8060, ""); //ὼ
        s0 = StringUtils.replace(s0, ""+(char)8061, ""); //ώ
        s0 = StringUtils.replace(s0, ""+(char)8179, ""); //ῳ
        s0 = StringUtils.replace(s0, ""+(char)8182, ""); //ῶ
        s0 = StringUtils.replace(s0, ""+(char)969, ""); //ω
        
        return s0;
    }
}
