/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.modele.convertisseurs;

import org.apache.commons.lang.StringUtils;
/**
 *
 * @author Sam
 */
public class ConvertisseurUnicodeVersBetaCode {
    public static String conversion(String s) {
        String s0 = s;
        
        // Liste tirée de logs d'utilisation du convertisseur GreekConverter, 
        // qui n'était pas tout à fait au point
        
        // Note : apparemment aucune majuscule dans les textes étudiés n'a de 
        // iota souscrit (ou du moins ne l'affiche en tant que caractère unicode)
        
        // Majuscules
        s0 = StringUtils.replace(s0, ""+(char)7946, "*A)\\"); //Ἂ
        s0 = StringUtils.replace(s0, ""+(char)7948, "*A)/"); //Ἄ
        s0 = StringUtils.replace(s0, ""+(char)7950, "*A)="); //Ἆ
        s0 = StringUtils.replace(s0, ""+(char)7944, "*A)"); //Ἀ
        s0 = StringUtils.replace(s0, ""+(char)7947, "*A(\\"); //Ἃ
        s0 = StringUtils.replace(s0, ""+(char)7949, "*A(/"); //Ἅ
        s0 = StringUtils.replace(s0, ""+(char)7951, "*A(="); //Ἇ
        s0 = StringUtils.replace(s0, ""+(char)7945, "*A("); //Ἁ
        s0 = StringUtils.replace(s0, ""+(char)913, "*A"); //Α
        s0 = StringUtils.replace(s0, ""+(char)7962, "*E)\\"); //Ἒ
        s0 = StringUtils.replace(s0, ""+(char)7963, "*E(\\"); //Ἓ
        s0 = StringUtils.replace(s0, ""+(char)7964, "*E)/"); //Ἔ
        s0 = StringUtils.replace(s0, ""+(char)7965, "*E(/"); //Ἕ
        s0 = StringUtils.replace(s0, ""+(char)7960, "*E)"); //Ἐ
        s0 = StringUtils.replace(s0, ""+(char)7961, "*E("); //Ἑ
        s0 = StringUtils.replace(s0, ""+(char)917, "*E"); //Ε
        s0 = StringUtils.replace(s0, ""+(char)7978, "*H)\\"); //Ἢ
        s0 = StringUtils.replace(s0, ""+(char)7979, "*H(\\"); //Ἣ
        s0 = StringUtils.replace(s0, ""+(char)7980, "*H)/"); //Ἤ
        s0 = StringUtils.replace(s0, ""+(char)7981, "*H(/"); //Ἥ
        s0 = StringUtils.replace(s0, ""+(char)7982, "*H)="); //Ἦ
        s0 = StringUtils.replace(s0, ""+(char)7983, "*H(="); //Ἧ
        s0 = StringUtils.replace(s0, ""+(char)7976, "*H)"); //Ἠ
        s0 = StringUtils.replace(s0, ""+(char)7977, "*H("); //Ἡ
        s0 = StringUtils.replace(s0, ""+(char)919, "*H"); //Η
        s0 = StringUtils.replace(s0, ""+(char)7994, "*I)\\"); //Ἲ
        s0 = StringUtils.replace(s0, ""+(char)7995, "*I(\\"); //Ἳ
        s0 = StringUtils.replace(s0, ""+(char)7996, "*I)/"); //Ἴ
        s0 = StringUtils.replace(s0, ""+(char)7997, "*I(/"); //Ἵ
        s0 = StringUtils.replace(s0, ""+(char)7998, "*I)="); //Ἶ
        s0 = StringUtils.replace(s0, ""+(char)7999, "*I(="); //Ἷ
        s0 = StringUtils.replace(s0, ""+(char)7992, "*I)"); //Ἰ
        s0 = StringUtils.replace(s0, ""+(char)7993, "*I("); //Ἱ
        s0 = StringUtils.replace(s0, ""+(char)921, "*I"); //Ι
        s0 = StringUtils.replace(s0, ""+(char)8010, "*O)\\"); //Ὂ
        s0 = StringUtils.replace(s0, ""+(char)8011, "*O(\\"); //Ὃ
        s0 = StringUtils.replace(s0, ""+(char)8012, "*O)/"); //Ὄ
        s0 = StringUtils.replace(s0, ""+(char)8013, "*O(/"); //Ὅ
        s0 = StringUtils.replace(s0, ""+(char)8008, "*O)"); //Ὀ
        s0 = StringUtils.replace(s0, ""+(char)8009, "*O("); //Ὁ
        s0 = StringUtils.replace(s0, ""+(char)927, "*O"); //Ο
        s0 = StringUtils.replace(s0, ""+(char)8027, "*U(\\"); //Ὓ
        s0 = StringUtils.replace(s0, ""+(char)8029, "*U(/"); //Ὕ
        s0 = StringUtils.replace(s0, ""+(char)8031, "*U(="); //Ὗ
        s0 = StringUtils.replace(s0, ""+(char)8025, "*U("); //Ὑ
        s0 = StringUtils.replace(s0, ""+(char)933, "*U"); //Υ
        s0 = StringUtils.replace(s0, ""+(char)8042, "*W)\\"); //Ὢ
        s0 = StringUtils.replace(s0, ""+(char)8043, "*W(\\"); //Ὣ
        s0 = StringUtils.replace(s0, ""+(char)8044, "*W)/"); //Ὤ
        s0 = StringUtils.replace(s0, ""+(char)8045, "*W(/"); //Ὥ
        s0 = StringUtils.replace(s0, ""+(char)8046, "*W)="); //Ὦ
        s0 = StringUtils.replace(s0, ""+(char)8047, "*W(="); //Ὧ
        s0 = StringUtils.replace(s0, ""+(char)8040, "*W)"); //Ὠ
        s0 = StringUtils.replace(s0, ""+(char)8041, "*W("); //Ὡ
        s0 = StringUtils.replace(s0, ""+(char)937, "*W"); //Ω
        s0 = StringUtils.replace(s0, ""+(char)8172, "*R("); //‘P
        s0 = StringUtils.replace(s0, ""+(char)929, "*R"); //Ρ
        
        s0 = StringUtils.replace(s0, ""+(char)914, "*B"); //Β
        s0 = StringUtils.replace(s0, ""+(char)915, "*G"); //Γ
        s0 = StringUtils.replace(s0, ""+(char)916, "*D"); //Δ
        s0 = StringUtils.replace(s0, ""+(char)918, "*Z"); //Ζ
        s0 = StringUtils.replace(s0, ""+(char)920, "*Q"); //Θ
        s0 = StringUtils.replace(s0, ""+(char)922, "*K"); //Κ
        s0 = StringUtils.replace(s0, ""+(char)923, "*L"); //Λ
        s0 = StringUtils.replace(s0, ""+(char)924, "*M"); //Μ
        s0 = StringUtils.replace(s0, ""+(char)925, "*N"); //Ν
        s0 = StringUtils.replace(s0, ""+(char)926, "*C"); //Ξ
        s0 = StringUtils.replace(s0, ""+(char)928, "*P"); //Π
        s0 = StringUtils.replace(s0, ""+(char)931, "*S"); //Σ
        s0 = StringUtils.replace(s0, ""+(char)932, "*T"); //Τ
        s0 = StringUtils.replace(s0, ""+(char)934, "*F"); //Φ
        s0 = StringUtils.replace(s0, ""+(char)935, "*X"); //Χ
        s0 = StringUtils.replace(s0, ""+(char)936, "*Y"); //Ψ
        
        // Minuscules
        s0 = StringUtils.replace(s0, ""+(char)8066, "A)\\|"); //ᾂ
        s0 = StringUtils.replace(s0, ""+(char)7938, "A)\\"); //ἂ
        s0 = StringUtils.replace(s0, ""+(char)8067, "A(\\|"); //ᾃ
        s0 = StringUtils.replace(s0, ""+(char)7939, "A(\\"); //ἃ
        s0 = StringUtils.replace(s0, ""+(char)8068, "A)/|"); //ᾄ
        s0 = StringUtils.replace(s0, ""+(char)7940, "A)/"); //ἄ
        s0 = StringUtils.replace(s0, ""+(char)8069, "A(/|"); //ᾅ
        s0 = StringUtils.replace(s0, ""+(char)7941, "A(/"); //ἅ
        s0 = StringUtils.replace(s0, ""+(char)8070, "A)=|"); //ᾆ
        s0 = StringUtils.replace(s0, ""+(char)7942, "A)="); //ἆ
        s0 = StringUtils.replace(s0, ""+(char)8071, "A(=|"); //ᾇ
        s0 = StringUtils.replace(s0, ""+(char)7943, "A(="); //ἇ
        s0 = StringUtils.replace(s0, ""+(char)8114, "A\\|"); //ᾲ
        s0 = StringUtils.replace(s0, ""+(char)8048, "A\\"); //ὰ
        s0 = StringUtils.replace(s0, ""+(char)8116, "A/|"); //ᾴ
        s0 = StringUtils.replace(s0, ""+(char)8049, "A/"); //ά
        s0 = StringUtils.replace(s0, ""+(char)8119, "A=|"); //ᾷ
        s0 = StringUtils.replace(s0, ""+(char)8118, "A="); //ᾶ
        s0 = StringUtils.replace(s0, ""+(char)8115, "A|"); //ᾳ
        s0 = StringUtils.replace(s0, ""+(char)8064, "A)|"); //ᾀ
        s0 = StringUtils.replace(s0, ""+(char)7936, "A)"); //ἀ
        s0 = StringUtils.replace(s0, ""+(char)8065, "A(|"); //ᾁ
        s0 = StringUtils.replace(s0, ""+(char)7937, "A("); //ἁ
        s0 = StringUtils.replace(s0, ""+(char)945, "A"); //α
        
        s0 = StringUtils.replace(s0, ""+(char)946, "B"); //β
        s0 = StringUtils.replace(s0, ""+(char)947, "G"); //γ
        s0 = StringUtils.replace(s0, ""+(char)948, "D"); //δ
        
        s0 = StringUtils.replace(s0, ""+(char)7954, "E)\\"); //ἒ
        s0 = StringUtils.replace(s0, ""+(char)7955, "E(\\"); //ἓ
        s0 = StringUtils.replace(s0, ""+(char)8050, "E\\"); //ὲ
        s0 = StringUtils.replace(s0, ""+(char)7956, "E)/"); //ἔ
        s0 = StringUtils.replace(s0, ""+(char)7957, "E(/"); //ἕ
        s0 = StringUtils.replace(s0, ""+(char)8051, "E/"); //έ
        s0 = StringUtils.replace(s0, ""+(char)7952, "E)"); //ἐ
        s0 = StringUtils.replace(s0, ""+(char)7953, "E("); //ἑ
        s0 = StringUtils.replace(s0, ""+(char)949, "E"); //ε
        
        s0 = StringUtils.replace(s0, ""+(char)950, "Z"); //ζ
        
        s0 = StringUtils.replace(s0, ""+(char)8082, "H)\\|"); //ᾒ
        s0 = StringUtils.replace(s0, ""+(char)8083, "H(\\|"); //ᾓ
        s0 = StringUtils.replace(s0, ""+(char)8084, "H)/|"); //ᾔ
        s0 = StringUtils.replace(s0, ""+(char)8085, "H(/|"); //ᾕ
        s0 = StringUtils.replace(s0, ""+(char)8086, "H)=|"); //ᾖ
        s0 = StringUtils.replace(s0, ""+(char)8087, "H(=|"); //ᾗ
        s0 = StringUtils.replace(s0, ""+(char)7970, "H)\\"); //ἢ
        s0 = StringUtils.replace(s0, ""+(char)7971, "H(\\"); //ἣ
        s0 = StringUtils.replace(s0, ""+(char)7972, "H)/"); //ἤ
        s0 = StringUtils.replace(s0, ""+(char)7973, "H(/"); //ἥ
        s0 = StringUtils.replace(s0, ""+(char)7974, "H)="); //ἦ
        s0 = StringUtils.replace(s0, ""+(char)7975, "H(="); //ἧ
        s0 = StringUtils.replace(s0, ""+(char)8080, "H)|"); //ᾐ
        s0 = StringUtils.replace(s0, ""+(char)8081, "H(|"); //ᾑ
        s0 = StringUtils.replace(s0, ""+(char)8130, "H\\|"); //ῂ
        s0 = StringUtils.replace(s0, ""+(char)8132, "H/|"); //ῄ
        s0 = StringUtils.replace(s0, ""+(char)8135, "H=|"); //ῇ
        s0 = StringUtils.replace(s0, ""+(char)8052, "H\\"); //ὴ
        s0 = StringUtils.replace(s0, ""+(char)8053, "H/"); //ή
        s0 = StringUtils.replace(s0, ""+(char)8131, "H|"); //ῃ
        s0 = StringUtils.replace(s0, ""+(char)8134, "H="); //ῆ
        s0 = StringUtils.replace(s0, ""+(char)7968, "H)"); //ἠ
        s0 = StringUtils.replace(s0, ""+(char)7969, "H("); //ἡ
        s0 = StringUtils.replace(s0, ""+(char)951, "H"); //η
        
        s0 = StringUtils.replace(s0, ""+(char)952, "Q"); //θ
        
        s0 = StringUtils.replace(s0, ""+(char)7986, "I)\\"); //ἲ
        s0 = StringUtils.replace(s0, ""+(char)7987, "I(\\"); //ἳ
        s0 = StringUtils.replace(s0, ""+(char)7988, "I)/"); //ἴ
        s0 = StringUtils.replace(s0, ""+(char)7989, "I(/"); //ἵ
        s0 = StringUtils.replace(s0, ""+(char)8146, "I\\+"); //ῒ
        s0 = StringUtils.replace(s0, ""+(char)8147, "I/+"); //ΐ
        s0 = StringUtils.replace(s0, ""+(char)7990, "I)="); //ἶ
        s0 = StringUtils.replace(s0, ""+(char)7991, "I(="); //ἷ
        s0 = StringUtils.replace(s0, ""+(char)8054, "I\\"); //ὶ
        s0 = StringUtils.replace(s0, ""+(char)8055, "I/"); //ί
        s0 = StringUtils.replace(s0, ""+(char)8150, "I="); //ῖ
        s0 = StringUtils.replace(s0, ""+(char)7984, "I)"); //ἰ
        s0 = StringUtils.replace(s0, ""+(char)7985, "I("); //ἱ
        s0 = StringUtils.replace(s0, ""+(char)970, "I+"); //ϊ
        s0 = StringUtils.replace(s0, ""+(char)953, "I"); //ι
        
        s0 = StringUtils.replace(s0, ""+(char)954, "K"); //κ
        s0 = StringUtils.replace(s0, ""+(char)955, "L"); //λ
        s0 = StringUtils.replace(s0, ""+(char)956, "M"); //μ
        s0 = StringUtils.replace(s0, ""+(char)957, "N"); //ν
        s0 = StringUtils.replace(s0, ""+(char)958, "C"); //ξ
        
        s0 = StringUtils.replace(s0, ""+(char)8004, "O)/"); //ὄ
        s0 = StringUtils.replace(s0, ""+(char)8005, "O(/"); //ὅ
        s0 = StringUtils.replace(s0, ""+(char)8002, "O)\\"); //ὂ
        s0 = StringUtils.replace(s0, ""+(char)8003, "O(\\"); //ὃ
        s0 = StringUtils.replace(s0, ""+(char)8056, "O\\"); //ὸ
        s0 = StringUtils.replace(s0, ""+(char)8057, "O/"); //ό
        s0 = StringUtils.replace(s0, ""+(char)8000, "O)"); //ὀ
        s0 = StringUtils.replace(s0, ""+(char)8001, "O("); //ὁ
        s0 = StringUtils.replace(s0, ""+(char)959, "O"); //ο
        
        s0 = StringUtils.replace(s0, ""+(char)960, "P"); //π
        
        s0 = StringUtils.replace(s0, ""+(char)8165, "R("); //ῥ
        s0 = StringUtils.replace(s0, ""+(char)961, "R"); //ρ
        
        s0 = StringUtils.replace(s0, ""+(char)962, "J"); //ς
        s0 = StringUtils.replace(s0, ""+(char)963, "S"); //σ
        s0 = StringUtils.replace(s0, ""+(char)964, "T"); //τ
        
        s0 = StringUtils.replace(s0, ""+(char)8020, "U)/"); //ὔ
        s0 = StringUtils.replace(s0, ""+(char)8021, "U(/"); //ὕ
        s0 = StringUtils.replace(s0, ""+(char)8022, "U)="); //ὖ
        s0 = StringUtils.replace(s0, ""+(char)8023, "U(="); //ὗ
        s0 = StringUtils.replace(s0, ""+(char)8162, "U\\+"); //ῢ
        s0 = StringUtils.replace(s0, ""+(char)8163, "U/+"); //ΰ
        s0 = StringUtils.replace(s0, ""+(char)8018, "U)\\"); //ὒ
        s0 = StringUtils.replace(s0, ""+(char)8019, "U(\\"); //ὓ
        s0 = StringUtils.replace(s0, ""+(char)8166, "U="); //ῦ
        s0 = StringUtils.replace(s0, ""+(char)8058, "U\\"); //ὺ
        s0 = StringUtils.replace(s0, ""+(char)8059, "U/"); //ύ
        s0 = StringUtils.replace(s0, ""+(char)8016, "U)"); //ὐ
        s0 = StringUtils.replace(s0, ""+(char)8017, "U("); //ὑ
        s0 = StringUtils.replace(s0, ""+(char)971, "U+"); //ϋ
        s0 = StringUtils.replace(s0, ""+(char)965, "U"); //υ
        
        s0 = StringUtils.replace(s0, ""+(char)966, "F"); //φ
        s0 = StringUtils.replace(s0, ""+(char)967, "X"); //χ
        s0 = StringUtils.replace(s0, ""+(char)968, "Y"); //ψ
        
        
        s0 = StringUtils.replace(s0, ""+(char)8098, "W)\\|"); //ᾢ
        s0 = StringUtils.replace(s0, ""+(char)8099, "W(\\|"); //ᾣ
        s0 = StringUtils.replace(s0, ""+(char)8100, "W)/|"); //ᾤ
        s0 = StringUtils.replace(s0, ""+(char)8101, "W(/|"); //ᾥ
        s0 = StringUtils.replace(s0, ""+(char)8102, "W)=|"); //ᾦ
        s0 = StringUtils.replace(s0, ""+(char)8103, "W(=|"); //ᾧ
        s0 = StringUtils.replace(s0, ""+(char)8178, "W\\|"); //ῲ
        s0 = StringUtils.replace(s0, ""+(char)8180, "W/|"); //ῴ
        s0 = StringUtils.replace(s0, ""+(char)8096, "W)|"); //ᾠ
        s0 = StringUtils.replace(s0, ""+(char)8097, "W(|"); //ᾡ
        s0 = StringUtils.replace(s0, ""+(char)8034, "W)\\"); //ὢ
        s0 = StringUtils.replace(s0, ""+(char)8035, "W(\\"); //ὣ
        s0 = StringUtils.replace(s0, ""+(char)8036, "W)/"); //ὤ
        s0 = StringUtils.replace(s0, ""+(char)8037, "W(/"); //ὥ
        s0 = StringUtils.replace(s0, ""+(char)8038, "W)="); //ὦ
        s0 = StringUtils.replace(s0, ""+(char)8039, "W(="); //ὧ
        s0 = StringUtils.replace(s0, ""+(char)8183, "W=|"); //ῷ
        s0 = StringUtils.replace(s0, ""+(char)8032, "W)"); //ὠ
        s0 = StringUtils.replace(s0, ""+(char)8033, "W("); //ὡ
        s0 = StringUtils.replace(s0, ""+(char)8060, "W\\"); //ὼ
        s0 = StringUtils.replace(s0, ""+(char)8061, "W/"); //ώ
        s0 = StringUtils.replace(s0, ""+(char)8179, "W|"); //ῳ
        s0 = StringUtils.replace(s0, ""+(char)8182, "W="); //ῶ
        s0 = StringUtils.replace(s0, ""+(char)969, "W"); //ω
        
        return s0.toLowerCase();
    }
}
