/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.modele;

/**
 *
 * @author Sam
 */
public interface ProcedeLemmatisation {
    /**
     * Renvoie les formes lemmatisées du mot fourni.
     * Mot à fournir en unicode, réponse en unicode.
     * @param terme un terme à lemmatiser
     * @return les lemmes trouvés pour ce terme (0, 1 ou plusieurs)
     */
    public String[] getFormesLemmatisees(String terme);
    
    /**
     * Donne des statistiques sur la base de lemmes actuellement connue
     * @return lesdites statistiques
     */
    public String getStats();
    
    /**
     * Liste les termes qui n'ont pas de lemme suivant ce procédé.
     * @return la liste
     */
    public String[] listeTermesSansLemme();
    
    /**
     * Indique si le lemme considéré fait partie de la liste des lemmes de ce lemmatiseur.
     * @param lemme un lemme
     * @return oui ou non (true ou false)
     */
    public boolean contientLemme(String lemme);
    
    /***
     * Donne la liste de toutes les formes connues de ce lemmatiseur.
     * @return 
     */
    public String[] getListeFormes();
}
