/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.modele.convertisseurs;

import org.apache.commons.lang.StringUtils;

/**
 *
 * @author sgesche
 */
public class ConvertisseurUnicodeVersSansAccentNiEsprit {
    public static String conversion(String s) {
        String s0 = s;
        
        // Majuscules
        s0 = StringUtils.replace(s0, ""+(char)7946, ""+(char)913); //Ἂ
        s0 = StringUtils.replace(s0, ""+(char)7948, ""+(char)913); //Ἄ
        s0 = StringUtils.replace(s0, ""+(char)7950, ""+(char)913); //Ἆ
        s0 = StringUtils.replace(s0, ""+(char)7944, ""+(char)913); //Ἀ
        s0 = StringUtils.replace(s0, ""+(char)7947, ""+(char)913); //Ἃ
        s0 = StringUtils.replace(s0, ""+(char)7949, ""+(char)913); //Ἅ
        s0 = StringUtils.replace(s0, ""+(char)7951, ""+(char)913); //Ἇ
        s0 = StringUtils.replace(s0, ""+(char)7945, ""+(char)913); //Ἁ
        s0 = StringUtils.replace(s0, ""+(char)7962, ""+(char)917); //Ἒ
        s0 = StringUtils.replace(s0, ""+(char)7963, ""+(char)917); //Ἓ
        s0 = StringUtils.replace(s0, ""+(char)7964, ""+(char)917); //Ἔ
        s0 = StringUtils.replace(s0, ""+(char)7965, ""+(char)917); //Ἕ
        s0 = StringUtils.replace(s0, ""+(char)7960, ""+(char)917); //Ἐ
        s0 = StringUtils.replace(s0, ""+(char)7961, ""+(char)917); //Ἑ
        s0 = StringUtils.replace(s0, ""+(char)7978, ""+(char)919); //Ἢ
        s0 = StringUtils.replace(s0, ""+(char)7979, ""+(char)919); //Ἣ
        s0 = StringUtils.replace(s0, ""+(char)7980, ""+(char)919); //Ἤ
        s0 = StringUtils.replace(s0, ""+(char)7981, ""+(char)919); //Ἥ
        s0 = StringUtils.replace(s0, ""+(char)7982, ""+(char)919); //Ἦ
        s0 = StringUtils.replace(s0, ""+(char)7983, ""+(char)919); //Ἧ
        s0 = StringUtils.replace(s0, ""+(char)7976, ""+(char)919); //Ἠ
        s0 = StringUtils.replace(s0, ""+(char)7977, ""+(char)919); //Ἡ
        s0 = StringUtils.replace(s0, ""+(char)7994, ""+(char)921); //Ἲ
        s0 = StringUtils.replace(s0, ""+(char)7995, ""+(char)921); //Ἳ
        s0 = StringUtils.replace(s0, ""+(char)7996, ""+(char)921); //Ἴ
        s0 = StringUtils.replace(s0, ""+(char)7997, ""+(char)921); //Ἵ
        s0 = StringUtils.replace(s0, ""+(char)7998, ""+(char)921); //Ἶ
        s0 = StringUtils.replace(s0, ""+(char)7999, ""+(char)921); //Ἷ
        s0 = StringUtils.replace(s0, ""+(char)7992, ""+(char)921); //Ἰ
        s0 = StringUtils.replace(s0, ""+(char)7993, ""+(char)921); //Ἱ
        s0 = StringUtils.replace(s0, ""+(char)8010, ""+(char)927); //Ὂ
        s0 = StringUtils.replace(s0, ""+(char)8011, ""+(char)927); //Ὃ
        s0 = StringUtils.replace(s0, ""+(char)8012, ""+(char)927); //Ὄ
        s0 = StringUtils.replace(s0, ""+(char)8013, ""+(char)927); //Ὅ
        s0 = StringUtils.replace(s0, ""+(char)8008, ""+(char)927); //Ὀ
        s0 = StringUtils.replace(s0, ""+(char)8009, ""+(char)927); //Ὁ
        s0 = StringUtils.replace(s0, ""+(char)8027, ""+(char)933); //Ὓ
        s0 = StringUtils.replace(s0, ""+(char)8029, ""+(char)933); //Ὕ
        s0 = StringUtils.replace(s0, ""+(char)8031, ""+(char)933); //Ὗ
        s0 = StringUtils.replace(s0, ""+(char)8025, ""+(char)933); //Ὑ
        s0 = StringUtils.replace(s0, ""+(char)8042, ""+(char)937); //Ὢ
        s0 = StringUtils.replace(s0, ""+(char)8043, ""+(char)937); //Ὣ
        s0 = StringUtils.replace(s0, ""+(char)8044, ""+(char)937); //Ὤ
        s0 = StringUtils.replace(s0, ""+(char)8045, ""+(char)937); //Ὥ
        s0 = StringUtils.replace(s0, ""+(char)8046, ""+(char)937); //Ὦ
        s0 = StringUtils.replace(s0, ""+(char)8047, ""+(char)937); //Ὧ
        s0 = StringUtils.replace(s0, ""+(char)8040, ""+(char)937); //Ὠ
        s0 = StringUtils.replace(s0, ""+(char)8041, ""+(char)937); //Ὡ
        s0 = StringUtils.replace(s0, ""+(char)8172, ""+(char)929); //‘P
        
        // Minuscules
        s0 = StringUtils.replace(s0, ""+(char)8066, ""+(char)945); //ᾂ
        s0 = StringUtils.replace(s0, ""+(char)7938, ""+(char)945); //ἂ
        s0 = StringUtils.replace(s0, ""+(char)8067, ""+(char)945); //ᾃ
        s0 = StringUtils.replace(s0, ""+(char)7939, ""+(char)945); //ἃ
        s0 = StringUtils.replace(s0, ""+(char)8068, ""+(char)945); //ᾄ
        s0 = StringUtils.replace(s0, ""+(char)7940, ""+(char)945); //ἄ
        s0 = StringUtils.replace(s0, ""+(char)8069, ""+(char)945); //ᾅ
        s0 = StringUtils.replace(s0, ""+(char)7941, ""+(char)945); //ἅ
        s0 = StringUtils.replace(s0, ""+(char)8070, ""+(char)945); //ᾆ
        s0 = StringUtils.replace(s0, ""+(char)7942, ""+(char)945); //ἆ
        s0 = StringUtils.replace(s0, ""+(char)8071, ""+(char)945); //ᾇ
        s0 = StringUtils.replace(s0, ""+(char)7943, ""+(char)945); //ἇ
        s0 = StringUtils.replace(s0, ""+(char)8114, ""+(char)945); //ᾲ
        s0 = StringUtils.replace(s0, ""+(char)8048, ""+(char)945); //ὰ
        s0 = StringUtils.replace(s0, ""+(char)8116, ""+(char)945); //ᾴ
        s0 = StringUtils.replace(s0, ""+(char)8049, ""+(char)945); //ά
        s0 = StringUtils.replace(s0, ""+(char)8119, ""+(char)945); //ᾷ
        s0 = StringUtils.replace(s0, ""+(char)8118, ""+(char)945); //ᾶ
        s0 = StringUtils.replace(s0, ""+(char)8115, ""+(char)945); //ᾳ
        s0 = StringUtils.replace(s0, ""+(char)8064, ""+(char)945); //ᾀ
        s0 = StringUtils.replace(s0, ""+(char)7936, ""+(char)945); //ἀ
        s0 = StringUtils.replace(s0, ""+(char)8065, ""+(char)945); //ᾁ
        s0 = StringUtils.replace(s0, ""+(char)7937, ""+(char)945); //ἁ
        
        s0 = StringUtils.replace(s0, ""+(char)7954, ""+(char)949); //ἒ
        s0 = StringUtils.replace(s0, ""+(char)7955, ""+(char)949); //ἓ
        s0 = StringUtils.replace(s0, ""+(char)8050, ""+(char)949); //ὲ
        s0 = StringUtils.replace(s0, ""+(char)7956, ""+(char)949); //ἔ
        s0 = StringUtils.replace(s0, ""+(char)7957, ""+(char)949); //ἕ
        s0 = StringUtils.replace(s0, ""+(char)8051, ""+(char)949); //έ
        s0 = StringUtils.replace(s0, ""+(char)7952, ""+(char)949); //ἐ
        s0 = StringUtils.replace(s0, ""+(char)7953, ""+(char)949); //ἑ
        
        s0 = StringUtils.replace(s0, ""+(char)8082, ""+(char)951); //ᾒ
        s0 = StringUtils.replace(s0, ""+(char)8083, ""+(char)951); //ᾓ
        s0 = StringUtils.replace(s0, ""+(char)8084, ""+(char)951); //ᾔ
        s0 = StringUtils.replace(s0, ""+(char)8085, ""+(char)951); //ᾕ
        s0 = StringUtils.replace(s0, ""+(char)8086, ""+(char)951); //ᾖ
        s0 = StringUtils.replace(s0, ""+(char)8087, ""+(char)951); //ᾗ
        s0 = StringUtils.replace(s0, ""+(char)7970, ""+(char)951); //ἢ
        s0 = StringUtils.replace(s0, ""+(char)7971, ""+(char)951); //ἣ
        s0 = StringUtils.replace(s0, ""+(char)7972, ""+(char)951); //ἤ
        s0 = StringUtils.replace(s0, ""+(char)7973, ""+(char)951); //ἥ
        s0 = StringUtils.replace(s0, ""+(char)7974, ""+(char)951); //ἦ
        s0 = StringUtils.replace(s0, ""+(char)7975, ""+(char)951); //ἧ
        s0 = StringUtils.replace(s0, ""+(char)8080, ""+(char)951); //ᾐ
        s0 = StringUtils.replace(s0, ""+(char)8081, ""+(char)951); //ᾑ
        s0 = StringUtils.replace(s0, ""+(char)8130, ""+(char)951); //ῂ
        s0 = StringUtils.replace(s0, ""+(char)8132, ""+(char)951); //ῄ
        s0 = StringUtils.replace(s0, ""+(char)8135, ""+(char)951); //ῇ
        s0 = StringUtils.replace(s0, ""+(char)8052, ""+(char)951); //ὴ
        s0 = StringUtils.replace(s0, ""+(char)8053, ""+(char)951); //ή
        s0 = StringUtils.replace(s0, ""+(char)8131, ""+(char)951); //ῃ
        s0 = StringUtils.replace(s0, ""+(char)8134, ""+(char)951); //ῆ
        s0 = StringUtils.replace(s0, ""+(char)7968, ""+(char)951); //ἠ
        s0 = StringUtils.replace(s0, ""+(char)7969, ""+(char)951); //ἡ
        
        s0 = StringUtils.replace(s0, ""+(char)7986, ""+(char)953); //ἲ
        s0 = StringUtils.replace(s0, ""+(char)7987, ""+(char)953); //ἳ
        s0 = StringUtils.replace(s0, ""+(char)7988, ""+(char)953); //ἴ
        s0 = StringUtils.replace(s0, ""+(char)7989, ""+(char)953); //ἵ
        s0 = StringUtils.replace(s0, ""+(char)8146, ""+(char)953); //ῒ
        s0 = StringUtils.replace(s0, ""+(char)8147, ""+(char)953); //ΐ
        s0 = StringUtils.replace(s0, ""+(char)7990, ""+(char)953); //ἶ
        s0 = StringUtils.replace(s0, ""+(char)7991, ""+(char)953); //ἷ
        s0 = StringUtils.replace(s0, ""+(char)8054, ""+(char)953); //ὶ
        s0 = StringUtils.replace(s0, ""+(char)8055, ""+(char)953); //ί
        s0 = StringUtils.replace(s0, ""+(char)8150, ""+(char)953); //ῖ
        s0 = StringUtils.replace(s0, ""+(char)7984, ""+(char)953); //ἰ
        s0 = StringUtils.replace(s0, ""+(char)7985, ""+(char)953); //ἱ
        s0 = StringUtils.replace(s0, ""+(char)970, ""+(char)953); //ϊ
        
        s0 = StringUtils.replace(s0, ""+(char)8004, ""+(char)959); //ὄ
        s0 = StringUtils.replace(s0, ""+(char)8005, ""+(char)959); //ὅ
        s0 = StringUtils.replace(s0, ""+(char)8002, ""+(char)959); //ὂ
        s0 = StringUtils.replace(s0, ""+(char)8003, ""+(char)959); //ὃ
        s0 = StringUtils.replace(s0, ""+(char)8056, ""+(char)959); //ὸ
        s0 = StringUtils.replace(s0, ""+(char)8057, ""+(char)959); //ό
        s0 = StringUtils.replace(s0, ""+(char)8000, ""+(char)959); //ὀ
        s0 = StringUtils.replace(s0, ""+(char)8001, ""+(char)959); //ὁ
        
        s0 = StringUtils.replace(s0, ""+(char)8165, ""+(char)961); //ῥ
        
        s0 = StringUtils.replace(s0, ""+(char)8020, ""+(char)965); //ὔ
        s0 = StringUtils.replace(s0, ""+(char)8021, ""+(char)965); //ὕ
        s0 = StringUtils.replace(s0, ""+(char)8022, ""+(char)965); //ὖ
        s0 = StringUtils.replace(s0, ""+(char)8023, ""+(char)965); //ὗ
        s0 = StringUtils.replace(s0, ""+(char)8162, ""+(char)965); //ῢ
        s0 = StringUtils.replace(s0, ""+(char)8163, ""+(char)965); //ΰ
        s0 = StringUtils.replace(s0, ""+(char)8018, ""+(char)965); //ὒ
        s0 = StringUtils.replace(s0, ""+(char)8019, ""+(char)965); //ὓ
        s0 = StringUtils.replace(s0, ""+(char)8166, ""+(char)965); //ῦ
        s0 = StringUtils.replace(s0, ""+(char)8058, ""+(char)965); //ὺ
        s0 = StringUtils.replace(s0, ""+(char)8059, ""+(char)965); //ύ
        s0 = StringUtils.replace(s0, ""+(char)8016, ""+(char)965); //ὐ
        s0 = StringUtils.replace(s0, ""+(char)8017, ""+(char)965); //ὑ
        s0 = StringUtils.replace(s0, ""+(char)971, ""+(char)965); //ϋ
        
        s0 = StringUtils.replace(s0, ""+(char)8098, ""+(char)969); //ᾢ
        s0 = StringUtils.replace(s0, ""+(char)8099, ""+(char)969); //ᾣ
        s0 = StringUtils.replace(s0, ""+(char)8100, ""+(char)969); //ᾤ
        s0 = StringUtils.replace(s0, ""+(char)8101, ""+(char)969); //ᾥ
        s0 = StringUtils.replace(s0, ""+(char)8102, ""+(char)969); //ᾦ
        s0 = StringUtils.replace(s0, ""+(char)8103, ""+(char)969); //ᾧ
        s0 = StringUtils.replace(s0, ""+(char)8178, ""+(char)969); //ῲ
        s0 = StringUtils.replace(s0, ""+(char)8180, ""+(char)969); //ῴ
        s0 = StringUtils.replace(s0, ""+(char)8096, ""+(char)969); //ᾠ
        s0 = StringUtils.replace(s0, ""+(char)8097, ""+(char)969); //ᾡ
        s0 = StringUtils.replace(s0, ""+(char)8034, ""+(char)969); //ὢ
        s0 = StringUtils.replace(s0, ""+(char)8035, ""+(char)969); //ὣ
        s0 = StringUtils.replace(s0, ""+(char)8036, ""+(char)969); //ὤ
        s0 = StringUtils.replace(s0, ""+(char)8037, ""+(char)969); //ὥ
        s0 = StringUtils.replace(s0, ""+(char)8038, ""+(char)969); //ὦ
        s0 = StringUtils.replace(s0, ""+(char)8039, ""+(char)969); //ὧ
        s0 = StringUtils.replace(s0, ""+(char)8183, ""+(char)969); //ῷ
        s0 = StringUtils.replace(s0, ""+(char)8032, ""+(char)969); //ὠ
        s0 = StringUtils.replace(s0, ""+(char)8033, ""+(char)969); //ὡ
        s0 = StringUtils.replace(s0, ""+(char)8060, ""+(char)969); //ὼ
        s0 = StringUtils.replace(s0, ""+(char)8061, ""+(char)969); //ώ
        s0 = StringUtils.replace(s0, ""+(char)8179, ""+(char)969); //ῳ
        s0 = StringUtils.replace(s0, ""+(char)8182, ""+(char)969); //ῶ
        
        return s0;
    }
}
