/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.modele.convertisseurs;

import org.apache.commons.lang.StringUtils;

/**
 *
 * @author Sam
 */
public class ConvertisseurBibleWorksVersUnicode {
    /*
     * Moyen 'élégant' de retourner la fonction pour un copier-coller facile
     */
    private static String replace(String cible, String remplacement, String motif) {
        return StringUtils.replace(cible, motif, remplacement);
    }
    
    public static String conversion(String s) {
        String s0 = s;
        
        // Tri des motifs par taille, pour éviter de remplacer des motifs 
        // courts qui sont en fait longs
        
        
        // Majuscules
        s0 = replace(s0, ""+(char)7944, "VA"); //Ἀ
        s0 = replace(s0, ""+(char)7945, "~A"); //Ἁ
        s0 = replace(s0, ""+(char)7946, "\"A"); //Ἂ
        s0 = replace(s0, ""+(char)7947, "}A"); //Ἃ
        s0 = replace(s0, ""+(char)7948, ":A"); //Ἄ
        s0 = replace(s0, ""+(char)7949, "{A"); //Ἅ
        s0 = replace(s0, ""+(char)7950, "+A"); //Ἆ
        s0 = replace(s0, ""+(char)7951, "_A"); //Ἇ
        s0 = replace(s0, ""+(char)913, "A"); //Α
        s0 = replace(s0, ""+(char)7960, "VE"); //Ἐ
        s0 = replace(s0, ""+(char)7961, "~E"); //Ἑ
        s0 = replace(s0, ""+(char)7962, "\"E"); //Ἒ
        s0 = replace(s0, ""+(char)7963, "}E"); //Ἓ
        s0 = replace(s0, ""+(char)7964, ":E"); //Ἔ
        s0 = replace(s0, ""+(char)7965, "{E"); //Ἕ
        s0 = replace(s0, ""+(char)917, "E"); //Ε
        s0 = replace(s0, ""+(char)7976, "VH"); //Ἠ
        s0 = replace(s0, ""+(char)7977, "~H"); //Ἡ
        s0 = replace(s0, ""+(char)7978, "\"H"); //Ἢ
        s0 = replace(s0, ""+(char)7979, "}H"); //Ἣ
        s0 = replace(s0, ""+(char)7980, ":H"); //Ἤ
        s0 = replace(s0, ""+(char)7981, "{H"); //Ἥ
        s0 = replace(s0, ""+(char)7982, "+H"); //Ἦ
        s0 = replace(s0, ""+(char)7983, "_H"); //Ἧ
        s0 = replace(s0, ""+(char)919, "H"); //Η
        s0 = replace(s0, ""+(char)7992, "VI"); //Ἰ
        s0 = replace(s0, ""+(char)7993, "~I"); //Ἱ
        s0 = replace(s0, ""+(char)7994, "\"I"); //Ἲ
        s0 = replace(s0, ""+(char)7995, "}I"); //Ἳ
        s0 = replace(s0, ""+(char)7996, ":I"); //Ἴ
        s0 = replace(s0, ""+(char)7997, "{I"); //Ἵ
        s0 = replace(s0, ""+(char)7998, "+I"); //Ἶ
        s0 = replace(s0, ""+(char)7999, "_I"); //Ἷ
        s0 = replace(s0, ""+(char)921, "I"); //Ι
        s0 = replace(s0, ""+(char)8008, "VO"); //Ὀ
        s0 = replace(s0, ""+(char)8009, "~O"); //Ὁ
        s0 = replace(s0, ""+(char)8010, "\"O"); //Ὂ
        s0 = replace(s0, ""+(char)8011, "}O"); //Ὃ
        s0 = replace(s0, ""+(char)8012, ":O"); //Ὄ
        s0 = replace(s0, ""+(char)8013, "{O"); //Ὅ
        s0 = replace(s0, ""+(char)927, "O"); //Ο
        s0 = replace(s0, ""+(char)8025, "~U"); //Ὑ
        s0 = replace(s0, ""+(char)8027, "}U"); //Ὓ
        s0 = replace(s0, ""+(char)8029, "{U"); //Ὕ
        s0 = replace(s0, ""+(char)8031, "_U"); //Ὗ
        s0 = replace(s0, ""+(char)933, "U"); //Υ
        s0 = replace(s0, ""+(char)8040, "VW"); //Ὠ
        s0 = replace(s0, ""+(char)8041, "~W"); //Ὡ
        s0 = replace(s0, ""+(char)8042, "\"W"); //Ὢ
        s0 = replace(s0, ""+(char)8043, "}W"); //Ὣ
        s0 = replace(s0, ""+(char)8044, ":W"); //Ὤ
        s0 = replace(s0, ""+(char)8045, "{W"); //Ὥ
        s0 = replace(s0, ""+(char)8046, "+W"); //Ὦ
        s0 = replace(s0, ""+(char)8047, "_W"); //Ὧ
        s0 = replace(s0, ""+(char)937, "W"); //Ω
        s0 = replace(s0, ""+(char)8172, "~R"); //Ῥ // pas le bon, mais pas d'ambiguité
        s0 = replace(s0, ""+(char)929, "R"); //Ρ
        
        s0 = replace(s0, ""+(char)914, "B"); //Β
        s0 = replace(s0, ""+(char)915, "G"); //Γ
        s0 = replace(s0, ""+(char)916, "D"); //Δ
        s0 = replace(s0, ""+(char)918, "Z"); //Ζ
        s0 = replace(s0, ""+(char)920, "Q"); //Θ
        s0 = replace(s0, ""+(char)922, "K"); //Κ
        s0 = replace(s0, ""+(char)923, "L"); //Λ
        s0 = replace(s0, ""+(char)924, "M"); //Μ
        s0 = replace(s0, ""+(char)925, "N"); //Ν
        s0 = replace(s0, ""+(char)926, "X"); //Ξ
        s0 = replace(s0, ""+(char)928, "P"); //Π
        s0 = replace(s0, ""+(char)931, "S"); //Σ
        s0 = replace(s0, ""+(char)932, "T"); //Τ
        s0 = replace(s0, ""+(char)934, "F"); //Φ
        s0 = replace(s0, ""+(char)935, "C"); //Χ
        s0 = replace(s0, ""+(char)936, "Y"); //Ψ
        
        // Minuscules
        s0 = replace(s0, ""+(char)8064, "av|"); //ᾀ
        s0 = replace(s0, ""+(char)7936, "av"); //ἀ
        s0 = replace(s0, ""+(char)8065, "a`|"); //ᾁ
        s0 = replace(s0, ""+(char)7937, "a`"); //ἁ
        s0 = replace(s0, ""+(char)8066, "a'|"); //ᾂ
        s0 = replace(s0, ""+(char)7938, "a'"); //ἂ
        s0 = replace(s0, ""+(char)8067, "a]|"); //ᾃ
        s0 = replace(s0, ""+(char)7939, "a]"); //ἃ
        s0 = replace(s0, ""+(char)8068, "a;|"); //ᾄ
        s0 = replace(s0, ""+(char)7940, "a;"); //ἄ
        s0 = replace(s0, ""+(char)8069, "a[|"); //ᾅ
        s0 = replace(s0, ""+(char)7941, "a["); //ἅ
        s0 = replace(s0, ""+(char)8070, "a=|"); //ᾆ
        s0 = replace(s0, ""+(char)7942, "a="); //ἆ
        s0 = replace(s0, ""+(char)8071, "a_|"); //ᾇ
        s0 = replace(s0, ""+(char)7943, "a_"); //ἇ
        s0 = replace(s0, ""+(char)8071, "a-|"); //ᾇ
        s0 = replace(s0, ""+(char)7943, "a-"); //ἇ
        s0 = replace(s0, ""+(char)8114, "a.|"); //ᾲ
        s0 = replace(s0, ""+(char)8048, "a."); //ὰ
        s0 = replace(s0, ""+(char)8116, "a,|"); //ᾴ
        s0 = replace(s0, ""+(char)8049, "a,"); //ά
        s0 = replace(s0, ""+(char)8119, "a/|"); //ᾷ
        s0 = replace(s0, ""+(char)8118, "a/"); //ᾶ
        s0 = replace(s0, ""+(char)8115, "a|"); //ᾳ
        s0 = replace(s0, ""+(char)945, "a<"); //le caractère ne semble pas exister
        s0 = replace(s0, ""+(char)945, "a>"); //le caractère ne semble pas exister
        s0 = replace(s0, ""+(char)945, "a"); //α
        
        s0 = replace(s0, ""+(char)946, "b"); //β
        s0 = replace(s0, ""+(char)947, "g"); //γ
        s0 = replace(s0, ""+(char)948, "d"); //δ
        
        s0 = replace(s0, ""+(char)7952, "ev"); //ἐ
        s0 = replace(s0, ""+(char)7953, "e`"); //ἑ
        s0 = replace(s0, ""+(char)7954, "e'"); //ἒ
        s0 = replace(s0, ""+(char)7955, "e]"); //ἓ
        s0 = replace(s0, ""+(char)7956, "e;"); //ἔ
        s0 = replace(s0, ""+(char)7957, "e["); //ἕ
        s0 = replace(s0, ""+(char)8050, "e."); //ὲ
        s0 = replace(s0, ""+(char)8051, "e,"); //έ
        s0 = replace(s0, ""+(char)949, "e"); //ε
        
        s0 = replace(s0, ""+(char)950, "z"); //ζ
        
        s0 = replace(s0, ""+(char)8080, "hv|"); //ᾐ
        s0 = replace(s0, ""+(char)7968, "hv"); //ἠ
        s0 = replace(s0, ""+(char)8081, "h`|"); //ᾑ
        s0 = replace(s0, ""+(char)7969, "h`"); //ἡ
        s0 = replace(s0, ""+(char)8082, "h'|"); //ᾒ
        s0 = replace(s0, ""+(char)7970, "h'"); //ἢ
        s0 = replace(s0, ""+(char)8083, "h]|"); //ᾓ
        s0 = replace(s0, ""+(char)7971, "h]"); //ἣ
        s0 = replace(s0, ""+(char)8084, "h;|"); //ᾔ
        s0 = replace(s0, ""+(char)7972, "h;"); //ἤ
        s0 = replace(s0, ""+(char)8085, "h[|"); //ᾕ
        s0 = replace(s0, ""+(char)7973, "h["); //ἥ
        s0 = replace(s0, ""+(char)8086, "h=|"); //ᾖ
        s0 = replace(s0, ""+(char)7974, "h="); //ἦ
        s0 = replace(s0, ""+(char)8087, "h_|"); //ᾗ
        s0 = replace(s0, ""+(char)7975, "h_"); //ἧ
        s0 = replace(s0, ""+(char)8087, "h-|"); //ᾗ
        s0 = replace(s0, ""+(char)7975, "h-"); //ἧ
        s0 = replace(s0, ""+(char)8130, "h.|"); //ῂ
        s0 = replace(s0, ""+(char)8052, "h."); //ὴ
        s0 = replace(s0, ""+(char)8132, "h,|"); //ῄ
        s0 = replace(s0, ""+(char)8053, "h,"); //ή
        s0 = replace(s0, ""+(char)8135, "h/|"); //ῇ
        s0 = replace(s0, ""+(char)8134, "h/"); //ῆ
        s0 = replace(s0, ""+(char)8131, "h|"); //ῃ
        s0 = replace(s0, ""+(char)951, "h"); //η
        
        s0 = replace(s0, ""+(char)952, "q"); //θ
        
        s0 = replace(s0, ""+(char)7984, "iv"); //ἰ
        s0 = replace(s0, ""+(char)7985, "i`"); //ἱ
        s0 = replace(s0, ""+(char)7986, "i'"); //ἲ
        s0 = replace(s0, ""+(char)7987, "i]"); //ἳ
        s0 = replace(s0, ""+(char)7988, "i;"); //ἴ
        s0 = replace(s0, ""+(char)7989, "i["); //ἵ
        s0 = replace(s0, ""+(char)7990, "i="); //ἶ
        s0 = replace(s0, ""+(char)7991, "i_"); //ἷ
        s0 = replace(s0, ""+(char)7991, "i-"); //ἷ
        s0 = replace(s0, ""+(char)8146, "i>"); //ῒ
        s0 = replace(s0, ""+(char)8147, "i<"); //ΐ
        s0 = replace(s0, ""+(char)8054, "i."); //ὶ
        s0 = replace(s0, ""+(char)8055, "i,"); //ί
        s0 = replace(s0, ""+(char)8150, "i/"); //ῖ
        s0 = replace(s0, ""+(char)970, "i?"); //ϊ
        s0 = replace(s0, ""+(char)953, "i"); //ι
        
        s0 = replace(s0, ""+(char)954, "k"); //κ
        s0 = replace(s0, ""+(char)955, "l"); //λ
        s0 = replace(s0, ""+(char)956, "m"); //μ
        s0 = replace(s0, ""+(char)957, "n"); //ν
        s0 = replace(s0, ""+(char)958, "x"); //ξ
        
        s0 = replace(s0, ""+(char)8000, "ov"); //ὀ
        s0 = replace(s0, ""+(char)8001, "o`"); //ὁ
        s0 = replace(s0, ""+(char)8002, "o'"); //ὂ
        s0 = replace(s0, ""+(char)8003, "o]"); //ὃ
        s0 = replace(s0, ""+(char)8004, "o;"); //ὄ
        s0 = replace(s0, ""+(char)8005, "o["); //ὅ
        s0 = replace(s0, ""+(char)8056, "o."); //ὸ
        s0 = replace(s0, ""+(char)8057, "o,"); //ό
        s0 = replace(s0, ""+(char)959, "o"); //ο
        
        s0 = replace(s0, ""+(char)960, "p"); //π
        
        s0 = replace(s0, ""+(char)8165, "r`"); //ῥ
        s0 = replace(s0, ""+(char)961, "r"); //ρ
        
        s0 = replace(s0, ""+(char)962, "j"); //ς
        s0 = replace(s0, ""+(char)963, "s"); //σ
        s0 = replace(s0, ""+(char)964, "t"); //τ
        
        s0 = replace(s0, ""+(char)8016, "uv"); //ὐ
        s0 = replace(s0, ""+(char)8017, "u`"); //ὑ
        s0 = replace(s0, ""+(char)8018, "u'"); //ὒ
        s0 = replace(s0, ""+(char)8019, "u]"); //ὓ
        s0 = replace(s0, ""+(char)8020, "u;"); //ὔ
        s0 = replace(s0, ""+(char)8021, "u["); //ὕ
        s0 = replace(s0, ""+(char)8022, "u="); //ὖ
        s0 = replace(s0, ""+(char)8023, "u_"); //ὗ
        s0 = replace(s0, ""+(char)8023, "u-"); //ὗ
        s0 = replace(s0, ""+(char)8162, "u>"); //ῢ
        s0 = replace(s0, ""+(char)8163, "u<"); //ΰ
        s0 = replace(s0, ""+(char)8058, "u."); //ὺ
        s0 = replace(s0, ""+(char)8059, "u,"); //ύ
        s0 = replace(s0, ""+(char)8166, "u/"); //ῦ
        s0 = replace(s0, ""+(char)971, "u?"); //ϋ
        s0 = replace(s0, ""+(char)965, "u"); //υ
        
        s0 = replace(s0, ""+(char)966, "f"); //φ
        s0 = replace(s0, ""+(char)967, "c"); //χ
        s0 = replace(s0, ""+(char)968, "y"); //ψ
        
        s0 = replace(s0, ""+(char)8096, "wv|"); //ᾠ
        s0 = replace(s0, ""+(char)8032, "wv"); //ὠ
        s0 = replace(s0, ""+(char)8097, "w`|"); //ᾡ
        s0 = replace(s0, ""+(char)8033, "w`"); //ὡ
        s0 = replace(s0, ""+(char)8098, "w'|"); //ᾢ
        s0 = replace(s0, ""+(char)8034, "w'"); //ὢ
        s0 = replace(s0, ""+(char)8099, "w]|"); //ᾣ
        s0 = replace(s0, ""+(char)8035, "w]"); //ὣ
        s0 = replace(s0, ""+(char)8100, "w;|"); //ᾤ
        s0 = replace(s0, ""+(char)8036, "w;"); //ὤ
        s0 = replace(s0, ""+(char)8101, "w[|"); //ᾥ
        s0 = replace(s0, ""+(char)8037, "w["); //ὥ
        s0 = replace(s0, ""+(char)8102, "w=|"); //ᾦ
        s0 = replace(s0, ""+(char)8038, "w="); //ὦ
        s0 = replace(s0, ""+(char)8103, "w_|"); //ᾧ
        s0 = replace(s0, ""+(char)8039, "w_"); //ὧ
        s0 = replace(s0, ""+(char)8103, "w-|"); //ᾧ
        s0 = replace(s0, ""+(char)8039, "w-"); //ὧ
        s0 = replace(s0, ""+(char)8178, "w.|"); //ῲ
        s0 = replace(s0, ""+(char)8060, "w."); //ὼ
        s0 = replace(s0, ""+(char)8180, "w,|"); //ῴ
        s0 = replace(s0, ""+(char)8061, "w,"); //ώ
        s0 = replace(s0, ""+(char)8183, "w/|"); //ῷ
        s0 = replace(s0, ""+(char)8182, "w/"); //ῶ
        s0 = replace(s0, ""+(char)8179, "w|"); //ῳ
        s0 = replace(s0, ""+(char)969, "w"); //ω
        
        
        // Ponctuation
        s0 = replace(s0, ";\"", "ȹ");
        s0 = replace(s0, "+", "!");
        s0 = replace(s0, "[", "@");
        s0 = replace(s0, "]", "#");
        s0 = replace(s0, "(", "$");
        s0 = replace(s0, ")", "%");
        s0 = replace(s0, ";", "*");
        s0 = replace(s0, "*", "^");
        s0 = replace(s0, ",", "(");
        s0 = replace(s0, ".", ")");
        s0 = replace(s0, "·", "\\");
        s0 = replace(s0, "\"", "Ź");
        s0 = replace(s0, "'", "V"); // apostrophe
        s0 = replace(s0, "'", "v"); // apostrophe aussi
        
        /// Caractères qui ont... subitement apparu. Problème d'encodage ?
        s0 = replace(s0, "", "Å");
        s0 = replace(s0, "", "È");
        s0 = replace(s0, "", "Î");
        s0 = replace(s0, "", "Ð");
        s0 = replace(s0, "", "¿");
        s0 = replace(s0, "", "À");
        
        
        // Tirets : à conserver uniquement au milieu des mots
        s0 = replace(s0, "-", "&");
        s0 = replace(s0, "", "-1");
        s0 = replace(s0, "", "-2");
        s0 = replace(s0, " ", " -");
        s0 = replace(s0, " ", "- ");
        if(!s0.isEmpty()) {
            if(s0.charAt(0) == '-') {
                s0 = s0.substring(1);
            }
            if(s0.charAt(s0.length()-1) == '-') {
                s0 = s0.substring(0, s0.length()-1);
            }
        }
        
        // Chiffres latins : à supprimer (différenciation des lemmes)
        s0 = s0.replaceAll("[0-9]", "");
        
        

        
        return ConvertisseurTexteUnicodeVersUnicode.conversion(s0, false);
    }
    
}

/**** Plages unicode ****/

/*  900-999
  900 : ΄  901 : ΅  902 : Ά  903 : ·  904 : Έ  905 : Ή  906 : Ί  907 : ΋  908 : Ό  909 : ΍
  910 : Ύ  911 : Ώ  912 : ΐ  913 : Α  914 : Β  915 : Γ  916 : Δ  917 : Ε  918 : Ζ  919 : Η
  920 : Θ  921 : Ι  922 : Κ  923 : Λ  924 : Μ  925 : Ν  926 : Ξ  927 : Ο  928 : Π  929 : Ρ
  930 : ΢  931 : Σ  932 : Τ  933 : Υ  934 : Φ  935 : Χ  936 : Ψ  937 : Ω  938 : Ϊ  939 : Ϋ
  940 : ά  941 : έ  942 : ή  943 : ί  944 : ΰ  945 : α  946 : β  947 : γ  948 : δ  949 : ε
  950 : ζ  951 : η  952 : θ  953 : ι  954 : κ  955 : λ  956 : μ  957 : ν  958 : ξ  959 : ο
  960 : π  961 : ρ  962 : ς  963 : σ  964 : τ  965 : υ  966 : φ  967 : χ  968 : ψ  969 : ω
  970 : ϊ  971 : ϋ  972 : ό  973 : ύ  974 : ώ  975 : Ϗ  976 : ϐ  977 : ϑ  978 : ϒ  981 : ϕ
  981 : ϕ  981 : ϕ  982 : ϖ  983 : ϗ  984 : Ϙ  985 : ϙ  986 : Ϛ  987 : ϛ  988 : Ϝ  989 : ϝ
  990 : Ϟ  991 : ϟ  992 : Ϡ  993 : ϡ  994 : Ϣ  995 : ϣ  996 : Ϥ  997 : ϥ  998 : Ϧ  999 : ϧ
*/

/*  7900-7999
  7900 : Ờ  7901 : ờ  7902 : Ở  7903 : ở  7904 : Ỡ  7905 : ỡ  7906 : Ợ  7907 : ợ  7908 : Ụ  7909 : ụ
  7910 : Ủ  7911 : ủ  7912 : Ứ  7913 : ứ  7914 : Ừ  7915 : ừ  7916 : Ử  7917 : ử  7918 : Ữ  7919 : ữ
  7920 : Ự  7921 : ự  7922 : Ỳ  7923 : ỳ  7924 : Ỵ  7925 : ỵ  7926 : Ỷ  7927 : ỷ  7928 : Ỹ  7929 : ỹ
  7930 : Ỻ  7931 : ỻ  7932 : Ỽ  7933 : ỽ  7934 : Ỿ  7935 : ỿ  7936 : ἀ  7937 : ἁ  7938 : ἂ  7939 : ἃ
  7940 : ἄ  7941 : ἅ  7942 : ἆ  7943 : ἇ  7944 : Ἀ  7945 : Ἁ  7946 : Ἂ  7947 : Ἃ  7948 : Ἄ  7949 : Ἅ
  7950 : Ἆ  7951 : Ἇ  7952 : ἐ  7953 : ἑ  7954 : ἒ  7955 : ἓ  7956 : ἔ  7957 : ἕ  7958 : ἖  7959 : ἗
  7960 : Ἐ  7961 : Ἑ  7962 : Ἒ  7963 : Ἓ  7964 : Ἔ  7965 : Ἕ  7966 : ἞  7967 : ἟  7968 : ἠ  7969 : ἡ
  7970 : ἢ  7971 : ἣ  7972 : ἤ  7973 : ἥ  7974 : ἦ  7975 : ἧ  7976 : Ἠ  7977 : Ἡ  7978 : Ἢ  7981 : Ἥ
  7981 : Ἥ  7981 : Ἥ  7982 : Ἦ  7983 : Ἧ  7984 : ἰ  7985 : ἱ  7986 : ἲ  7987 : ἳ  7988 : ἴ  7989 : ἵ
  7990 : ἶ  7991 : ἷ  7992 : Ἰ  7993 : Ἱ  7994 : Ἲ  7995 : Ἳ  7996 : Ἴ  7997 : Ἵ  7998 : Ἶ  7999 : Ἷ
*/

/*  8000-8099
  8000 : ὀ  8001 : ὁ  8002 : ὂ  8003 : ὃ  8004 : ὄ  8005 : ὅ  8006 : ὆  8007 : ὇  8008 : Ὀ  8009 : Ὁ
  8010 : Ὂ  8011 : Ὃ  8012 : Ὄ  8013 : Ὅ  8014 : ὎  8015 : ὏  8016 : ὐ  8017 : ὑ  8018 : ὒ  8019 : ὓ
  8020 : ὔ  8021 : ὕ  8022 : ὖ  8023 : ὗ  8024 : ὘  8025 : Ὑ  8026 : ὚  8027 : Ὓ  8028 : ὜  8029 : Ὕ
  8030 : ὞  8031 : Ὗ  8032 : ὠ  8033 : ὡ  8034 : ὢ  8035 : ὣ  8036 : ὤ  8037 : ὥ  8038 : ὦ  8039 : ὧ
  8040 : Ὠ  8041 : Ὡ  8042 : Ὢ  8043 : Ὣ  8044 : Ὤ  8045 : Ὥ  8046 : Ὦ  8047 : Ὧ  8048 : ὰ  8049 : ά
  8050 : ὲ  8051 : έ  8052 : ὴ  8053 : ή  8054 : ὶ  8055 : ί  8056 : ὸ  8057 : ό  8058 : ὺ  8059 : ύ
  8060 : ὼ  8061 : ώ  8062 : ὾  8063 : ὿  8064 : ᾀ  8065 : ᾁ  8066 : ᾂ  8067 : ᾃ  8068 : ᾄ  8069 : ᾅ
  8070 : ᾆ  8071 : ᾇ  8072 : ᾈ  8073 : ᾉ  8074 : ᾊ  8075 : ᾋ  8076 : ᾌ  8077 : ᾍ  8078 : ᾎ  8081 : ᾑ
  8081 : ᾑ  8081 : ᾑ  8082 : ᾒ  8083 : ᾓ  8084 : ᾔ  8085 : ᾕ  8086 : ᾖ  8087 : ᾗ  8088 : ᾘ  8089 : ᾙ
  8090 : ᾚ  8091 : ᾛ  8092 : ᾜ  8093 : ᾝ  8094 : ᾞ  8095 : ᾟ  8096 : ᾠ  8097 : ᾡ  8098 : ᾢ  8099 : ᾣ
*/

/*  8100-8199
  8100 : ᾤ  8101 : ᾥ  8102 : ᾦ  8103 : ᾧ  8104 : ᾨ  8105 : ᾩ  8106 : ᾪ  8107 : ᾫ  8108 : ᾬ  8109 : ᾭ
  8110 : ᾮ  8111 : ᾯ  8112 : ᾰ  8113 : ᾱ  8114 : ᾲ  8115 : ᾳ  8116 : ᾴ  8117 : ᾵  8118 : ᾶ  8119 : ᾷ
  8120 : Ᾰ  8121 : Ᾱ  8122 : Ὰ  8123 : Ά  8124 : ᾼ  8125 : ᾽  8126 : ι  8127 : ᾿  8128 : ῀  8129 : ῁
  8130 : ῂ  8131 : ῃ  8132 : ῄ  8133 : ῅  8134 : ῆ  8135 : ῇ  8136 : Ὲ  8137 : Έ  8138 : Ὴ  8139 : Ή
  8140 : ῌ  8141 : ῍  8142 : ῎  8143 : ῏  8144 : ῐ  8145 : ῑ  8146 : ῒ  8147 : ΐ  8148 : ῔  8149 : ῕
  8150 : ῖ  8151 : ῗ  8152 : Ῐ  8153 : Ῑ  8154 : Ὶ  8155 : Ί  8156 : ῜  8157 : ῝  8158 : ῞  8159 : ῟
  8160 : ῠ  8161 : ῡ  8162 : ῢ  8163 : ΰ  8164 : ῤ  8165 : ῥ  8166 : ῦ  8167 : ῧ  8168 : Ῠ  8169 : Ῡ
  8170 : Ὺ  8171 : Ύ  8172 : Ῥ  8173 : ῭  8174 : ΅  8175 : `  8176 : ῰  8177 : ῱  8178 : ῲ  8181 : ῵
  8181 : ῵  8181 : ῵  8182 : ῶ  8183 : ῷ  8184 : Ὸ  8185 : Ό  8186 : Ὼ  8187 : Ώ  8188 : ῼ  8189 : ´
  8190 : ῾  8191 : ῿  8192 :    8193 :    8194 :    8195 :    8196 :    8197 :    8198 :    8199 :  
*/