/*
Copyright 2012-2014 Samuel Gesche

This file is part of the Greek Reuse Toolkit.

The Greek Reuse Toolkit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

The Greek Reuse Toolkit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the Greek Reuse Toolkit.  If not, see <http://www.gnu.org/licenses/>.
*/

package fr.cnrs.liris.drim.grt.ihm;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Toolkit;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import fr.cnrs.liris.drim.grt.modele.Coordonnee;
import fr.cnrs.liris.drim.grt.modele.OrdreStrict;
import fr.cnrs.liris.drim.grt.modele.Passage;
import fr.cnrs.liris.drim.grt.modele.Terme;
import fr.cnrs.liris.drim.grt.modele.lemmatiseurs.BibleWorks;
import fr.cnrs.liris.drim.grt.modele.lemmatiseurs.SourcesChretiennes;
import fr.cnrs.liris.drim.grt.modele.listes.LemmesUsuels;
import fr.cnrs.liris.drim.grt.modele.listes.LemmesVides;
import fr.cnrs.liris.drim.grt.modele.listes.NomsPropres;
import org.apache.commons.lang.StringUtils;
import fr.cnrs.liris.drim.grt.proc.Texte;
import fr.cnrs.liris.drim.grt.proc.parsers.ImportFichier;
import fr.cnrs.liris.drim.grt.modele.listes.OrdreAlphabetiqueGrec;
import fr.cnrs.liris.drim.grt.proc.parsers.PassageType;
import fr.cnrs.liris.drim.grt.proc.parsers.References;
import fr.cnrs.liris.drim.grt.proc.parsers.Temps;
import fr.cnrs.liris.drim.grt.proc.parsers.Textes;

/**
 *
 * @author Sam
 */
public class FenetreLemmatiseur extends javax.swing.JFrame {
    public Passage aEtudier = null;
    
    /**
     * Creates new form FenetreLemmatiseur
     */
    public FenetreLemmatiseur() {
        initComponents();
        this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        jSplitPane1.setDividerLocation(Toolkit.getDefaultToolkit().getScreenSize().width*4/5);
        
        Font grec = new Font("GFS DidotClassic", Font.PLAIN, 16);
        try {
            grec = Font.createFont(Font.TRUETYPE_FONT, new File("GFSDidot-Regular.ttf")).deriveFont(Font.PLAIN, 16f);
        } catch (FontFormatException | IOException ex) {
            lStatut.setText(ex.getClass() + " : " + ex.getMessage());
        }
        lemTexteEntre.setFont(grec);
        lemTexteEntre.setContentType("text/plain");
        lemTexteSortie.setFont(grec);
        lemTexteSortie.setContentType("text/plain");
        lemListeLemmesParTerme.setFont(grec);
        lemListeLemmesParTerme.setContentType("text/plain");
        lemListeTermesParLemme.setFont(grec);
        lemListeTermesParLemme.setContentType("text/plain");
        lemListeNomsPropres.setFont(grec);
        lemListeNomsPropres.setContentType("text/plain");
        tRechercheLpT.setFont(grec);
        tRechercheTpL.setFont(grec);
        tRechercheNp.setFont(grec);
        tRechercheTexteBrut.setFont(grec);
        tRechercheTexteTraite.setFont(grec);
        Map<String, String[]> liste = SourcesChretiennes.getInstance().getListe();
        Terme[] liste2 = NomsPropres.getInstance().getListe();
        chargerLemmesParTerme(liste);
        chargerTermesParLemme(liste);
        chargerNomsPropres(liste2);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel25 = new javax.swing.JPanel();
        jPanel27 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jPanel28 = new javax.swing.JPanel();
        jPanel29 = new javax.swing.JPanel();
        bRemarques = new javax.swing.JButton();
        jPanel30 = new javax.swing.JPanel();
        bFAQ = new javax.swing.JButton();
        jSplitPane1 = new javax.swing.JSplitPane();
        jPanel6 = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        lemTexteEntre = new javax.swing.JEditorPane();
        jPanel4 = new javax.swing.JPanel();
        jPanel24 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        lemChargerRTF = new javax.swing.JButton();
        bViderTexteEntre = new javax.swing.JButton();
        lStatut = new javax.swing.JLabel();
        jPanel23 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        tRechercheTexteBrut = new javax.swing.JTextField();
        bRechercheTexteBrut = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        lemTexteSortie = new javax.swing.JEditorPane();
        jPanel3 = new javax.swing.JPanel();
        jPanel12 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        lemLemmatiser = new javax.swing.JButton();
        lemLemmatiser2 = new javax.swing.JButton();
        lemLemmesInconnus = new javax.swing.JButton();
        statutSortie = new javax.swing.JLabel();
        jPanel26 = new javax.swing.JPanel();
        bIndexDesLemmes = new javax.swing.JButton();
        bIndexDesLemmesAvecFormes = new javax.swing.JButton();
        bExporter = new javax.swing.JButton();
        jPanel13 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        tRechercheTexteTraite = new javax.swing.JTextField();
        bRechercheTexteTraite = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel7 = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        lemListeLemmesParTerme = new javax.swing.JEditorPane();
        jPanel10 = new javax.swing.JPanel();
        jPanel14 = new javax.swing.JPanel();
        lStatutLemmesParTerme = new javax.swing.JLabel();
        jPanel15 = new javax.swing.JPanel();
        tRechercheLpT = new javax.swing.JTextField();
        bRechercheLpT = new javax.swing.JButton();
        jPanel9 = new javax.swing.JPanel();
        lemModifierListeLpT = new javax.swing.JButton();
        lemSaveLpTPossible = new javax.swing.JLabel();
        jPanel5 = new javax.swing.JPanel();
        jPanel11 = new javax.swing.JPanel();
        jPanel16 = new javax.swing.JPanel();
        lStatutTermesParLemme = new javax.swing.JLabel();
        jPanel17 = new javax.swing.JPanel();
        tRechercheTpL = new javax.swing.JTextField();
        bRechercheTpL = new javax.swing.JButton();
        jScrollPane4 = new javax.swing.JScrollPane();
        lemListeTermesParLemme = new javax.swing.JEditorPane();
        jPanel8 = new javax.swing.JPanel();
        lemModifierListeTpL = new javax.swing.JButton();
        lemSaveTpLPossible = new javax.swing.JLabel();
        jPanel18 = new javax.swing.JPanel();
        jPanel19 = new javax.swing.JPanel();
        jPanel20 = new javax.swing.JPanel();
        lStatutNomsPropres = new javax.swing.JLabel();
        jPanel21 = new javax.swing.JPanel();
        tRechercheNp = new javax.swing.JTextField();
        bRechercheNp = new javax.swing.JButton();
        jScrollPane5 = new javax.swing.JScrollPane();
        lemListeNomsPropres = new javax.swing.JEditorPane();
        jPanel22 = new javax.swing.JPanel();
        lemModifierListeNp = new javax.swing.JButton();
        lemSaveNpPossible = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Greek Reuse Toolkit - Lemmatiseur");

        jPanel25.setLayout(new java.awt.GridLayout(1, 1, 10, 10));

        jPanel27.setLayout(new java.awt.BorderLayout());

        jLabel1.setText("<html><p>Bienvenue dans le lemmatiseur de <i>Greek Quotation Toolkit</i></p><p>A gauche, vous pouvez analyser un texte : chargez ou copiez un texte en haut, et choisissez dans les boutons du milieu l'analyse que vous souhaitez effectuer.</p><p>A droite, vous pouvez gérer la liste des lemmes. Cette liste peut être modifiée, n'hésitez donc pas à l'enrichir ou à la corriger.</p><p>Vous pouvez librement copier-coller d'une zone à l'autre en utilisant ctrl-c / ctrl-v.</p></html>");
        jPanel27.add(jLabel1, java.awt.BorderLayout.CENTER);

        jPanel28.setLayout(new java.awt.GridLayout(2, 1));

        bRemarques.setText("Mes remarques");
        bRemarques.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bRemarquesActionPerformed(evt);
            }
        });
        jPanel29.add(bRemarques);

        jPanel28.add(jPanel29);

        bFAQ.setText("FAQ");
        bFAQ.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bFAQActionPerformed(evt);
            }
        });
        jPanel30.add(bFAQ);

        jPanel28.add(jPanel30);

        jPanel27.add(jPanel28, java.awt.BorderLayout.EAST);

        jPanel25.add(jPanel27);

        getContentPane().add(jPanel25, java.awt.BorderLayout.NORTH);

        jSplitPane1.setDividerLocation(1000);

        jPanel6.setLayout(new java.awt.GridLayout(2, 1));

        jPanel1.setLayout(new java.awt.BorderLayout());

        jScrollPane1.setViewportView(lemTexteEntre);

        jPanel1.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jPanel4.setLayout(new java.awt.GridLayout(2, 1));

        jLabel2.setText("Je souhaite...");
        jPanel24.add(jLabel2);

        jButton1.setText("Copier un texte directement ci-dessous");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        jPanel24.add(jButton1);

        lemChargerRTF.setText("Charger un fichier du TLG");
        lemChargerRTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lemChargerRTFActionPerformed(evt);
            }
        });
        jPanel24.add(lemChargerRTF);

        bViderTexteEntre.setText("Supprimer le texte ci-dessous");
        bViderTexteEntre.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bViderTexteEntreActionPerformed(evt);
            }
        });
        jPanel24.add(bViderTexteEntre);
        jPanel24.add(lStatut);

        jPanel4.add(jPanel24);

        jLabel3.setText("J'aimerais trouver ci-dessous : ");
        jPanel23.add(jLabel3);

        tRechercheTexteBrut.setColumns(10);
        jPanel23.add(tRechercheTexteBrut);

        bRechercheTexteBrut.setText("Rechercher");
        bRechercheTexteBrut.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bRechercheTexteBrutActionPerformed(evt);
            }
        });
        jPanel23.add(bRechercheTexteBrut);

        jPanel4.add(jPanel23);

        jPanel1.add(jPanel4, java.awt.BorderLayout.NORTH);

        jPanel6.add(jPanel1);

        jPanel2.setLayout(new java.awt.BorderLayout());

        jScrollPane2.setViewportView(lemTexteSortie);

        jPanel2.add(jScrollPane2, java.awt.BorderLayout.CENTER);

        jPanel3.setLayout(new java.awt.GridLayout(3, 1));

        jLabel5.setText("Je souhaite obtenir : ");
        jPanel12.add(jLabel5);

        lemLemmatiser.setText("mot par mot, le texte lemmatisé");
        lemLemmatiser.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lemLemmatiserActionPerformed(evt);
            }
        });
        jPanel12.add(lemLemmatiser);

        lemLemmatiser2.setText("ligne par ligne, le texte et ses lemmes");
        lemLemmatiser2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lemLemmatiser2ActionPerformed(evt);
            }
        });
        jPanel12.add(lemLemmatiser2);

        lemLemmesInconnus.setText("la liste des termes dont le lemme manque encore");
        lemLemmesInconnus.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lemLemmesInconnusActionPerformed(evt);
            }
        });
        jPanel12.add(lemLemmesInconnus);
        jPanel12.add(statutSortie);

        jPanel3.add(jPanel12);

        bIndexDesLemmes.setText("l'index des lemmes du texte");
        bIndexDesLemmes.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bIndexDesLemmesActionPerformed(evt);
            }
        });
        jPanel26.add(bIndexDesLemmes);

        bIndexDesLemmesAvecFormes.setText("l'index des lemmes du texte avec leurs formes");
        bIndexDesLemmesAvecFormes.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bIndexDesLemmesAvecFormesActionPerformed(evt);
            }
        });
        jPanel26.add(bIndexDesLemmesAvecFormes);

        bExporter.setText("un fichier contenant ce qui est affiché ci-dessous");
        bExporter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bExporterActionPerformed(evt);
            }
        });
        jPanel26.add(bExporter);

        jPanel3.add(jPanel26);

        jLabel4.setText("J'aimerais trouver ci-dessous : ");
        jPanel13.add(jLabel4);

        tRechercheTexteTraite.setColumns(10);
        jPanel13.add(tRechercheTexteTraite);

        bRechercheTexteTraite.setText("Rechercher");
        bRechercheTexteTraite.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bRechercheTexteTraiteActionPerformed(evt);
            }
        });
        jPanel13.add(bRechercheTexteTraite);

        jPanel3.add(jPanel13);

        jPanel2.add(jPanel3, java.awt.BorderLayout.PAGE_START);

        jPanel6.add(jPanel2);

        jSplitPane1.setLeftComponent(jPanel6);

        jPanel7.setLayout(new java.awt.BorderLayout());

        jScrollPane3.setViewportView(lemListeLemmesParTerme);

        jPanel7.add(jScrollPane3, java.awt.BorderLayout.CENTER);

        jPanel10.setLayout(new java.awt.GridLayout(2, 1));

        lStatutLemmesParTerme.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lStatutLemmesParTerme.setText("Liste des lemmes par terme");
        jPanel14.add(lStatutLemmesParTerme);

        jPanel10.add(jPanel14);

        tRechercheLpT.setColumns(10);
        jPanel15.add(tRechercheLpT);

        bRechercheLpT.setText("Rechercher");
        bRechercheLpT.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bRechercheLpTActionPerformed(evt);
            }
        });
        jPanel15.add(bRechercheLpT);

        jPanel10.add(jPanel15);

        jPanel7.add(jPanel10, java.awt.BorderLayout.NORTH);

        lemModifierListeLpT.setText("Enregistrer les modifications");
        lemModifierListeLpT.setEnabled(false);
        lemModifierListeLpT.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lemModifierListeLpTActionPerformed(evt);
            }
        });
        jPanel9.add(lemModifierListeLpT);

        lemSaveLpTPossible.setText("(possible)");
        jPanel9.add(lemSaveLpTPossible);

        jPanel7.add(jPanel9, java.awt.BorderLayout.SOUTH);

        jTabbedPane1.addTab("Lemmes par terme", jPanel7);

        jPanel5.setLayout(new java.awt.BorderLayout());

        jPanel11.setLayout(new java.awt.GridLayout(2, 1));

        lStatutTermesParLemme.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lStatutTermesParLemme.setText("Liste des termes par lemme");
        jPanel16.add(lStatutTermesParLemme);

        jPanel11.add(jPanel16);

        tRechercheTpL.setColumns(10);
        jPanel17.add(tRechercheTpL);

        bRechercheTpL.setText("Rechercher");
        bRechercheTpL.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bRechercheTpLActionPerformed(evt);
            }
        });
        jPanel17.add(bRechercheTpL);

        jPanel11.add(jPanel17);

        jPanel5.add(jPanel11, java.awt.BorderLayout.NORTH);

        jScrollPane4.setViewportView(lemListeTermesParLemme);

        jPanel5.add(jScrollPane4, java.awt.BorderLayout.CENTER);

        lemModifierListeTpL.setText("Enregistrer les modifications");
        lemModifierListeTpL.setEnabled(false);
        lemModifierListeTpL.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lemModifierListeTpLActionPerformed(evt);
            }
        });
        jPanel8.add(lemModifierListeTpL);

        lemSaveTpLPossible.setText("(possible)");
        jPanel8.add(lemSaveTpLPossible);

        jPanel5.add(jPanel8, java.awt.BorderLayout.PAGE_END);

        jTabbedPane1.addTab("Termes par lemme", jPanel5);

        jPanel18.setLayout(new java.awt.BorderLayout());

        jPanel19.setLayout(new java.awt.GridLayout(2, 1));

        lStatutNomsPropres.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lStatutNomsPropres.setText("Liste des noms propres");
        jPanel20.add(lStatutNomsPropres);

        jPanel19.add(jPanel20);

        tRechercheNp.setColumns(10);
        jPanel21.add(tRechercheNp);

        bRechercheNp.setText("Rechercher");
        bRechercheNp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bRechercheNpActionPerformed(evt);
            }
        });
        jPanel21.add(bRechercheNp);

        jPanel19.add(jPanel21);

        jPanel18.add(jPanel19, java.awt.BorderLayout.NORTH);

        jScrollPane5.setViewportView(lemListeNomsPropres);

        jPanel18.add(jScrollPane5, java.awt.BorderLayout.CENTER);

        lemModifierListeNp.setText("Enregistrer les modifications");
        lemModifierListeNp.setEnabled(false);
        lemModifierListeNp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lemModifierListeNpActionPerformed(evt);
            }
        });
        jPanel22.add(lemModifierListeNp);

        lemSaveNpPossible.setText("(possible)");
        jPanel22.add(lemSaveNpPossible);

        jPanel18.add(jPanel22, java.awt.BorderLayout.PAGE_END);

        jTabbedPane1.addTab("Noms propres", jPanel18);

        jSplitPane1.setRightComponent(jTabbedPane1);

        getContentPane().add(jSplitPane1, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    
    private void lemLemmatiserActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lemLemmatiserActionPerformed
        // TODO add your handling code here:
        statutSortie.setText("En cours");
        String[] lignes;
        if(aEtudier != null) {
            lignes = new Texte(aEtudier).getTexte().replaceAll("[<>]", "").replaceAll("ϕ", "φ").replaceAll(" {0,}\\.{2,} {0,2}", " ").split("\n");
        } else {
            lignes = lemTexteEntre.getText().replaceAll("[<>]", "").replaceAll("ϕ", "φ").replaceAll(" {0,}\\.{2,} {0,2}", " ").split("\n");
        }
        String resultat = "";
        for(int a=0; a<lignes.length; a++) {
            String ligne = lignes[a].trim();
            String[] mots = ligne.split(" ");
            ArrayList<String> resultat2 = new ArrayList<>();
            for(int i=0; i<mots.length; i++) {
                String aLemmatiser = Textes.supprimeMajuscules(Textes.nettoieTerme(mots[i].trim()).replaceAll("[\\.;0-9a-zA-Z\\&\"]", ""));
                if(!aLemmatiser.isEmpty()) {
                    String[] lemmes = SourcesChretiennes.getInstance().getFormesLemmatisees(aLemmatiser);
                    String res = "";
                    if(lemmes.length<1) {
                        res += aLemmatiser + " = ?";
                    } else {
                        res += aLemmatiser + " = " + lemmes[0];
                    }
                    if(lemmes.length>1) {
                        for(int j=1; j<lemmes.length; j++) {
                            res += ", " + lemmes[j];
                        }
                    }
                    resultat2.add(res);
                }
            }
            String resultat0 = "";
            for(int i=0; i<resultat2.size(); i++) {
                resultat0 += resultat2.get(i);
                if(i < resultat2.size()-1) {
                    resultat0 += "\n";
                }
            }
            resultat += resultat0 + "\n";
        }
        lemTexteSortie.setText(resultat);
        statutSortie.setText("");
    }//GEN-LAST:event_lemLemmatiserActionPerformed

    private void lemLemmatiser2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lemLemmatiser2ActionPerformed
        // TODO add your handling code here:
        statutSortie.setText("En cours");
        String[] lignes;
        if(aEtudier != null) {
            lignes = aEtudier.getTexteCompletSansMots().replaceAll("<.*?>", "").replaceAll("[<>]", "").replaceAll("ϕ", "φ").replaceAll(" {0,}\\.{2,} {0,2}", " ").split("\n");
        } else {
            lignes = lemTexteEntre.getText().replaceAll("[<>]", "").replaceAll("ϕ", "φ").replaceAll(" {0,}\\.{2,} {0,2}", " ").split("\n");
        }
        String resultat = "";
        for(int a=0; a<lignes.length; a++) {
            String ligne = lignes[a];
            if(!ligne.trim().isEmpty()) {
                String[] mots = ligne.split(" ");
                ArrayList<String> resultat2 = new ArrayList<>();
                for(int i=0; i<mots.length; i++) {
                    String aLemmatiser = Textes.supprimeMajuscules(Textes.nettoieTerme(mots[i].trim()).replaceAll("[\\.;0-9a-zA-Z\\&\"]", ""));
                    if(!aLemmatiser.isEmpty()) {
                        String[] lemmes = SourcesChretiennes.getInstance().getFormesLemmatisees(aLemmatiser);
                        String res = "";
                        if(lemmes.length<1) {
                            res += aLemmatiser + " = ?";
                        } else {
                            res += aLemmatiser + " = " + lemmes[0];
                        }
                        if(lemmes.length>1) {
                            for(int j=1; j<lemmes.length; j++) {
                                res += ", " + lemmes[j];
                            }
                        }
                        resultat2.add(res);
                    }
                }
                String resultat0 = "";
                for(int i=0; i<resultat2.size(); i++) {
                    resultat0 += resultat2.get(i);
                    if(i < resultat2.size()-1) {
                        resultat0 += "\n";
                    }
                }
                resultat += ligne.trim() + "\n" + resultat0 + "\n\n";
            }
        }
        lemTexteSortie.setText(resultat);
        statutSortie.setText("");
    }//GEN-LAST:event_lemLemmatiser2ActionPerformed

    private void lemLemmesInconnusActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lemLemmesInconnusActionPerformed
        // TODO add your handling code here:
        statutSortie.setText("En cours");
        String[] lignes;
        if(aEtudier != null) {
            lignes = new Texte(aEtudier).getTexte().replaceAll("[<>]", "").replaceAll("ϕ", "φ").replaceAll(" {0,}\\.{2,} {0,2}", " ").split("\n");
        } else {
            lignes = lemTexteEntre.getText().replaceAll("[<>]", "").replaceAll("ϕ", "φ").replaceAll(" {0,}\\.{2,} {0,2}", " ").split("\n");
        }
        String resultat = "";
        Set<String> resultat2 = new HashSet<>();
        for(int a=0; a<lignes.length; a++) {
            String ligne = lignes[a];
            String[] mots = ligne.split(" ");
            for(int i=0; i<mots.length; i++) {
                String aLemmatiser = Textes.supprimeMajuscules(Textes.nettoieTerme(mots[i].trim()).replaceAll("[\\.;0-9a-zA-Z\\&\"]", ""));
                if(!aLemmatiser.isEmpty()) {
                    String[] lemmes = SourcesChretiennes.getInstance().getFormesLemmatisees(aLemmatiser);
                    if(lemmes.length<1) {
                        resultat2.add(aLemmatiser + " = ?");
                    }
                }
            }
        }
        String[] resultat3 = new String[resultat2.size()];
        resultat2.toArray(resultat3);
        Arrays.sort(resultat3, new OrdreAlphabetiqueGrec());
        String resultat0 = "";
        for(int i=0; i<resultat3.length; i++) {
            resultat0 += resultat3[i] + "\n";
        }
        resultat += resultat0;
        lemTexteSortie.setText(resultat);
        statutSortie.setText(resultat3.length+" lemmes inconnus");
    }//GEN-LAST:event_lemLemmesInconnusActionPerformed

    private void lemChargerRTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lemChargerRTFActionPerformed
        // TODO add your handling code here:
        JFileChooser loader = new JFileChooser();
        if(loader.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            final File toLoad = loader.getSelectedFile();
            lStatut.setText("Lecture en cours");
            lemTexteEntre.setText("");
            new Thread() {
                @Override
                public void run() {
                    try {
                        aEtudier = ImportFichier.importPatristiqueRTF(toLoad);
                        lStatut.setText("Test de charge en cours");
                        String s = aEtudier.getTexteCompletMisEnForme();
                        lStatut.setText("Affichage en cours");
                        lemTexteEntre.setText(s);
                        lemTexteEntre.setEditable(false);
                        lStatut.setText(s.length() + " caractères");
                    } catch(IOException | BadLocationException ioe) {
                        lStatut.setText(ioe.getClass() + " : " + ioe.getMessage());
                    }
                }
            }.start();
        }
    }//GEN-LAST:event_lemChargerRTFActionPerformed

    private void lemModifierListeLpTActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lemModifierListeLpTActionPerformed
        // TODO add your handling code here:
        lStatut.setText("Sauvegarde de l'ancienne liste");
        sauvegarderListeLemmes();
        lStatut.setText("Correction de la liste");
        if(lemListeLemmesParTerme.isEditable()) {
            Map<String, String[]> nouvelleListe = new HashMap<>();
            String[] listeLemmesStr = lemListeLemmesParTerme.getText().split("\n");
            for(String lemmeStr: listeLemmesStr) {
                String[] termeEtLemmes = lemmeStr.split("=");
                String[] lemmes = termeEtLemmes[1].split(",");
                for(int i=0; i<lemmes.length; i++) {
                    lemmes[i] = lemmes[i].trim();
                }
                if(!termeEtLemmes[0].trim().isEmpty() && lemmes.length>0 && !nouvelleListe.containsKey(termeEtLemmes[0].trim())) {
                    nouvelleListe.put(termeEtLemmes[0].trim(), lemmes);
                } else {
                    System.err.println("pas pris en compte : " + lemmeStr);
                }
            }
            System.err.println(nouvelleListe.keySet().size());
            SourcesChretiennes.getInstance().corrigeListe(nouvelleListe);
            chargerLemmesParTerme(SourcesChretiennes.getInstance().getListe());
            chargerTermesParLemme(SourcesChretiennes.getInstance().getListe());
        }
        lStatut.setText("Terminé");
    }//GEN-LAST:event_lemModifierListeLpTActionPerformed

    private void bRechercheLpTActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bRechercheLpTActionPerformed
        // TODO add your handling code here:
        String texte = lemListeLemmesParTerme.getText();
        int selectionActuelle = lemListeLemmesParTerme.getSelectionStart();
        int nouvelleSelection = texte.indexOf(tRechercheLpT.getText(), selectionActuelle+1);
        if(nouvelleSelection >= 0) {
            lemListeLemmesParTerme.setSelectionEnd(nouvelleSelection + tRechercheLpT.getText().length());
            lemListeLemmesParTerme.setSelectionStart(nouvelleSelection);
        } else {
            nouvelleSelection = texte.indexOf(tRechercheLpT.getText(), 0);
            if(nouvelleSelection >= 0) {
                lemListeLemmesParTerme.setSelectionEnd(nouvelleSelection + tRechercheLpT.getText().length());
                lemListeLemmesParTerme.setSelectionStart(nouvelleSelection);
            }
        }
        lemListeLemmesParTerme.getCaret().setSelectionVisible(true);
    }//GEN-LAST:event_bRechercheLpTActionPerformed

    private void bRechercheTpLActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bRechercheTpLActionPerformed
        // TODO add your handling code here:
        String texte = lemListeTermesParLemme.getText();
        int selectionActuelle = lemListeTermesParLemme.getSelectionStart();
        int nouvelleSelection = texte.indexOf(tRechercheTpL.getText(), selectionActuelle+1);
        if(nouvelleSelection >= 0) {
            lemListeTermesParLemme.setSelectionEnd(nouvelleSelection + tRechercheTpL.getText().length());
            lemListeTermesParLemme.setSelectionStart(nouvelleSelection);
        } else {
            nouvelleSelection = texte.indexOf(tRechercheTpL.getText(), 0);
            if(nouvelleSelection >= 0) {
                lemListeTermesParLemme.setSelectionEnd(nouvelleSelection + tRechercheTpL.getText().length());
                lemListeTermesParLemme.setSelectionStart(nouvelleSelection);
            }
        }
        lemListeTermesParLemme.getCaret().setSelectionVisible(true);
    }//GEN-LAST:event_bRechercheTpLActionPerformed

    private void bRechercheTexteBrutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bRechercheTexteBrutActionPerformed
        // TODO add your handling code here:
        String texte = lemTexteEntre.getText();
        int selectionActuelle = lemTexteEntre.getSelectionStart();
        int nouvelleSelection = texte.indexOf(tRechercheTexteBrut.getText(), selectionActuelle+1);
        if(nouvelleSelection >= 0) {
            lemTexteEntre.setSelectionEnd(nouvelleSelection + tRechercheTexteBrut.getText().length());
            lemTexteEntre.setSelectionStart(nouvelleSelection);
        } else {
            nouvelleSelection = texte.indexOf(tRechercheTexteBrut.getText(), 0);
            if(nouvelleSelection >= 0) {
                lemTexteEntre.setSelectionEnd(nouvelleSelection + tRechercheTexteBrut.getText().length());
                lemTexteEntre.setSelectionStart(nouvelleSelection);
            }
        }
        lemTexteEntre.getCaret().setSelectionVisible(true);
    }//GEN-LAST:event_bRechercheTexteBrutActionPerformed

    private void bRechercheTexteTraiteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bRechercheTexteTraiteActionPerformed
        // TODO add your handling code here:
        String texte = lemTexteSortie.getText();
        int selectionActuelle = lemTexteSortie.getSelectionStart();
        int nouvelleSelection = texte.indexOf(tRechercheTexteTraite.getText(), selectionActuelle+1);
        if(nouvelleSelection >= 0) {
            lemTexteSortie.setSelectionEnd(nouvelleSelection + tRechercheTexteTraite.getText().length());
            lemTexteSortie.setSelectionStart(nouvelleSelection);
        } else {
            nouvelleSelection = texte.indexOf(tRechercheTexteTraite.getText(), 0);
            if(nouvelleSelection >= 0) {
                lemTexteSortie.setSelectionEnd(nouvelleSelection + tRechercheTexteTraite.getText().length());
                lemTexteSortie.setSelectionStart(nouvelleSelection);
            }
        }
        lemTexteSortie.getCaret().setSelectionVisible(true);
    }//GEN-LAST:event_bRechercheTexteTraiteActionPerformed

    private void bViderTexteEntreActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bViderTexteEntreActionPerformed
        // TODO add your handling code here:
        lemTexteEntre.setText("");
        lemTexteEntre.setEditable(true);
        aEtudier = null;
    }//GEN-LAST:event_bViderTexteEntreActionPerformed

    private void bIndexDesLemmesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bIndexDesLemmesActionPerformed
        // TODO add your handling code here:
        if(aEtudier == null) {
            // Créer un Passage avec juste les mots dedans
            String texte = lemTexteEntre.getText().replaceAll("[<>]", "").replaceAll("ϕ", "φ").replaceAll(" {0,}\\.{2,} {0,2}", " ");
            String[] mots = texte.split("\\s");
            aEtudier = Passage.creeDocument("");
            for(int i=0; i<mots.length; i++) {
                aEtudier.addSousPassage(
                        new Coordonnee(OrdreStrict.getInstance(OrdreStrict.MOTS), i+1), 
                        Passage.creeMot(new Passage[]{aEtudier}, Terme.cree(mots[i])));
            }
        }
        new Thread() {
            @Override
            public void run() {
                statutSortie.setText("En cours");
                Passage[] mots = aEtudier.getAllMots();
                Map<String, ArrayList<String>> index = new HashMap<>();
                for(Passage mot: mots) {
                    if(!mot.getContenu().estUneFinDePhrase()) {
                        String[] lemmes = SourcesChretiennes.getInstance().getFormesLemmatisees(mot.getContenu().getExpression());
                        String reference = References.toReference(
                                mot.getReferenceInitialeDans(aEtudier), mot.getReferenceInitialeDans(aEtudier), PassageType.PASSAGE_PATRISTIQUE);
                        for(String lemme: lemmes) {
                            if(!index.containsKey(lemme)) {
                                index.put(lemme, new ArrayList<String>());
                            }
                            index.get(lemme).add(reference);
                        }
                    }
                }
                String[] lemmes = new String[index.keySet().size()];
                index.keySet().toArray(lemmes);
                Arrays.sort(lemmes, new OrdreAlphabetiqueGrec());
                String resultat = "";
                for(String lemme: lemmes) {
                    String B = "";
                    if(LemmesVides.contientLemme(Terme.cree(lemme)) || LemmesUsuels.contientLemme(Terme.cree(lemme))) {
                        B = " [C]";
                    } else if(BibleWorks.getInstance().contientLemme(lemme)) {
                        B = " [B]";
                    }
                    resultat += lemme + B + " : ";
                    for(String ref: index.get(lemme)) {
                        resultat += ref.split(" ")[0] + "\t";
                    }
                    resultat = resultat.trim();
                    resultat += "\n";
                }
                resultat = StringUtils.replace(resultat, "\t", ", ");
                lemTexteSortie.setText(resultat);
                statutSortie.setText("");
            }
        }.start();
    }//GEN-LAST:event_bIndexDesLemmesActionPerformed

    private void bExporterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bExporterActionPerformed
        // TODO add your handling code here:
        JFileChooser save = new JFileChooser();
        int resultat = save.showSaveDialog(this);
        if(resultat == JFileChooser.APPROVE_OPTION) {
            statutSortie.setText("En cours");
            BufferedWriter writer = null;
            try {
                File fichier = save.getSelectedFile();
                String aExporter = lemTexteSortie.getText();
                writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fichier), "UTF-8"));
                writer.write(aExporter);
                writer.flush();
                statutSortie.setText("");
            } catch (IOException ex) {
                statutSortie.setText("Erreur");
            } finally {
                try {
                    writer.close();
                } catch (IOException ex) {  
                }
            }
        }
    }//GEN-LAST:event_bExporterActionPerformed

    private void lemModifierListeTpLActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lemModifierListeTpLActionPerformed
        // TODO add your handling code here:
        sauvegarderListeLemmes();
        if(lemListeTermesParLemme.isEditable()) {
            Map<String, String[]> nouvelleListe = new HashMap<>();
            String[] listeTermesStr = lemListeTermesParLemme.getText().split("\n");
            for(String termeStr: listeTermesStr) {
                String[] lemmeEtTermes = termeStr.split("=");
                if(lemmeEtTermes.length>1) {
                    String[] termes = lemmeEtTermes[1].split(",");
                    for(int i=0; i<termes.length; i++) {
                        termes[i] = termes[i].trim();
                    }
                    for(String terme: termes) {
                        if(!lemmeEtTermes[0].trim().isEmpty() && !terme.isEmpty()) {
                            if(!nouvelleListe.containsKey(terme)) {
                                nouvelleListe.put(terme, new String[]{});
                            }
                            String[] lemmes = nouvelleListe.get(terme);
                            ArrayList<String> lemmes2 = new ArrayList(Arrays.asList(lemmes));
                            lemmes2.add(lemmeEtTermes[0].trim());
                            String[] lemmes3 = new String[lemmes2.size()];
                            lemmes2.toArray(lemmes3);
                            nouvelleListe.put(terme, lemmes3);
                        } else {
                            // Termes ou lemmes vides
                        }
                    }
                } else {
                    // Un terme sans lemme
                }
            }
            System.err.println(nouvelleListe.keySet().size());
            SourcesChretiennes.getInstance().corrigeListe(nouvelleListe);
            chargerLemmesParTerme(SourcesChretiennes.getInstance().getListe());
            chargerTermesParLemme(SourcesChretiennes.getInstance().getListe());
        }
    }//GEN-LAST:event_lemModifierListeTpLActionPerformed

    private void bIndexDesLemmesAvecFormesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bIndexDesLemmesAvecFormesActionPerformed
        // TODO add your handling code here:
        if(aEtudier == null) {
            // Créer un Passage avec juste les mots dedans
            String texte = lemTexteEntre.getText().replaceAll("[<>]", "").replaceAll("ϕ", "φ").replaceAll(" {0,}\\.{2,} {0,2}", " ");
            String[] mots = texte.split("\\s");
            aEtudier = Passage.creeDocument("");
            for(int i=0; i<mots.length; i++) {
                aEtudier.addSousPassage(
                        new Coordonnee(OrdreStrict.getInstance(OrdreStrict.MOTS), i+1), 
                        Passage.creeMot(new Passage[]{aEtudier}, Terme.cree(mots[i])));
            }
        }
        new Thread() {
            @Override
            public void run() {
                statutSortie.setText("En cours");
                Passage[] mots = aEtudier.getAllMots();
                Map<String, ArrayList<String>> index = new HashMap<>();
                Map<String, ArrayList<String>> index2 = new HashMap<>();
                for(Passage mot: mots) {
                    if(!mot.getContenu().estUneFinDePhrase()) {
                        String[] lemmes = SourcesChretiennes.getInstance().getFormesLemmatisees(mot.getContenu().getExpression());
                        String reference = References.toReference(
                                mot.getReferenceInitialeDans(aEtudier), mot.getReferenceInitialeDans(aEtudier), PassageType.PASSAGE_PATRISTIQUE);
                        for(String lemme: lemmes) {
                            if(!index.containsKey(lemme)) {
                                index.put(lemme, new ArrayList<String>());
                                index2.put(lemme, new ArrayList<String>());
                            }
                            index.get(lemme).add(reference);
                            index2.get(lemme).add(mot.getContenu().getExpression());
                        }
                    }
                }
                String[] lemmes = new String[index.keySet().size()];
                index.keySet().toArray(lemmes);
                Arrays.sort(lemmes, new OrdreAlphabetiqueGrec());
                String resultat = "";
                for(String lemme: lemmes) {
                    String B = "";
                    if(LemmesVides.contientLemme(Terme.cree(lemme)) || LemmesUsuels.contientLemme(Terme.cree(lemme))) {
                        B = " [C]";
                    } else if(BibleWorks.getInstance().contientLemme(lemme)) {
                        B = " [B]";
                    }
                    resultat += lemme + B + " : ";
                    for(int i=0; i<index.get(lemme).size(); i++) {
                        String ref = index.get(lemme).get(i);
                        String forme = index2.get(lemme).get(i);
                        resultat += ref.split(" ")[0] + " (" + forme + ")" + "\t";
                    }
                    resultat = resultat.trim();
                    resultat += "\n";
                }
                resultat = StringUtils.replace(resultat, "\t", ", ");
                lemTexteSortie.setText(resultat);
                statutSortie.setText("");
            }
        }.start();
    }//GEN-LAST:event_bIndexDesLemmesAvecFormesActionPerformed

    private void bRechercheNpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bRechercheNpActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_bRechercheNpActionPerformed

    private void lemModifierListeNpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lemModifierListeNpActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_lemModifierListeNpActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // TODO add your handling code here:
        JOptionPane.showConfirmDialog(this, "<html><p>Vous pouvez vous placer dans la zone de texte sous les boutons et coller un texte avec ctrl-v.</p></html>", "Copier un texte", JOptionPane.YES_OPTION, JOptionPane.INFORMATION_MESSAGE);
    }//GEN-LAST:event_jButton1ActionPerformed

    private void bRemarquesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bRemarquesActionPerformed
        // TODO add your handling code here:
        new FenetreRemarques().setVisible(true);
    }//GEN-LAST:event_bRemarquesActionPerformed

    private void bFAQActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bFAQActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_bFAQActionPerformed

    private void chargerLemmesParTerme(final Map<String, String[]> liste) {
        new Thread() {
            @Override
            public void run() {
                lemModifierListeLpT.setEnabled(false);
                lStatutLemmesParTerme.setText("Liste des lemmes par terme - tri");
                String[] termes = new String[liste.keySet().size()];
                liste.keySet().toArray(termes);
                Arrays.sort(termes, new OrdreAlphabetiqueGrec());
                lStatutLemmesParTerme.setText("Liste des lemmes par terme - affichage");
                ArrayList<Character> txt = new ArrayList<>();
                for(int i=0; i<termes.length; i++) {
                    String terme = termes[i];
                    String texte = terme + " = ";
                    String[] lemmes = liste.get(terme);
                    if(lemmes != null) {
                        for(int a=0; a<lemmes.length; a++) {
                            texte += lemmes[a];
                            if(a < lemmes.length-1) {
                                texte += ", ";
                            }
                        }
                        texte += "\n";
                        char[] cc = texte.toCharArray();
                        for(char c: cc) {
                            txt.add(c);
                        }
                    }
                }
                lStatutLemmesParTerme.setText("Liste des lemmes par terme");
                int qt = 0;
                char[] cc = new char[txt.size()];
                for(int i=0; i<cc.length; i++) {
                    cc[i] = txt.get(i).charValue();
                    if(cc[i] == '\n') {
                        qt++;
                    }
                }
                String texte = new String(cc);
                lStatutLemmesParTerme.setText("Liste des lemmes par terme ("+qt+" termes)");
                lemListeLemmesParTerme.setText(texte);
                lemModifierListeLpT.setEnabled(true);
            }
        }.start();
    }                                              

    private void chargerTermesParLemme(final Map<String, String[]> liste0) {
        new Thread() {
            @Override
            public void run() {
                lemModifierListeTpL.setEnabled(false);
                lStatutTermesParLemme.setText("Liste des termes par lemme - tri");
                Map<String, String[]> liste = new HashMap<>();
                for(String terme: liste0.keySet()) {
                    String[] lemmes = liste0.get(terme);
                    for(String lemme: lemmes) {
                        if(liste.containsKey(lemme)) {
                            Set<String> listeTermes = new HashSet<>();
                            listeTermes.add(terme);
                            for(String ancienTerme: liste.get(lemme)) {
                               listeTermes.add(ancienTerme); 
                            }
                            String[] nouveauxTermes = new String[listeTermes.size()];
                            listeTermes.toArray(nouveauxTermes);
                            liste.put(lemme, nouveauxTermes);
                        } else {
                            liste.put(lemme, new String[]{terme});
                        }
                    }
                }
                String[] lemmes = new String[liste.keySet().size()];
                liste.keySet().toArray(lemmes);
                Arrays.sort(lemmes, new OrdreAlphabetiqueGrec());
                lStatutTermesParLemme.setText("Liste des termes par lemme - affichage");
                ArrayList<Character> txt = new ArrayList<>();
                for(int i=0; i<lemmes.length; i++) {
                    String lemme = lemmes[i];
                    String texte = lemme + " = ";
                    String[] termes = liste.get(lemme);
                    if(termes != null) {
                        for(int a=0; a<termes.length; a++) {
                            texte += termes[a];
                            if(a < termes.length-1) {
                                texte += ", ";
                            }
                        }
                        texte += "\n";
                        char[] cc = texte.toCharArray();
                        for(char c: cc) {
                            txt.add(c);
                        }
                    }
                }
                lStatutTermesParLemme.setText("Liste des termes par lemme");
                int qt = 0;
                char[] cc = new char[txt.size()];
                for(int i=0; i<cc.length; i++) {
                    cc[i] = txt.get(i).charValue();
                    if(cc[i] == '\n') {
                        qt++;
                    }
                }
                String texte = new String(cc);
                lStatutTermesParLemme.setText("Liste des termes par lemme ("+qt+" lemmes)");
                lemListeTermesParLemme.setText(texte);
                lemModifierListeTpL.setEnabled(true);
            }
        }.start();
    }
    
    public void sauvegarderListeLemmes() {
        new Thread() {
            @Override
            public void run() {
                try {
                    lemModifierListeLpT.setEnabled(false);
                    File liste = new File("lemmesSourcesChretiennes.txt");
                    int num = 1;
                    File sauvegarde = new File("lemmesSourcesChretiennes - Sauvegarde_" + Temps.getDateCourante() +(num>1?" "+num:"")+".txt");
                    while (sauvegarde.exists()) {
                        num++;
                        sauvegarde = new File("lemmesSourcesChretiennes - Sauvegarde_" + Temps.getDateCourante() +(num>1?" "+num:"")+".txt");
                    }
                    Files.copy(liste.toPath(), sauvegarde.toPath());
                    lemModifierListeLpT.setEnabled(true);
                } catch(IOException ioe) {
                    lemSaveLpTPossible.setText("(impossible : "+ioe.getMessage()+")");
                    lemListeLemmesParTerme.setEditable(false);
                } catch(NullPointerException npe) {
                    lemSaveLpTPossible.setText("(formatage à corriger)");
                    npe.printStackTrace();
                }  
            }
        }.start();
    }
    
    private void chargerNomsPropres(final Terme[] liste0) {
        new Thread() {
            @Override
            public void run() {
                lemModifierListeNp.setEnabled(false);
                lStatutNomsPropres.setText("Liste des noms propres - tri");
                Set<String> liste = new HashSet<>();
                for(Terme terme: liste0) {
                    liste.add(terme.getExpression());
                }
                String[] termes = new String[liste.size()];
                liste.toArray(termes);
                Arrays.sort(termes, new OrdreAlphabetiqueGrec());
                lStatutTermesParLemme.setText("Liste des noms propres - affichage");
                ArrayList<Character> txt = new ArrayList<>();
                for(int i=0; i<termes.length; i++) {
                    String texte = termes[i];
                    if(!texte.isEmpty()) {
                        texte += "\n";
                        char[] cc = texte.toCharArray();
                        for(char c: cc) {
                            txt.add(c);
                        }
                    }
                }
                lStatutNomsPropres.setText("Liste des noms propres");
                int qt = 0;
                char[] cc = new char[txt.size()];
                for(int i=0; i<cc.length; i++) {
                    cc[i] = txt.get(i).charValue();
                    if(cc[i] == '\n') {
                        qt++;
                    }
                }
                String texte = new String(cc);
                lStatutNomsPropres.setText("Liste des noms propres ("+qt+")");
                lemListeNomsPropres.setText(texte);
                lemModifierListeNp.setEnabled(true);
            }
        }.start();
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(FenetreLemmatiseur.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(FenetreLemmatiseur.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(FenetreLemmatiseur.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(FenetreLemmatiseur.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new FenetreLemmatiseur().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bExporter;
    private javax.swing.JButton bFAQ;
    private javax.swing.JButton bIndexDesLemmes;
    private javax.swing.JButton bIndexDesLemmesAvecFormes;
    private javax.swing.JButton bRechercheLpT;
    private javax.swing.JButton bRechercheNp;
    private javax.swing.JButton bRechercheTexteBrut;
    private javax.swing.JButton bRechercheTexteTraite;
    private javax.swing.JButton bRechercheTpL;
    private javax.swing.JButton bRemarques;
    private javax.swing.JButton bViderTexteEntre;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel12;
    private javax.swing.JPanel jPanel13;
    private javax.swing.JPanel jPanel14;
    private javax.swing.JPanel jPanel15;
    private javax.swing.JPanel jPanel16;
    private javax.swing.JPanel jPanel17;
    private javax.swing.JPanel jPanel18;
    private javax.swing.JPanel jPanel19;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel20;
    private javax.swing.JPanel jPanel21;
    private javax.swing.JPanel jPanel22;
    private javax.swing.JPanel jPanel23;
    private javax.swing.JPanel jPanel24;
    private javax.swing.JPanel jPanel25;
    private javax.swing.JPanel jPanel26;
    private javax.swing.JPanel jPanel27;
    private javax.swing.JPanel jPanel28;
    private javax.swing.JPanel jPanel29;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel30;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JScrollPane jScrollPane5;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JLabel lStatut;
    private javax.swing.JLabel lStatutLemmesParTerme;
    private javax.swing.JLabel lStatutNomsPropres;
    private javax.swing.JLabel lStatutTermesParLemme;
    private javax.swing.JButton lemChargerRTF;
    private javax.swing.JButton lemLemmatiser;
    private javax.swing.JButton lemLemmatiser2;
    private javax.swing.JButton lemLemmesInconnus;
    private javax.swing.JEditorPane lemListeLemmesParTerme;
    private javax.swing.JEditorPane lemListeNomsPropres;
    private javax.swing.JEditorPane lemListeTermesParLemme;
    private javax.swing.JButton lemModifierListeLpT;
    private javax.swing.JButton lemModifierListeNp;
    private javax.swing.JButton lemModifierListeTpL;
    private javax.swing.JLabel lemSaveLpTPossible;
    private javax.swing.JLabel lemSaveNpPossible;
    private javax.swing.JLabel lemSaveTpLPossible;
    private javax.swing.JEditorPane lemTexteEntre;
    private javax.swing.JEditorPane lemTexteSortie;
    private javax.swing.JLabel statutSortie;
    private javax.swing.JTextField tRechercheLpT;
    private javax.swing.JTextField tRechercheNp;
    private javax.swing.JTextField tRechercheTexteBrut;
    private javax.swing.JTextField tRechercheTexteTraite;
    private javax.swing.JTextField tRechercheTpL;
    // End of variables declaration//GEN-END:variables
}
