/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.MessageHandler;
import greekconverter.UnicodePrecompose;

public class GreekKeysToUnicode {
    private static final char NOT_ASSIGNED = '?';
    private static final char NOT_SUPPORTED = '?';
    private static final char[] tblLookup = new char[256];
    private static final String[] tblDiacrit = new String[11];

    public static String getClassInfo(int infoType) {
        String info;
        switch (infoType) {
            case 0: {
                info = "16-Sep-2002";
                break;
            }
            case 1: {
                info = "Converts a short array with GreekKeys \"characters\" into Unicode";
                break;
            }
            case 2: {
                info = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                info = "Ut sementem feceris, ita metes.";
            }
        }
        return info;
    }

    static final String convertString(short[] gkString) {
        int strPos = 0;
        StringBuffer uniString = new StringBuffer();
        String diacrit = null;
        MessageHandler.clearMsgQueue();
        while (gkString[strPos] != 0) {
            if (diacrit != null) {
                uniString.append(UnicodePrecompose.precomposeStringFirstPass(GreekKeysToUnicode.convertChar(gkString[strPos]) + diacrit));
                diacrit = null;
            } else if (gkString[strPos] > 127 && gkString[strPos] < 139) {
                diacrit = tblDiacrit[gkString[strPos] - 128];
            } else {
                uniString.append(GreekKeysToUnicode.convertChar(gkString[strPos]));
            }
            ++strPos;
        }
        return uniString.toString();
    }

    private static final char convertChar(short gkChar) {
        return tblLookup[gkChar];
    }

    private String getVersionDate() {
        return "01-Sep-2002";
    }

    private String getClassDesc() {
        return "converts GreekKeys into precomposed Unicode";
    }

    static {
        GreekKeysToUnicode.tblDiacrit[0] = "\u0301";
        GreekKeysToUnicode.tblDiacrit[1] = "\u0300";
        GreekKeysToUnicode.tblDiacrit[2] = "\u0302";
        GreekKeysToUnicode.tblDiacrit[3] = "\u0313";
        GreekKeysToUnicode.tblDiacrit[4] = "\u0314";
        GreekKeysToUnicode.tblDiacrit[5] = "\u0313\u0301";
        GreekKeysToUnicode.tblDiacrit[6] = "\u0314\u0301";
        GreekKeysToUnicode.tblDiacrit[7] = "\u0313\u0300";
        GreekKeysToUnicode.tblDiacrit[8] = "\u0314\u0300";
        GreekKeysToUnicode.tblDiacrit[9] = "\u0313\u0302";
        GreekKeysToUnicode.tblDiacrit[10] = "\u0314\u0302";
        for (int i = 0; i < 256; i = (int)((short)(i + 1))) {
            GreekKeysToUnicode.tblLookup[i] = (char)i;
        }
        GreekKeysToUnicode.tblLookup[33] = 1010;
        GreekKeysToUnicode.tblLookup[35] = 971;
        GreekKeysToUnicode.tblLookup[36] = 8990;
        GreekKeysToUnicode.tblLookup[37] = 1010;
        GreekKeysToUnicode.tblLookup[38] = 8115;
        GreekKeysToUnicode.tblLookup[42] = 63;
        GreekKeysToUnicode.tblLookup[43] = 890;
        GreekKeysToUnicode.tblLookup[58] = 903;
        GreekKeysToUnicode.tblLookup[59] = 894;
        GreekKeysToUnicode.tblLookup[61] = 8165;
        GreekKeysToUnicode.tblLookup[63] = 63;
        GreekKeysToUnicode.tblLookup[64] = 8163;
        GreekKeysToUnicode.tblLookup[65] = 913;
        GreekKeysToUnicode.tblLookup[66] = 914;
        GreekKeysToUnicode.tblLookup[67] = 936;
        GreekKeysToUnicode.tblLookup[68] = 916;
        GreekKeysToUnicode.tblLookup[69] = 917;
        GreekKeysToUnicode.tblLookup[70] = 934;
        GreekKeysToUnicode.tblLookup[71] = 915;
        GreekKeysToUnicode.tblLookup[72] = 919;
        GreekKeysToUnicode.tblLookup[73] = 921;
        GreekKeysToUnicode.tblLookup[74] = 926;
        GreekKeysToUnicode.tblLookup[75] = 922;
        GreekKeysToUnicode.tblLookup[76] = 923;
        GreekKeysToUnicode.tblLookup[77] = 924;
        GreekKeysToUnicode.tblLookup[78] = 925;
        GreekKeysToUnicode.tblLookup[79] = 927;
        GreekKeysToUnicode.tblLookup[80] = 928;
        GreekKeysToUnicode.tblLookup[81] = 992;
        GreekKeysToUnicode.tblLookup[82] = 929;
        GreekKeysToUnicode.tblLookup[83] = 931;
        GreekKeysToUnicode.tblLookup[84] = 932;
        GreekKeysToUnicode.tblLookup[85] = 933;
        GreekKeysToUnicode.tblLookup[86] = 937;
        GreekKeysToUnicode.tblLookup[87] = 988;
        GreekKeysToUnicode.tblLookup[88] = 935;
        GreekKeysToUnicode.tblLookup[89] = 920;
        GreekKeysToUnicode.tblLookup[90] = 918;
        GreekKeysToUnicode.tblLookup[94] = 63;
        GreekKeysToUnicode.tblLookup[95] = 91;
        GreekKeysToUnicode.tblLookup[96] = 803;
        GreekKeysToUnicode.tblLookup[97] = 945;
        GreekKeysToUnicode.tblLookup[98] = 946;
        GreekKeysToUnicode.tblLookup[99] = 968;
        GreekKeysToUnicode.tblLookup[100] = 948;
        GreekKeysToUnicode.tblLookup[101] = 949;
        GreekKeysToUnicode.tblLookup[102] = 966;
        GreekKeysToUnicode.tblLookup[103] = 947;
        GreekKeysToUnicode.tblLookup[104] = 951;
        GreekKeysToUnicode.tblLookup[105] = 953;
        GreekKeysToUnicode.tblLookup[106] = 958;
        GreekKeysToUnicode.tblLookup[107] = 954;
        GreekKeysToUnicode.tblLookup[108] = 955;
        GreekKeysToUnicode.tblLookup[109] = 956;
        GreekKeysToUnicode.tblLookup[110] = 957;
        GreekKeysToUnicode.tblLookup[111] = 959;
        GreekKeysToUnicode.tblLookup[112] = 960;
        GreekKeysToUnicode.tblLookup[113] = 990;
        GreekKeysToUnicode.tblLookup[114] = 961;
        GreekKeysToUnicode.tblLookup[115] = 963;
        GreekKeysToUnicode.tblLookup[116] = 964;
        GreekKeysToUnicode.tblLookup[117] = 965;
        GreekKeysToUnicode.tblLookup[118] = 969;
        GreekKeysToUnicode.tblLookup[119] = 962;
        GreekKeysToUnicode.tblLookup[120] = 967;
        GreekKeysToUnicode.tblLookup[121] = 952;
        GreekKeysToUnicode.tblLookup[122] = 950;
        GreekKeysToUnicode.tblLookup[126] = 8224;
        GreekKeysToUnicode.tblLookup[127] = 63;
        GreekKeysToUnicode.tblLookup[139] = 8049;
        GreekKeysToUnicode.tblLookup[140] = 8048;
        GreekKeysToUnicode.tblLookup[141] = 8118;
        GreekKeysToUnicode.tblLookup[142] = 7936;
        GreekKeysToUnicode.tblLookup[143] = 7937;
        GreekKeysToUnicode.tblLookup[144] = 7940;
        GreekKeysToUnicode.tblLookup[145] = 7941;
        GreekKeysToUnicode.tblLookup[146] = 7938;
        GreekKeysToUnicode.tblLookup[147] = 7939;
        GreekKeysToUnicode.tblLookup[148] = 7942;
        GreekKeysToUnicode.tblLookup[149] = 7943;
        GreekKeysToUnicode.tblLookup[150] = 8116;
        GreekKeysToUnicode.tblLookup[151] = 8114;
        GreekKeysToUnicode.tblLookup[152] = 8119;
        GreekKeysToUnicode.tblLookup[153] = 8064;
        GreekKeysToUnicode.tblLookup[154] = 8065;
        GreekKeysToUnicode.tblLookup[155] = 8068;
        GreekKeysToUnicode.tblLookup[156] = 8069;
        GreekKeysToUnicode.tblLookup[157] = 8066;
        GreekKeysToUnicode.tblLookup[158] = 8067;
        GreekKeysToUnicode.tblLookup[159] = 8070;
        GreekKeysToUnicode.tblLookup[160] = 63;
        GreekKeysToUnicode.tblLookup[161] = 8051;
        GreekKeysToUnicode.tblLookup[162] = 8050;
        GreekKeysToUnicode.tblLookup[163] = 8162;
        GreekKeysToUnicode.tblLookup[164] = 7952;
        GreekKeysToUnicode.tblLookup[165] = 7953;
        GreekKeysToUnicode.tblLookup[166] = 7956;
        GreekKeysToUnicode.tblLookup[167] = 7957;
        GreekKeysToUnicode.tblLookup[168] = 7954;
        GreekKeysToUnicode.tblLookup[169] = 7955;
        GreekKeysToUnicode.tblLookup[170] = 8071;
        GreekKeysToUnicode.tblLookup[171] = 93;
        GreekKeysToUnicode.tblLookup[172] = 63;
        GreekKeysToUnicode.tblLookup[173] = 63;
        GreekKeysToUnicode.tblLookup[174] = 8053;
        GreekKeysToUnicode.tblLookup[175] = 8052;
        GreekKeysToUnicode.tblLookup[176] = 8134;
        GreekKeysToUnicode.tblLookup[177] = 7968;
        GreekKeysToUnicode.tblLookup[178] = 7969;
        GreekKeysToUnicode.tblLookup[179] = 7972;
        GreekKeysToUnicode.tblLookup[180] = 7973;
        GreekKeysToUnicode.tblLookup[181] = 7970;
        GreekKeysToUnicode.tblLookup[182] = 7971;
        GreekKeysToUnicode.tblLookup[183] = 7974;
        GreekKeysToUnicode.tblLookup[184] = 7975;
        GreekKeysToUnicode.tblLookup[185] = 8132;
        GreekKeysToUnicode.tblLookup[186] = 8130;
        GreekKeysToUnicode.tblLookup[187] = 8135;
        GreekKeysToUnicode.tblLookup[188] = 8080;
        GreekKeysToUnicode.tblLookup[189] = 8081;
        GreekKeysToUnicode.tblLookup[190] = 8084;
        GreekKeysToUnicode.tblLookup[191] = 8085;
        GreekKeysToUnicode.tblLookup[192] = 8082;
        GreekKeysToUnicode.tblLookup[193] = 8083;
        GreekKeysToUnicode.tblLookup[194] = 8086;
        GreekKeysToUnicode.tblLookup[195] = 8087;
        GreekKeysToUnicode.tblLookup[196] = 8179;
        GreekKeysToUnicode.tblLookup[197] = 8061;
        GreekKeysToUnicode.tblLookup[198] = 8060;
        GreekKeysToUnicode.tblLookup[199] = 8182;
        GreekKeysToUnicode.tblLookup[200] = 8032;
        GreekKeysToUnicode.tblLookup[201] = 8033;
        GreekKeysToUnicode.tblLookup[202] = 8036;
        GreekKeysToUnicode.tblLookup[203] = 8037;
        GreekKeysToUnicode.tblLookup[204] = 8034;
        GreekKeysToUnicode.tblLookup[205] = 8035;
        GreekKeysToUnicode.tblLookup[206] = 8038;
        GreekKeysToUnicode.tblLookup[207] = 8039;
        GreekKeysToUnicode.tblLookup[208] = 8180;
        GreekKeysToUnicode.tblLookup[209] = 8178;
        GreekKeysToUnicode.tblLookup[210] = 8183;
        GreekKeysToUnicode.tblLookup[211] = 8096;
        GreekKeysToUnicode.tblLookup[212] = 8097;
        GreekKeysToUnicode.tblLookup[213] = 8100;
        GreekKeysToUnicode.tblLookup[214] = 8101;
        GreekKeysToUnicode.tblLookup[215] = 8098;
        GreekKeysToUnicode.tblLookup[216] = 8099;
        GreekKeysToUnicode.tblLookup[217] = 8102;
        GreekKeysToUnicode.tblLookup[218] = 8103;
        GreekKeysToUnicode.tblLookup[219] = 8055;
        GreekKeysToUnicode.tblLookup[220] = 8054;
        GreekKeysToUnicode.tblLookup[221] = 8150;
        GreekKeysToUnicode.tblLookup[222] = 7984;
        GreekKeysToUnicode.tblLookup[223] = 7985;
        GreekKeysToUnicode.tblLookup[224] = 7988;
        GreekKeysToUnicode.tblLookup[225] = 7989;
        GreekKeysToUnicode.tblLookup[226] = 7986;
        GreekKeysToUnicode.tblLookup[227] = 7987;
        GreekKeysToUnicode.tblLookup[228] = 7990;
        GreekKeysToUnicode.tblLookup[229] = 7991;
        GreekKeysToUnicode.tblLookup[230] = 8059;
        GreekKeysToUnicode.tblLookup[231] = 8058;
        GreekKeysToUnicode.tblLookup[232] = 8166;
        GreekKeysToUnicode.tblLookup[233] = 8016;
        GreekKeysToUnicode.tblLookup[234] = 8017;
        GreekKeysToUnicode.tblLookup[235] = 8020;
        GreekKeysToUnicode.tblLookup[236] = 8021;
        GreekKeysToUnicode.tblLookup[237] = 8018;
        GreekKeysToUnicode.tblLookup[238] = 8019;
        GreekKeysToUnicode.tblLookup[239] = 8022;
        GreekKeysToUnicode.tblLookup[240] = 8023;
        GreekKeysToUnicode.tblLookup[241] = 8057;
        GreekKeysToUnicode.tblLookup[242] = 8056;
        GreekKeysToUnicode.tblLookup[243] = 970;
        GreekKeysToUnicode.tblLookup[244] = 8000;
        GreekKeysToUnicode.tblLookup[245] = 8001;
        GreekKeysToUnicode.tblLookup[246] = 8004;
        GreekKeysToUnicode.tblLookup[247] = 8005;
        GreekKeysToUnicode.tblLookup[248] = 8002;
        GreekKeysToUnicode.tblLookup[249] = 8003;
        GreekKeysToUnicode.tblLookup[250] = 8131;
        GreekKeysToUnicode.tblLookup[251] = 986;
        GreekKeysToUnicode.tblLookup[252] = 8991;
        GreekKeysToUnicode.tblLookup[253] = 8147;
        GreekKeysToUnicode.tblLookup[254] = 8146;
        GreekKeysToUnicode.tblLookup[255] = 63;
    }
}

