/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

public class DynShortArray {
    private int initSize;
    private int chunkSize;
    private int currPos = -1;
    public short[] array;

    public static String getClassInfo(int infoType) {
        String info;
        switch (infoType) {
            case 0: {
                info = "31-Aug-2002";
                break;
            }
            case 1: {
                info = "Dynamic short array";
                break;
            }
            case 2: {
                info = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                info = "Homo sum, humani nil a me alienum puto.";
            }
        }
        return info;
    }

    public DynShortArray(int initSize, int chunkSize) {
        this.initSize = initSize;
        this.chunkSize = chunkSize;
        this.array = new short[initSize];
    }

    public void pushElem(short elem) {
        if (++this.currPos >= this.array.length) {
            this.resize();
        }
        this.array[this.currPos] = elem;
    }

    public void setElem(short elem, int pos) {
        this.array[pos] = elem;
    }

    public short getElem(int pos) {
        return this.array[pos];
    }

    public short[] getArray() {
        return this.array;
    }

    public void reset() {
        this.array = new short[this.initSize];
        this.currPos = -1;
    }

    public int length() {
        return this.array.length;
    }

    public int getPos() {
        return this.currPos;
    }

    private void resize() {
        short[] mem = this.array;
        this.array = new short[mem.length + this.chunkSize];
        System.arraycopy(mem, 0, this.array, 0, mem.length);
    }
}

