/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.MessageHandler;

public class BibleWorksToBetacode {
    public static String getClassInfo(int infoType) {
        String info;
        switch (infoType) {
            case 0: {
                info = "23-Mar-2002";
                break;
            }
            case 1: {
                info = "Converts text with BibleWorks' coding into Beta coding - no longer being maintained";
                break;
            }
            case 2: {
                info = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                info = "Est modus in rebus, sunt certi denique fines.";
            }
        }
        return info;
    }

    String convertString(String bwString) {
        int strLen = bwString.length();
        String betaString = new String();
        char prevChar = ' ';
        MessageHandler.clearMsgQueue();
        for (int strPos = 0; strPos < strLen; ++strPos) {
            char currChar = bwString.charAt(strPos);
            betaString = betaString + this.convertChar(prevChar, currChar);
            prevChar = currChar;
            MessageHandler.enqueueMsg(" at pos. " + String.valueOf(strPos + 1) + "\n");
        }
        return betaString;
    }

    private String convertChar(char prevBwChar, char bwChar) {
        String betaChar;
        char bwUpperChar = Character.toUpperCase(bwChar);
        switch (bwChar) {
            case '|': {
                betaChar = "|";
                break;
            }
            case '?': {
                betaChar = "+";
                break;
            }
            case ',': {
                betaChar = "/";
                break;
            }
            case '<': {
                betaChar = "/+";
                break;
            }
            case '.': {
                betaChar = "\\";
                break;
            }
            case '>': {
                betaChar = "\\+";
                break;
            }
            case '/': {
                betaChar = "=";
                break;
            }
            case 'v': {
                betaChar = ")";
                break;
            }
            case '`': {
                betaChar = "(";
                break;
            }
            case 'V': {
                if (prevBwChar == ' ') {
                    betaChar = "*)";
                    break;
                }
                betaChar = "'";
                break;
            }
            case '~': {
                betaChar = "*(";
                break;
            }
            case ';': {
                betaChar = ")/";
                break;
            }
            case '[': {
                betaChar = "(/";
                break;
            }
            case '\'': {
                betaChar = ")\\";
                break;
            }
            case ']': {
                betaChar = "(\\";
                break;
            }
            case '=': {
                betaChar = ")=";
                break;
            }
            case '-': {
                betaChar = "(=";
                break;
            }
            case ':': {
                betaChar = "*)/";
                break;
            }
            case '{': {
                betaChar = "*(/";
                break;
            }
            case '\"': {
                betaChar = "*)\\";
                break;
            }
            case '}': {
                betaChar = "*(\\";
                break;
            }
            case '+': {
                betaChar = "*)=";
                break;
            }
            case '_': {
                betaChar = "*(=";
                break;
            }
            case '\\': {
                betaChar = ":";
                break;
            }
            case '\u00c7': {
                betaChar = ":";
                break;
            }
            case '*': {
                betaChar = ";";
                break;
            }
            case '\u00c8': {
                betaChar = ";";
                break;
            }
            case '(': {
                betaChar = ",";
                break;
            }
            case '\u00c3': {
                betaChar = ",";
                break;
            }
            case ')': {
                betaChar = ".";
                break;
            }
            case '\u00c5': {
                betaChar = ".";
                break;
            }
            case '@': {
                betaChar = "[";
                break;
            }
            case '\u00ce': {
                betaChar = "[";
                break;
            }
            case '#': {
                betaChar = "]";
                break;
            }
            case '\u00d0': {
                betaChar = "]";
                break;
            }
            case '$': {
                betaChar = "[";
                break;
            }
            case '\u00bf': {
                betaChar = "[";
                break;
            }
            case '%': {
                betaChar = "]";
                break;
            }
            case '\u00c0': {
                betaChar = "[";
                break;
            }
            case '^': {
                betaChar = "\u2022";
                break;
            }
            case '\u00c1': {
                betaChar = "\u2022";
                break;
            }
            case '&': {
                betaChar = "-";
                break;
            }
            case '\u00c4': {
                betaChar = "-";
                break;
            }
            case '!': {
                betaChar = "\u2020";
                break;
            }
            case '\u00c2': {
                betaChar = "\u2020";
                break;
            }
            case '\u00b9': {
                betaChar = "\"";
                break;
            }
            case '\u00b8': {
                betaChar = "!";
                break;
            }
            case '\u00ba': {
                betaChar = "#";
                break;
            }
            case '\u00bb': {
                betaChar = "$";
                break;
            }
            case '\u00bc': {
                betaChar = "%";
                break;
            }
            case '\u00bd': {
                betaChar = "&";
                break;
            }
            case '\u00be': {
                betaChar = "'";
                break;
            }
            case '\u00c9': {
                betaChar = "<";
                break;
            }
            case '\u00cb': {
                betaChar = ">";
                break;
            }
            case '\u00cc': {
                betaChar = "?";
                break;
            }
            case '\u00cd': {
                betaChar = "@";
                break;
            }
            case '\u00d1': {
                betaChar = "^";
                break;
            }
            case '\u00d2': {
                betaChar = "_";
                break;
            }
            case '\u00d3': {
                betaChar = "`";
                break;
            }
            case '\u00d4': {
                betaChar = "{";
                break;
            }
            case '\u00d6': {
                betaChar = "}";
                break;
            }
            case '\u00d7': {
                betaChar = "~";
                break;
            }
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': {
                betaChar = String.valueOf(bwChar);
                break;
            }
            default: {
                if (bwChar > '\u007f') {
                    betaChar = "?";
                    break;
                }
                if (bwChar >= '0' && bwChar <= '9') {
                    betaChar = String.valueOf(bwChar);
                    break;
                }
                switch (bwUpperChar) {
                    case 'C': {
                        betaChar = "X";
                        break;
                    }
                    case 'X': {
                        betaChar = "C";
                        break;
                    }
                    default: {
                        betaChar = String.valueOf(bwUpperChar);
                    }
                }
                if (!Character.isUpperCase(bwChar) || prevBwChar != ' ') break;
                betaChar = "*" + betaChar;
            }
        }
        return betaChar;
    }
}

