/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.MessageHandler;
import greekconverter.UnicodeToName;
import java.util.Stack;

public class BetacodeToUnicode {
    private static final char UNDEFINED_SYMBOL = '\u0000';
    private static final byte CASE_LOWER = 0;
    private static final byte CASE_UPPER = 1;
    private static final byte WORDEND_NO = 0;
    private static final byte WORDEND_YES = 1;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_SYMBOL = 1;
    private static final int STATE_UPPERCASE = 2;
    private static final char[][] tblLookup;
    private static final char[] tblChars;
    private static final char[] tblPunct;
    private static final char[] tblTSyms;
    private static final char[] tblSigma;
    private static final char[] tblLBrack;
    private static final char[] tblRBrack;
    private static final byte[] tblWordEnd;
    Stack bracketStack = new Stack();
    int state = 0;

    public static String getClassInfo(int infoType) {
        String info;
        switch (infoType) {
            case 0: {
                info = "12-Feb-2004";
                break;
            }
            case 1: {
                info = "Converts a Beta coded string into *decomposed* Unicode.";
                break;
            }
            case 2: {
                info = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                info = "Quid sit futurum cras, fuge quaerere.";
            }
        }
        return info;
    }

    public String convertString(String betaText) {
        int strLen = betaText.length();
        int strPos = 0;
        StringBuffer uniText = new StringBuffer(strLen);
        char currChar = ' ';
        int prevChar = 32;
        BetaSymbol betaSym = new BetaSymbol();
        boolean endOfString = false;
        MessageHandler.clearMsgQueue();
        MessageHandler.enqueueMsg("Input >" + betaText + "< has " + strLen + " characters", 20);
        while (strPos < strLen) {
            currChar = betaText.charAt(strPos++);
            switch (currChar) {
                case '*': {
                    uniText.append(this.convertChar(betaSym));
                    betaSym.setCase((byte)1);
                    this.state = 2;
                    break;
                }
                case ')': {
                    betaSym.setBreathing('\u0313');
                    break;
                }
                case '(': {
                    betaSym.setBreathing('\u0314');
                    break;
                }
                case '/': {
                    betaSym.setAccent('\u0301');
                    break;
                }
                case '\\': {
                    betaSym.setAccent('\u0300');
                    break;
                }
                case '=': {
                    betaSym.setAccent('\u0342');
                    break;
                }
                case '|': {
                    betaSym.setIota('\u0345');
                    break;
                }
                case '+': {
                    betaSym.setDiaeresis('\u0308');
                    break;
                }
                case '#': 
                case '%': 
                case '[': 
                case ']': {
                    uniText.append(this.convertChar(betaSym));
                    betaSym.setCharacter(currChar);
                    this.state = 1;
                    break;
                }
                case 'S': 
                case 's': {
                    if (this.state == 2) {
                        betaSym.setCharacter(currChar);
                        this.state = 0;
                        break;
                    }
                    uniText.append(this.convertChar(betaSym));
                    betaSym.setCharacter(currChar);
                    this.state = 1;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (this.state == 1) {
                        betaSym.appNumStr(String.valueOf(currChar));
                        break;
                    }
                }
                default: {
                    if (this.state == 2) {
                        betaSym.setCharacter(currChar);
                        this.state = 0;
                        break;
                    }
                    betaSym.setWordEnd(tblWordEnd[currChar]);
                    uniText.append(this.convertChar(betaSym));
                    betaSym.setCharacter(currChar);
                }
            }
            MessageHandler.enqueueMsg(" at pos. " + strPos + "\n");
        }
        betaSym.setWordEnd((byte)1);
        uniText.append(this.convertChar(betaSym));
        MessageHandler.enqueueMsg(" at pos. " + strPos + "\n");
        return uniText.toString();
    }

    private String convertChar(BetaSymbol betaSym) {
        StringBuffer uniBuf = new StringBuffer(5);
        char symChar = betaSym.getCharacter();
        byte charCase = betaSym.getCase();
        int symNum = betaSym.getNum();
        try {
            if (tblLookup[symChar] == tblChars) {
                symNum = charCase == 1 ? (int)Character.toUpperCase(symChar) : (int)Character.toLowerCase(symChar);
            } else if (tblLookup[symChar] == tblSigma) {
                if (charCase == 1) {
                    symNum = 4;
                } else if (symNum == 0 && betaSym.getWordEnd() == 1) {
                    symNum = 2;
                }
            }
            char uniChar = tblLookup[symChar][symNum];
            if (uniChar == '\u0000') {
                uniBuf.append(symChar);
                uniBuf.append(symNum);
            } else {
                uniBuf.append(uniChar);
                uniBuf.append(betaSym.getBreathing());
                uniBuf.append(betaSym.getDiaeresis());
                uniBuf.append(betaSym.getAccent());
                uniBuf.append(betaSym.getIota());
            }
        }
        catch (Exception e) {
            uniBuf.append(symChar);
            uniBuf.append(symNum);
        }
        this.state = 0;
        betaSym.reset();
        String uniStr = uniBuf.toString();
        MessageHandler.enqueueMsg(UnicodeToName.convertString(uniStr), 20);
        return uniStr;
    }

    static {
        int i;
        tblLookup = new char[256][];
        tblChars = new char[256];
        tblPunct = new char[164];
        tblTSyms = new char[23];
        tblSigma = new char[5];
        tblLBrack = new char[33];
        tblRBrack = new char[33];
        tblWordEnd = new byte[256];
        for (i = 0; i < 256; ++i) {
            BetacodeToUnicode.tblLookup[i] = tblChars;
        }
        BetacodeToUnicode.tblLookup[35] = tblTSyms;
        BetacodeToUnicode.tblLookup[37] = tblPunct;
        BetacodeToUnicode.tblLookup[83] = tblSigma;
        BetacodeToUnicode.tblLookup[91] = tblLBrack;
        BetacodeToUnicode.tblLookup[93] = tblRBrack;
        BetacodeToUnicode.tblLookup[115] = tblSigma;
        for (i = 0; i < 256; ++i) {
            BetacodeToUnicode.tblChars[i] = (char)i;
        }
        BetacodeToUnicode.tblChars[63] = 803;
        BetacodeToUnicode.tblChars[65] = 913;
        BetacodeToUnicode.tblChars[66] = 914;
        BetacodeToUnicode.tblChars[67] = 926;
        BetacodeToUnicode.tblChars[68] = 916;
        BetacodeToUnicode.tblChars[69] = 917;
        BetacodeToUnicode.tblChars[70] = 934;
        BetacodeToUnicode.tblChars[71] = 915;
        BetacodeToUnicode.tblChars[72] = 919;
        BetacodeToUnicode.tblChars[73] = 921;
        BetacodeToUnicode.tblChars[74] = '\u0000';
        BetacodeToUnicode.tblChars[75] = 922;
        BetacodeToUnicode.tblChars[76] = 923;
        BetacodeToUnicode.tblChars[77] = 924;
        BetacodeToUnicode.tblChars[78] = 925;
        BetacodeToUnicode.tblChars[79] = 927;
        BetacodeToUnicode.tblChars[80] = 928;
        BetacodeToUnicode.tblChars[81] = 920;
        BetacodeToUnicode.tblChars[82] = 929;
        BetacodeToUnicode.tblChars[83] = 931;
        BetacodeToUnicode.tblChars[84] = 932;
        BetacodeToUnicode.tblChars[85] = 933;
        BetacodeToUnicode.tblChars[86] = 988;
        BetacodeToUnicode.tblChars[87] = 937;
        BetacodeToUnicode.tblChars[88] = 935;
        BetacodeToUnicode.tblChars[89] = 936;
        BetacodeToUnicode.tblChars[90] = 918;
        BetacodeToUnicode.tblChars[97] = 945;
        BetacodeToUnicode.tblChars[98] = 946;
        BetacodeToUnicode.tblChars[99] = 958;
        BetacodeToUnicode.tblChars[100] = 948;
        BetacodeToUnicode.tblChars[101] = 949;
        BetacodeToUnicode.tblChars[102] = 966;
        BetacodeToUnicode.tblChars[103] = 947;
        BetacodeToUnicode.tblChars[104] = 951;
        BetacodeToUnicode.tblChars[105] = 953;
        BetacodeToUnicode.tblChars[106] = 962;
        BetacodeToUnicode.tblChars[107] = 954;
        BetacodeToUnicode.tblChars[108] = 955;
        BetacodeToUnicode.tblChars[109] = 956;
        BetacodeToUnicode.tblChars[110] = 957;
        BetacodeToUnicode.tblChars[111] = 959;
        BetacodeToUnicode.tblChars[112] = 960;
        BetacodeToUnicode.tblChars[113] = 952;
        BetacodeToUnicode.tblChars[114] = 961;
        BetacodeToUnicode.tblChars[115] = 963;
        BetacodeToUnicode.tblChars[116] = 964;
        BetacodeToUnicode.tblChars[117] = 965;
        BetacodeToUnicode.tblChars[118] = 989;
        BetacodeToUnicode.tblChars[119] = 969;
        BetacodeToUnicode.tblChars[120] = 967;
        BetacodeToUnicode.tblChars[121] = 968;
        BetacodeToUnicode.tblChars[122] = 950;
        for (i = 0; i < 164; ++i) {
            BetacodeToUnicode.tblPunct[i] = '\u0000';
        }
        BetacodeToUnicode.tblPunct[0] = 8224;
        BetacodeToUnicode.tblPunct[1] = 63;
        BetacodeToUnicode.tblPunct[2] = 42;
        BetacodeToUnicode.tblPunct[3] = 47;
        BetacodeToUnicode.tblPunct[4] = 33;
        BetacodeToUnicode.tblPunct[5] = 124;
        BetacodeToUnicode.tblPunct[6] = 61;
        BetacodeToUnicode.tblPunct[7] = 43;
        BetacodeToUnicode.tblPunct[8] = 37;
        BetacodeToUnicode.tblPunct[9] = 38;
        BetacodeToUnicode.tblPunct[10] = 58;
        BetacodeToUnicode.tblPunct[11] = 46;
        BetacodeToUnicode.tblPunct[13] = 8225;
        BetacodeToUnicode.tblPunct[14] = 167;
        BetacodeToUnicode.tblPunct[15] = 8242;
        BetacodeToUnicode.tblPunct[16] = 166;
        BetacodeToUnicode.tblPunct[18] = 60;
        BetacodeToUnicode.tblPunct[19] = 8208;
        BetacodeToUnicode.tblPunct[20] = 769;
        BetacodeToUnicode.tblPunct[21] = 768;
        BetacodeToUnicode.tblPunct[22] = 770;
        BetacodeToUnicode.tblPunct[23] = 776;
        BetacodeToUnicode.tblPunct[24] = 771;
        BetacodeToUnicode.tblPunct[25] = 807;
        BetacodeToUnicode.tblPunct[26] = 772;
        BetacodeToUnicode.tblPunct[27] = 774;
        BetacodeToUnicode.tblPunct[28] = 776;
        BetacodeToUnicode.tblPunct[29] = 803;
        BetacodeToUnicode.tblPunct[30] = 8127;
        BetacodeToUnicode.tblPunct[31] = 8190;
        BetacodeToUnicode.tblPunct[32] = 8189;
        BetacodeToUnicode.tblPunct[33] = 8175;
        BetacodeToUnicode.tblPunct[34] = 8128;
        BetacodeToUnicode.tblPunct[35] = 8142;
        BetacodeToUnicode.tblPunct[36] = 8158;
        BetacodeToUnicode.tblPunct[37] = 8157;
        BetacodeToUnicode.tblPunct[38] = 8159;
        BetacodeToUnicode.tblPunct[39] = 168;
        BetacodeToUnicode.tblPunct[40] = 728;
        BetacodeToUnicode.tblPunct[41] = 175;
        BetacodeToUnicode.tblPunct[43] = 120;
        BetacodeToUnicode.tblPunct[47] = 61;
        BetacodeToUnicode.tblPunct[100] = 59;
        BetacodeToUnicode.tblPunct[101] = 35;
        BetacodeToUnicode.tblPunct[102] = 39;
        BetacodeToUnicode.tblPunct[103] = 92;
        BetacodeToUnicode.tblPunct[107] = 126;
        BetacodeToUnicode.tblPunct[108] = 177;
        BetacodeToUnicode.tblPunct[109] = 183;
        BetacodeToUnicode.tblPunct[128] = 770;
        BetacodeToUnicode.tblPunct[129] = 8224;
        BetacodeToUnicode.tblPunct[132] = 8174;
        BetacodeToUnicode.tblPunct[133] = 8141;
        BetacodeToUnicode.tblPunct[134] = 8143;
        BetacodeToUnicode.tblPunct[147] = 778;
        BetacodeToUnicode.tblPunct[150] = 124;
        BetacodeToUnicode.tblPunct[151] = 8208;
        BetacodeToUnicode.tblPunct[152] = 46;
        BetacodeToUnicode.tblPunct[153] = 8208;
        BetacodeToUnicode.tblPunct[159] = 215;
        BetacodeToUnicode.tblPunct[160] = 45;
        BetacodeToUnicode.tblPunct[161] = 247;
        BetacodeToUnicode.tblPunct[163] = 182;
        for (i = 0; i < 23; ++i) {
            BetacodeToUnicode.tblTSyms[i] = '\u0000';
        }
        BetacodeToUnicode.tblTSyms[0] = 884;
        BetacodeToUnicode.tblTSyms[1] = 990;
        BetacodeToUnicode.tblTSyms[2] = 986;
        BetacodeToUnicode.tblTSyms[3] = 990;
        BetacodeToUnicode.tblTSyms[4] = 990;
        BetacodeToUnicode.tblTSyms[5] = 992;
        BetacodeToUnicode.tblTSyms[6] = 8208;
        BetacodeToUnicode.tblTSyms[7] = 46;
        BetacodeToUnicode.tblTSyms[9] = 769;
        BetacodeToUnicode.tblTSyms[17] = 47;
        BetacodeToUnicode.tblTSyms[19] = 768;
        BetacodeToUnicode.tblTSyms[22] = 885;
        BetacodeToUnicode.tblSigma[0] = 963;
        BetacodeToUnicode.tblSigma[1] = 963;
        BetacodeToUnicode.tblSigma[2] = 962;
        BetacodeToUnicode.tblSigma[3] = 1010;
        BetacodeToUnicode.tblSigma[4] = 931;
        for (i = 0; i < 33; ++i) {
            BetacodeToUnicode.tblLBrack[i] = '\u0000';
            BetacodeToUnicode.tblRBrack[i] = '\u0000';
        }
        BetacodeToUnicode.tblLBrack[0] = 91;
        BetacodeToUnicode.tblRBrack[0] = 93;
        BetacodeToUnicode.tblLBrack[1] = 40;
        BetacodeToUnicode.tblRBrack[1] = 41;
        BetacodeToUnicode.tblLBrack[3] = 123;
        BetacodeToUnicode.tblRBrack[3] = 125;
        BetacodeToUnicode.tblLBrack[13] = 91;
        BetacodeToUnicode.tblRBrack[13] = 93;
        for (i = 0; i < 256; ++i) {
            BetacodeToUnicode.tblWordEnd[i] = 0;
        }
        BetacodeToUnicode.tblWordEnd[32] = 1;
        BetacodeToUnicode.tblWordEnd[46] = 1;
        BetacodeToUnicode.tblWordEnd[58] = 1;
        BetacodeToUnicode.tblWordEnd[59] = 1;
        BetacodeToUnicode.tblWordEnd[44] = 1;
        BetacodeToUnicode.tblWordEnd[35] = 1;
        BetacodeToUnicode.tblWordEnd[37] = 1;
        BetacodeToUnicode.tblWordEnd[91] = 1;
        BetacodeToUnicode.tblWordEnd[93] = 1;
        BetacodeToUnicode.tblWordEnd[34] = 1;
        BetacodeToUnicode.tblWordEnd[36] = 1;
        BetacodeToUnicode.tblWordEnd[60] = 1;
        BetacodeToUnicode.tblWordEnd[62] = 1;
        BetacodeToUnicode.tblWordEnd[64] = 1;
    }

    private class BetaSymbol {
        char character;
        String breathing;
        String accent;
        String iota;
        String diaeresis;
        byte charCase;
        byte wordEnd;
        String numStr;

        public void reset() {
            this.character = (char)32;
            this.breathing = "";
            this.accent = "";
            this.iota = "";
            this.diaeresis = "";
            this.charCase = 0;
            this.wordEnd = 0;
            this.numStr = "0";
        }

        public BetaSymbol() {
            this.reset();
        }

        public void setCharacter(char val) {
            this.character = val;
        }

        public char getCharacter() {
            return this.character;
        }

        public void setBreathing(char val) {
            this.breathing = String.valueOf(val);
        }

        public String getBreathing() {
            return this.breathing;
        }

        public void setAccent(char val) {
            this.accent = String.valueOf(val);
        }

        public String getAccent() {
            return this.accent;
        }

        public void setIota(char val) {
            this.iota = String.valueOf(val);
        }

        public String getIota() {
            return this.iota;
        }

        public void setDiaeresis(char val) {
            this.diaeresis = String.valueOf(val);
        }

        public String getDiaeresis() {
            return this.diaeresis;
        }

        public void setCase(byte val) {
            this.charCase = val;
        }

        public byte getCase() {
            return this.charCase;
        }

        public void setWordEnd(byte val) {
            this.wordEnd = val;
        }

        public byte getWordEnd() {
            return this.wordEnd;
        }

        public void setNumStr(String val) {
            this.numStr = val;
        }

        public void appNumStr(String val) {
            this.numStr = this.numStr + val;
        }

        public void setNum(int val) {
            this.numStr = String.valueOf(val);
        }

        public int getNum() {
            return Integer.parseInt(this.numStr);
        }
    }
}

