/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

public abstract class RealDoubleFFT {
    int n;

    public RealDoubleFFT(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The transform length must be >=0 : " + n);
        }
        this.n = n;
    }

    protected void checkData(double[] dArray, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("The offset must be >=0 : " + n);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("The stride must be >=1 : " + n2);
        }
        if (n + n2 * (this.n - 1) + 1 > dArray.length) {
            throw new IllegalArgumentException("The data array is too small for " + this.n + ":" + "i0=" + n + " stride=" + n2 + " data.length=" + dArray.length);
        }
    }

    public void transform(double[] dArray) {
        this.transform(dArray, 0, 1);
    }

    public abstract void transform(double[] var1, int var2, int var3);

    public abstract double[] toWraparoundOrder(double[] var1);

    public abstract double[] toWraparoundOrder(double[] var1, int var2, int var3);

    public void backtransform(double[] dArray) {
        this.backtransform(dArray, 0, 1);
    }

    public abstract void backtransform(double[] var1, int var2, int var3);

    public double normalization() {
        return 1.0 / (double)this.n;
    }

    public void inverse(double[] dArray) {
        this.inverse(dArray, 0, 1);
    }

    public void inverse(double[] dArray, int n, int n2) {
        this.backtransform(dArray, n, n2);
        double d = this.normalization();
        for (int i = 0; i < this.n; ++i) {
            int n3 = n + n2 * i;
            dArray[n3] = dArray[n3] * d;
        }
    }
}

