/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexFloatFFT;
import jnt.FFT.Factorize;

public class ComplexFloatFFT_Radix2
extends ComplexFloatFFT {
    static final int FORWARD = -1;
    static final int BACKWARD = 1;
    static final int DECINTIME = 0;
    static final int DECINFREQ = 1;
    private int logn;
    private int decimate = 0;

    public ComplexFloatFFT_Radix2(int n) {
        super(n);
        this.logn = Factorize.log2(n);
        if (this.logn < 0) {
            throw new Error(n + " is not a power of 2");
        }
    }

    public void setDecimateInTime() {
        this.decimate = 0;
    }

    public void setDecimateInFrequency() {
        this.decimate = 1;
    }

    @Override
    public void transform(float[] fArray, int n, int n2) {
        this.checkData(fArray, n, n2);
        this.transform_internal(fArray, n, n2, -1);
    }

    @Override
    public void backtransform(float[] fArray, int n, int n2) {
        this.checkData(fArray, n, n2);
        this.transform_internal(fArray, n, n2, 1);
    }

    void transform_internal(float[] fArray, int n, int n2, int n3) {
        if (this.decimate == 1) {
            this.transform_DIF(fArray, n, n2, n3);
        } else {
            this.transform_DIT(fArray, n, n2, n3);
        }
    }

    void transform_DIT(float[] fArray, int n, int n2, int n3) {
        if (this.n == 1) {
            return;
        }
        this.bitreverse(fArray, n, n2);
        int n4 = 0;
        int n5 = 1;
        while (n4 < this.logn) {
            float f;
            int n6;
            int n7;
            float f2 = 1.0f;
            float f3 = 0.0f;
            double d = 2.0 * (double)n3 * Math.PI / (2.0 * (double)n5);
            float f4 = (float)Math.sin(d);
            float f5 = (float)Math.sin(d / 2.0);
            float f6 = 2.0f * f5 * f5;
            for (n7 = 0; n7 < this.n; n7 += 2 * n5) {
                n6 = n + n7 * n2;
                int n8 = n + (n7 + n5) * n2;
                float f7 = fArray[n8];
                f = fArray[n8 + 1];
                fArray[n8] = fArray[n6] - f7;
                fArray[n8 + 1] = fArray[n6 + 1] - f;
                int n9 = n6;
                fArray[n9] = fArray[n9] + f7;
                int n10 = n6 + 1;
                fArray[n10] = fArray[n10] + f;
            }
            for (n7 = 1; n7 < n5; ++n7) {
                float f8 = f2 - f4 * f3 - f6 * f2;
                float f9 = f3 + f4 * f2 - f6 * f3;
                f2 = f8;
                f3 = f9;
                for (n6 = 0; n6 < this.n; n6 += 2 * n5) {
                    int n11 = n + (n6 + n7) * n2;
                    int n12 = n + (n6 + n7 + n5) * n2;
                    f = fArray[n12];
                    float f10 = fArray[n12 + 1];
                    float f11 = f2 * f - f3 * f10;
                    float f12 = f2 * f10 + f3 * f;
                    fArray[n12] = fArray[n11] - f11;
                    fArray[n12 + 1] = fArray[n11 + 1] - f12;
                    int n13 = n11;
                    fArray[n13] = fArray[n13] + f11;
                    int n14 = n11 + 1;
                    fArray[n14] = fArray[n14] + f12;
                }
            }
            ++n4;
            n5 *= 2;
        }
    }

    void transform_DIF(float[] fArray, int n, int n2, int n3) {
        if (this.n == 1) {
            return;
        }
        int n4 = 0;
        int n5 = this.n / 2;
        while (n4 < this.logn) {
            float f = 1.0f;
            float f2 = 0.0f;
            double d = 2.0 * (double)n3 * Math.PI / (double)(2 * n5);
            float f3 = (float)Math.sin(d);
            float f4 = (float)Math.sin(d / 2.0);
            float f5 = 2.0f * f4 * f4;
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < this.n; j += 2 * n5) {
                    int n6 = n + (i + j) * n2;
                    int n7 = n + (i + j + n5) * n2;
                    float f6 = fArray[n6] + fArray[n7];
                    float f7 = fArray[n6 + 1] + fArray[n7 + 1];
                    float f8 = fArray[n6] - fArray[n7];
                    float f9 = fArray[n6 + 1] - fArray[n7 + 1];
                    fArray[n6] = f6;
                    fArray[n6 + 1] = f7;
                    fArray[n7] = f * f8 - f2 * f9;
                    fArray[n7 + 1] = f * f9 + f2 * f8;
                }
                float f10 = f - f3 * f2 - f5 * f;
                float f11 = f2 + f3 * f - f5 * f2;
                f = f10;
                f2 = f11;
            }
            ++n4;
            n5 /= 2;
        }
        this.bitreverse(fArray, n, n2);
    }

    protected void bitreverse(float[] fArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.n - 1; ++i) {
            int n4 = n + i * n2;
            int n5 = n + n3 * n2;
            int n6 = this.n / 2;
            if (i < n3) {
                float f = fArray[n4];
                float f2 = fArray[n4 + 1];
                fArray[n4] = fArray[n5];
                fArray[n4 + 1] = fArray[n5 + 1];
                fArray[n5] = f;
                fArray[n5 + 1] = f2;
            }
            while (n6 <= n3) {
                n3 -= n6;
                n6 /= 2;
            }
            n3 += n6;
        }
    }
}

